/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.sql;

import com.prelytis.dashboard.data.engine.SqlString;
import com.prelytis.dashboard.data.sql.AbstractRequestBuilder;
import com.prelytis.dashboard.data.value.QueryDS;
import com.prelytis.dashboard.data.value.QueryDSField;
import com.prelytis.dashboard.data.value.QueryDSJoin;
import com.prelytis.dashboard.data.value.QueryDSJoinElement;
import com.prelytis.dashboard.data.value.QueryDSTable;
import com.prelytis.dashboard.db.QuerySQL;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.util.Collection;
import java.util.List;

public class RequestBuilderAnsi
extends AbstractRequestBuilder {
    @Override
    public QuerySQL getRequest(QueryDS query) throws DashboardException {
        String sort;
        SqlString having;
        SqlString where;
        QuerySQL querySQL = new QuerySQL();
        querySQL.setMaxRows(query.getMaxRows());
        List fieldList = querySQL.getFieldList();
        List pl = querySQL.getParameterList();
        StringBuilder on = new StringBuilder();
        StringBuilder groupBy = new StringBuilder();
        StringBuilder q = new StringBuilder();
        q.append("SELECT ");
        int cpt = 1;
        List<QueryDSField> dsFieldList = query.getFieldList();
        if (dsFieldList.isEmpty()) {
            throw new DashboardRuntimeException(ErrorCode.EMPTY_FIELD_LIST);
        }
        for (QueryDSField queryField : dsFieldList) {
            if (cpt != 1) {
                q.append(", ");
            }
            SqlString s = queryField.getSqlString();
            q.append(s.getSql());
            pl.addAll(s.getParameterList());
            fieldList.add(new FieldMetaData(cpt, "C" + cpt, "C" + cpt, queryField.getDataType()));
            ++cpt;
        }
        q.append(" FROM ");
        String filter = this.getStringFrom(query);
        on.append(filter);
        if (on.length() > 0) {
            q.append(on.toString());
        }
        if ((where = query.getWhere()) != null) {
            q.append(" WHERE ");
            q.append(where.getSql());
            pl.addAll(where.getParameterList());
        }
        if ((having = query.getHaving()) != null) {
            q.append(" HAVING ");
            q.append(having.getSql());
            pl.addAll(having.getParameterList());
        }
        Collection<SqlString> groupByList = query.getGroupByList();
        boolean first = true;
        for (SqlString gb : groupByList) {
            if (first) {
                first = false;
            } else {
                groupBy.append(", ");
            }
            pl.addAll(gb.getParameterList());
            groupBy.append(gb.getSql());
        }
        if (groupBy.length() > 0) {
            q.append(" GROUP BY ");
            q.append(groupBy.toString());
        }
        if ((sort = this.getSort(query)) != null) {
            q.append(sort);
        }
        querySQL.setQueryString(q.toString());
        return querySQL;
    }

    private String getStringFrom(QueryDS query) {
        QueryDSTable factTable = query.getQueryTable();
        if (factTable == null) {
            return null;
        }
        return this.calc(factTable, 0);
    }

    private String calc(QueryDSTable table, int num) {
        boolean emptyJoin;
        StringBuilder filter = new StringBuilder();
        int nb = table.getChildList().size();
        if (nb == 0) {
            return table.getTableName();
        }
        QueryDSTable child = table.getChildList().get(num);
        QueryDSJoin join = child.getJoin();
        int joinType = join.getJoinType();
        String type = null;
        boolean bl = emptyJoin = join.getJoinElementList() == null || join.getJoinElementList().isEmpty();
        if (emptyJoin) {
            joinType = 5;
        }
        switch (joinType) {
            default: {
                type = " INNER JOIN ";
                break;
            }
            case 2: {
                type = " LEFT OUTER JOIN ";
                break;
            }
            case 3: {
                type = " RIGHT OUTER JOIN ";
                break;
            }
            case 4: {
                type = " FULL OUTER JOIN ";
                break;
            }
            case 5: {
                type = " CROSS JOIN ";
            }
        }
        filter.append("(");
        if (nb < num + 2) {
            filter.append(table.getTableName());
        } else {
            filter.append(this.calc(table, num + 1));
        }
        filter.append(type).append(this.calc(child, 0));
        if (!emptyJoin) {
            filter.append(" ON (");
            boolean first = true;
            for (QueryDSJoinElement elt : join.getJoinElementList()) {
                if (first) {
                    first = false;
                } else {
                    filter.append(" AND ");
                }
                filter.append(elt.getLeftOperand());
                filter.append(" = ");
                filter.append(elt.getRightOperand());
            }
            filter.append(")");
        }
        filter.append(") ");
        return filter.toString();
    }
}

