/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.sql;

import com.prelytis.dashboard.data.engine.SqlString;
import com.prelytis.dashboard.data.sql.AbstractRequestBuilder;
import com.prelytis.dashboard.data.value.QueryDS;
import com.prelytis.dashboard.data.value.QueryDSField;
import com.prelytis.dashboard.data.value.QueryDSJoin;
import com.prelytis.dashboard.data.value.QueryDSJoinElement;
import com.prelytis.dashboard.data.value.QueryDSTable;
import com.prelytis.dashboard.db.QuerySQL;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.util.List;

public class RequestBuilderBasic
extends AbstractRequestBuilder {
    @Override
    public QuerySQL getRequest(QueryDS query) throws DashboardException {
        String sort;
        SqlString having;
        QuerySQL querySQL = new QuerySQL();
        querySQL.setMaxRows(query.getMaxRows());
        StringBuilder q = new StringBuilder();
        List fieldList = querySQL.getFieldList();
        List pl = querySQL.getParameterList();
        StringBuilder groupBy = new StringBuilder();
        q.append("SELECT ");
        int cpt = 1;
        List<QueryDSField> dsFieldList = query.getFieldList();
        if (dsFieldList.isEmpty()) {
            throw new DashboardRuntimeException(ErrorCode.EMPTY_FIELD_LIST);
        }
        for (QueryDSField queryField : dsFieldList) {
            if (cpt != 1) {
                q.append(", ");
            }
            SqlString s = queryField.getSqlString();
            q.append(s.getSql());
            pl.addAll(s.getParameterList());
            fieldList.add(new FieldMetaData(cpt, "C" + cpt, "C" + cpt, queryField.getDataType()));
            ++cpt;
        }
        q.append(" FROM ");
        String from = this.getFrom(query);
        if (from.length() > 0) {
            q.append(from);
        }
        String join = this.getWhere(query);
        SqlString where = query.getWhere();
        int situation = 0;
        if (join.length() > 0) {
            ++situation;
        }
        if (where != null) {
            situation += 2;
        }
        if (situation > 0) {
            q.append(" WHERE ");
            if ((situation & 1) != 0) {
                q.append(join);
            }
            if (situation == 3) {
                q.append(" AND ");
            }
            if ((situation & 2) != 0) {
                q.append(where.getSql());
                pl.addAll(where.getParameterList());
            }
        }
        if ((having = query.getHaving()) != null) {
            q.append(" HAVING ");
            q.append(having.getSql());
            pl.addAll(having.getParameterList());
        }
        boolean first = true;
        for (SqlString gb : query.getGroupByList()) {
            if (first) {
                first = false;
            } else {
                groupBy.append(", ");
            }
            pl.addAll(gb.getParameterList());
            groupBy.append(gb.getSql());
        }
        if (groupBy.length() > 0) {
            q.append(" GROUP BY ");
            q.append(groupBy.toString());
        }
        if ((sort = this.getSort(query)) != null) {
            q.append(sort);
        }
        querySQL.setQueryString(q.toString());
        return querySQL;
    }

    private String getFrom(QueryDS query) {
        StringBuilder from = new StringBuilder();
        QueryDSTable table = query.getQueryTable();
        from.append(table.getTableName());
        this.appendFrom(from, table.getChildList());
        return from.toString();
    }

    private void appendFrom(StringBuilder from, List<QueryDSTable> tableList) {
        for (QueryDSTable table : tableList) {
            from.append(", ");
            from.append(table.getTableName());
            this.appendFrom(from, table.getChildList());
        }
    }

    private String getWhere(QueryDS query) {
        QueryDSTable factTable = query.getQueryTable();
        if (factTable == null) {
            return null;
        }
        String where = this.calc(query, factTable).toString();
        if (where.length() > 0) {
            return where.substring(5);
        }
        return where;
    }

    private StringBuilder calc(QueryDS query, QueryDSTable table) {
        StringBuilder filter = new StringBuilder();
        QueryDSJoin join = table.getJoin();
        if (join != null) {
            for (QueryDSJoinElement elt : join.getJoinElementList()) {
                filter.append(" AND ");
                filter.append(elt.getLeftOperand());
                filter.append(" = ");
                filter.append(elt.getRightOperand());
            }
        }
        for (QueryDSTable child : table.getChildList()) {
            filter.append((CharSequence)this.calc(query, child));
        }
        return filter;
    }
}

