/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.ConditionalFormatDefinition;
import com.prelytis.dashboard.data.transformation.ConditionalFormatHelper;
import com.prelytis.dashboard.data.transformation.DefaultDataFilter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.helper.ClassElementHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ConditionalFormatDataFilter
extends DefaultDataFilter {
    private String[] formats;
    private List<List<ConditionalFormatDefinition>> conditionalFormatList;
    private ConditionalFormatHelper cfh;
    private ClassElementHelper ceh;
    private Stack<RowCell> sections = new Stack();

    @Override
    public void endSection(SectionParameter section) throws DashboardException {
        this.sections.pop();
        super.endSection(section);
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        int cpt = 0;
        ArrayList<RowCell> rowCells = new ArrayList<RowCell>();
        rowCells.addAll(this.sections);
        rowCells.addAll(row.getCells());
        for (RowCell rowCell : rowCells) {
            rowCell.setFormat(this.formats[cpt]);
            List<ConditionalFormatDefinition> def = this.conditionalFormatList.get(cpt);
            if (def != null && !def.isEmpty()) {
                this.cfh.update(def, rowCell, rowCells);
            }
            if (row.getBackgroundColor() != null) {
                rowCell.setClassElement(this.ceh.create(rowCell.getClassElement(), row.getBackgroundColor()));
            }
            ++cpt;
        }
        super.startRow(row);
    }

    @Override
    public void startSection(SectionParameter section) throws DashboardException {
        RowCell rc = new RowCell(section.getValue(), section.getClassElement(), section.getFormat());
        this.sections.push(rc);
        super.startSection(section);
    }

    public List<List<ConditionalFormatDefinition>> getConditionalFormatList() {
        return this.conditionalFormatList;
    }

    public void setConditionalFormatList(List<List<ConditionalFormatDefinition>> conditionalFormatList) {
        this.conditionalFormatList = conditionalFormatList;
    }

    public ConditionalFormatHelper getConditionalFormatHelper() {
        return this.cfh;
    }

    public void setConditionalFormatHelper(ConditionalFormatHelper cfh) {
        this.cfh = cfh;
        this.ceh = cfh.getClassElementHelper();
    }

    public String[] getFormats() {
        return this.formats;
    }

    public void setFormats(String[] formats) {
        this.formats = formats;
    }
}

