/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.CrossTableCalculationLine;
import com.prelytis.dashboard.data.CrossTableHeader;
import com.prelytis.dashboard.data.CrossTableHeaderDefinition;
import com.prelytis.dashboard.data.CrossTableHeaderTree;
import com.prelytis.dashboard.data.CrossTableValueDefinition;
import com.prelytis.dashboard.data.link.LinkDefinition;
import com.prelytis.dashboard.data.link.LinkFieldParam;
import com.prelytis.dashboard.data.link.LinkHelper;
import com.prelytis.dashboard.data.link.RefField;
import com.prelytis.dashboard.data.transformation.ConditionalFormatHelper;
import com.prelytis.dashboard.data.transformation.CrossTableCalculationHelper;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueNumber;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.util.TableFactory;
import com.prelytis.dashboard.util.TreeNodeHelper;
import com.prelytis.dashboard.value.chart.Cell;
import com.prelytis.dashboard.value.chart.CellHeader;
import com.prelytis.dashboard.value.chart.CellHeaderElt;
import com.prelytis.dashboard.value.chart.CellValue;
import com.prelytis.dashboard.value.chart.CellValueElt;
import com.prelytis.dashboard.value.chart.ColRow;
import com.prelytis.dashboard.value.chart.Link;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.data.CrossTableLabel;
import com.prelytis.dashboard.value.tree.DefaultMutableTreeNode;
import com.prelytis.dashboard.value.tree.TreeNode;
import com.prelytis.dashboard.value.tree.TreePath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;

public class CrossTableCache {
    private final List<TreePath<CrossTableHeaderDefinition>> abs;
    private final List<TreePath<CrossTableHeaderDefinition>> ord;
    private final TreeNode<CrossTableHeaderDefinition> absDef;
    private final TreeNode<CrossTableHeaderDefinition> ordDef;
    private final CrossTableValueDefinition valueDefinition;
    private final int absCol;
    private final int ordCol;
    private final int mda;
    private final int mdo;
    private final CrossTableLabel firstCell;
    private final CellHeaderElt firstCellElt;
    private final CrossTableHeaderTree topAbs;
    private final CrossTableHeaderTree topOrd;
    private final Counter cAbs = new Counter();
    private final Counter cOrd = new Counter();
    private final Map<Integer, Map<Integer, Value[]>> values = new HashMap<Integer, Map<Integer, Value[]>>();
    private final ConditionalFormatHelper helper;
    private final LinkHelper linkHelper = LinkHelper.getInstance();

    public CrossTableCache(int absCol, TreeNode<CrossTableHeaderDefinition> absDef, int mda, int ordCol, TreeNode<CrossTableHeaderDefinition> ordDef, int mdo, CrossTableValueDefinition valueDefinition, ConditionalFormatHelper helper, CrossTableLabel firstCell, CellHeaderElt firstCellElt) {
        TreeNodeHelper tnh = TreeNodeHelper.getInstance();
        this.absCol = absCol;
        this.absDef = absDef;
        this.abs = tnh.getPathList(absDef);
        this.ordCol = ordCol;
        this.ordDef = ordDef;
        this.ord = tnh.getPathList(ordDef);
        this.topAbs = new CrossTableHeaderTree();
        this.topOrd = new CrossTableHeaderTree();
        this.valueDefinition = valueDefinition;
        this.mda = mda;
        this.mdo = mdo;
        this.helper = helper;
        this.firstCell = firstCell;
        this.firstCellElt = firstCellElt;
    }

    public void reset() {
        this.cAbs.reset();
        this.cOrd.reset();
        this.topAbs.setChilds(null);
        this.topOrd.setChilds(null);
        this.values.clear();
    }

    private Integer getHeaderAbscisseId(List<RowCell> list) {
        Value av = this.getValue(list, this.absCol);
        int a = (int)((ValueNumber)av).getLong();
        TreePath<CrossTableHeaderDefinition> at = this.abs.get(a);
        return this.getHeaderId(at, this.topAbs, list, this.cAbs);
    }

    private Integer getHeaderOrdonneeId(List<RowCell> list) {
        Value ov = this.getValue(list, this.ordCol);
        int o = (int)((ValueNumber)ov).getLong();
        TreePath<CrossTableHeaderDefinition> ot = this.ord.get(o);
        return this.getHeaderId(ot, this.topOrd, list, this.cOrd);
    }

    public void addRow(List<RowCell> list) {
        Integer ai = this.getHeaderAbscisseId(list);
        Integer oi = this.getHeaderOrdonneeId(list);
        Map<Integer, Value[]> m = this.values.get(ai);
        if (m == null) {
            m = new HashMap<Integer, Value[]>();
            this.values.put(ai, m);
        }
        int[] cols = this.valueDefinition.getCols();
        Value[] values = new Value[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            RowCell ref = list.get(cols[i]);
            values[i] = ref.getValue();
        }
        Value[] v = m.put(oi, values);
        if (v != null) {
            throw new DashboardRuntimeException(ErrorCode.INSIGHT_UNKNOWN, "Values already available");
        }
    }

    private TreeNode<CrossTableHeader> getHeaders(CrossTableHeaderTree h, TreeNode<CrossTableHeaderDefinition> defNode, Counter c) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        this.addHeaders(h, defNode, (TreeNode<CrossTableHeader>)node, c);
        this.updateSpan((TreeNode<CrossTableHeader>)node);
        return node;
    }

    private int updateSpan(TreeNode<CrossTableHeader> node) {
        CrossTableHeader cth = (CrossTableHeader)node.getUserObject();
        int span = 0;
        if (node.getChildren() == null) {
            span = 1;
        } else {
            for (TreeNode c : node.getChildren()) {
                span += this.updateSpan((TreeNode<CrossTableHeader>)c);
            }
        }
        if (cth != null) {
            cth.setSpan(span);
        }
        return span;
    }

    private void addHeaders(CrossTableHeaderTree h, TreeNode<CrossTableHeaderDefinition> parentDefNode, TreeNode<CrossTableHeader> parentNode, Counter cpt) {
        Map<Integer, Map<Value, CrossTableHeaderTree>> cm = h.getChilds();
        if (cm != null && !cm.isEmpty() && parentDefNode.getChildren() != null) {
            List defs = parentDefNode.getChildren();
            for (Map.Entry<Integer, Map<Value, CrossTableHeaderTree>> entry : cm.entrySet()) {
                TreeNode defNode = (TreeNode)defs.get(entry.getKey());
                final CrossTableHeaderDefinition def = (CrossTableHeaderDefinition)defNode.getUserObject();
                TreeSet<CrossTableHeaderTree> set = new TreeSet<CrossTableHeaderTree>(new Comparator<CrossTableHeaderTree>(){

                    @Override
                    public int compare(CrossTableHeaderTree o1, CrossTableHeaderTree o2) {
                        if (o1 == o2) {
                            return 0;
                        }
                        Value v1 = o1.getHeader().getSortValue();
                        Value v2 = o2.getHeader().getSortValue();
                        return def.getValueComparator().compare(v1, v2);
                    }
                });
                int start = parentNode.getChildCount();
                set.addAll(entry.getValue().values());
                for (CrossTableHeaderTree c : set) {
                    CrossTableHeader hc = c.getHeader();
                    TreeNode<CrossTableHeader> n = this.addNode(parentNode, hc);
                    this.addHeaders(c, (TreeNode<CrossTableHeaderDefinition>)defNode, n, cpt);
                }
                int end = parentNode.getChildCount();
                if (def.getCalculationLines() == null || def.getCalculationLines().isEmpty()) continue;
                for (CrossTableCalculationLine calcLine : def.getCalculationLines()) {
                    CrossTableHeader clh = new CrossTableHeader(cpt.getNext(), calcLine, start, end);
                    this.addNode(parentNode, clh);
                }
            }
        }
    }

    private TreeNode<CrossTableHeader> addNode(TreeNode<CrossTableHeader> parentNode, CrossTableHeader h) {
        DefaultMutableTreeNode n = new DefaultMutableTreeNode();
        ArrayList<DefaultMutableTreeNode> cl = parentNode.getChildren();
        if (cl == null) {
            cl = new ArrayList<DefaultMutableTreeNode>();
            parentNode.setChildren(cl);
        }
        cl.add(n);
        n.setUserObject((Object)h);
        n.setParent(parentNode);
        return n;
    }

    private Value getValue(List<RowCell> list, int col) {
        RowCell cell = list.get(col);
        return cell.getValue();
    }

    private Integer getHeaderId(TreePath<CrossTableHeaderDefinition> path, CrossTableHeaderTree p, List<RowCell> list, Counter counter) {
        CrossTableHeaderTree current = p;
        for (TreeNode n : path.getPath()) {
            CrossTableHeaderTree h;
            Map<Value, CrossTableHeaderTree> map;
            CrossTableHeaderDefinition def = (CrossTableHeaderDefinition)n.getUserObject();
            Value v = this.getValue(list, def.getValueCol());
            Value s = this.getValue(list, def.getSortValueCol());
            Map<Integer, Map<Value, CrossTableHeaderTree>> mc = current.getChilds();
            if (mc == null) {
                mc = new HashMap<Integer, Map<Value, CrossTableHeaderTree>>();
                current.setChilds(mc);
            }
            if ((map = mc.get(def.getId())) == null) {
                map = new HashMap<Value, CrossTableHeaderTree>();
                current.getChilds().put(def.getId(), map);
            }
            if ((h = map.get(v)) == null) {
                CrossTableHeader hh = new CrossTableHeader(counter.getNext(), (TreeNode<CrossTableHeaderDefinition>)n, v, s);
                h = new CrossTableHeaderTree(hh);
                map.put(v, h);
            }
            current = h;
        }
        return current.getHeader().getId();
    }

    public Table getTable(TimeZone tz, Locale locale) throws DashboardException {
        TreeNode<CrossTableHeader> a = this.getHeaders(this.topAbs, this.absDef, this.cAbs);
        TreeNodeHelper tnh = TreeNodeHelper.getInstance();
        List al = tnh.asChildList(a);
        int nbCols = al.size() + 1;
        TreeNode<CrossTableHeader> o = this.getHeaders(this.topOrd, this.ordDef, this.cOrd);
        CrossTableCalculationHelper calculationHelper = new CrossTableCalculationHelper(this.helper, this.valueDefinition, this.values);
        if (nbCols > 0) {
            Table table = TableFactory.getCrossTable((TimeZone)tz, (Locale)locale, (int)nbCols);
            table.setFirstCell(this.firstCell);
            table.setHorizontalData(true);
            String[] desc = this.valueDefinition.getVisibleDescriptions();
            table.setDataDescriptions(desc);
            table.setDisplayDataDescription(desc.length > 1);
            ColRow ah = TableFactory.addRow((Table)table);
            CellHeader ch = (CellHeader)TableFactory.getFinalCell((Table)table, (int)0, (int)0);
            TableFactory.setCellHeaderElt((CellHeader)ch, (CellHeaderElt)this.firstCellElt);
            this.addHeader(ah, a, null, 1);
            this.addLines(calculationHelper, table, o, al, null);
            return table;
        }
        return null;
    }

    private void addLines(CrossTableCalculationHelper calculationHelper, Table table, TreeNode<CrossTableHeader> o, List<TreeNode<CrossTableHeader>> al, CellHeaderElt p) throws DashboardException {
        CellHeaderElt c = p;
        if (o.getUserObject() != null) {
            c = this.getCellHeaderElt(o, c);
        }
        if (o.getChildren() != null) {
            for (TreeNode co : o.getChildren()) {
                this.addLines(calculationHelper, table, (TreeNode<CrossTableHeader>)co, al, c);
            }
            return;
        }
        assert (c != null);
        for (int i = c.getCellEltNum() + 1; i < this.mdo; ++i) {
            CellHeaderElt elt = new CellHeaderElt();
            elt.setNbReferences(1);
            elt.setValue((Object)"");
            elt.setCellEltNum((byte)i);
            elt.setParent(c);
            c = elt;
        }
        ColRow row = TableFactory.addRow((Table)table);
        CellHeader ch = (CellHeader)row.get(0);
        ch.setCellHeaderElt(c);
        while (c != null && c.getCell() == null) {
            c.setCell((Cell)ch);
            c = c.getParent();
        }
        int cpt = 1;
        for (TreeNode<CrossTableHeader> a : al) {
            CellValue cv = (CellValue)row.get(cpt);
            CellValueElt[] cve = calculationHelper.getCellEltValues(cv, a, o);
            cv.setCellValueElt(cve);
            ++cpt;
        }
    }

    private CellHeaderElt getCellHeaderElt(TreeNode<CrossTableHeader> node, CellHeaderElt p) {
        CrossTableHeader h = (CrossTableHeader)node.getUserObject();
        CellHeaderElt elt = new CellHeaderElt();
        elt.setNbReferences(h.getSpan());
        elt.setValue(this.getObject(h.getValue()));
        int cellEltNum = p == null ? 0 : p.getCellEltNum() + 1;
        elt.setCellEltNum((byte)cellEltNum);
        if (h.getDef() != null) {
            CrossTableHeaderDefinition def = (CrossTableHeaderDefinition)h.getDef().getUserObject();
            elt.setFormat(def.getFormat());
            elt.setClassElement(def.getClassElement());
            List<LinkDefinition> ll = def.getLinks();
            if (ll != null && !ll.isEmpty()) {
                ArrayList<Link> linkList = new ArrayList<Link>();
                for (LinkDefinition ld : ll) {
                    HashMap<String, Object[]> valuesMap = new HashMap<String, Object[]>();
                    if (ld.getFields() != null) {
                        for (LinkFieldParam param : ld.getFields()) {
                            RefField rf = param.getField();
                            Value v = this.linkHelper.getHeaderValue(node, rf.getIndex());
                            valuesMap.put(param.getDstName(), this.linkHelper.getObjects(v));
                        }
                    }
                    Link l = this.linkHelper.getLink(ld, valuesMap);
                    linkList.add(l);
                }
                elt.setLinkList(linkList);
            }
        } else {
            elt.setFormat("{0}");
            elt.setClassElement(h.getCalculationLine().getClassElement());
        }
        elt.setParent(p);
        return elt;
    }

    private int addHeader(ColRow header, TreeNode<CrossTableHeader> node, CellHeaderElt p, int start) {
        CellHeaderElt c = p;
        if (node.getUserObject() != null) {
            c = this.getCellHeaderElt(node, c);
        }
        if (node.getChildren() != null) {
            int s = start;
            for (TreeNode cn : node.getChildren()) {
                s = this.addHeader(header, (TreeNode<CrossTableHeader>)cn, c, s);
            }
            return s;
        }
        assert (c != null);
        for (int i = c.getCellEltNum() + 1; i < this.mda; ++i) {
            CellHeaderElt elt = new CellHeaderElt();
            elt.setNbReferences(1);
            elt.setCellEltNum((byte)i);
            elt.setValue((Object)"");
            elt.setParent(c);
            c = elt;
        }
        CellHeader ch = (CellHeader)header.get(start);
        ch.setCellHeaderElt(c);
        while (c != null && c.getCell() == null) {
            c.setCell((Cell)ch);
            c = c.getParent();
        }
        return start + 1;
    }

    private Object getObject(Value value) {
        if (value == null) {
            return null;
        }
        Object resu = value.getObject();
        if (resu instanceof Object[]) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Object o : (Object[])resu) {
                if (first) {
                    first = false;
                } else {
                    sb.append("/");
                }
                sb.append(o == null ? "null" : o.toString());
            }
            return sb.toString();
        }
        return resu;
    }

    private class Counter {
        private int id = 1;

        private Counter() {
        }

        private void reset() {
            this.id = 1;
        }

        private int getNext() {
            return this.id++;
        }
    }
}

