/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.CrossTableCalculation;
import com.prelytis.dashboard.data.CrossTableHeader;
import com.prelytis.dashboard.data.CrossTableHeaderDefinition;
import com.prelytis.dashboard.data.CrossTableValue;
import com.prelytis.dashboard.data.CrossTableValueDefinition;
import com.prelytis.dashboard.data.calculation.CalculationBase;
import com.prelytis.dashboard.data.link.LinkDefinition;
import com.prelytis.dashboard.data.link.LinkFieldParam;
import com.prelytis.dashboard.data.link.LinkHelper;
import com.prelytis.dashboard.data.link.RefField;
import com.prelytis.dashboard.data.transformation.ConditionalFormatDefinition;
import com.prelytis.dashboard.data.transformation.ConditionalFormatHelper;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueBigDecimal;
import com.prelytis.dashboard.db.value.ValueDecimalNumber;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.chart.Cell;
import com.prelytis.dashboard.value.chart.CellValue;
import com.prelytis.dashboard.value.chart.CellValueElt;
import com.prelytis.dashboard.value.chart.Link;
import com.prelytis.dashboard.value.data.SummaryCalculation;
import com.prelytis.dashboard.value.tree.TreeNode;
import com.prelytis.dashboard.value.util.ClassElement;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class CrossTableCalculationHelper {
    private final LinkHelper linkHelper = LinkHelper.getInstance();
    private final ConditionalFormatHelper helper;
    private final Map<Integer, Map<Integer, Value[]>> values;
    private final int nb;
    private final int nbVisible;
    private final Map<Integer, Map<Integer, Map<Integer, CalculationBase>>> calculations = new HashMap<Integer, Map<Integer, Map<Integer, CalculationBase>>>();
    private final CrossTableValueDefinition valueDefinition;

    public CrossTableCalculationHelper(ConditionalFormatHelper helper, CrossTableValueDefinition valueDefinition, Map<Integer, Map<Integer, Value[]>> values) {
        this.helper = helper;
        this.nb = valueDefinition.getCols().length;
        this.nbVisible = valueDefinition.getVisibleDescriptions().length;
        this.valueDefinition = valueDefinition;
        this.values = values;
    }

    private CellValueElt[] getCTV(CellValue cv, TreeNode<CrossTableHeader> abs, TreeNode<CrossTableHeader> ord, Value[] values) {
        assert (values != null);
        Map<Integer, CrossTableValue[]> tmp = this.valueDefinition.getMap() == null ? null : this.valueDefinition.getMap().get(this.getHeaderPathId(ord));
        CrossTableValue[] def = tmp != null ? tmp.get(this.getHeaderPathId(abs)) : null;
        ClassElement[] defCes = this.valueDefinition.getClassElements();
        String[] defFs = this.valueDefinition.getFormats();
        ClassElement[] ces = new ClassElement[this.nb];
        String[] fs = new String[this.nb];
        List[] ls = new List[this.nb];
        for (int cpt = 0; cpt < this.nb; ++cpt) {
            List<ConditionalFormatDefinition> l;
            ces[cpt] = defCes[cpt];
            fs[cpt] = defFs[cpt];
            if (def == null || def[cpt] == null) continue;
            List<LinkDefinition> links = def[cpt].getLinks();
            if (links != null && !links.isEmpty()) {
                ls[cpt] = new ArrayList();
                for (LinkDefinition ld : links) {
                    HashMap<String, Object[]> valuesMap = new HashMap<String, Object[]>();
                    if (ld.getFields() != null) {
                        for (LinkFieldParam param : ld.getFields()) {
                            Value v = this.getValue(param.getField(), abs, ord, values);
                            valuesMap.put(param.getDstName(), this.linkHelper.getObjects(v));
                        }
                    }
                    Link l2 = this.linkHelper.getLink(ld, valuesMap);
                    ls[cpt].add(l2);
                }
            }
            if ((l = def[cpt].getConditionalFormats()) == null || l.isEmpty()) continue;
            for (ConditionalFormatDefinition cdtFmt : l) {
                Value v;
                if (!this.helper.isTrue(cdtFmt, v = this.getValue(cdtFmt.getField(), abs, ord, values))) continue;
                ces[cpt] = this.helper.getClassElement(cdtFmt, ces[cpt]);
                fs[cpt] = cdtFmt.getFormat() == null ? fs[cpt] : cdtFmt.getFormat();
            }
        }
        return this.getCellValueElt(cv, values, ces, fs, ls);
    }

    private Value getValue(RefField f, TreeNode<CrossTableHeader> abs, TreeNode<CrossTableHeader> ord, Value[] values) {
        switch (f.getType()) {
            case DATA: {
                return values[f.getIndex()];
            }
            case COL: {
                return this.getHeaderValue(abs, f.getIndex());
            }
            case ROW: {
                return this.getHeaderValue(ord, f.getIndex());
            }
        }
        return null;
    }

    private Value getHeaderValue(TreeNode<CrossTableHeader> node, int offset) {
        if (node == null || offset < 0) {
            return null;
        }
        if (offset == 0) {
            CrossTableHeader h = (CrossTableHeader)node.getUserObject();
            if (h == null) {
                return null;
            }
            return h.getValue();
        }
        return this.getHeaderValue((TreeNode<CrossTableHeader>)node.getParent(), offset - 1);
    }

    private Integer getHeaderPathId(TreeNode<CrossTableHeader> node) {
        CrossTableHeader h = (CrossTableHeader)node.getUserObject();
        if (h == null) {
            return null;
        }
        TreeNode<CrossTableHeaderDefinition> defNode = h.getDef();
        if (defNode == null) {
            return null;
        }
        CrossTableHeaderDefinition def = (CrossTableHeaderDefinition)defNode.getUserObject();
        if (def == null) {
            return null;
        }
        return def.getPathId();
    }

    private CellValueElt[] getCalculatedValue(CellValue cv, TreeNode<CrossTableHeader> abs, TreeNode<CrossTableHeader> ord, CrossTableCalculation[] calculations) throws DashboardException {
        int num = 0;
        Value[] values = new Value[this.nb];
        ClassElement[] classElements = new ClassElement[this.nb];
        String[] formats = new String[this.nb];
        for (CrossTableCalculation calculation : calculations) {
            CalculationBase base = null;
            if (calculation == null) continue;
            switch (calculation.getCalculation()) {
                case NONE: {
                    break;
                }
                default: {
                    base = this.getBaseCalculation(abs, ord, num);
                }
            }
            if (base != null) {
                switch (calculation.getCalculation()) {
                    case AVERAGE: {
                        values[num] = base.getAverage();
                        break;
                    }
                    case COUNT: {
                        values[num] = base.getCount();
                        break;
                    }
                    case MAX: {
                        values[num] = base.getMax();
                        break;
                    }
                    case MEDIAN: {
                        values[num] = base.getMedian();
                        break;
                    }
                    case MIN: {
                        values[num] = base.getMin();
                        break;
                    }
                    case STANDARD_DEVIATION: {
                        values[num] = base.getStandardDeviation();
                        break;
                    }
                    case TOTAL: {
                        values[num] = base.getSum();
                        break;
                    }
                    case TOTAL_SQUARRED: {
                        values[num] = base.getSumSquarred();
                        break;
                    }
                    case VARIANCE: {
                        values[num] = base.getVariance();
                        break;
                    }
                    case EVOLUTION: {
                        values[num] = base.getEvolution();
                        break;
                    }
                    case PERC_EVOLUTION: {
                        values[num] = base.getPercEvolution();
                        break;
                    }
                    case PERC_TOTAL: {
                        TreeNode o;
                        TreeNode a;
                        ValueDecimalNumber v1 = (ValueDecimalNumber)base.getSum();
                        boolean calc = false;
                        if (calculation.getAbcisseRefColId() != null) {
                            for (a = abs; a != null && !this.sameId(a, calculation.getAbcisseRefColId()); a = a.getParent()) {
                            }
                            if (a != null && a.getUserObject() != null) {
                                a = a.getParent();
                                calc = true;
                            }
                        } else if (calculation.getOrdonneeRefColId() != null) {
                            for (o = ord; o != null && !this.sameId(o, calculation.getOrdonneeRefColId()); o = o.getParent()) {
                            }
                            if (o != null && o.getUserObject() != null) {
                                o = o.getParent();
                                calc = true;
                            }
                        }
                        if (calc) {
                            base = this.getBaseCalculation((TreeNode<CrossTableHeader>)a, o, num);
                            ValueDecimalNumber v2 = (ValueDecimalNumber)base.getSum();
                            if (v2.getDecimalValue().signum() == 0) {
                                values[num] = ValueNull.BIG_DECIMAL;
                                break;
                            }
                            values[num] = new ValueBigDecimal(v1.getDecimalValue().divide(v2.getDecimalValue(), MathContext.DECIMAL32));
                            break;
                        }
                        values[num] = ValueNull.BIG_DECIMAL;
                        break;
                    }
                    default: {
                        values[num] = ValueNull.BIG_DECIMAL;
                    }
                }
            }
            classElements[num] = calculation.getClassElement();
            formats[num] = calculation.getFormat();
            ++num;
        }
        return this.getCellValueElt(cv, values, classElements, formats, null);
    }

    private boolean sameId(TreeNode<CrossTableHeader> node, int colId) {
        if (node == null) {
            return false;
        }
        CrossTableHeader cth = (CrossTableHeader)node.getUserObject();
        if (cth == null) {
            return false;
        }
        TreeNode<CrossTableHeaderDefinition> n = cth.getDef();
        if (n == null) {
            return false;
        }
        CrossTableHeaderDefinition cthd = (CrossTableHeaderDefinition)n.getUserObject();
        if (cthd == null) {
            return false;
        }
        Integer id = cthd.getId();
        if (id == null) {
            return false;
        }
        return id.intValue() == cthd.getId().intValue();
    }

    private CalculationBase getBaseCalculation(TreeNode<CrossTableHeader> abs, TreeNode<CrossTableHeader> ord, int num) throws DashboardException {
        CalculationBase calculation;
        Map<Integer, CalculationBase> cs;
        CrossTableHeader absh = (CrossTableHeader)abs.getUserObject();
        Integer absId = absh == null ? -1 : absh.getId();
        CrossTableHeader ordh = (CrossTableHeader)ord.getUserObject();
        Integer ordId = ordh == null ? -1 : ordh.getId();
        Map<Integer, Map<Integer, CalculationBase>> m = this.calculations.get(absId);
        if (m == null) {
            m = new HashMap<Integer, Map<Integer, CalculationBase>>();
            this.calculations.put(absId, m);
        }
        if ((cs = m.get(ordId)) == null) {
            cs = new HashMap<Integer, CalculationBase>();
            m.put(ordId, cs);
        }
        if ((calculation = cs.get(num)) == null) {
            List ol;
            List al;
            calculation = new CalculationBase();
            calculation.reset();
            if (absh != null && absh.isCalculated()) {
                al = abs.getParent().getChildren().subList(absh.getStart(), absh.getEnd());
            } else {
                al = new ArrayList<TreeNode<CrossTableHeader>>();
                al.add(abs);
            }
            if (ordh != null && ordh.isCalculated()) {
                ol = ord.getParent().getChildren().subList(ordh.getStart(), ordh.getEnd());
            } else {
                ol = new ArrayList<TreeNode<CrossTableHeader>>();
                ol.add(ord);
            }
            for (TreeNode ta : al) {
                for (TreeNode to : ol) {
                    this.calculate(calculation, (TreeNode<CrossTableHeader>)ta, (TreeNode<CrossTableHeader>)to, num);
                }
            }
            cs.put(num, calculation);
        }
        return calculation;
    }

    private void calculate(CalculationBase calculation, TreeNode<CrossTableHeader> abs, TreeNode<CrossTableHeader> ord, int num) throws DashboardException {
        CrossTableHeader absh = (CrossTableHeader)abs.getUserObject();
        if (absh != null && absh.isCalculated()) {
            return;
        }
        CrossTableHeader ordh = (CrossTableHeader)ord.getUserObject();
        if (ordh != null && ordh.isCalculated()) {
            return;
        }
        if (abs.getChildren() != null) {
            for (TreeNode h : abs.getChildren()) {
                if (h.getChildren() != null) {
                    calculation.addValues(this.getBaseCalculation((TreeNode<CrossTableHeader>)h, ord, num));
                    continue;
                }
                this.calculate(calculation, (TreeNode<CrossTableHeader>)h, ord, num);
            }
            return;
        }
        if (ord.getChildren() != null) {
            for (TreeNode h : ord.getChildren()) {
                if (h.getChildren() != null) {
                    calculation.addValues(this.getBaseCalculation(abs, (TreeNode<CrossTableHeader>)h, num));
                    continue;
                }
                this.calculate(calculation, abs, (TreeNode<CrossTableHeader>)h, num);
            }
            return;
        }
        Map<Integer, Value[]> m = this.values.get(absh == null ? 0 : absh.getId());
        if (m == null) {
            return;
        }
        Value[] value = m.get(ordh == null ? 0 : ordh.getId());
        if (value == null) {
            return;
        }
        calculation.addValue(value[num]);
    }

    private CrossTableCalculation[] getSummaryCalculation(TreeNode<CrossTableHeader> abs, TreeNode<CrossTableHeader> ord) {
        CrossTableHeader ordh;
        CrossTableCalculation[] calculations = new CrossTableCalculation[this.nb];
        CrossTableHeader absh = (CrossTableHeader)abs.getUserObject();
        if (absh.getCalculationLine() != null) {
            this.updateCalculation(calculations, absh.getCalculationLine().getCalculations());
        }
        if ((ordh = (CrossTableHeader)ord.getUserObject()).getCalculationLine() != null) {
            this.updateCalculation(calculations, ordh.getCalculationLine().getCalculations());
        }
        for (int i = 0; i < this.nb; ++i) {
            if (calculations[i] != null) continue;
            calculations[i] = new CrossTableCalculation();
            calculations[i].setCalculation(SummaryCalculation.NONE);
        }
        return calculations;
    }

    private void updateCalculation(CrossTableCalculation[] calculations, CrossTableCalculation[] refs) {
        int cpt = 0;
        for (CrossTableCalculation ref : refs) {
            if (calculations[cpt] == null) {
                calculations[cpt] = new CrossTableCalculation();
                calculations[cpt].setCalculation(ref.getCalculation());
                calculations[cpt].setClassElement(ref.getClassElement());
                calculations[cpt].setFormat(ref.getFormat());
                calculations[cpt].setAbcisseRefColId(ref.getAbcisseRefColId());
                calculations[cpt].setOrdonneeRefColId(ref.getOrdonneeRefColId());
            } else if (calculations[cpt].getCalculation() != ref.getCalculation()) {
                calculations[cpt].setCalculation(SummaryCalculation.NONE);
                calculations[cpt].setClassElement(null);
                calculations[cpt].setFormat(null);
            }
            ++cpt;
        }
    }

    public CellValueElt[] getCellEltValues(CellValue cv, TreeNode<CrossTableHeader> abs, TreeNode<CrossTableHeader> ord) throws DashboardException {
        Object[] values;
        CrossTableHeader absh = (CrossTableHeader)abs.getUserObject();
        CrossTableHeader ordh = (CrossTableHeader)ord.getUserObject();
        if (absh.isCalculated() || ordh.isCalculated()) {
            CrossTableCalculation[] c = this.getSummaryCalculation(abs, ord);
            return this.getCalculatedValue(cv, abs, ord, c);
        }
        Map<Integer, Value[]> m = this.values.get(absh.getId());
        Object[] v = m == null ? null : m.get(ordh.getId());
        if (v == null) {
            values = new Value[this.nb];
            Arrays.fill(values, ValueNull.DOUBLE);
        } else {
            values = v;
        }
        return this.getCTV(cv, abs, ord, (Value[])values);
    }

    private CellValueElt[] getCellValueElt(CellValue cv, Value[] values, ClassElement[] classElements, String[] formats, List<Link>[] ls) {
        assert (values != null && classElements != null && formats != null && values.length == classElements.length && values.length == formats.length);
        CellValueElt[] valueElts = new CellValueElt[this.nbVisible];
        boolean[] visibles = this.valueDefinition.getVisible();
        int cpt = 0;
        int fc = 0;
        for (Value v : values) {
            if (visibles[cpt]) {
                CellValueElt elt = new CellValueElt();
                elt.setFormat(formats[cpt]);
                elt.setClassElement(classElements[cpt]);
                elt.setValue(this.getObject(v));
                elt.setCellEltNum((byte)fc);
                elt.setCell((Cell)cv);
                if (ls != null) {
                    elt.setLinkList(ls[cpt]);
                }
                valueElts[fc] = elt;
                ++fc;
            }
            ++cpt;
        }
        return valueElts;
    }

    private Object getObject(Value value) {
        if (value == null) {
            return null;
        }
        Object resu = value.getObject();
        if (resu instanceof Object[]) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Object o : (Object[])resu) {
                if (first) {
                    first = false;
                } else {
                    sb.append("/");
                }
                sb.append(o == null ? "null" : o.toString());
            }
            return sb.toString();
        }
        return resu;
    }
}

