/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.DefaultDataFilter;
import com.prelytis.dashboard.data.transformation.InlineCalculationHelper;
import com.prelytis.dashboard.data.transformation.PrevColumnCalculationHelper;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.interfaces.DashboardException;
import java.util.List;
import java.util.Map;

public class InlineCalculationDataFilter
extends DefaultDataFilter {
    private InlineCalculationHelper global;
    private Map<Integer, InlineCalculationHelper> sections;
    private Map<Integer, InlineCalculationHelper> ruptures;
    private List<PrevColumnCalculationHelper> prevColCalcList;

    public List<PrevColumnCalculationHelper> getPrevColCalcList() {
        return this.prevColCalcList;
    }

    public void setPrevColCalcList(List<PrevColumnCalculationHelper> prevColCalcList) {
        this.prevColCalcList = prevColCalcList;
    }

    public InlineCalculationHelper getGlobal() {
        return this.global;
    }

    public void setGlobal(InlineCalculationHelper global) {
        this.global = global;
    }

    public Map<Integer, InlineCalculationHelper> getSections() {
        return this.sections;
    }

    public void setSections(Map<Integer, InlineCalculationHelper> sections) {
        this.sections = sections;
    }

    public Map<Integer, InlineCalculationHelper> getRuptures() {
        return this.ruptures;
    }

    public void setRuptures(Map<Integer, InlineCalculationHelper> ruptures) {
        this.ruptures = ruptures;
    }

    @Override
    public void endContainer(ContainerParameter container) throws DashboardException {
        if (this.global != null) {
            this.global.resetCalculation();
        }
        super.endContainer(container);
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        if (this.global != null) {
            this.global.updateCalculation(row);
        }
        if (this.sections != null) {
            for (InlineCalculationHelper helper : this.sections.values()) {
                helper.updateCalculation(row);
            }
        }
        if (this.ruptures != null) {
            for (InlineCalculationHelper helper : this.ruptures.values()) {
                helper.updateCalculation(row);
            }
        }
        if (this.prevColCalcList != null) {
            for (PrevColumnCalculationHelper h : this.prevColCalcList) {
                h.updateCalculation(row);
            }
        }
        this.dataHandler.startRow(row);
    }

    @Override
    public void endRow(RowParameter row) throws DashboardException {
        this.dataHandler.endRow(row);
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
        this.dataHandler.endRupture(rupture);
    }

    @Override
    public void endSection(SectionParameter section) throws DashboardException {
        this.dataHandler.endSection(section);
    }

    @Override
    public void startRupture(RuptureParameter rupture) throws DashboardException {
        InlineCalculationHelper helper;
        if (this.ruptures != null && (helper = this.ruptures.get(rupture.getRuptureLevel())) != null) {
            helper.resetCalculation();
        }
        this.dataHandler.startRupture(rupture);
    }

    @Override
    public void startSection(SectionParameter section) throws DashboardException {
        InlineCalculationHelper helper;
        if (this.sections != null && (helper = this.sections.get(section.getSectionLevel())) != null) {
            helper.resetCalculation();
        }
        this.dataHandler.startSection(section);
    }
}

