/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.AbstractDataReader;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.db.sql.Result;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.helper.DocumentCommandHelper;
import com.prelytis.dashboard.helper.FieldMetaDataHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.util.ClassElement;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ResultsetDataReader
extends AbstractDataReader {
    public static final String PRIMARY_KEY_VALUES_ATTRIBUTE = "primaryKeyValues";
    public static final String CRITERIA_FIELD_VALUES_ATTRIBUTE = "criteriaFieldValues";
    public static final String ROW_NUMBER_ATTRIBUTE = "rowNumber";
    private final Result result;
    private final ClassElement[] classElements;
    private final boolean forceData;

    public ResultsetDataReader(Result result) {
        this(result, null, false);
    }

    public ResultsetDataReader(Result result, ClassElement[] classElements, boolean forceData) {
        if (classElements == null || result.getNbCols() != classElements.length) {
            this.classElements = new ClassElement[result.getNbCols()];
            ClassElement defaultClassElement = new ClassElement();
            defaultClassElement.setName("tbl-body");
            Arrays.fill(this.classElements, defaultClassElement);
        } else {
            this.classElements = classElements;
        }
        this.result = result;
        this.forceData = forceData;
    }

    @Override
    public void read() throws DashboardException {
        try {
            int nbCols = this.result.getNbCols();
            int maxRows = this.result.getMaxRows();
            ArrayList<FieldMetaData> newList = null;
            HashMap<Integer, String> primaryKeyFields = new HashMap<Integer, String>();
            HashMap<Integer, String> criteriaFields = new HashMap<Integer, String>();
            if (this.result.getFieldMetaDataList() != null) {
                newList = new ArrayList<FieldMetaData>();
                for (int i = 0; i < this.result.getFieldMetaDataList().size(); ++i) {
                    FieldMetaData fmd = (FieldMetaData)this.result.getFieldMetaDataList().get(i);
                    newList.add(FieldMetaDataHelper.getCopy(fmd));
                    if (fmd.isKey()) {
                        primaryKeyFields.put(i, fmd.getName());
                    }
                    if (!fmd.isCriteriaField()) continue;
                    criteriaFields.put(i, fmd.getName());
                }
            }
            DataParameter def = new DataParameter();
            def.setNbCols(nbCols);
            def.setMetaDataList(newList);
            int rowNum = 0;
            ContainerParameter container = new ContainerParameter();
            this.dataHandler.startContainer(container);
            boolean hasData = false;
            while (this.result.next()) {
                if (!hasData) {
                    this.dataHandler.startData(def);
                    hasData = true;
                }
                ++rowNum;
                RowParameter row = new RowParameter();
                HashMap primaryKeyValues = new HashMap();
                HashMap<String, Object> criteriaFieldValues = new HashMap<String, Object>();
                List<RowCell> list = row.getCells();
                for (int col = 0; col < nbCols; ++col) {
                    Value value = this.result.getData(col);
                    list.add(new RowCell(value, this.classElements[col], "{0}"));
                    if (primaryKeyFields.containsKey(col)) {
                        primaryKeyValues.put(primaryKeyFields.get(col), value.toString());
                    }
                    if (!criteriaFields.containsKey(col)) continue;
                    criteriaFieldValues.put(DocumentCommandHelper.getSimpleFieldName((String)criteriaFields.get(col)), value.getObject());
                }
                row.setRowNumber(rowNum);
                if (!primaryKeyValues.isEmpty()) {
                    row.setAttribute(PRIMARY_KEY_VALUES_ATTRIBUTE, primaryKeyValues);
                } else {
                    row.setAttribute(ROW_NUMBER_ATTRIBUTE, rowNum);
                }
                row.setAttribute(CRITERIA_FIELD_VALUES_ATTRIBUTE, criteriaFieldValues);
                if (maxRows > 0 && rowNum > maxRows) continue;
                this.dataHandler.startRow(row);
                this.dataHandler.endRow(row);
            }
            if (!hasData && this.forceData) {
                this.dataHandler.startData(def);
                hasData = true;
            }
            if (hasData) {
                this.dataHandler.endData(def);
            }
            container.setIgnoredData(this.result.isIgnoredData());
            this.dataHandler.endContainer(container);
        }
        catch (Exception e) {
            this.handleException(this.result.toString(), e);
        }
    }
}

