/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.Break;
import com.prelytis.dashboard.data.transformation.DefaultDataFilter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.interfaces.DashboardException;

public class RuptureDataFilter
extends DefaultDataFilter {
    private Break b;
    private RowParameter previousRow;
    private RuptureParameter rupture;
    private int ruptureLevel;

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        if (this.rupture == null) {
            this.rupture = new RuptureParameter(row.getCells().size());
            this.rupture.setRuptureLevel(this.ruptureLevel);
            this.dataHandler.startRupture(this.rupture);
        } else if (!this.b.hasSameColumnValue(this.previousRow, row)) {
            this.dataHandler.endRupture(this.rupture);
            this.rupture = new RuptureParameter(row.getCells().size());
            this.rupture.setRuptureLevel(this.ruptureLevel);
            this.dataHandler.startRupture(this.rupture);
        }
        super.startRow(row);
    }

    @Override
    public void endRow(RowParameter row) throws DashboardException {
        super.endRow(row);
        this.previousRow = row;
    }

    @Override
    public void endData(DataParameter data) throws DashboardException {
        if (this.rupture != null) {
            this.dataHandler.endRupture(this.rupture);
            this.rupture = null;
        }
        super.endData(data);
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
        if (this.rupture != null) {
            this.dataHandler.endRupture(this.rupture);
            this.rupture = null;
        }
        this.dataHandler.endRupture(rupture);
    }

    @Override
    public void startRupture(RuptureParameter rupture) throws DashboardException {
        if (this.rupture != null) {
            this.rupture = null;
        }
        super.startRupture(rupture);
    }

    public Break getBreak() {
        return this.b;
    }

    public void setBreak(Break b) {
        this.b = b;
    }

    public int getRuptureLevel() {
        return this.ruptureLevel;
    }

    public void setRuptureLevel(int ruptureLevel) {
        this.ruptureLevel = ruptureLevel;
    }
}

