/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.interfaces.DataFilter;
import com.prelytis.dashboard.data.transformation.interfaces.DataHandler;
import com.prelytis.dashboard.data.transformation.interfaces.DataReader;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.interfaces.DashboardException;
import java.util.ArrayList;
import java.util.List;

public class SectionCacheDataFilter
implements DataHandler,
DataFilter {
    private DataReader dataReader;
    private DataHandler dataHandler;
    private List<Action> cache = new ArrayList<Action>();

    @Override
    public DataReader getParent() {
        return this.dataReader;
    }

    @Override
    public void setParent(DataReader dataReader) {
        this.dataReader = dataReader;
        dataReader.setDataHandler(this);
    }

    @Override
    public void endContainer(ContainerParameter container) throws DashboardException {
        this.dataHandler.endContainer(container);
    }

    @Override
    public void endData(DataParameter data) throws DashboardException {
        for (Action a : this.cache) {
            if (a.row != null) {
                if (a.start) {
                    this.dataHandler.startRow(a.row);
                    continue;
                }
                this.dataHandler.endRow(a.row);
                continue;
            }
            if (a.rupture == null) continue;
            if (a.start) {
                this.dataHandler.startRupture(a.rupture);
                continue;
            }
            this.dataHandler.endRupture(a.rupture);
        }
        this.cache.clear();
        this.dataHandler.endData(data);
    }

    @Override
    public void endRow(RowParameter row) throws DashboardException {
        Action a = new Action();
        a.start = false;
        a.row = row;
        this.cache.add(a);
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
        Action a = new Action();
        a.start = false;
        a.rupture = rupture;
        this.cache.add(a);
    }

    @Override
    public void endSection(SectionParameter section) throws DashboardException {
        this.dataHandler.endSection(section);
    }

    @Override
    public void startContainer(ContainerParameter container) throws DashboardException {
        this.dataHandler.startContainer(container);
    }

    @Override
    public void startData(DataParameter data) throws DashboardException {
        this.dataHandler.startData(data);
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        Action a = new Action();
        a.start = true;
        a.row = row;
        this.cache.add(a);
    }

    @Override
    public void startRupture(RuptureParameter rupture) throws DashboardException {
        Action a = new Action();
        a.start = true;
        a.rupture = rupture;
        this.cache.add(a);
    }

    @Override
    public void startSection(SectionParameter section) throws DashboardException {
        this.dataHandler.startSection(section);
    }

    @Override
    public void read() throws DashboardException {
        this.dataReader.read();
    }

    @Override
    public void setDataHandler(DataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    private static class Action {
        private boolean start;
        private RowParameter row;
        private RuptureParameter rupture;

        private Action() {
        }
    }
}

