/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.Break;
import com.prelytis.dashboard.data.transformation.DefaultDataFilter;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.util.ClassElement;
import java.util.List;

public class SectionDataFilter
extends DefaultDataFilter {
    private final Break breakDefinition;
    private final int colNum;
    private final ClassElement classElement;
    private final String format;
    private RowParameter currentRow;
    private RowParameter newRow;
    private SectionParameter currentSection;
    private DataParameter dataDefinition;
    private int sectionLevel;
    private int rowNumber;

    public SectionDataFilter(int colNum, ClassElement classElement, String format) {
        this.breakDefinition = new Break(new int[]{colNum});
        this.colNum = colNum;
        this.format = format;
        this.classElement = classElement;
    }

    @Override
    public void startContainer(ContainerParameter container) throws DashboardException {
        super.startContainer(container);
    }

    @Override
    public void endContainer(ContainerParameter container) throws DashboardException {
        this.dataHandler.endContainer(container);
    }

    @Override
    public void endData(DataParameter data) throws DashboardException {
        this.dataHandler.endData(data);
        if (this.currentSection != null) {
            this.dataHandler.endSection(this.currentSection);
            this.currentSection = null;
            this.dataDefinition = null;
        }
    }

    @Override
    public void startData(DataParameter data) throws DashboardException {
        this.dataDefinition = data;
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        List<RowCell> list = row.getCells();
        if (this.currentRow == null || !this.breakDefinition.hasSameColumnValue(this.currentRow, row)) {
            int sectionNum = 0;
            if (this.currentSection != null) {
                this.dataHandler.endData(this.dataDefinition);
                this.dataHandler.endSection(this.currentSection);
                sectionNum = this.currentSection.getSectionNum();
            }
            this.currentSection = new SectionParameter();
            this.currentSection.setNbCols(list.size());
            this.currentSection.setSectionNum(++sectionNum);
            this.currentSection.setValue(list.get(this.colNum).getValue());
            this.currentSection.setSectionLevel(this.sectionLevel);
            this.currentSection.setClassElement(this.classElement);
            this.currentSection.setFormat(this.format);
            this.dataHandler.startSection(this.currentSection);
            this.dataHandler.startData(this.dataDefinition);
            this.rowNumber = 0;
        }
        this.newRow = new RowParameter();
        this.newRow.setRowNumber(this.rowNumber);
        this.newRow.setBackgroundColor(row.getBackgroundColor());
        List<RowCell> newList = this.newRow.getCells();
        newList.addAll(list);
        newList.remove(this.colNum);
        this.dataHandler.startRow(this.newRow);
        ++this.rowNumber;
        this.currentRow = row;
    }

    @Override
    public void endRow(RowParameter row) throws DashboardException {
        super.endRow(this.newRow);
        this.newRow = null;
    }

    @Override
    public void endSection(SectionParameter section) throws DashboardException {
        this.dataHandler.endSection(section);
        --this.sectionLevel;
        this.currentRow = null;
    }

    @Override
    public void startSection(SectionParameter section) throws DashboardException {
        this.dataHandler.startSection(section);
        ++this.sectionLevel;
        this.currentRow = null;
    }
}

