/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.comparator.RowComparator;
import com.prelytis.dashboard.data.transformation.DefaultDataFilter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.db.operation.SortColumn;
import com.prelytis.dashboard.interfaces.DashboardException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class SortDataFilter
extends DefaultDataFilter {
    private Collator collator;
    private List<SortColumn> sortDefinition;
    private List<RowParameter> list = new ArrayList<RowParameter>();

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
        this.sendData();
        super.endRupture(rupture);
    }

    @Override
    public void endData(DataParameter data) throws DashboardException {
        this.sendData();
        this.dataHandler.endData(data);
    }

    @Override
    public void startRow(RowParameter row) {
        this.list.add(row);
    }

    @Override
    public void endRow(RowParameter row) {
    }

    private void sendData() throws DashboardException {
        if (!this.list.isEmpty()) {
            TreeSet<RowParameter> treeSet = new TreeSet<RowParameter>(new RowComparator(this.collator, this.sortDefinition));
            treeSet.addAll(this.list);
            int rowNum = 0;
            for (RowParameter row : treeSet) {
                row.setRowNumber(++rowNum);
                this.dataHandler.startRow(row);
                this.dataHandler.endRow(row);
            }
            this.list.clear();
        }
    }

    public List<SortColumn> getSortDefinition() {
        return this.sortDefinition;
    }

    public void setSortDefinition(List<SortColumn> sortDefinition) {
        this.sortDefinition = sortDefinition;
    }

    public List<RowParameter> getList() {
        return this.list;
    }

    public void setList(List<RowParameter> list) {
        this.list = list;
    }

    public Collator getCollator() {
        return this.collator;
    }

    public void setCollator(Collator collator) {
        this.collator = collator;
    }
}

