/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.AbstractDataHandler;
import com.prelytis.dashboard.data.transformation.CrossTableCache;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.util.TableFactory;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.data.BeanReportCrossTable;
import com.prelytis.dashboard.value.structure.Document;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.structure.SectionDocument;
import com.prelytis.dashboard.value.structure.TableDocument;
import com.prelytis.dashboard.value.util.ColorList;
import com.prelytis.dashboard.value.util.Thresholds;
import java.io.Serializable;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;

public class TableContainerCrossTableDataHandler
extends AbstractDataHandler {
    private final ReportDocument document = new ReportDocument();
    private Stack<SectionDocument> sectionStack;
    private Table currentTable;
    private ColorList chartColorList;
    private BeanReportCrossTable report;
    private Locale locale;
    private TimeZone timeZone;
    private Thresholds thresholds;
    private boolean startRowCalled = false;
    private final CrossTableCache cache;
    private boolean pageBreakOnSection;
    private final GuidFactory guidFactory = GuidFactory.getInstance();

    public TableContainerCrossTableDataHandler(CrossTableCache cache) {
        this.cache = cache;
    }

    @Override
    public void startContainer(ContainerParameter container) throws DashboardException {
    }

    @Override
    public void endContainer(ContainerParameter container) {
    }

    @Override
    public void startSection(SectionParameter section) throws DashboardException {
        try {
            SectionDocument s = new SectionDocument();
            Value value = section.getValue();
            s.setData((Serializable)value.getObject());
            s.setClassElement(section.getClassElement());
            s.setPattern(section.getFormat());
            s.setPageBreakBefore(this.pageBreakOnSection);
            this.document.add((Document)s);
            if (this.sectionStack == null) {
                this.sectionStack = new Stack();
            }
            this.sectionStack.add(s);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void endSection(SectionParameter section) {
        if (this.startRowCalled && this.currentTable != null) {
            TableDocument td = new TableDocument();
            td.setName(this.guidFactory.generateGUID((Object)td));
            td.setTable(this.currentTable);
            if (this.report.getColRowInversion()) {
                TableFactory.transpose((Table)this.currentTable);
            }
            this.document.add((Document)td);
        }
        this.sectionStack.pop();
        this.currentTable = null;
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        try {
            if (!this.startRowCalled) {
                this.startRowCalled = true;
            }
            this.cache.addRow(row.getCells());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void endRow(RowParameter row) {
    }

    @Override
    public void startData(DataParameter data) {
        this.startRowCalled = false;
    }

    @Override
    public void endData(DataParameter data) throws DashboardException {
        this.currentTable = this.cache.getTable(this.timeZone, this.locale);
        this.cache.reset();
        this.currentTable.setColorList(this.chartColorList);
        this.currentTable.setThresholds(this.thresholds);
        if (this.sectionStack == null && this.startRowCalled && TableFactory.hasData((Table)this.currentTable)) {
            TableDocument td = new TableDocument();
            td.setName(this.guidFactory.generateGUID((Object)td));
            td.setTable(this.currentTable);
            if (this.report.getColRowInversion()) {
                TableFactory.transpose((Table)this.currentTable);
            }
            this.document.add((Document)td);
            this.currentTable = null;
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public BeanReportCrossTable getReport() {
        return this.report;
    }

    public void setReport(BeanReportCrossTable report) {
        this.report = report;
    }

    public Thresholds getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(Thresholds thresholds) {
        this.thresholds = thresholds;
    }

    @Override
    public void startRupture(RuptureParameter rupture) throws DashboardException {
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
    }

    public ColorList getChartColorList() {
        return this.chartColorList;
    }

    public void setChartColorList(ColorList chartColorList) {
        this.chartColorList = chartColorList;
    }

    public ReportDocument getDocument() {
        return this.document;
    }

    public boolean isPageBreakOnSection() {
        return this.pageBreakOnSection;
    }

    public void setPageBreakOnSection(boolean pageBreakOnSection) {
        this.pageBreakOnSection = pageBreakOnSection;
    }
}

