/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.AbstractDataHandler;
import com.prelytis.dashboard.data.transformation.CellEltFactory;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.util.TableFactory;
import com.prelytis.dashboard.value.chart.Cell;
import com.prelytis.dashboard.value.chart.CellHeader;
import com.prelytis.dashboard.value.chart.CellHeaderElt;
import com.prelytis.dashboard.value.chart.ColRow;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.structure.Document;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.structure.TableDocument;
import com.prelytis.dashboard.value.util.ClassElement;
import com.prelytis.dashboard.value.util.ColorList;
import com.prelytis.dashboard.value.util.FieldMetaData;
import com.prelytis.dashboard.value.util.StyleElement;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class TableContainerQueryHandler
extends AbstractDataHandler {
    private final ReportDocument document = new ReportDocument();
    private Table currentTable;
    private Locale locale;
    private TimeZone timeZone;
    private ClassElement bodyCE = new ClassElement();
    private ClassElement headerCE;
    private String bodyFmt = "{0}";
    private CellEltFactory cellEltFactory;
    private ColorList colorList;

    public TableContainerQueryHandler() {
        this.bodyCE.setName("tbl-body");
        this.bodyCE.setStyle(new StyleElement());
        this.headerCE = new ClassElement();
        this.headerCE.setName("tbl-header");
        this.headerCE.setStyle(new StyleElement());
    }

    @Override
    public void startContainer(ContainerParameter container) throws DashboardException {
        this.cellEltFactory = new CellEltFactory();
        this.colorList = new ColorList();
        this.colorList.addColor((Object)"999999");
        this.colorList.addColor((Object)"BBBBBB");
        this.colorList.addColor((Object)"DDDDDD");
    }

    @Override
    public void endContainer(ContainerParameter container) throws DashboardException {
    }

    @Override
    public void startSection(SectionParameter section) throws DashboardException {
    }

    @Override
    public void endSection(SectionParameter section) throws DashboardException {
    }

    @Override
    public void startData(DataParameter data) throws DashboardException {
        this.currentTable = TableFactory.getStdTable((TimeZone)this.timeZone, (Locale)this.locale, (int)data.getNbCols());
        this.currentTable.setColorList(this.colorList);
        ColRow tableRow = TableFactory.addRow((Table)this.currentTable);
        List<FieldMetaData> fmdList = data.getMetaDataList();
        for (int i = 0; i < fmdList.size(); ++i) {
            CellHeader cell = (CellHeader)tableRow.get(i);
            FieldMetaData fmd = fmdList.get(i);
            CellHeaderElt cellHeaderElt = new CellHeaderElt();
            cellHeaderElt.setCell((Cell)cell);
            cellHeaderElt.setClassElement(this.headerCE);
            cellHeaderElt.setFormat(this.bodyFmt);
            cellHeaderElt.setValue((Object)fmd.getName());
            cell.setCellHeaderElt(cellHeaderElt);
        }
    }

    @Override
    public void endData(DataParameter data) throws DashboardException {
        TableDocument td = new TableDocument();
        td.setName("preview");
        this.document.add((Document)td);
        td.setTable(this.currentTable);
        this.document.add((Document)td);
        this.currentTable = null;
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        ColRow tableRow = TableFactory.addRow((Table)this.currentTable);
        List<RowCell> list = row.getCells();
        for (int i = 0; i < list.size(); ++i) {
            Cell cell = (Cell)tableRow.get(i);
            RowCell rowCell = list.get(i);
            this.cellEltFactory.setCellValue(cell, rowCell);
        }
    }

    @Override
    public void endRow(RowParameter row) throws DashboardException {
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void startRupture(RuptureParameter rupture) throws DashboardException {
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
    }

    public ReportDocument getDocument() {
        return this.document;
    }
}

