/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.interfaces.DataHandler;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.interfaces.DashboardException;
import java.util.List;

public class TextDataHandler
implements DataHandler {
    StringBuffer str = new StringBuffer();

    @Override
    public void startContainer(ContainerParameter container) {
        this.str.append("<container>\n");
    }

    @Override
    public void endContainer(ContainerParameter container) {
        this.str.append("</container>\n");
    }

    @Override
    public void startSection(SectionParameter section) {
        this.str.append("<section num=\"").append(section.getSectionNum()).append("\" value=\"").append(section.getValue()).append("\">\n");
    }

    @Override
    public void endSection(SectionParameter section) {
        this.str.append("</section>\n");
    }

    @Override
    public void startRow(RowParameter row) {
        this.str.append("<row num=\"").append(row.getRowNumber()).append("\">\n");
        List<RowCell> list = row.getCells();
        for (int i = 0; i < list.size(); ++i) {
            RowCell cell = list.get(i);
            this.str.append("<cell num=\"").append(i).append("\" value=\"").append(cell.toString()).append("\"/>\n");
        }
    }

    @Override
    public void endRow(RowParameter row) {
        this.str.append("</row>\n");
    }

    public String getValue() {
        return this.str.toString();
    }

    @Override
    public void startData(DataParameter data) {
        this.str.append("<data>\n");
    }

    @Override
    public void endData(DataParameter data) {
        this.str.append("</data>\n");
    }

    @Override
    public void startRupture(RuptureParameter rupture) throws DashboardException {
        this.str.append("<rupture>\n");
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
        this.str.append("</rupture>\n");
    }
}

