/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.transformation;

import com.prelytis.dashboard.data.transformation.PrevColumnCalculationHelper;
import com.prelytis.dashboard.data.transformation.parameter.AbstractRowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueDecimalNumber;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.db.value.ValueString;
import java.math.BigDecimal;
import java.util.List;

public class TrendCalculationHelper
implements PrevColumnCalculationHelper {
    private int decal;
    private List<Integer> calculationList;

    @Override
    public List<Integer> getCalculationList() {
        return this.calculationList;
    }

    @Override
    public void setCalculationList(List<Integer> calculationList) {
        this.calculationList = calculationList;
    }

    @Override
    public void updateCalculation(AbstractRowParameter row) {
        if (this.calculationList != null) {
            List<RowCell> list = row.getCells();
            for (Integer col : this.calculationList) {
                if (col <= 0) continue;
                RowCell cell1 = list.get(this.decal + col - 1);
                Value value1 = cell1.getValue();
                RowCell cell2 = list.get(this.decal + col);
                Value value2 = cell2.getValue();
                if (value1 instanceof ValueDecimalNumber && value2 instanceof ValueDecimalNumber) {
                    BigDecimal p = ((ValueDecimalNumber)value1).getDecimalValue();
                    BigDecimal c = ((ValueDecimalNumber)value2).getDecimalValue();
                    switch (c.compareTo(p)) {
                        case -1: {
                            cell2.setValue((Value)new ValueString("down"));
                            break;
                        }
                        case 0: {
                            cell2.setValue((Value)new ValueString("stable"));
                            break;
                        }
                        case 1: {
                            cell2.setValue((Value)new ValueString("up"));
                        }
                    }
                    continue;
                }
                cell2.setValue((Value)ValueNull.STRING);
            }
        }
    }
}

