/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.prelytis.dashboard.chart.IPaintable;
import com.prelytis.dashboard.document.GIF.GIFEncoder;
import com.prelytis.dashboard.document.factory.AbstractImageFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.value.structure.ImageDocument;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

final class GIFFactory
extends AbstractImageFactory {
    GIFFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageDocument getImageDocument(I18nElement elt, IPaintable paintable, Dimension size, double scale, Integer dpi, boolean scaletofit) throws DashboardException {
        try {
            IPaintable p = this.getPaintable(paintable, size, scale);
            int width = (int)p.getSize().getWidth();
            int height = (int)p.getSize().getHeight();
            BufferedImage image = new BufferedImage(width, height, 13);
            Graphics2D graphics = image.createGraphics();
            try {
                graphics.setPaint(Color.WHITE);
                graphics.fillRect(0, 0, width, height);
                p.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
            ImageDocument imageDocument = this.getImageDocument(image, dpi, elt.getName());
            imageDocument.setObjectID(elt.getObjectID());
            imageDocument.getDescriptionMap().putAll(elt.getDescriptionMap());
            imageDocument.setAreas(p.getAreas());
            imageDocument.setImageHeight(height);
            imageDocument.setImageWidth(width);
            return imageDocument;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageDocument getImageDocument(BufferedImage image, Integer dpi, String name) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            GIFEncoder encoder = new GIFEncoder(image, (OutputStream)out, true);
            encoder.encode();
        }
        ImageDocument imageDocument = new ImageDocument();
        imageDocument.setName(name);
        imageDocument.setFileName(name + ".gif");
        imageDocument.setContentType("image/gif");
        imageDocument.setData(out.toByteArray());
        imageDocument.setReference(GuidFactory.getInstance().generateGUID((Object)imageDocument));
        return imageDocument;
    }
}

