/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.prelytis.dashboard.chart.IPaintable;
import com.prelytis.dashboard.document.factory.AbstractImageFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.value.structure.ImageDocument;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.w3c.dom.NodeList;

final class JPEGFactory
extends AbstractImageFactory {
    private static final String JPEG_IMAGEIO_KEY = "javax_imageio_jpeg_image_1.0";
    private static final String JPEG_IMAGEIO_VARIETY_KEY = "pHYs";
    private static final String JPEG_IMAGEIO_JFIF_KEY = "app0JFIF";
    private float quality = 1.0f;

    JPEGFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageDocument getImageDocument(I18nElement elt, IPaintable paintable, Dimension size, double scale, Integer dpi, boolean scaletofit) throws DashboardException {
        try {
            IPaintable p = this.getPaintable(paintable, size, scale);
            int width = (int)p.getSize().getWidth();
            int height = (int)p.getSize().getHeight();
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D graphics = image.createGraphics();
            try {
                graphics.setPaint(Color.WHITE);
                graphics.fillRect(0, 0, width, height);
                p.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
            ImageDocument imageDocument = this.getImageDocument(image, dpi, elt.getName());
            imageDocument.setObjectID(elt.getObjectID());
            imageDocument.getDescriptionMap().putAll(elt.getDescriptionMap());
            imageDocument.setAreas(p.getAreas());
            imageDocument.setImageHeight(height);
            imageDocument.setImageWidth(width);
            return imageDocument;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageDocument getImageDocument(BufferedImage image, Integer dpi, String name) throws IOException {
        ByteArrayOutputStream out;
        block8: {
            out = new ByteArrayOutputStream();
            try {
                if (dpi != null) {
                    ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
                    Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, "jpeg");
                    ImageWriter writer = null;
                    if (!iter.hasNext()) {
                        throw new IOException("ImageWriter not found.");
                    }
                    writer = iter.next();
                    IIOMetadata metadata = writer.getDefaultImageMetadata(type, null);
                    IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(JPEG_IMAGEIO_KEY);
                    IIOMetadataNode variety = this.getNode(root, JPEG_IMAGEIO_VARIETY_KEY);
                    IIOMetadataNode jfif = this.getNode(variety, JPEG_IMAGEIO_JFIF_KEY);
                    String sdpi = String.valueOf(dpi);
                    jfif.setAttribute("resUnits", "1");
                    jfif.setAttribute("Xdensity", sdpi);
                    jfif.setAttribute("Ydensity", sdpi);
                    metadata.setFromTree(JPEG_IMAGEIO_KEY, root);
                    try {
                        writer.setOutput(ImageIO.createImageOutputStream(out));
                        writer.write(new IIOImage(image, null, metadata));
                        break block8;
                    }
                    finally {
                        writer.dispose();
                    }
                }
                Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("jpeg");
                ImageWriter writer = it.next();
                writer.setOutput(new MemoryCacheImageOutputStream(out));
                ImageWriteParam param = writer.getDefaultWriteParam();
                param.setCompressionMode(2);
                param.setCompressionQuality(this.quality);
                IIOImage img = new IIOImage(image, null, null);
                writer.write(null, img, param);
            }
            finally {
                out.close();
            }
        }
        ImageDocument imageDocument = new ImageDocument();
        imageDocument.setName(name);
        imageDocument.setFileName(name + ".jpg");
        imageDocument.setContentType("image/jpeg");
        imageDocument.setData(out.toByteArray());
        imageDocument.setReference(GuidFactory.getInstance().generateGUID((Object)imageDocument));
        return imageDocument;
    }

    private IIOMetadataNode getNode(IIOMetadataNode parent, String key) {
        NodeList nodeList = parent.getElementsByTagName(key);
        IIOMetadataNode node = nodeList.getLength() > 0 ? (IIOMetadataNode)nodeList.item(0) : (IIOMetadataNode)parent.appendChild(new IIOMetadataNode(key));
        return node;
    }
}

