/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.prelytis.dashboard.chart.IChart;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.data.helper.NoDataHelper;
import com.prelytis.dashboard.data.transformation.interfaces.NoDataHandler;
import com.prelytis.dashboard.document.factory.AbstractFactoryTable;
import com.prelytis.dashboard.document.factory.ChartFactory;
import com.prelytis.dashboard.document.factory.DocumentPageEvent;
import com.prelytis.dashboard.document.factory.PDFiTextHelper;
import com.prelytis.dashboard.document.factory.PageLayout;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.helper.StyleHelper;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.util.TableFactory;
import com.prelytis.dashboard.value.chart.CellHeader;
import com.prelytis.dashboard.value.chart.CellHeaderElt;
import com.prelytis.dashboard.value.chart.ColRow;
import com.prelytis.dashboard.value.chart.DisplayProperties;
import com.prelytis.dashboard.value.chart.ICellElt;
import com.prelytis.dashboard.value.chart.PaintableProperties;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.chart.properties.AbstractChartProperties;
import com.prelytis.dashboard.value.data.BeanDisplayType;
import com.prelytis.dashboard.value.data.BeanPageLayout;
import com.prelytis.dashboard.value.data.BeanPersFieldValue;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.data.CrossTableLabel;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.structure.AbstractDocument;
import com.prelytis.dashboard.value.structure.DashboardBlock;
import com.prelytis.dashboard.value.structure.DashboardDocument;
import com.prelytis.dashboard.value.structure.DashboardTemplate;
import com.prelytis.dashboard.value.structure.Document;
import com.prelytis.dashboard.value.structure.ImageDocument;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.structure.SectionDocument;
import com.prelytis.dashboard.value.structure.TableDocument;
import com.prelytis.dashboard.value.structure.TextDocument;
import com.prelytis.dashboard.value.util.ClassElement;
import com.prelytis.dashboard.value.util.StyleElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PDFiTextFactoryTable
extends AbstractFactoryTable {
    private static final String PDF = "application/pdf";
    private final DaoFactory daoFactory;
    private final Map<String, BeanStyleDefinition> styleMap = new HashMap<String, BeanStyleDefinition>();
    private final boolean shapes = true;
    private final PageLayout pageLayout;
    private List<? extends ReportFilter> reportFilterList;
    private boolean displayReportTop = false;
    private String author = "Axway Sentinel Web Dashboard";
    private String creator = "Axway Sentinel Web Dashboard";
    private String fileName = "export.pdf";
    private String title;
    private String subject;

    public PDFiTextFactoryTable(DaoFactory daoFactory, AbstractDocument document, Locale locale, PageLayout pageLayout, List<BeanPersFieldValue> persFieldValueList) {
        super(document, locale);
        this.daoFactory = daoFactory;
        this.pageLayout = pageLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageDocument getImageDocument() throws DashboardException {
        try {
            try (ByteArrayOutputStream pdfOS = new ByteArrayOutputStream();){
                com.lowagie.text.Document pdfDocument = new com.lowagie.text.Document(new Rectangle(this.pageLayout.unitToPt(this.pageLayout.getPageWidth()), this.pageLayout.unitToPt(this.pageLayout.getPageHeight())), this.pageLayout.unitToPt(this.pageLayout.getLeftMargin()), this.pageLayout.unitToPt(this.pageLayout.getRightMargin()), this.pageLayout.unitToPt(this.pageLayout.getTopMargin() + this.pageLayout.getHeaderHeight()), this.pageLayout.unitToPt(this.pageLayout.getBottomMargin() + this.pageLayout.getFooterHeight()));
                try {
                    PdfWriter pdfWriter = PdfWriter.getInstance((com.lowagie.text.Document)pdfDocument, (OutputStream)pdfOS);
                    pdfWriter.setPdfVersion(PDFiTextHelper.getPdfVersion(this.pageLayout.getPdfVersion()));
                    if (this.pageLayout.isFullCompression()) {
                        pdfWriter.setFullCompression();
                    }
                    if (this.pageLayout.getEncrypt() != BeanPageLayout.Encryption.NONE) {
                        byte[] uPwd = null;
                        if (this.pageLayout.getUserPassword() != null) {
                            uPwd = this.pageLayout.getUserPassword().getBytes("UTF-8");
                        }
                        byte[] oPwd = null;
                        if (this.pageLayout.getOwnerPassword() != null) {
                            oPwd = this.pageLayout.getOwnerPassword().getBytes("UTF-8");
                        }
                        pdfWriter.setEncryption(uPwd, oPwd, PDFiTextHelper.getPermissions(this.pageLayout.getPerms()), PDFiTextHelper.getEncryption(this.pageLayout.getEncrypt()));
                    }
                    pdfWriter.setPageEvent((PdfPageEvent)new DocumentPageEvent(this.pageLayout, this.getLocale()));
                    pdfDocument.addCreator(this.creator);
                    pdfDocument.addAuthor(this.author);
                    if (this.title != null) {
                        pdfDocument.addTitle(this.title);
                    }
                    if (this.subject != null) {
                        pdfDocument.addSubject(this.subject);
                    }
                    pdfDocument.open();
                    float pageWidth = this.pageLayout.unitToPt(this.pageLayout.getPageWidth() - this.pageLayout.getLeftMargin() - this.pageLayout.getRightMargin());
                    if (this.title != null) {
                        pdfDocument.add((Element)new Paragraph(this.title, new Font(1, (float)this.pageLayout.getFontSize()[5])));
                    }
                    this.fillAD(pdfWriter, pdfDocument, (Document)this.document, pageWidth);
                }
                finally {
                    if (pdfDocument.isOpen()) {
                        pdfDocument.close();
                    }
                }
            }
            ImageDocument imageDocument = new ImageDocument();
            imageDocument.setObjectID(this.document.getObjectID());
            imageDocument.setName(this.document.getName());
            imageDocument.setDescription(this.document.getDescription());
            imageDocument.getDescriptionMap().putAll(this.document.getDescriptionMap());
            imageDocument.setData(pdfOS.toByteArray());
            imageDocument.setContentType(PDF);
            String timeStamp = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
            imageDocument.setFileName(this.document.getDescription() + "-" + timeStamp + ".pdf");
            imageDocument.setReference(GuidFactory.getInstance().generateGUID((Object)imageDocument));
            return imageDocument;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private List<ReportFilter> getBlockFilters(DashboardTemplate template, int blockId) {
        ArrayList<ReportFilter> filterList = new ArrayList<ReportFilter>();
        DashboardBlock block = (DashboardBlock)template.getBlockList().get(blockId);
        List listOfFilters = block.getFilterList();
        if (listOfFilters != null) {
            for (ReportFilter filter : listOfFilters) {
                if (!filter.getUseFilter()) continue;
                filterList.add(filter);
            }
        }
        return filterList;
    }

    private void fillAD(PdfWriter pdfWriter, com.lowagie.text.Document pdfDocument, Document documentPart, float width) throws DashboardException, DocumentException {
        if (documentPart instanceof ReportDocument) {
            this.fill(pdfWriter, pdfDocument, (ReportDocument)documentPart, width);
        } else if (documentPart instanceof DashboardDocument) {
            DashboardDocument doc = (DashboardDocument)documentPart;
            boolean np = false;
            for (DashboardTemplate template : doc.getTemplateList()) {
                String tn = template.getDescription();
                if (np) {
                    pdfDocument.newPage();
                }
                if (tn != null) {
                    pdfDocument.add((Element)new Paragraph(tn, new Font(1, (float)this.pageLayout.getFontSize()[4])));
                    np = false;
                }
                for (DashboardBlock block : template.getBlockList()) {
                    Document d = block.getUserObject();
                    int blockId = block.getId();
                    List<ReportFilter> filterList = this.getBlockFilters(template, blockId);
                    if (filterList.size() > 0) {
                        this.setReportFilterList(filterList);
                    }
                    if (d instanceof ReportDocument) {
                        String bn = d.getDescription();
                        if (np) {
                            pdfDocument.newPage();
                        }
                        if (bn != null) {
                            pdfDocument.add((Element)new Paragraph(bn, new Font(1, (float)this.pageLayout.getFontSize()[3])));
                            np = false;
                        }
                        this.fill(pdfWriter, pdfDocument, (ReportDocument)d, width);
                        np = true;
                    }
                    this.setReportFilterList(null);
                }
            }
        }
    }

    private void fill(PdfWriter writer, com.lowagie.text.Document pdfDocument, PDFiTextHelper pdfiTextHelper, SectionDocument section, float width) throws DashboardException {
        try {
            if (section.getData() != null) {
                Cell pdfCell;
                MessageFormat mf = new MessageFormat(section.getPattern(), this.locale);
                String label = mf.format(new Object[]{section.getData()});
                com.lowagie.text.Table pdfTable = new com.lowagie.text.Table(1);
                pdfTable.setPadding(2.0f);
                pdfTable.setWidth(100.0f);
                pdfTable.setBorder(0);
                Font font = pdfiTextHelper.getFont(section.getClassElement());
                if (font != null) {
                    pdfCell = new Cell((Element)new Phrase(label, font));
                    StyleElement styleElement = pdfiTextHelper.getStyleElement(section.getClassElement());
                    pdfCell.setBackgroundColor(PDFiTextHelper.getColor(styleElement.getBackColor()));
                    pdfCell.setHorizontalAlignment(PDFiTextHelper.getHorizontalAlignment(styleElement));
                } else {
                    pdfCell = new Cell((Element)new Phrase(label));
                }
                pdfTable.addCell(pdfCell);
                if (section.isPageBreakBefore()) {
                    pdfDocument.newPage();
                }
                pdfDocument.add((Element)pdfTable);
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private void fill(PdfWriter pdfWriter, com.lowagie.text.Document pdfDocument, ReportDocument doc, float width) throws DashboardException, DocumentException {
        com.lowagie.text.Table tableComment;
        com.lowagie.text.Table filterTable = this.getFilterPart(this.pageLayout, width);
        boolean filterFirst = this.getDisplayReportTop();
        if (filterFirst && filterTable != null) {
            pdfDocument.add((Element)filterTable);
        }
        if (!doc.isEmpty()) {
            BeanStyleDefinition style = this.styleMap.get(doc.getStyle());
            if (style == null) {
                StyleHelper styleHelper = StyleHelper.getInstance(this.daoFactory);
                style = styleHelper.getDefinition(doc.getStyle());
                this.styleMap.put(style.getName(), style);
            }
            PDFiTextHelper pdfiTextHelper = new PDFiTextHelper(this.locale, style, this.pageLayout.getTheme());
            for (int i = 0; i < doc.size(); ++i) {
                AbstractDocument documentPart = doc.getDocument(i);
                if (documentPart instanceof TableDocument) {
                    this.fill(pdfWriter, pdfDocument, pdfiTextHelper, (TableDocument)documentPart, doc.getDisplayProperties(), width);
                    continue;
                }
                if (!(documentPart instanceof SectionDocument)) continue;
                this.fill(pdfWriter, pdfDocument, pdfiTextHelper, (SectionDocument)documentPart, width);
            }
        } else {
            Font font = new Font(1, (float)this.pageLayout.getFontSize()[4], 0, Color.black);
            pdfDocument.add((Element)new Paragraph("   ", font));
        }
        if (!filterFirst && filterTable != null) {
            pdfDocument.add((Element)filterTable);
        }
        if ((tableComment = this.getCommentTable(this.pageLayout, doc.getComment())) != null) {
            pdfDocument.add((Element)tableComment);
        }
    }

    private void fill(PdfWriter pdfWriter, com.lowagie.text.Document pdfDocument, PDFiTextHelper pdfiTextHelper, TextDocument documentPart, float width) throws DashboardException, DocumentException {
        StyleElement styleElement = documentPart.getFont();
        pdfDocument.add((Element)new Paragraph(documentPart.getText(), pdfiTextHelper.getFont(styleElement)));
    }

    private void fill(PdfWriter pdfWriter, com.lowagie.text.Document pdfDocument, PDFiTextHelper pdfiTextHelper, TableDocument tableDocument, DisplayProperties dp, float width) throws DashboardException, DocumentException {
        Table table = tableDocument.getTable();
        if (TableFactory.hasData((Table)table)) {
            BeanDisplayType displayType = dp.getDisplayType();
            if (displayType != null && displayType != BeanDisplayType.TABLE && displayType != BeanDisplayType.SEARCH) {
                this.fillChartDocument(pdfWriter, pdfDocument, tableDocument, dp, pdfiTextHelper.getStyle(), width);
            } else if (table.getReportType() == 1) {
                this.fillCrossTableDocument(pdfWriter, pdfDocument, pdfiTextHelper, tableDocument, width);
            } else {
                this.fillStdDocument(pdfWriter, pdfDocument, pdfiTextHelper, tableDocument, width);
            }
        } else {
            Font font = new Font(1, (float)this.pageLayout.getFontSize()[3], 0, Color.black);
            String noDataFound = "no data";
            pdfDocument.add((Element)new Paragraph(noDataFound, font));
        }
    }

    private void fillCrossTableDocument(PdfWriter pdfWriter, com.lowagie.text.Document pdfDocument, PDFiTextHelper pdfiTextHelper, TableDocument tableDocument, float width) throws DashboardException, DocumentException {
        int row1NbRows = 1;
        Table table = tableDocument.getTable();
        try {
            row1NbRows = this.getNbSubHeader(TableFactory.getFinalCell((Table)table, (int)1, (int)0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int col1NbCols = 1;
        try {
            col1NbCols = this.getNbSubHeader(TableFactory.getFinalCell((Table)table, (int)0, (int)1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int nbCols = TableFactory.getFinalNbCols((Table)table);
        int nbRows = TableFactory.getFinalNbRows((Table)table);
        int factor = 1;
        int colOffset = 0;
        if (table.isHorizontalData() && table.getDataDescriptions() != null) {
            factor = table.getDataDescriptions().length;
        }
        if (table.isDisplayDataDescription() && !table.isHorizontalData()) {
            ++colOffset;
        }
        com.lowagie.text.Table pdfTable = new com.lowagie.text.Table((nbCols - 1) * factor + col1NbCols + colOffset);
        pdfTable.setBorder(0);
        pdfTable.setPadding(2.0f);
        pdfTable.setWidths(this.getWidths(table, factor, colOffset));
        pdfTable.setWidth(100.0f);
        Context context = new Context(col1NbCols);
        this.fillFirstRow(pdfiTextHelper, pdfTable, table, TableFactory.getFinalRow((Table)table, (int)0), col1NbCols, row1NbRows);
        for (int i = 1; i < nbRows; ++i) {
            int k;
            ColRow row = TableFactory.getFinalRow((Table)table, (int)i);
            if (table.isHorizontalData()) {
                context.fillFirstCell(pdfiTextHelper, pdfTable, table, (CellHeader)TableFactory.getFinalCell((ColRow)row, (int)0));
                for (int j = 1; j < nbCols; ++j) {
                    com.prelytis.dashboard.value.chart.Cell cell = TableFactory.getFinalCell((ColRow)row, (int)j);
                    for (k = 0; k < TableFactory.getNbCellElt((com.prelytis.dashboard.value.chart.Cell)cell); ++k) {
                        ICellElt cellElt = TableFactory.getCellElt((com.prelytis.dashboard.value.chart.Cell)cell, (int)k);
                        Cell pdfCell = pdfiTextHelper.getPdfCell(cellElt);
                        pdfTable.addCell(pdfCell);
                    }
                }
                continue;
            }
            String[] dataDescriptions = table.getDataDescriptions();
            boolean displayDescription = dataDescriptions != null && dataDescriptions.length > 0 && table.isDisplayDataDescription();
            context.fillFirstCell(pdfiTextHelper, pdfTable, table, (CellHeader)TableFactory.getFinalCell((ColRow)row, (int)0));
            if (displayDescription) {
                this.fillMVCells(pdfiTextHelper, pdfTable, table, row, dataDescriptions[0], 0);
            }
            if (!displayDescription) continue;
            for (k = 1; k < dataDescriptions.length; ++k) {
                this.fillMVCells(pdfiTextHelper, pdfTable, table, row, dataDescriptions[k], k);
            }
        }
        pdfDocument.add((Element)pdfTable);
    }

    private void fillMVCells(PDFiTextHelper pdfiTextHelper, com.lowagie.text.Table pdfTable, Table table, ColRow row, String dataDescription, int k) throws BadElementException {
        Cell pdfCell = pdfiTextHelper.getPdfCell(dataDescription);
        pdfTable.addCell(pdfCell);
        for (int j = 1; j < TableFactory.getFinalNbCols((Table)table); ++j) {
            com.prelytis.dashboard.value.chart.Cell cell = TableFactory.getFinalCell((ColRow)row, (int)j);
            if (cell == null || TableFactory.getNbCellElt((com.prelytis.dashboard.value.chart.Cell)cell) <= k) continue;
            ICellElt cellElt = TableFactory.getCellElt((com.prelytis.dashboard.value.chart.Cell)cell, (int)k);
            pdfCell = pdfiTextHelper.getPdfCell(cellElt);
            pdfTable.addCell(pdfCell);
        }
    }

    private void fillStdDocument(PdfWriter pdfWriter, com.lowagie.text.Document pdfDocument, PDFiTextHelper pdfiTextHelper, TableDocument tableDocument, float width) throws DashboardException, DocumentException {
        Table table = tableDocument.getTable();
        int nbCols = TableFactory.getFinalNbCols((Table)table);
        int nbRows = TableFactory.getFinalNbRows((Table)table);
        final com.lowagie.text.Table pdfTable = new com.lowagie.text.Table(nbCols);
        pdfTable.setBorder(0);
        pdfTable.setPadding(2.0f);
        pdfTable.setWidths(this.getWidths(table, 1, 0));
        pdfTable.setWidth(100.0f);
        final ValueContext vc = new ValueContext(pdfiTextHelper, nbCols, nbRows, TableFactory.getColRowInv((Table)table));
        boolean noDataTable = NoDataHelper.isNoDataTable(table);
        if (noDataTable) {
            NoDataHelper.buildNoDataTable(new NoDataHandler(){

                @Override
                public void fill(com.prelytis.dashboard.value.chart.Cell cell, int colIdx, int rowIdx, Integer colSpan, Integer rowSpan) throws BadElementException {
                    vc.fillCell(pdfTable, colIdx, rowIdx, cell, colSpan, rowSpan);
                }
            }, table, nbRows, nbCols);
        } else {
            for (int i = 0; i < nbRows; ++i) {
                ColRow row = TableFactory.getFinalRow((Table)table, (int)i);
                for (int j = 0; j < nbCols; ++j) {
                    vc.fillCell(pdfTable, j, i, TableFactory.getFinalCell((ColRow)row, (int)j));
                }
                if (i != 0) continue;
                pdfTable.endHeaders();
            }
        }
        pdfDocument.add((Element)pdfTable);
    }

    private void fillChartDocument(PdfWriter pdfWriter, com.lowagie.text.Document pdfDocument, TableDocument tableDocument, DisplayProperties dp, BeanStyleDefinition style, float width) throws DashboardException {
        try {
            float height = this.pageLayout.unitToPt(this.pageLayout.getPageHeight() - this.pageLayout.getTopMargin() - this.pageLayout.getHeaderHeight() - this.pageLayout.getBottomMargin() - this.pageLayout.getFooterHeight()) - (float)(7 * this.pageLayout.getFontSize()[5]);
            if (width > height * 3.0f / 2.0f) {
                width = height * 3.0f / 2.0f;
            } else {
                height = width * 2.0f / 3.0f;
            }
            PdfContentByte pdfCB = pdfWriter.getDirectContent();
            PdfTemplate pdfT = pdfCB.createTemplate(width, height);
            Graphics2D graphics = null;
            this.getClass();
            graphics = pdfT.createGraphicsShapes(width, height);
            Dimension dim = new Dimension((int)width, (int)height);
            if (dp instanceof AbstractChartProperties) {
                AbstractChartProperties chartProperties = (AbstractChartProperties)dp;
                chartProperties.setInteractive(Boolean.FALSE);
                IChart chart = ChartFactory.getInstance(this.daoFactory).getChart(dp.getDisplayType(), (PaintableProperties)chartProperties, tableDocument.getTable(), style);
                chart.setScreen(tableDocument.getScreen());
                chart.setSize(dim);
                chart.init();
                chart.paint(graphics);
            }
            pdfDocument.add((Element)Image.getInstance((PdfTemplate)pdfT));
            graphics.dispose();
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private int[] getWidths(Table table, int factor, int colOffset) {
        int i;
        int col1NbCols = 1;
        try {
            col1NbCols = this.getNbSubHeader(TableFactory.getFinalCell((Table)table, (int)0, (int)1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int nbCols = TableFactory.getFinalNbCols((Table)table);
        int[] widths = new int[(nbCols - 1) * factor + col1NbCols + colOffset];
        int totalWidth = (int)(this.pageLayout.unitToPt(this.pageLayout.getPageWidth() - this.pageLayout.getLeftMargin() - this.pageLayout.getRightMargin()) * 100.0f);
        int stdWidth = totalWidth / nbCols;
        int nbAuto = 0;
        for (i = 0; i < nbCols; ++i) {
            int j;
            int calcWidth = -1;
            String width = null;
            try {
                width = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (width == null || "auto".equalsIgnoreCase(width) || width.length() <= 2) {
                calcWidth = -1;
            } else {
                String unit = width.substring(width.length() - 2);
                try {
                    calcWidth = Integer.parseInt(width.substring(0, width.length() - 2));
                    calcWidth = "in".equalsIgnoreCase(unit) ? (calcWidth *= 7200) : ("cm".equalsIgnoreCase(unit) ? (calcWidth *= 2830) : ("mm".equalsIgnoreCase(unit) ? (calcWidth *= 283) : ("pt".equalsIgnoreCase(unit) ? (calcWidth *= 100) : ("pc".equalsIgnoreCase(unit) ? (calcWidth *= 1200) : ("px".equalsIgnoreCase(unit) ? (calcWidth *= 100) : -1)))));
                }
                catch (Exception e) {
                    calcWidth = -1;
                }
            }
            if (calcWidth > 0) {
                totalWidth -= calcWidth;
            } else {
                nbAuto = i == 0 ? (nbAuto += col1NbCols) : (nbAuto += factor);
            }
            if (i == 0) {
                for (j = 0; j < col1NbCols; ++j) {
                    widths[j] = calcWidth;
                }
                for (j = 0; j < colOffset; ++j) {
                    widths[col1NbCols + j] = calcWidth;
                }
                continue;
            }
            for (j = 0; j < factor; ++j) {
                widths[(i - 1) * factor + colOffset + col1NbCols + j] = calcWidth;
            }
        }
        if (nbAuto > 0) {
            if (totalWidth > 1000 * nbAuto) {
                stdWidth = totalWidth / nbAuto;
            }
            for (i = 0; i < widths.length; ++i) {
                if (widths[i] >= 0) continue;
                widths[i] = stdWidth;
            }
        }
        return widths;
    }

    private com.lowagie.text.Table getCommentTable(PageLayout pageLayout, String comment) throws DocumentException {
        com.lowagie.text.Table commentTable = null;
        boolean showComment = true;
        if (comment != null && !comment.equals("") && showComment) {
            float[] widths = new float[]{100.0f};
            commentTable = new com.lowagie.text.Table(1);
            commentTable.setWidths(widths);
            commentTable.setWidth(100.0f);
            commentTable.setBorder(0);
            Font pdfFont = new Font(1, (float)pageLayout.getFontSize()[3], 0, Color.black);
            Cell cell = new Cell((Element)new Phrase(comment, pdfFont));
            cell.setBorder(0);
            commentTable.addCell(cell);
        }
        return commentTable;
    }

    private com.lowagie.text.Table getFilterPart(PageLayout pageLayout, float width) throws DashboardException, DocumentException {
        com.lowagie.text.Table table = null;
        int numberOfColumns = 2;
        if (this.reportFilterList != null && this.hasVisibleFilter(this.reportFilterList)) {
            Font font = new Font(1, (float)(pageLayout.getFontSize()[3] - 2), 0, Color.black);
            ConversionHelper conversionHelper = ConversionHelper.getConverter((Locale)this.locale, null, (boolean)true);
            class FilterDescriptionAndValues {
                private String description;
                private String values;

                public FilterDescriptionAndValues(String description, String values) {
                    this.description = description;
                    this.values = values;
                }

                public String getDescription() {
                    return this.description;
                }

                public String getValues() {
                    return this.values;
                }
            }
            ArrayList<FilterDescriptionAndValues> displayableFilters = new ArrayList<FilterDescriptionAndValues>();
            for (int i = 0; i < this.reportFilterList.size(); ++i) {
                ReportFilter filter = this.reportFilterList.get(i);
                if (!filter.getUseFilter() || !filter.isVisible()) continue;
                String[] parameter = null;
                try {
                    parameter = conversionHelper.format(filter.getValues());
                }
                catch (Exception e) {
                    parameter = null;
                }
                StringBuffer strParam = new StringBuffer();
                if (parameter != null) {
                    for (int j = 0; j < parameter.length; ++j) {
                        if (j != 0) {
                            strParam.append(", ");
                        }
                        strParam.append(parameter[j]);
                    }
                }
                displayableFilters.add(new FilterDescriptionAndValues(filter.getDescription(), strParam.toString()));
            }
            table = new com.lowagie.text.Table(numberOfColumns);
            float[] widths = new float[numberOfColumns];
            Arrays.fill(widths, 100.0f / (float)numberOfColumns);
            table.setWidths(widths);
            table.setWidth(100.0f);
            table.setBorder(0);
            table.setPadding(0.0f);
            table.setSpacing(0.0f);
            for (FilterDescriptionAndValues displayableFilter : displayableFilters) {
                Cell cellFilter = new Cell((Element)new Phrase(displayableFilter.getDescription() + " : " + displayableFilter.getValues(), font));
                cellFilter.setBorder(0);
                table.addCell(cellFilter);
            }
            if (displayableFilters.size() % 2 != 0) {
                table.addCell(this.createBlankCell());
            }
            Cell blankCell = this.createBlankCell();
            blankCell.setColspan(numberOfColumns);
            table.addCell(blankCell);
        }
        return table;
    }

    private Cell createBlankCell() throws BadElementException {
        Cell blankCell = new Cell((Element)new Phrase("blank", new Font(1, 4.0f, 0, Color.WHITE)));
        blankCell.setBorder(0);
        return blankCell;
    }

    private boolean hasVisibleFilter(List<? extends ReportFilter> reportFilterList) {
        if (reportFilterList != null) {
            for (ReportFilter reportFilter : reportFilterList) {
                if (!reportFilter.isVisible()) continue;
                return true;
            }
        }
        return false;
    }

    private void fillFirstRow(PDFiTextHelper pdfiTextHelper, com.lowagie.text.Table pdfTable, Table table, ColRow row, int cell1X, int cell1Y) throws DashboardException, DocumentException {
        int nbCols = TableFactory.getFinalNbCols((Table)table);
        boolean horizontalData = table.isHorizontalData();
        boolean displayDataDescription = table.isDisplayDataDescription();
        String[] dataDescriptions = table.getDataDescriptions();
        int cell1YOffset = 0;
        int cell1XOffset = 0;
        if (displayDataDescription) {
            if (horizontalData) {
                ++cell1YOffset;
            } else {
                ++cell1XOffset;
            }
        }
        int factor = 1;
        if (horizontalData && dataDescriptions != null) {
            factor = dataDescriptions.length;
        }
        ArrayList<CellHeaderElt> l = new ArrayList<CellHeaderElt>();
        CellHeader c = (CellHeader)TableFactory.getFinalCell((Table)table, (int)0, (int)0);
        for (CellHeaderElt h = c.getCellHeaderElt(); h != null; h = h.getParent()) {
            l.add(0, h);
        }
        for (int i = 0; i < cell1Y; ++i) {
            Cell pdfCell;
            int j = 1;
            if (i == 0 && table.getFirstCell() == CrossTableLabel.ORDINATE) {
                int l2 = l.size();
                for (int k = 0; k < l2; ++k) {
                    CellHeaderElt h2 = (CellHeaderElt)l.get(k);
                    Cell pdfCell2 = pdfiTextHelper.getPdfCell((ICellElt)h2);
                    pdfCell2.setRowspan(cell1Y + cell1YOffset);
                    pdfTable.addCell(pdfCell2);
                }
                if (!horizontalData && displayDataDescription) {
                    pdfCell = new Cell();
                    pdfCell.setRowspan(cell1Y + cell1YOffset);
                    pdfTable.addCell(pdfCell);
                }
            } else if (i == 0 && table.getFirstCell() == CrossTableLabel.NONE) {
                Cell pdfCell3 = new Cell();
                pdfCell3.setColspan(cell1X + cell1XOffset);
                pdfCell3.setRowspan(cell1Y + cell1YOffset);
                pdfTable.addCell(pdfCell3);
            } else if (table.getFirstCell() == CrossTableLabel.ABSCISSE) {
                CellHeaderElt h2;
                CellHeaderElt cellHeaderElt = h2 = i < l.size() ? (CellHeaderElt)l.get(i) : null;
                if (h2 != null) {
                    Cell pdfCell4 = pdfiTextHelper.getPdfCell((ICellElt)h2);
                    pdfCell4.setColspan(cell1X + cell1XOffset);
                    pdfTable.addCell(pdfCell4);
                } else if (horizontalData && displayDataDescription) {
                    Cell pdfCell5 = new Cell();
                    pdfCell5.setColspan(cell1X + cell1XOffset);
                    pdfTable.addCell(pdfCell5);
                }
            }
            while (j < nbCols) {
                CellHeader cell = (CellHeader)TableFactory.getFinalCell((ColRow)row, (int)j);
                CellHeaderElt cellElt = TableFactory.getCellHeaderElt((CellHeader)cell, (int)(cell1Y - i - 1));
                pdfCell = pdfiTextHelper.getPdfCell((ICellElt)cellElt);
                if (cellElt.getNbReferences() != 1 || factor != 1) {
                    pdfCell.setColspan(factor * cellElt.getNbReferences());
                    j += cellElt.getNbReferences();
                } else {
                    ++j;
                }
                pdfTable.addCell(pdfCell);
            }
        }
        if (horizontalData && displayDataDescription) {
            int dataDescriptionSize = dataDescriptions.length;
            String className = "tbl-header";
            ClassElement ce = new ClassElement();
            ce.setName(className);
            StyleElement se = pdfiTextHelper.getStyleElement(ce);
            Font font = PDFiTextHelper.getFont(se, pdfiTextHelper.getFontSize());
            Color color = PDFiTextHelper.getColor(se.getBackColor());
            int horizontalAlignment = PDFiTextHelper.getHorizontalAlignment(se);
            for (int i = 1; i < nbCols; ++i) {
                for (int j = 0; j < dataDescriptionSize; ++j) {
                    Cell pdfCell = new Cell((Element)new Phrase(dataDescriptions[j], font));
                    pdfCell.setBackgroundColor(color);
                    pdfCell.setHorizontalAlignment(horizontalAlignment);
                    pdfTable.addCell(pdfCell);
                }
            }
        }
    }

    private int getNbSubHeader(com.prelytis.dashboard.value.chart.Cell cell) {
        if (cell instanceof CellHeader) {
            CellHeader cellHeader = (CellHeader)cell;
            return cellHeader.getCellHeaderElt().getLevel();
        }
        return 1;
    }

    public List<? extends ReportFilter> getReportFilterList() {
        return this.reportFilterList;
    }

    public void setReportFilterList(List<? extends ReportFilter> reportFilterList) {
        this.reportFilterList = reportFilterList;
    }

    public boolean getDisplayReportTop() {
        return this.displayReportTop;
    }

    public void setDisplayReportTop(boolean displayReportTop) {
        this.displayReportTop = displayReportTop;
    }

    private class Context {
        private int[] pos;

        public Context(int size) {
            this.pos = new int[size];
        }

        private void fillFirstCell(PDFiTextHelper pdfiTextHelper, com.lowagie.text.Table pdfTable, Table table, CellHeader cell) throws BadElementException {
            int factor = 1;
            if (!table.isHorizontalData() && table.isDisplayDataDescription()) {
                factor = table.getDataDescriptions().length;
            }
            int i = 0;
            while (i < this.pos.length) {
                if (this.pos[i] == 0) {
                    CellHeaderElt cellElt = TableFactory.getCellHeaderElt((CellHeader)cell, (int)(this.pos.length - i - 1));
                    Cell pdfCell = pdfiTextHelper.getPdfCell((ICellElt)cellElt);
                    if (cellElt != null) {
                        this.pos[i] = cellElt.getNbReferences();
                        if (this.pos[i] > 1 || factor != 1) {
                            pdfCell.setRowspan(factor * this.pos[i]);
                        }
                    }
                    pdfTable.addCell(pdfCell);
                }
                int n = i++;
                this.pos[n] = this.pos[n] - 1;
            }
        }
    }

    private static class ValueContext {
        private PDFiTextHelper pdfiTextHelper;
        private int[] pos;
        private boolean invCol;

        public ValueContext(PDFiTextHelper pdfiTextHelper, int nbCols, int nbRows, boolean invCol) {
            this.pdfiTextHelper = pdfiTextHelper;
            int nb = nbCols;
            if (invCol) {
                nb = nbRows;
            }
            this.pos = new int[nb];
            this.invCol = invCol;
        }

        private void fillCell(com.lowagie.text.Table pdfTable, int col, int row, com.prelytis.dashboard.value.chart.Cell cell) throws BadElementException {
            this.fillCell(pdfTable, col, row, cell, null, null);
        }

        private void fillCell(com.lowagie.text.Table pdfTable, int col, int row, com.prelytis.dashboard.value.chart.Cell cell, Integer colSpan, Integer rowSpan) throws BadElementException {
            int lPos = col;
            if (this.invCol) {
                lPos = row;
            }
            if (this.pos[lPos] <= 0) {
                ICellElt cellElt = TableFactory.getCellElt((com.prelytis.dashboard.value.chart.Cell)cell, (int)0);
                Cell pdfCell = this.pdfiTextHelper.getPdfCell(cellElt);
                if (cellElt != null) {
                    this.pos[lPos] = cellElt.getNbReferences();
                    if (this.pos[lPos] > 1) {
                        if (this.invCol) {
                            pdfCell.setColspan(this.pos[lPos]);
                        } else {
                            pdfCell.setRowspan(this.pos[lPos]);
                        }
                    }
                }
                if (colSpan != null) {
                    pdfCell.setColspan(colSpan.intValue());
                }
                if (rowSpan != null) {
                    pdfCell.setRowspan(rowSpan.intValue());
                }
                pdfTable.addCell(pdfCell);
            }
            int n = lPos;
            this.pos[n] = this.pos[n] - 1;
        }
    }
}

