/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.prelytis.dashboard.chart.helper.FieldFormatHelper;
import com.prelytis.dashboard.data.helper.NoDataHelper;
import com.prelytis.dashboard.util.StyleElementHelper;
import com.prelytis.dashboard.util.TableFactory;
import com.prelytis.dashboard.value.chart.ICellElt;
import com.prelytis.dashboard.value.data.BeanPageLayout;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.data.BeanThemeDefinition;
import com.prelytis.dashboard.value.data.ThemeImageBundle;
import com.prelytis.dashboard.value.util.ClassElement;
import com.prelytis.dashboard.value.util.StyleElement;
import java.awt.Color;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class PDFiTextHelper {
    private final FieldFormatHelper fieldFormatHelper;
    private final StyleElementHelper styleElementHelper;
    private final BeanStyleDefinition style;
    private final Map<String, ThemeImageBundle> imageMap = new HashMap<String, ThemeImageBundle>();
    private int[] fontSize;

    PDFiTextHelper(Locale locale, BeanStyleDefinition style, BeanThemeDefinition theme) {
        this.fieldFormatHelper = new FieldFormatHelper(locale, 2, "{0}");
        this.styleElementHelper = StyleElementHelper.getInstance((BeanStyleDefinition)style);
        this.style = style;
        this.fontSize = new int[]{6, 8, 10, 12, 14, 16, 24};
        List list = theme.getImageList();
        if (list != null) {
            for (ThemeImageBundle img : list) {
                if (img == null || img.getName() == null) continue;
                this.imageMap.put(img.getName(), img);
            }
        }
    }

    public static BaseFont getBaseFont(StyleElement styleElement) throws DocumentException, IOException {
        String[] baseFont = new String[]{"Times-Roman", "Helvetica", "Times-Roman", "Times-Roman", "Courier"};
        return BaseFont.createFont((String)baseFont[styleElement.getFontFamily() - 1], (String)"UTF-8", (boolean)false);
    }

    public Font getFont(StyleElement styleElement) {
        return PDFiTextHelper.getFont(styleElement, this.fontSize);
    }

    public static Font getFont(StyleElement styleElement, int[] fontSize) {
        int[] fontFamily = new int[]{2, 1, 2, 2, 0};
        int[] fontStyle = new int[]{0, 2, 2};
        int[] fontWeight = new int[]{0, 0, 1, 1};
        return new Font(fontFamily[styleElement.getFontFamily() - 1], (float)fontSize[styleElement.getFontSize() - 1], fontStyle[styleElement.getFontStyle() - 1] | fontWeight[styleElement.getFontWeight() - 1], PDFiTextHelper.getColor(styleElement.getForeColor()));
    }

    public static final Color getColor(String color) {
        if (color == null) {
            return new Color(255, 255, 255, 255);
        }
        return new Color(Integer.parseInt(color, 16));
    }

    public static int getHorizontalAlignment(StyleElement styleElement) {
        int[] textAlign = new int[]{0, 1, 2};
        return textAlign[styleElement.getTextAlign() - 1];
    }

    public Cell getPdfCell(com.prelytis.dashboard.value.chart.Cell cell) throws BadElementException {
        ClassElement classElement = TableFactory.getCellElt((com.prelytis.dashboard.value.chart.Cell)cell, (int)0).getClassElement();
        if (classElement != null) {
            StyleElement styleElement = this.getStyleElement(classElement);
            Cell pdfCell = new Cell((Element)new Phrase(this.getFormattedValue(cell), this.getFont(styleElement)));
            pdfCell.setBackgroundColor(PDFiTextHelper.getColor(styleElement.getBackColor()));
            pdfCell.setHorizontalAlignment(PDFiTextHelper.getHorizontalAlignment(styleElement));
            return pdfCell;
        }
        return new Cell((Element)new Phrase(this.getFormattedValue(cell)));
    }

    public Cell getPdfCell(ICellElt cellElt) throws BadElementException {
        ClassElement classElement = cellElt.getClassElement();
        if (classElement != null) {
            if (this.isImage(cellElt)) {
                return this.getImageCell(cellElt);
            }
            StyleElement styleElement = this.getStyleElement(classElement);
            Cell pdfCell = new Cell((Element)new Phrase(this.getFormattedValue(cellElt), this.getFont(styleElement)));
            pdfCell.setBackgroundColor(PDFiTextHelper.getColor(styleElement.getBackColor()));
            pdfCell.setHorizontalAlignment(PDFiTextHelper.getHorizontalAlignment(styleElement));
            return pdfCell;
        }
        return new Cell((Element)new Phrase(this.getFormattedValue(cellElt)));
    }

    private Cell getImageCell(ICellElt cellElt) {
        byte[] imgData = this.getImage(cellElt);
        Image image = null;
        try {
            image = Image.getInstance((byte[])imgData);
            if (image != null) {
                return new Cell((Element)image);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Cell();
    }

    private byte[] getImage(ICellElt cellElt) {
        ThemeImageBundle bundle;
        String img = "doc";
        Object value = cellElt.getValue();
        if (value != null) {
            if (value instanceof Float) {
                Float fValue = (Float)cellElt.getValue();
                img = String.valueOf(fValue.intValue());
            } else {
                img = value.toString();
            }
        }
        if ((bundle = this.imageMap.get(img)) == null) {
            return null;
        }
        byte[] data = null;
        if (bundle.getHighDpiImage() != null) {
            data = bundle.getHighDpiImage().getData();
        }
        if (data == null && bundle.getLowDpiImage() != null) {
            data = bundle.getLowDpiImage().getData();
        }
        return data;
    }

    private boolean isImage(ICellElt cellElt) {
        String pattern = cellElt.getFormat();
        return "[image-png]".equals(pattern) || "[image-gif]".equals(pattern) || "[image-jpg]".equals(pattern) || "[image]".equals(pattern);
    }

    private String getFormattedValue(com.prelytis.dashboard.value.chart.Cell cell) {
        return this.fieldFormatHelper.getFormattedValue(cell);
    }

    private String getFormattedValue(ICellElt cellElt) {
        String pattern = cellElt.getFormat();
        if (pattern == null) {
            pattern = "{0}";
        }
        return this.fieldFormatHelper.getFormattedValue(pattern, NoDataHelper.removeNoDataMarker(cellElt.getValue()));
    }

    public StyleElement getStyleElement(ClassElement classElement) {
        return this.styleElementHelper.getStyleElement(classElement);
    }

    public Font getFont(ClassElement classElement) {
        StyleElement styleElement = this.styleElementHelper.getStyleElement(classElement);
        return this.getFont(styleElement);
    }

    public int getHorizontalAlignment(ClassElement classElement) {
        StyleElement styleElement = this.styleElementHelper.getStyleElement(classElement);
        return styleElement.getTextAlign();
    }

    public int[] getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int[] fontSize) {
        this.fontSize = fontSize;
    }

    public Cell getPdfCell(String description) {
        Cell cell = new Cell(description == null ? "" : description);
        return cell;
    }

    public static int getPermissions(EnumSet<BeanPageLayout.Permission> perms) {
        int p = 0;
        if (perms.contains(BeanPageLayout.Permission.ASSEMBLY)) {
            p |= 0x400;
        }
        if (perms.contains(BeanPageLayout.Permission.COPY)) {
            p |= 0x10;
        }
        if (perms.contains(BeanPageLayout.Permission.DEGRADED_PAINTING)) {
            p |= 4;
        }
        if (perms.contains(BeanPageLayout.Permission.FILLIN)) {
            p |= 0x100;
        }
        if (perms.contains(BeanPageLayout.Permission.MODIFY_ANNOTATIONS)) {
            p |= 0x20;
        }
        if (perms.contains(BeanPageLayout.Permission.MODIFY_CONTENTS)) {
            p |= 8;
        }
        if (perms.contains(BeanPageLayout.Permission.PRINTING)) {
            p |= 0x804;
        }
        if (perms.contains(BeanPageLayout.Permission.SCREEN_READERS)) {
            p |= 0x200;
        }
        return p;
    }

    public static char getPdfVersion(BeanPageLayout.PdfVersion pdfVersion) {
        switch (pdfVersion) {
            case _1_5: {
                return '5';
            }
            default: {
                return '6';
            }
            case _1_7: 
        }
        return '7';
    }

    public static int getEncryption(BeanPageLayout.Encryption encrypt) {
        switch (encrypt) {
            case _128BITS: {
                return 2;
            }
        }
        return 8;
    }

    public BeanStyleDefinition getStyle() {
        return this.style;
    }
}

