/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.prelytis.dashboard.chart.IPaintable;
import com.prelytis.dashboard.document.factory.AbstractImageFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.value.structure.ImageDocument;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NodeList;

final class PNGFactory
extends AbstractImageFactory {
    private static final String PNG_IMAGEIO_KEY = "javax_imageio_png_1.0";
    private static final String PNG_IMAGEIO_PHYS_KEY = "pHYs";

    PNGFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageDocument getImageDocument(I18nElement elt, IPaintable paintable, Dimension size, double scale, Integer dpi, boolean scaletofit) throws DashboardException {
        try {
            IPaintable p = this.getPaintable(paintable, size, scale);
            int width = (int)p.getSize().getWidth();
            int height = (int)p.getSize().getHeight();
            BufferedImage image = new BufferedImage(width, height, 2);
            Graphics2D graphics = image.createGraphics();
            try {
                p.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
            ImageDocument imageDocument = this.getImageDocument(image, dpi, elt.getName());
            imageDocument.setObjectID(elt.getObjectID());
            imageDocument.getDescriptionMap().putAll(elt.getDescriptionMap());
            imageDocument.setAreas(p.getAreas());
            imageDocument.setImageHeight(height);
            imageDocument.setImageWidth(width);
            return imageDocument;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageDocument getImageDocument(BufferedImage image, Integer dpi, String name) throws IOException {
        ByteArrayOutputStream out;
        block8: {
            out = new ByteArrayOutputStream();
            try {
                if (dpi != null) {
                    ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
                    Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, "png");
                    ImageWriter writer = null;
                    if (!iter.hasNext()) {
                        throw new IOException("ImageWriter not found.");
                    }
                    writer = iter.next();
                    IIOMetadata metadata = writer.getDefaultImageMetadata(type, null);
                    IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(PNG_IMAGEIO_KEY);
                    NodeList nodeList = root.getElementsByTagName(PNG_IMAGEIO_PHYS_KEY);
                    IIOMetadataNode node = nodeList.getLength() > 0 ? (IIOMetadataNode)nodeList.item(0) : (IIOMetadataNode)root.appendChild(new IIOMetadataNode(PNG_IMAGEIO_PHYS_KEY));
                    String sdpi = String.valueOf((int)(100.0 * (double)dpi.intValue() / 2.54));
                    node.setAttribute("pixelsPerUnitXAxis", sdpi);
                    node.setAttribute("pixelsPerUnitYAxis", sdpi);
                    node.setAttribute("unitSpecifier", "meter");
                    metadata.setFromTree(PNG_IMAGEIO_KEY, root);
                    try {
                        writer.setOutput(ImageIO.createImageOutputStream(out));
                        writer.write(new IIOImage(image, null, metadata));
                        break block8;
                    }
                    finally {
                        writer.dispose();
                    }
                }
                ImageIO.write((RenderedImage)image, "png", out);
            }
            finally {
                out.close();
            }
        }
        ImageDocument imageDocument = new ImageDocument();
        imageDocument.setName(name);
        imageDocument.setFileName(name + ".png");
        imageDocument.setContentType("image/png");
        imageDocument.setData(out.toByteArray());
        imageDocument.setReference(GuidFactory.getInstance().generateGUID((Object)imageDocument));
        return imageDocument;
    }
}

