/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.prelytis.dashboard.chart.IPaintable;
import com.prelytis.dashboard.document.factory.AbstractImageFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.value.structure.ImageDocument;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

final class SVGFactory
extends AbstractImageFactory {
    SVGFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageDocument getImageDocument(I18nElement elt, IPaintable paintable, Dimension size, double scale, Integer dpi, boolean scaletofit) throws DashboardException {
        ImageDocument imageDocument;
        IPaintable p = this.getPaintable(paintable, size, scale);
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            SVGGraphics2D graphics = new SVGGraphics2D(document);
            try {
                p.paint((Graphics2D)graphics);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                graphics.stream((Writer)writer, true);
            }
            finally {
                graphics.dispose();
            }
            ImageDocument imageDocument2 = new ImageDocument();
            imageDocument2.setObjectID(elt.getObjectID());
            imageDocument2.setName(elt.getName());
            imageDocument2.getDescriptionMap().putAll(elt.getDescriptionMap());
            imageDocument2.setData(out.toByteArray());
            imageDocument2.setContentType("image/svg+xml");
            imageDocument2.setAreas(p.getAreas());
            imageDocument2.setFileName(elt.getName() + ".svg");
            imageDocument2.setReference(GuidFactory.getInstance().generateGUID((Object)imageDocument2));
            imageDocument = imageDocument2;
        }
        catch (Throwable throwable) {
            try {
                out.close();
                throw throwable;
            }
            catch (Exception e) {
                throw this.getException(e);
            }
        }
        out.close();
        return imageDocument;
    }
}

