/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.factory;

import com.lowagie.text.BadElementException;
import com.prelytis.dashboard.chart.helper.FieldFormatHelper;
import com.prelytis.dashboard.data.helper.NoDataHelper;
import com.prelytis.dashboard.data.transformation.interfaces.NoDataHandler;
import com.prelytis.dashboard.document.factory.AbstractFactoryTable;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.util.FontHelper;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.util.IntervalFormat;
import com.prelytis.dashboard.util.StyleElementHelper;
import com.prelytis.dashboard.util.TableFactory;
import com.prelytis.dashboard.value.chart.CellHeader;
import com.prelytis.dashboard.value.chart.CellHeaderElt;
import com.prelytis.dashboard.value.chart.CellValueElt;
import com.prelytis.dashboard.value.chart.ColRow;
import com.prelytis.dashboard.value.chart.ICellElt;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.data.BeanPersFieldValue;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.data.BeanThemeDefinition;
import com.prelytis.dashboard.value.data.ImageType;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.data.ThemeImageBundle;
import com.prelytis.dashboard.value.structure.AbstractDocument;
import com.prelytis.dashboard.value.structure.ImageDocument;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.structure.SectionDocument;
import com.prelytis.dashboard.value.structure.TableDocument;
import com.prelytis.dashboard.value.structure.TextDocument;
import com.prelytis.dashboard.value.util.ClassElement;
import com.prelytis.dashboard.value.util.StyleElement;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class XLSFactoryTable
extends AbstractFactoryTable {
    private final Map<String, Map<StyleElement, CellStyle>> colStyleMap = new HashMap<String, Map<StyleElement, CellStyle>>();
    private final Map<String, Font> fontMap = new HashMap<String, Font>();
    private final Map<String, Integer> colorMap = new HashMap<String, Integer>();
    private final Map<String, Integer> sectionMap = new HashMap<String, Integer>();
    private final Map<String, String> dateFormat = new HashMap<String, String>();
    private final Map<String, String> numericFormat = new HashMap<String, String>();
    private final Map<String, PictInfo> pictureIdMap = new HashMap<String, PictInfo>();
    private final StyleElementHelper styleElementHelper;
    private final BeanStyleDefinition style;
    private List<? extends ReportFilter> filterList = null;
    private final Map<String, ThemeImageBundle> imageMap = new HashMap<String, ThemeImageBundle>();

    public XLSFactoryTable(AbstractDocument document, Locale locale, BeanStyleDefinition style, BeanThemeDefinition theme, List<BeanPersFieldValue> persFieldValueList) {
        super(document, locale);
        this.colorMap.put("000000", 8);
        this.colorMap.put("FFFFFF", 9);
        this.styleElementHelper = StyleElementHelper.getInstance((BeanStyleDefinition)style);
        this.style = style;
        List list = theme.getImageList();
        if (list != null) {
            for (ThemeImageBundle img : list) {
                if (img == null || img.getName() == null) continue;
                this.imageMap.put(img.getName(), img);
            }
        }
    }

    @Override
    public ImageDocument getImageDocument() throws DashboardException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        this.writeAD((Workbook)workbook, this.document);
        try {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                workbook.write((OutputStream)out);
            }
            ImageDocument imageDocument = new ImageDocument();
            imageDocument.setObjectID(this.document.getObjectID());
            imageDocument.setName(this.document.getName());
            imageDocument.setDescription(this.document.getDescription());
            imageDocument.getDescriptionMap().putAll(this.document.getDescriptionMap());
            imageDocument.setData(out.toByteArray());
            imageDocument.setContentType("application/vnd.ms-excel");
            String timeStamp = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
            imageDocument.setFileName(this.document.getDescription() + "-" + timeStamp + ".xls");
            imageDocument.setReference(GuidFactory.getInstance().generateGUID((Object)imageDocument));
            return imageDocument;
        }
        catch (IOException ioe) {
            throw this.getException(ioe);
        }
    }

    public void writeAD(Workbook workbook, AbstractDocument document) throws DashboardException {
        Sheet currentSheet = null;
        if (document instanceof TableDocument) {
            this.write(workbook, (TableDocument)document, currentSheet);
            currentSheet = null;
        } else if (document instanceof SectionDocument) {
            currentSheet = this.write(workbook, (SectionDocument)document);
        } else if (document instanceof TextDocument) {
            this.write(workbook, (TextDocument)document);
        } else if (document instanceof ImageDocument) {
            this.write(workbook, (ImageDocument)document);
        } else if (document instanceof ReportDocument) {
            this.write(workbook, (ReportDocument)document);
        }
    }

    private void write(Workbook workbook, ReportDocument document) throws DashboardException {
        for (int i = 0; i < document.size(); ++i) {
            this.writeAD(workbook, document.getDocument(i));
        }
    }

    private void write(Workbook workbook, TableDocument document, Sheet sheet) throws DashboardException {
        Table table = document.getTable();
        Sheet currentSheet = sheet == null ? workbook.createSheet() : sheet;
        int maxCol = 0;
        ArrayList<Picture> pictures = new ArrayList<Picture>();
        maxCol = table.getReportType() == 1 ? this.fillCrossTableSheet(workbook, currentSheet, table, pictures) : this.fillStdSheet(workbook, currentSheet, table, pictures);
        for (int i = 0; i <= maxCol; ++i) {
            currentSheet.autoSizeColumn(i, true);
        }
        for (Picture p : pictures) {
            p.resize();
        }
    }

    private Sheet write(Workbook workbook, SectionDocument document) throws DashboardException {
        String sc = this.getFormattedValue(document.getData());
        if (sc != null) {
            Integer id;
            sc = sc.replaceAll("\\*", " ");
            sc = sc.replaceAll("\\[", " ");
            sc = sc.replaceAll("\\]", " ");
            sc = sc.replaceAll("\\/", " ");
            sc = sc.replaceAll("\\\\", " ");
            sc = sc.replaceAll("\\?", " ");
            sc = sc.replaceAll("\\_", " ");
            if ((sc = sc.replaceAll("\\:", " ")).length() > 30) {
                sc = sc.substring(0, 30);
            }
            if ((id = this.sectionMap.get(sc)) != null) {
                if (sc.length() > 28 && (id = this.sectionMap.get(sc = sc.substring(0, 28))) == null) {
                    id = 0;
                }
                id = id + 1;
                this.sectionMap.put(sc, id);
                sc = new StringBuffer().append(sc).append(id).toString();
            } else {
                this.sectionMap.put(sc, 0);
            }
            try {
                return workbook.createSheet(sc);
            }
            catch (Exception e) {
                throw this.getException(e);
            }
        }
        return null;
    }

    public void write(Workbook workbook, TextDocument document) {
    }

    public void write(Workbook workbook, ImageDocument document) {
    }

    private int fillCrossTableSheet(Workbook workbook, Sheet sheet, Table table, List<Picture> pictures) throws DashboardException {
        int nbCols = 0;
        try {
            int i;
            CreationHelper creationHelper = workbook.getCreationHelper();
            int row1NbRows = 1;
            try {
                row1NbRows = this.getNbSubHeader(TableFactory.getFinalCell((Table)table, (int)1, (int)0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int col1NbCols = 1;
            try {
                col1NbCols = this.getNbSubHeader(TableFactory.getFinalCell((Table)table, (int)0, (int)1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int cell1YOffset = 0;
            int cell1XOffset = 0;
            if (table.isDisplayDataDescription()) {
                if (table.isHorizontalData()) {
                    ++cell1YOffset;
                } else {
                    ++cell1XOffset;
                }
            }
            int factorX = 1;
            int factorY = 1;
            if (table.getDataDescriptions() != null) {
                if (table.isHorizontalData()) {
                    factorX = table.getDataDescriptions().length;
                } else {
                    factorY = table.getDataDescriptions().length;
                }
            }
            if (col1NbCols > 1 || row1NbRows > 1) {
                sheet.addMergedRegion(new CellRangeAddress(0, row1NbRows + cell1YOffset - 1, 0, col1NbCols + cell1XOffset - 1));
            }
            Context context = new Context(col1NbCols);
            for (i = 0; i < row1NbRows + cell1YOffset; ++i) {
                sheet.createRow(i);
            }
            this.fillFirstRow(workbook, sheet, table, TableFactory.getFinalRow((Table)table, (int)0), col1NbCols, row1NbRows, pictures);
            for (i = 1; i < TableFactory.getFinalNbRows((Table)table); ++i) {
                int k;
                ColRow row = TableFactory.getFinalRow((Table)table, (int)i);
                if (table.isHorizontalData()) {
                    Row xlsRow = sheet.createRow(i + row1NbRows + cell1YOffset - 1);
                    context.fillFirstCell(workbook, sheet, xlsRow, table, (CellHeader)TableFactory.getFinalCell((ColRow)row, (int)0), pictures);
                    for (int j = 1; j < TableFactory.getFinalNbCols((Table)table); ++j) {
                        com.prelytis.dashboard.value.chart.Cell cell = TableFactory.getFinalCell((ColRow)row, (int)j);
                        for (k = 0; k < TableFactory.getNbCellElt((com.prelytis.dashboard.value.chart.Cell)cell); ++k) {
                            ICellElt cellElt = TableFactory.getCellElt((com.prelytis.dashboard.value.chart.Cell)cell, (int)k);
                            int numCol = (j - 1) * factorX + k + col1NbCols + cell1XOffset;
                            if (numCol > nbCols) {
                                nbCols = numCol;
                            }
                            Cell xlsCell = xlsRow.createCell(numCol);
                            this.fillCell(workbook, sheet, xlsCell, cellElt, pictures);
                        }
                    }
                    continue;
                }
                String[] dataDescriptions = table.getDataDescriptions();
                boolean displayDescription = dataDescriptions != null && dataDescriptions.length > 0 && table.isDisplayDataDescription();
                Row xlsRow = sheet.createRow((i - 1) * factorY + row1NbRows + cell1YOffset);
                context.fillFirstCell(workbook, sheet, xlsRow, table, (CellHeader)TableFactory.getFinalCell((ColRow)row, (int)0), pictures);
                for (k = 0; k < dataDescriptions.length; ++k) {
                    if (k > 0) {
                        xlsRow = sheet.createRow((i - 1) * factorY + k + row1NbRows + cell1YOffset);
                    }
                    if (displayDescription) {
                        Cell xlsCell = xlsRow.createCell(col1NbCols);
                        xlsCell.setCellType(1);
                        xlsCell.setCellValue(creationHelper.createRichTextString(dataDescriptions[k]));
                    }
                    for (int j = 1; j < TableFactory.getFinalNbCols((Table)table); ++j) {
                        com.prelytis.dashboard.value.chart.Cell cell = TableFactory.getFinalCell((ColRow)row, (int)j);
                        if (cell == null || TableFactory.getNbCellElt((com.prelytis.dashboard.value.chart.Cell)cell) <= k) continue;
                        ICellElt cellElt = TableFactory.getCellElt((com.prelytis.dashboard.value.chart.Cell)cell, (int)k);
                        int numCol = (j - 1) * factorX + col1NbCols + cell1XOffset;
                        if (numCol > nbCols) {
                            nbCols = numCol;
                        }
                        Cell xlsCell = xlsRow.createCell(numCol);
                        this.fillCell(workbook, sheet, xlsCell, cellElt, pictures);
                    }
                }
            }
            this.fillCellsWithFilters(workbook, sheet, table, pictures, null);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        return nbCols;
    }

    private int fillStdSheet(final Workbook workbook, final Sheet sheet, Table table, final List<Picture> pictures) throws DashboardException {
        try {
            int nbCols = TableFactory.getFinalNbCols((Table)table);
            int nbRows = TableFactory.getFinalNbRows((Table)table);
            boolean invCol = TableFactory.getColRowInv((Table)table);
            final ValueContext valueContext = new ValueContext(table.getCols().size(), table.getRows().size(), invCol);
            boolean noDataTable = NoDataHelper.isNoDataTable(table);
            if (noDataTable) {
                NoDataHelper.buildNoDataTable(new NoDataHandler(){

                    @Override
                    public void fill(com.prelytis.dashboard.value.chart.Cell cell, int colIdx, int rowIdx, Integer colSpan, Integer rowSpan) throws BadElementException {
                        Row xlsRow = sheet.getRow(rowIdx);
                        if (xlsRow == null) {
                            xlsRow = sheet.createRow(rowIdx);
                        }
                        valueContext.addCell(workbook, sheet, xlsRow, colIdx, rowIdx, cell, pictures, colSpan, rowSpan);
                    }
                }, table, nbRows, nbCols);
            } else {
                for (int i = 0; i < nbRows; ++i) {
                    ColRow row = TableFactory.getFinalRow((Table)table, (int)i);
                    Row xlsRow = sheet.createRow(i);
                    for (int j = 0; j < nbCols; ++j) {
                        com.prelytis.dashboard.value.chart.Cell cell = TableFactory.getFinalCell((ColRow)row, (int)j);
                        valueContext.addCell(workbook, sheet, xlsRow, j, i, cell, pictures);
                    }
                }
            }
            if (this.filterList != null) {
                this.fillCellsWithFilters(workbook, sheet, table, pictures, valueContext);
            }
            return nbCols;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private void fillCellsWithFilters(Workbook workbook, Sheet sheet, Table table, List<Picture> pictures, ValueContext valueContext) {
        int nbRows = TableFactory.getFinalNbRows((Table)table);
        int numberFilters = this.filterList.size();
        int countUsedFilters = 0;
        for (int i = 0; i < numberFilters; ++i) {
            ReportFilter filter = this.filterList.get(i);
            if (!filter.getUseFilter()) continue;
            Row xlsRow = sheet.createRow(nbRows + countUsedFilters);
            String filterName = filter.getDescription();
            StringBuffer value = new StringBuffer();
            Object[] listValues = filter.getValues();
            if (listValues.length > 0) {
                value.append(listValues[0].toString());
            }
            for (int k = 1; k < listValues.length; ++k) {
                value.append(", " + listValues[k].toString());
            }
            this.addCell(workbook, sheet, xlsRow, 0, filterName, pictures);
            this.addCell(workbook, sheet, xlsRow, 1, value, pictures);
            ++countUsedFilters;
        }
    }

    public void addCell(Workbook workbook, Sheet sheet, Row xlsRow, int col, Object value, List<Picture> pictures) {
        CellValueElt cellElt = new CellValueElt();
        cellElt.setValue(value);
        Cell xlsCell = xlsRow.createCell(col);
        this.fillCell(workbook, sheet, xlsCell, (ICellElt)cellElt, pictures);
    }

    private void fillCell(Workbook workbook, Sheet sheet, Cell xlsCell, ICellElt cellElt, List<Picture> pictures) {
        if (cellElt == null) {
            return;
        }
        if (this.isImage(cellElt)) {
            try {
                PictInfo info = this.getPictureId(cellElt, workbook);
                if (info != null) {
                    Row row = xlsCell.getRow();
                    if (row.getHeightInPoints() < (float)info.getHeight()) {
                        row.setHeightInPoints((float)info.getHeight());
                    }
                    CreationHelper helper = workbook.getCreationHelper();
                    Drawing drawing = sheet.createDrawingPatriarch();
                    ClientAnchor anchor = helper.createClientAnchor();
                    anchor.setCol1(xlsCell.getColumnIndex());
                    anchor.setRow1(xlsCell.getRowIndex());
                    Picture pict = drawing.createPicture(anchor, info.getId().intValue());
                    pictures.add(pict);
                    xlsCell.setCellStyle(this.getStyle(workbook, cellElt.getClassElement(), "@"));
                    return;
                }
            }
            catch (IOException ioe) {
                LogManager.getLogger(this.getClass()).info((Object)ioe);
            }
        }
        Object value = NoDataHelper.removeNoDataMarker(cellElt.getValue());
        String xlsFormat = "@";
        if (value != null) {
            if (value instanceof Number) {
                String format = cellElt.getFormat();
                boolean setValue = true;
                if (format != null && format.startsWith("{0,interval")) {
                    try {
                        xlsCell.setCellType(1);
                        CreationHelper creationHelper = workbook.getCreationHelper();
                        IntervalFormat mf = new IntervalFormat(format, this.locale);
                        xlsCell.setCellValue(creationHelper.createRichTextString(mf.format(cellElt.getValue())));
                        setValue = false;
                    }
                    catch (Exception e) {
                        LogManager.getLogger(this.getClass()).info((Object)e);
                    }
                }
                if (setValue) {
                    xlsCell.setCellType(0);
                    xlsCell.setCellValue(((Number)value).doubleValue());
                    xlsFormat = this.getNumericFormat(format);
                }
            } else if (value instanceof Date) {
                xlsCell.setCellType(0);
                xlsCell.setCellValue((Date)value);
                xlsFormat = this.getDateFormat(cellElt.getFormat());
            } else {
                xlsCell.setCellType(1);
                CreationHelper creationHelper = workbook.getCreationHelper();
                xlsCell.setCellValue(creationHelper.createRichTextString(value.toString()));
            }
        }
        xlsCell.setCellStyle(this.getStyle(workbook, cellElt.getClassElement(), xlsFormat));
    }

    private String getDateFormat(String format) {
        String xlsFormat = this.dateFormat.get(format);
        if (xlsFormat == null) {
            block5: {
                try {
                    MessageFormat mf = new MessageFormat(format, this.getLocale());
                    Format[] fs = mf.getFormats();
                    if (fs != null && fs.length == 1 && fs[0] instanceof SimpleDateFormat) {
                        SimpleDateFormat df = (SimpleDateFormat)fs[0];
                        xlsFormat = df.toPattern();
                    }
                }
                catch (Exception e) {
                    Logger log = LogManager.getLogger(this.getClass());
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)new StringBuffer().append("Invalid format ").append(format).toString());
                }
            }
            if (xlsFormat == null) {
                xlsFormat = "m/d/yy h:mm";
            }
            this.dateFormat.put(format, xlsFormat);
        }
        return xlsFormat;
    }

    private String getNumericFormat(String format) {
        String xlsFormat = this.numericFormat.get(format);
        if (xlsFormat == null) {
            block5: {
                try {
                    String newFormat = format.replaceAll("\\[euro\\]", "\u20ac");
                    MessageFormat mf = new MessageFormat(newFormat, this.getLocale());
                    Format[] fs = mf.getFormats();
                    if (fs != null && fs.length == 1 && fs[0] instanceof DecimalFormat) {
                        DecimalFormat df = (DecimalFormat)fs[0];
                        xlsFormat = df.toPattern();
                    }
                }
                catch (Exception e) {
                    Logger log = LogManager.getLogger(this.getClass());
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)new StringBuffer().append("Invalid format ").append(format).toString());
                }
            }
            if (xlsFormat == null) {
                xlsFormat = "0";
            }
            this.numericFormat.put(format, xlsFormat);
        }
        return xlsFormat;
    }

    private CellStyle getStyle(Workbook workbook, ClassElement classElement, String format) {
        StyleElement styleElement = this.styleElementHelper.getStyleElement(classElement);
        return this.getStyle(workbook, styleElement, format);
    }

    private CellStyle getStyle(Workbook workbook, StyleElement styleElement, String format) {
        CellStyle style;
        Map<StyleElement, CellStyle> map = this.colStyleMap.get(format);
        if (map == null) {
            map = new HashMap<StyleElement, CellStyle>();
            this.colStyleMap.put(format, map);
        }
        if ((style = map.get(styleElement)) == null) {
            style = workbook.createCellStyle();
            DataFormat df = workbook.createDataFormat();
            style.setDataFormat(df.getFormat(format));
            style.setFillPattern((short)1);
            short color = this.getColor(workbook, styleElement.getBackColor());
            if (color < 0) {
                color = 9;
            }
            style.setFillForegroundColor(color);
            style.setFont(this.getFont(workbook, styleElement));
            switch (styleElement.getTextAlign()) {
                case 1: {
                    style.setAlignment((short)1);
                    break;
                }
                case 2: {
                    style.setAlignment((short)2);
                    break;
                }
                case 3: {
                    style.setAlignment((short)3);
                }
            }
            if (this.style.isHorizontalBorder()) {
                style.setBorderBottom((short)1);
                style.setBorderTop((short)1);
            }
            if (this.style.isVerticalBorder()) {
                style.setBorderLeft((short)1);
                style.setBorderRight((short)1);
            }
            map.put(styleElement, style);
        }
        return style;
    }

    private Font getFont(Workbook workbook, StyleElement styleElement) {
        String key = new StringBuffer().append(FontHelper.getParam((StyleElement)styleElement)).append(",").append(styleElement.getForeColor()).toString();
        Font xlsFont = this.fontMap.get(key);
        if (xlsFont == null) {
            Boolean isItalic;
            xlsFont = workbook.createFont();
            short color = this.getColor(workbook, styleElement.getForeColor());
            if (color < 0) {
                color = 8;
            }
            xlsFont.setColor(color);
            Boolean isBold = styleElement.isBold();
            if (isBold != null && isBold.booleanValue()) {
                xlsFont.setBoldweight((short)700);
            }
            if ((isItalic = styleElement.isItalic()) != null && isItalic.booleanValue()) {
                xlsFont.setItalic(true);
            }
            short[] lFontSize = new short[]{6, 8, 10, 12, 14, 17, 21, 26};
            xlsFont.setFontHeightInPoints(lFontSize[styleElement.getFontSize()]);
            this.fontMap.put(key, xlsFont);
        }
        return xlsFont;
    }

    private short getColor(Workbook workbook, String color) {
        if (color == null) {
            return -1;
        }
        if (color.length() != 6) {
            return -1;
        }
        Integer intColor = this.colorMap.get(color = color.toUpperCase());
        if (intColor == null && workbook instanceof HSSFWorkbook) {
            byte red = Integer.valueOf(color.substring(0, 2), 16).byteValue();
            byte green = Integer.valueOf(color.substring(2, 4), 16).byteValue();
            byte blue = Integer.valueOf(color.substring(4, 6), 16).byteValue();
            HSSFPalette palette = ((HSSFWorkbook)workbook).getCustomPalette();
            short index = (short)(8 + this.colorMap.size());
            if (index > 64) {
                try {
                    intColor = palette.findSimilarColor(red, green, blue).getIndex();
                }
                catch (Exception e) {
                    intColor = null;
                }
            } else {
                palette.setColorAtIndex(index, red, green, blue);
                intColor = index;
            }
            this.colorMap.put(color, intColor);
        }
        if (intColor == null) {
            return -1;
        }
        return intColor.shortValue();
    }

    private int getNbSubHeader(com.prelytis.dashboard.value.chart.Cell cell) {
        if (cell instanceof CellHeader) {
            CellHeader cellHeader = (CellHeader)cell;
            return cellHeader.getCellHeaderElt().getLevel();
        }
        return 1;
    }

    private void fillFirstRow(Workbook workbook, Sheet sheet, Table table, ColRow row, int cell1X, int cell1Y, List<Picture> pictures) {
        CreationHelper creationHelper = workbook.getCreationHelper();
        int nbCols = TableFactory.getFinalNbCols((Table)table);
        boolean horizontalData = table.isHorizontalData();
        boolean displayDataDescription = table.isDisplayDataDescription();
        String[] dataDescriptions = table.getDataDescriptions();
        int cell1XOffset = 0;
        if (displayDataDescription && !horizontalData) {
            ++cell1XOffset;
        }
        int factor = 1;
        if (horizontalData && dataDescriptions != null) {
            factor = dataDescriptions.length;
        }
        for (int i = 0; i < cell1Y; ++i) {
            CellHeaderElt cellElt;
            Row xlsRow = sheet.getRow(i);
            for (int j = 1; j < nbCols; j += cellElt.getNbReferences()) {
                int x = (j - 1) * factor + cell1X + cell1XOffset;
                cellElt = (CellHeaderElt)TableFactory.getFinalCellElt((ColRow)row, (int)j, (int)(cell1Y - i - 1));
                int lastx = x + factor * cellElt.getNbReferences() - 1;
                if (lastx != x) {
                    sheet.addMergedRegion(new CellRangeAddress(i, i, x, lastx));
                }
                Cell xlsCell = xlsRow.createCell(x);
                this.fillCell(workbook, sheet, xlsCell, (ICellElt)cellElt, pictures);
            }
        }
        if (horizontalData && displayDataDescription && dataDescriptions != null) {
            int dataDescriptionSize = dataDescriptions.length;
            Row xlsRow = sheet.getRow(cell1Y);
            String xlsFormat = "@";
            String className = "tbl-header";
            ClassElement ce = new ClassElement();
            ce.setName(className);
            CellStyle cs = this.getStyle(workbook, ce, xlsFormat);
            for (int i = 1; i < nbCols; ++i) {
                int x = (i - 1) * factor + cell1X + cell1XOffset;
                for (int j = 0; j < dataDescriptionSize; ++j) {
                    Cell xlsCell = xlsRow.createCell(x);
                    xlsCell.setCellStyle(cs);
                    xlsCell.setCellType(1);
                    xlsCell.setCellValue(creationHelper.createRichTextString(dataDescriptions[j]));
                    ++x;
                }
            }
        }
    }

    private String getFormattedValue(Object value) {
        if (value != null) {
            return value.toString();
        }
        return " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PictInfo getPictureId(ICellElt cellElt, Workbook wb) throws IOException {
        String img = "doc";
        String formatImage = ".png";
        String pattern = cellElt.getFormat();
        Object value = cellElt.getValue();
        if (value != null) {
            if (pattern.equals("[image-gif]")) {
                formatImage = ".gif";
            } else if (pattern.equals("[image-jpg]")) {
                formatImage = ".jpg";
            }
            if (value instanceof Float) {
                Float fValue = (Float)cellElt.getValue();
                img = String.valueOf(fValue.intValue());
            } else {
                img = value.toString();
            }
        }
        String fileName = img + formatImage;
        ThemeImageBundle bundle = this.imageMap.get(img);
        if (bundle != null) {
            PictInfo info = this.pictureIdMap.get(fileName);
            if (info == null) {
                byte[] b;
                int it = 6;
                int width = bundle.getWidth();
                int height = bundle.getHeight();
                if (bundle.getLowDpiImage().getImageType() == ImageType.GIF) {
                    BufferedImage bi = ImageIO.read(new ByteArrayInputStream(bundle.getLowDpiImage().getData()));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        ImageIO.write((RenderedImage)bi, "PNG", baos);
                    }
                    finally {
                        baos.close();
                        this.pictureIdMap.put(fileName, null);
                    }
                    b = baos.toByteArray();
                } else {
                    if (bundle.getLowDpiImage().getImageType() == ImageType.JPEG) {
                        it = 5;
                    }
                    b = bundle.getLowDpiImage().getData();
                }
                Integer id = wb.addPicture(b, it);
                info = new PictInfo(id, width, height);
                this.pictureIdMap.put(fileName, info);
            }
            return info;
        }
        return null;
    }

    private boolean isImage(ICellElt cellElt) {
        String pattern = cellElt.getFormat();
        return "[image-png]".equals(pattern) || "[image-gif]".equals(pattern) || "[image-jpg]".equals(pattern) || "[image]".equals(pattern);
    }

    public void setFilterList(List<? extends ReportFilter> filterList) {
        this.filterList = filterList;
    }

    public List<? extends ReportFilter> getFilter() {
        return this.filterList;
    }

    private static class PictInfo {
        private final Integer id;
        private final int width;
        private final int height;

        private PictInfo(Integer id, int width, int height) {
            this.id = id;
            this.width = width;
            this.height = height;
        }

        public Integer getId() {
            return this.id;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    private final class ValueContext {
        private int[] pos;
        private boolean invCol;
        private final FieldFormatHelper fieldFormatHelper;

        public ValueContext(int nbCols, int nbRows, boolean invCol) {
            int nb = nbCols;
            if (invCol) {
                nb = nbRows;
            }
            this.pos = new int[nb];
            this.invCol = invCol;
            this.fieldFormatHelper = new FieldFormatHelper(XLSFactoryTable.this.locale, 2, "{0}");
        }

        private void addCell(Workbook workbook, Sheet sheet, Row xlsRow, int col, int row, com.prelytis.dashboard.value.chart.Cell cell, List<Picture> pictures) {
            this.addCell(workbook, sheet, xlsRow, col, row, cell, pictures, null, null);
        }

        private void addCell(Workbook workbook, Sheet sheet, Row xlsRow, int col, int row, com.prelytis.dashboard.value.chart.Cell cell, List<Picture> pictures, Integer colSpan, Integer rowSpan) {
            int colPos = col;
            if (this.pos[colPos] <= 0) {
                ICellElt cellElt = TableFactory.getCellElt((com.prelytis.dashboard.value.chart.Cell)cell, (int)0);
                String pattern = this.getFormattedValue(cellElt);
                String formattedValue = this.fieldFormatHelper.getFormattedValue(pattern, NoDataHelper.removeNoDataMarker(cellElt.getValue()));
                cellElt.setValue((Object)formattedValue);
                if (cellElt != null) {
                    this.pos[colPos] = cellElt.getNbReferences();
                    if (this.pos[colPos] > 1) {
                        if (this.invCol) {
                            sheet.addMergedRegion(new CellRangeAddress(row, row, col, col + this.pos[colPos] - 1));
                        } else {
                            sheet.addMergedRegion(new CellRangeAddress(row, row + this.pos[colPos] - 1, col, col));
                        }
                    }
                    if (colSpan != null) {
                        sheet.addMergedRegion(new CellRangeAddress(row, row, col, col + colSpan - 1));
                    }
                    if (rowSpan != null) {
                        sheet.addMergedRegion(new CellRangeAddress(row, row + rowSpan - 1, col, col));
                    }
                    Cell xlsCell = xlsRow.createCell(col);
                    XLSFactoryTable.this.fillCell(workbook, sheet, xlsCell, cellElt, pictures);
                    if (rowSpan != null) {
                        xlsCell.getCellStyle().setVerticalAlignment((short)1);
                    }
                }
            }
            int n = colPos;
            this.pos[n] = this.pos[n] - 1;
        }

        private String getFormattedValue(ICellElt cellElt) {
            String pattern = cellElt.getFormat();
            if (pattern == null) {
                pattern = "{0}";
            }
            return pattern;
        }
    }

    private final class Context {
        private int[] pos;

        public Context(int size) {
            this.pos = new int[size];
        }

        private void fillFirstCell(Workbook workbook, Sheet sheet, Row xlsRow, Table table, CellHeader cell, List<Picture> pictures) {
            int factor = 1;
            if (!table.isHorizontalData() && table.isDisplayDataDescription()) {
                factor = table.getDataDescriptions().length;
            }
            int i = 0;
            while (i < this.pos.length) {
                CellHeaderElt cellElt;
                if (this.pos[i] == 0 && (cellElt = TableFactory.getCellHeaderElt((CellHeader)cell, (int)(this.pos.length - i - 1))) != null) {
                    this.pos[i] = cellElt.getNbReferences();
                    int lastY = xlsRow.getRowNum() + this.pos[i] * factor - 1;
                    if (xlsRow.getRowNum() == 1 && cellElt.getNbReferences() > 1 || lastY != this.pos[i]) {
                        CellRangeAddress cra = new CellRangeAddress(xlsRow.getRowNum(), lastY, i, i);
                        sheet.addMergedRegion(cra);
                    }
                    Cell xlsCell = xlsRow.createCell(i);
                    XLSFactoryTable.this.fillCell(workbook, sheet, xlsCell, (ICellElt)cellElt, pictures);
                }
                int n = i++;
                this.pos[n] = this.pos[n] - 1;
            }
        }
    }
}

