/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.document.util;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class ClippingGraphics2D
extends Graphics2D {
    private Graphics2D graphics2D;
    private Rectangle2D rectangle;

    public ClippingGraphics2D(Graphics2D graphics2D, Rectangle2D rectangle) {
        this.graphics2D = graphics2D;
        this.rectangle = rectangle;
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.graphics2D.addRenderingHints(hints);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.graphics2D.clearRect(x, y, width, height);
    }

    @Override
    public void clip(Shape s) {
        this.graphics2D.clip(s);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.graphics2D.clipRect(x, y, width, height);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.graphics2D.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public Graphics create() {
        return this.graphics2D.create();
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        return this.graphics2D.create(x, y, width, height);
    }

    @Override
    public void dispose() {
        this.graphics2D.dispose();
    }

    @Override
    public void draw(Shape s) {
        if (this.isVisible(s)) {
            this.graphics2D.draw(s);
        }
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.graphics2D.draw3DRect(x, y, width, height, raised);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.graphics2D.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.graphics2D.drawBytes(data, offset, length, x, y);
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.graphics2D.drawChars(data, offset, length, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.graphics2D.drawGlyphVector(g, x, y);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.graphics2D.drawImage(img, op, x, y);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.graphics2D.drawImage(img, xform, obs);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (this.isVisible(img, AffineTransform.getTranslateInstance(x, y), observer)) {
            return this.graphics2D.drawImage(img, x, y, bgcolor, observer);
        }
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (this.isVisible(img, AffineTransform.getTranslateInstance(x, y), observer)) {
            return this.graphics2D.drawImage(img, x, y, observer);
        }
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.graphics2D.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.graphics2D.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.graphics2D.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.graphics2D.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics2D.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.graphics2D.drawOval(x, y, width, height);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nbPoints) {
        this.drawPolygon(new Polygon(xPoints, yPoints, nbPoints));
    }

    @Override
    public void drawPolygon(Polygon p) {
        if (this.isVisible(p)) {
            this.graphics2D.drawPolygon(p);
        }
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nbPoints) {
        if (this.isVisible(new Polygon(xPoints, yPoints, nbPoints))) {
            this.graphics2D.drawPolyline(xPoints, yPoints, nbPoints);
        }
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.graphics2D.drawRect(x, y, width, height);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.graphics2D.drawRenderableImage(img, xform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.graphics2D.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.graphics2D.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.graphics2D.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.graphics2D.drawString(iterator, x, y);
    }

    @Override
    public void drawString(String s, float x, float y) {
        if (this.isVisibleText(s, x, y)) {
            this.graphics2D.drawString(s, x, y);
        }
    }

    @Override
    public void drawString(String str, int x, int y) {
        if (this.isVisibleText(str, x, y)) {
            this.graphics2D.drawString(str, x, y);
        }
    }

    public boolean equals(Object obj) {
        return this.graphics2D.equals(obj);
    }

    @Override
    public void fill(Shape s) {
        if (this.isVisible(s)) {
            this.graphics2D.fill(s);
        }
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.graphics2D.fill3DRect(x, y, width, height, raised);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.graphics2D.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.graphics2D.fillOval(x, y, width, height);
    }

    @Override
    public void fillPolygon(int[] xPoint, int[] yPoint, int nbPoints) {
        this.fillPolygon(new Polygon(xPoint, yPoint, nbPoints));
    }

    @Override
    public void fillPolygon(Polygon p) {
        if (this.isVisible(p)) {
            this.graphics2D.fillPolygon(p);
        }
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.graphics2D.fillRect(x, y, width, height);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.graphics2D.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public Color getBackground() {
        return this.graphics2D.getBackground();
    }

    @Override
    public Shape getClip() {
        return this.graphics2D.getClip();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.graphics2D.getClipBounds();
    }

    @Override
    public Rectangle getClipBounds(Rectangle r) {
        return this.graphics2D.getClipBounds(r);
    }

    @Override
    @Deprecated
    public Rectangle getClipRect() {
        return this.graphics2D.getClipRect();
    }

    @Override
    public Color getColor() {
        return this.graphics2D.getColor();
    }

    @Override
    public Composite getComposite() {
        return this.graphics2D.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphics2D.getDeviceConfiguration();
    }

    @Override
    public Font getFont() {
        return this.graphics2D.getFont();
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.graphics2D.getFontMetrics();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.graphics2D.getFontMetrics(f);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.graphics2D.getFontRenderContext();
    }

    @Override
    public Paint getPaint() {
        return this.graphics2D.getPaint();
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.graphics2D.getRenderingHint(hintKey);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.graphics2D.getRenderingHints();
    }

    @Override
    public Stroke getStroke() {
        return this.graphics2D.getStroke();
    }

    @Override
    public AffineTransform getTransform() {
        return this.graphics2D.getTransform();
    }

    public int hashCode() {
        return this.graphics2D.hashCode();
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.graphics2D.hit(rect, s, onStroke);
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        return this.graphics2D.hitClip(x, y, width, height);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.graphics2D.rotate(theta, x, y);
    }

    @Override
    public void rotate(double theta) {
        this.graphics2D.rotate(theta);
    }

    @Override
    public void scale(double sx, double sy) {
        this.graphics2D.scale(sx, sy);
    }

    @Override
    public void setBackground(Color color) {
        this.graphics2D.setBackground(color);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.graphics2D.setClip(x, y, width, height);
    }

    @Override
    public void setClip(Shape clip) {
        this.graphics2D.setClip(clip);
    }

    @Override
    public void setColor(Color c) {
        this.graphics2D.setColor(c);
    }

    @Override
    public void setComposite(Composite comp) {
        this.graphics2D.setComposite(comp);
    }

    @Override
    public void setFont(Font font) {
        this.graphics2D.setFont(font);
    }

    @Override
    public void setPaint(Paint paint) {
        this.graphics2D.setPaint(paint);
    }

    @Override
    public void setPaintMode() {
        this.graphics2D.setPaintMode();
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.graphics2D.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.graphics2D.setRenderingHints(hints);
    }

    @Override
    public void setStroke(Stroke s) {
        this.graphics2D.setStroke(s);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.graphics2D.setTransform(Tx);
    }

    @Override
    public void setXORMode(Color c1) {
        this.graphics2D.setXORMode(c1);
    }

    @Override
    public void shear(double shx, double shy) {
        this.graphics2D.shear(shx, shy);
    }

    @Override
    public String toString() {
        return this.graphics2D.toString();
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.graphics2D.transform(Tx);
    }

    @Override
    public void translate(double tx, double ty) {
        this.graphics2D.translate(tx, ty);
    }

    @Override
    public void translate(int x, int y) {
        this.graphics2D.translate(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVisibleText(String s, float x, float y) {
        AffineTransform initialAT = this.graphics2D.getTransform();
        try {
            this.graphics2D.translate(x, y);
            FontMetrics fm = this.graphics2D.getFontMetrics();
            Rectangle2D r = fm.getStringBounds(s, this.graphics2D);
            boolean bl = this.isVisible(r);
            return bl;
        }
        finally {
            this.graphics2D.setTransform(initialAT);
        }
    }

    private boolean isVisible(Rectangle2D r) {
        boolean visible;
        if (this.graphics2D.getClip() != null && !(visible = r.intersects(this.graphics2D.getClipBounds()))) {
            return false;
        }
        return this.rectangle.intersects(r);
    }

    private boolean isVisible(Shape s) {
        if (s != null) {
            return this.isVisible(s.getBounds2D());
        }
        return false;
    }

    private boolean isVisible(Image img, AffineTransform at, ImageObserver observer) {
        int width = img.getWidth(observer);
        int height = img.getWidth(observer);
        if (width == -1 || height == -1) {
            return true;
        }
        Rectangle2D r = new Rectangle2D.Double(0.0, 0.0, width, height);
        r = at.createTransformedShape(r).getBounds2D();
        return this.isVisible(r);
    }
}

