/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.ext;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.ext.AbstractAuthenticationFacade;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardFacade;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.model.helper.PrelytisInfoHelper;
import com.prelytis.dashboard.value.LoginRequest;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.naming.ldap.InitialLdapContext;
import org.apache.log4j.LogManager;

public class LdapAuthenticationFacade
extends AbstractAuthenticationFacade {
    private static final String PRINCIPAL_DN_PREFIX_OPT = "principalDNPrefix";
    private static final String PRINCIPAL_DN_SUFFIX_OPT = "principalDNSuffix";
    private Properties initEnv = new Properties();

    public LdapAuthenticationFacade(DashboardFacade facade) {
        super(facade);
    }

    public Response dashboardRequest(Request request) throws DashboardException {
        LoginRequest value;
        if (request.getType() == 3 && this.connectionTypeSet.contains((value = (LoginRequest)request).getConnectionType())) {
            String userName = null;
            try {
                userName = value.getUserPrincipal().getName();
            }
            catch (Exception ex) {
                LogManager.getLogger(this.getClass()).info((Object)("Unknown user " + userName));
                throw this.createLoginException(ErrorCode.INSIGHT_INVALID_CREDENTIALS, "invalidUser");
            }
            if (value.getPassword() == null) {
                value.setPassword(new char[0]);
            }
            if (this.forceConnection != null) {
                value.setForceConnection(this.forceConnection);
            }
            if (!this.checkPassword(userName, new String(value.getPassword()))) {
                LogManager.getLogger(this.getClass()).info((Object)("Invalid password for user " + userName));
                throw this.createLoginException(ErrorCode.INSIGHT_INVALID_CREDENTIALS, "invalidUser");
            }
        }
        return this.getFacade().dashboardRequest(request);
    }

    @Override
    public void init(Map<String, String> properties) {
        super.init(properties);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getValue() == null) continue;
            this.initEnv.put(entry.getKey(), entry.getValue());
        }
        String protocol = properties.get("java.naming.security.protocol");
        String providerURL = properties.get("java.naming.provider.url");
        String factoryName = properties.get("java.naming.factory.initial");
        String authType = properties.get("java.naming.security.authentication");
        if (factoryName == null || "".equals(factoryName)) {
            this.initEnv.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        if (authType == null || "".equals(authType)) {
            this.initEnv.setProperty("java.naming.security.authentication", "simple");
        }
        if (providerURL == null || "".equals(providerURL)) {
            this.initEnv.setProperty("java.naming.provider.url", "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389"));
        }
    }

    private boolean checkPassword(String username, String credentials) {
        try {
            String principalDNPrefix = this.initEnv.getProperty(PRINCIPAL_DN_PREFIX_OPT);
            String principalDNSuffix = this.initEnv.getProperty(PRINCIPAL_DN_SUFFIX_OPT);
            if (principalDNPrefix == null) {
                principalDNPrefix = "";
            }
            if (principalDNSuffix == null) {
                principalDNSuffix = "";
            }
            String userDN = principalDNPrefix + username + principalDNSuffix;
            Properties env = new Properties(this.initEnv);
            env.setProperty("java.naming.security.principal", userDN);
            env.setProperty("java.naming.security.credentials", credentials);
            new InitialLdapContext(env, null);
            return true;
        }
        catch (Exception e) {
            LogManager.getLogger(this.getClass()).error((Object)e);
            return false;
        }
    }

    private DashboardException createLoginException(ErrorCode errorCode, String key) {
        DaoFactory daoFactory = DaoFactory.getInstance();
        PrelytisInfoHelper prelytisInfoHelper = PrelytisInfoHelper.getInstance(daoFactory);
        Locale locale = prelytisInfoHelper.getDefaultLocale();
        return ExceptionHelper.getInstance(locale).createLoginException(errorCode, key);
    }
}

