/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.chart.IPaintable;
import com.prelytis.dashboard.util.SegmentHelper;
import com.prelytis.dashboard.value.area.IArea;
import com.prelytis.dashboard.value.area.datastructure.FieldArea;
import com.prelytis.dashboard.value.area.datastructure.JoinArea;
import com.prelytis.dashboard.value.area.datastructure.RestArea;
import com.prelytis.dashboard.value.area.datastructure.TableArea;
import com.prelytis.dashboard.value.chart.PaintableProperties;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoin;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoinElement;
import com.prelytis.dashboard.value.data.BeanQueryStar;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractDataStructureMap
implements IPaintable {
    protected static final Logger log = LogManager.getLogger(AbstractDataStructureMap.class);
    protected PaintableProperties paintableProperties;
    protected BeanQueryStar queryStar;
    protected Dimension size;
    protected TableRep tableRep;
    protected Color backColor = null;
    protected Color titleForeColor = Color.black;
    protected Color factTitleForeColor = Color.black;
    protected Paint titleBackColor = new GradientPaint(0.0f, 0.0f, new Color(132, 176, 230), 0.0f, 50.0f, new Color(41, 111, 196));
    protected Paint factTitleBackColor = new GradientPaint(0.0f, 0.0f, new Color(255, 245, 204), 0.0f, 50.0f, new Color(255, 196, 78));
    protected Paint titleBoxBackColor = new GradientPaint(0.0f, 0.0f, new Color(41, 111, 196), 0.0f, 50.0f, new Color(43, 86, 141));
    protected Paint factTitleBoxBackColor = new GradientPaint(0.0f, 0.0f, new Color(175, 117, 47), 0.0f, 50.0f, new Color(199, 139, 35));
    protected Color fieldColor = Color.black;
    protected Font titleFont = new Font("SansSerif", 1, 12);
    protected Font fieldFont = new Font("SansSerif", 0, 10);
    protected int titleAlignment = 1;
    protected int fieldAlignment = 1;
    protected int nbDisplayField;
    protected List<IArea> areas = new ArrayList<IArea>();
    protected int maxWidth;
    protected int maxHeight;
    private boolean primaryKey;
    private boolean foreignKey;
    private boolean fields;
    protected BufferedImage contIcon;
    private static int border = 5;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    private FontRenderContext frc = new FontRenderContext(null, true, true);

    public AbstractDataStructureMap(BeanQueryStar queryStar, int nbDisplayField, boolean primaryKey, boolean foreignKey, boolean fields, Locale locale) {
        this.nbDisplayField = nbDisplayField;
        this.queryStar = queryStar;
        this.primaryKey = primaryKey;
        this.foreignKey = foreignKey;
        this.fields = fields;
        this.paintableProperties = new PaintableProperties();
        this.tableRep = new TableRep(queryStar.getTableFact(), locale, nbDisplayField);
    }

    public AbstractDataStructureMap(BeanQueryStar queryStar, Locale locale) {
        this(queryStar, 10, true, true, true, locale);
    }

    public Color getTitleForeColor() {
        return this.titleForeColor;
    }

    public void setTitleForeColor(Color titleForeColor) {
        this.titleForeColor = titleForeColor;
    }

    public Paint getTitleBackColor() {
        return this.titleBackColor;
    }

    public void setTitleBackColor(Paint titleBackColor) {
        this.titleBackColor = titleBackColor;
    }

    public Paint getFactTitleBackColor() {
        return this.factTitleBackColor;
    }

    public void setFactTitleBackColor(Paint factTitleBackColor) {
        this.factTitleBackColor = factTitleBackColor;
    }

    public Color getFieldColor() {
        return this.fieldColor;
    }

    public void setFieldColor(Color fieldColor) {
        this.fieldColor = fieldColor;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public Font getFieldFont() {
        return this.fieldFont;
    }

    public void setFieldFont(Font fieldFont) {
        this.fieldFont = fieldFont;
    }

    public int getTitleAlignment() {
        return this.titleAlignment;
    }

    public void setTitleAlignment(int titleAlignment) {
        this.titleAlignment = titleAlignment;
    }

    public int getFieldAlignment() {
        return this.fieldAlignment;
    }

    public void setFieldAlignment(int fieldAlignment) {
        this.fieldAlignment = fieldAlignment;
    }

    public int getNbDisplayField() {
        return this.nbDisplayField;
    }

    public void setNbDisplayField(int nbDisplayField) {
        this.nbDisplayField = nbDisplayField;
    }

    public void setContextualizationIcon(URL icon) {
        try {
            this.contIcon = ImageIO.read(icon);
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    public TableRep getTableRep() {
        return this.tableRep;
    }

    public void setTableRep(TableRep tableRep) {
        this.tableRep = tableRep;
    }

    public final void setSize(Dimension size) {
        this.size = size;
    }

    public final Dimension getSize() {
        return this.size;
    }

    public final List<IArea> getAreas() {
        return this.areas;
    }

    public final PaintableProperties getPaintableProperties() {
        return this.paintableProperties;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.areas.size(); ++i) {
            IArea area = this.areas.get(i);
            str.append(area.toString());
        }
        return str.toString();
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    private Point2D getPoint(Point source, Rectangle destination) {
        double posX1 = source.x;
        double posY1 = source.y;
        double posX2 = destination.getCenterX();
        double posY2 = destination.getCenterY();
        double y2 = destination.getWidth() / 2.0 / (posX1 - posX2) * (posY1 - posY2);
        if (2.0 * Math.abs(y2) < destination.getHeight()) {
            if (posX1 > posX2) {
                return new Point2D.Double(destination.getCenterX() + destination.getWidth() / 2.0, posY2 + y2);
            }
            return new Point2D.Double(destination.getCenterX() - destination.getWidth() / 2.0, posY2 - y2);
        }
        double lX2 = (posX1 - posX2) * destination.getHeight() / 2.0 / (posY1 - posY2);
        if (posY1 > posY2) {
            return new Point2D.Double(posX2 + lX2, destination.getCenterY() + destination.getHeight() / 2.0);
        }
        return new Point2D.Double(posX2 - lX2, destination.getCenterY() - destination.getHeight() / 2.0);
    }

    class RestRep {
        private Dimension size;
        private final String text;
        private final TableRep tableRep;

        public RestRep(TableRep tableRep, String descriptionKey) {
            this.tableRep = tableRep;
            this.text = descriptionKey;
        }

        public void refresh() {
            FontRenderContext frc = new FontRenderContext(null, true, true);
            if (this.text != null) {
                TextLayout textLayout = new TextLayout(this.text, AbstractDataStructureMap.this.titleFont, frc);
                Rectangle2D bounds = textLayout.getBounds();
                this.size = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
            }
        }

        public void paint(Graphics2D graphics2D) {
            if (this.text == null) {
                return;
            }
            int left = 0;
            RestArea area = new RestArea();
            area.setId(this.tableRep.getId());
            area.setText(this.text);
            area.setSegments(SegmentHelper.getSegments((Shape)new GeneralPath(new Rectangle(0, -this.size.height, this.tableRep.getSize().width, this.size.height)).createTransformedShape(graphics2D.getTransform())));
            AbstractDataStructureMap.this.areas.add((IArea)area);
            switch (AbstractDataStructureMap.this.titleAlignment) {
                default: {
                    left = border;
                    break;
                }
                case 1: {
                    left = (this.tableRep.getSize().width - this.size.width) / 2;
                    break;
                }
                case 2: {
                    left = this.tableRep.getSize().width - this.size.width - border;
                }
            }
            graphics2D.drawString(this.text, left, 0);
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setSize(Dimension size) {
            this.size = size;
        }

        public String getText() {
            return this.text;
        }
    }

    class TitleRep {
        private Dimension size;
        private final String descriptionKey;
        private final TableRep tableRep;

        public TitleRep(TableRep tableRep, String text) {
            this.tableRep = tableRep;
            this.descriptionKey = text == null ? "????" : text;
        }

        public void refresh() {
            TextLayout textLayout = new TextLayout(this.descriptionKey, AbstractDataStructureMap.this.titleFont, AbstractDataStructureMap.this.frc);
            Rectangle2D bounds = textLayout.getBounds();
            int contIconH = 0;
            int contIconW = 0;
            if (AbstractDataStructureMap.this.contIcon != null && this.tableRep.getContext()) {
                contIconH = AbstractDataStructureMap.this.contIcon.getHeight();
                contIconW = AbstractDataStructureMap.this.contIcon.getWidth() + border;
            }
            this.size = new Dimension((int)bounds.getWidth() + contIconW, Math.max((int)bounds.getHeight(), contIconH));
        }

        public void paint(Graphics2D graphics2D) {
            if (this.descriptionKey == null) {
                return;
            }
            int left = 0;
            TableArea area = new TableArea();
            area.setId(this.tableRep.getId());
            area.setDescriptionKey(this.descriptionKey);
            area.setSegments(SegmentHelper.getSegments((Shape)new GeneralPath(new Rectangle(0, -this.size.height, this.tableRep.getSize().width, this.size.height)).createTransformedShape(graphics2D.getTransform())));
            AbstractDataStructureMap.this.areas.add((IArea)area);
            switch (AbstractDataStructureMap.this.titleAlignment) {
                default: {
                    left = border;
                    break;
                }
                case 1: {
                    left = (this.tableRep.getSize().width - this.size.width) / 2;
                    break;
                }
                case 2: {
                    left = this.tableRep.getSize().width - this.size.width - border;
                }
            }
            graphics2D.drawString(this.descriptionKey, left, 0);
            if (AbstractDataStructureMap.this.contIcon != null && this.tableRep.getContext()) {
                graphics2D.drawImage((Image)AbstractDataStructureMap.this.contIcon, left + this.size.width - AbstractDataStructureMap.this.contIcon.getWidth(), -AbstractDataStructureMap.this.contIcon.getHeight(), null);
            }
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setSize(Dimension size) {
            this.size = size;
        }

        public String getText() {
            return this.descriptionKey;
        }
    }

    class FieldRepKey {
        private final String field;
        private Dimension size;
        private final TableRep tableRep;

        public FieldRepKey(TableRep tableRep, String field) {
            this.tableRep = tableRep;
            this.field = field;
        }

        public void refresh() {
            FontRenderContext frc = new FontRenderContext(null, true, true);
            TextLayout textLayout = new TextLayout(this.field, AbstractDataStructureMap.this.fieldFont, frc);
            Rectangle2D bounds = textLayout.getBounds();
            this.size = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
        }

        public void paint(Graphics2D graphics2D) {
            int left = 0;
            switch (AbstractDataStructureMap.this.fieldAlignment) {
                default: {
                    left = border;
                    break;
                }
                case 1: {
                    left = (this.tableRep.getSize().width - this.size.width) / 2;
                    break;
                }
                case 2: {
                    left = this.tableRep.getSize().width - this.size.width - border;
                }
            }
            graphics2D.setColor(AbstractDataStructureMap.this.fieldColor);
            graphics2D.drawString(this.field, left, 0);
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setSize(Dimension size) {
            this.size = size;
        }
    }

    class FieldRep {
        private final BeanQueryDataStructureTableField dataStructureTableField;
        private Dimension size;
        private final String name;
        private final String description;
        private final TableRep tableRep;

        public FieldRep(TableRep tableRep, BeanQueryDataStructureTableField queryDataStructureTableField, Locale locale) {
            this.tableRep = tableRep;
            this.dataStructureTableField = queryDataStructureTableField;
            this.name = queryDataStructureTableField.getName();
            String description = (String)queryDataStructureTableField.getDescriptionMap().get(locale);
            if (description == null || "".equals(description)) {
                description = queryDataStructureTableField.getName();
            }
            this.description = description;
        }

        public void refresh() {
            FontRenderContext frc = new FontRenderContext(null, true, true);
            TextLayout textLayout = new TextLayout(this.description, AbstractDataStructureMap.this.fieldFont, frc);
            Rectangle2D bounds = textLayout.getBounds();
            this.size = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
        }

        public void paint(Graphics2D graphics2D) {
            if (this.description == null) {
                return;
            }
            int left = 0;
            FieldArea area = new FieldArea();
            area.setId(this.getId());
            area.setDescription(this.description);
            area.setField(this.name);
            area.setSegments(SegmentHelper.getSegments((Shape)new GeneralPath(new Rectangle(0, -this.size.height, this.tableRep.getSize().width, this.size.height)).createTransformedShape(graphics2D.getTransform())));
            AbstractDataStructureMap.this.areas.add((IArea)area);
            switch (AbstractDataStructureMap.this.fieldAlignment) {
                default: {
                    left = border;
                    break;
                }
                case 1: {
                    left = (this.tableRep.getSize().width - this.size.width) / 2;
                    break;
                }
                case 2: {
                    left = this.tableRep.getSize().width - this.size.width - border;
                }
            }
            graphics2D.setPaint(AbstractDataStructureMap.this.fieldColor);
            graphics2D.drawString(this.description, left, 0);
        }

        public int getId() {
            return this.dataStructureTableField.getId();
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setSize(Dimension size) {
            this.size = size;
        }

        public BeanQueryDataStructureTableField getDataStructureTableField() {
            return this.dataStructureTableField;
        }
    }

    class TableRep {
        private BeanQueryDataStructureTable queryDataStructureTable;
        private Dimension size;
        private TitleRep titleRep;
        private List<FieldRep> fieldRepList = new ArrayList<FieldRep>();
        private List<FieldRepKey> fieldListPrimaryKey = new ArrayList<FieldRepKey>();
        private List<FieldRepKey> fieldListForeignKey = new ArrayList<FieldRepKey>();
        private int nbDisplayField;
        private RestRep restRep;
        private List<TableRep> childTableRepList = new ArrayList<TableRep>();
        private Point position;
        private boolean context = false;

        private TableRep(BeanQueryDataStructureTable queryDataStructureTable, Locale locale, int nbDisplayField) {
            this.nbDisplayField = nbDisplayField;
            this.queryDataStructureTable = queryDataStructureTable;
            BeanQueryDataStructureTableJoin join = queryDataStructureTable.getJoin();
            List tableList = queryDataStructureTable.getTableChildList();
            List list = queryDataStructureTable.getTableFieldList();
            this.titleRep = new TitleRep(this, (String)queryDataStructureTable.getDescriptionMap().get(locale));
            for (int i = 0; i < tableList.size(); ++i) {
                BeanQueryDataStructureTableJoin childJoin = ((BeanQueryDataStructureTable)tableList.get(i)).getJoin();
                for (BeanQueryDataStructureTableJoinElement elt : childJoin.getJoinElementList()) {
                    String leftField = elt.getLeftField();
                    FieldRepKey fieldRep = new FieldRepKey(this, leftField);
                    this.fieldListForeignKey.add(fieldRep);
                }
            }
            if (join != null) {
                for (BeanQueryDataStructureTableJoinElement elt : join.getJoinElementList()) {
                    String rightField = elt.getRightField();
                    FieldRepKey fieldRep = new FieldRepKey(this, rightField);
                    this.fieldListPrimaryKey.add(fieldRep);
                }
            }
            for (BeanQueryDataStructureTableField f : list) {
                if (!f.isActive()) continue;
                FieldRep fieldRep = new FieldRep(this, f, locale);
                this.fieldRepList.add(fieldRep);
            }
            for (int i = 0; i < tableList.size(); ++i) {
                TableRep tableRep = new TableRep((BeanQueryDataStructureTable)tableList.get(i), locale, nbDisplayField);
                this.childTableRepList.add(tableRep);
            }
            this.restRep = new RestRep(this, "...");
            if (queryDataStructureTable.getFilterList().size() > 0) {
                this.context = true;
            }
        }

        public int getId() {
            return this.queryDataStructureTable.getId();
        }

        public String getDescription() {
            return this.titleRep.getText();
        }

        public String getJoin() {
            return this.queryDataStructureTable.getJoin().getJoinName();
        }

        public boolean getContext() {
            return this.context;
        }

        public int getParentTable() {
            if (this.queryDataStructureTable.getParentTable() != null) {
                return this.queryDataStructureTable.getParentTable().getId();
            }
            return 0;
        }

        public void refresh() {
            Object fieldRep;
            int i;
            this.titleRep.refresh();
            int max = this.titleRep.getSize().width;
            int height = this.titleRep.getSize().height + 3 * border;
            if (AbstractDataStructureMap.this.primaryKey) {
                for (i = 0; i < this.fieldListPrimaryKey.size(); ++i) {
                    fieldRep = this.fieldListPrimaryKey.get(i);
                    ((FieldRepKey)fieldRep).refresh();
                    max = Math.max(max, ((FieldRepKey)fieldRep).getSize().width);
                    if (i >= this.nbDisplayField) continue;
                    height += border + ((FieldRepKey)fieldRep).getSize().height;
                }
                height += border;
            }
            if (AbstractDataStructureMap.this.foreignKey) {
                for (i = 0; i < this.fieldListForeignKey.size(); ++i) {
                    fieldRep = this.fieldListForeignKey.get(i);
                    ((FieldRepKey)fieldRep).refresh();
                    max = Math.max(max, ((FieldRepKey)fieldRep).getSize().width);
                    if (i >= this.nbDisplayField) continue;
                    height += border + ((FieldRepKey)fieldRep).getSize().height;
                }
                height += border;
            }
            if (AbstractDataStructureMap.this.fields) {
                for (i = 0; i < this.fieldRepList.size(); ++i) {
                    fieldRep = this.fieldRepList.get(i);
                    ((FieldRep)fieldRep).refresh();
                    max = Math.max(max, ((FieldRep)fieldRep).getSize().width);
                    if (i >= this.nbDisplayField) continue;
                    height += border + ((FieldRep)fieldRep).getSize().height;
                }
            }
            this.restRep.refresh();
            if (this.fieldRepList.size() > this.nbDisplayField) {
                height += border + this.restRep.getSize().height;
            }
            this.size = new Dimension(max + 2 * border, height);
            if (this.size.width > AbstractDataStructureMap.this.maxWidth) {
                AbstractDataStructureMap.this.maxWidth = this.size.width;
            }
            if (this.size.height > AbstractDataStructureMap.this.maxHeight) {
                AbstractDataStructureMap.this.maxHeight = this.size.height;
            }
            for (i = 0; i < this.childTableRepList.size(); ++i) {
                TableRep tableRep = this.childTableRepList.get(i);
                tableRep.refresh();
            }
        }

        public void setChildTableRepList(List<TableRep> childTableRepList) {
            this.childTableRepList = childTableRepList;
        }

        public List<TableRep> getChildTableRepList() {
            return this.childTableRepList;
        }

        public void setPosition(Point position) {
            this.position = position;
        }

        public Point getPosition() {
            return this.position;
        }

        public void setNbDisplayField(int nbDisplayField) {
            this.nbDisplayField = nbDisplayField;
        }

        public int getNbDisplayField() {
            return this.nbDisplayField;
        }

        public void paint(Graphics2D graphics2D) {
            Object fieldRep;
            int i;
            int lBorder = 3;
            if (this.position == null) {
                return;
            }
            AffineTransform at = graphics2D.getTransform();
            graphics2D.setColor(Color.black);
            for (i = 0; i < this.childTableRepList.size(); ++i) {
                TableRep tableRep = this.childTableRepList.get(i);
                Point2D p1 = AbstractDataStructureMap.this.getPoint(this.position, new Rectangle(new Point(tableRep.getPosition().x - tableRep.getSize().width / 2, tableRep.getPosition().y - tableRep.getSize().height / 2), tableRep.getSize()));
                Point2D p2 = AbstractDataStructureMap.this.getPoint(tableRep.getPosition(), new Rectangle(new Point(this.position.x - this.size.width / 2, this.position.y - this.size.height / 2), this.size));
                graphics2D.draw(new Line2D.Double(p1, p2));
                double width = p1.getX() - p2.getX();
                double height = p1.getY() - p2.getY();
                double delta = Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0)) / (double)lBorder;
                double deltaX = height / delta;
                double deltaY = width / delta;
                GeneralPath path = new GeneralPath();
                path.moveTo((float)(p2.getX() + deltaX), (float)(p2.getY() - deltaY));
                path.lineTo((float)(p1.getX() + deltaX), (float)(p1.getY() - deltaY));
                path.lineTo((float)(p1.getX() - deltaX), (float)(p1.getY() + deltaY));
                path.lineTo((float)(p2.getX() - deltaX), (float)(p2.getY() + deltaY));
                path.closePath();
                JoinArea area = new JoinArea();
                area.setId(tableRep.getId());
                area.setName(tableRep.getDescription());
                area.setSegments(SegmentHelper.getSegments((Shape)path.createTransformedShape(at)));
                AbstractDataStructureMap.this.areas.add((IArea)area);
            }
            graphics2D.translate(this.position.x - this.size.width / 2, this.position.y - this.size.height / 2);
            graphics2D.setColor(new Color(255, 255, 255, 200));
            graphics2D.fillRoundRect(0, 0, this.size.width, this.size.height, 2 * border, 2 * border);
            graphics2D.setClip(0, 0, this.size.width, 2 * border + this.titleRep.getSize().height);
            if (this.queryDataStructureTable.getParentTable() != null) {
                graphics2D.setPaint(AbstractDataStructureMap.this.titleBackColor);
            } else {
                graphics2D.setPaint(AbstractDataStructureMap.this.factTitleBackColor);
            }
            graphics2D.fillRoundRect(0, 0, this.size.width, 40, 2 * border, 2 * border);
            graphics2D.setClip(null);
            if (this.queryDataStructureTable.getParentTable() != null) {
                graphics2D.setPaint(AbstractDataStructureMap.this.titleBoxBackColor);
            } else {
                graphics2D.setPaint(AbstractDataStructureMap.this.factTitleBoxBackColor);
            }
            graphics2D.drawRoundRect(0, 0, this.size.width, this.size.height, 2 * border, 2 * border);
            if (this.queryDataStructureTable.getParentTable() != null) {
                graphics2D.setPaint(AbstractDataStructureMap.this.titleForeColor);
            } else {
                graphics2D.setPaint(AbstractDataStructureMap.this.factTitleForeColor);
            }
            graphics2D.setFont(AbstractDataStructureMap.this.titleFont);
            graphics2D.translate(0, border + this.titleRep.getSize().height);
            this.titleRep.paint(graphics2D);
            graphics2D.setColor(Color.black);
            graphics2D.translate(0, border);
            graphics2D.setFont(AbstractDataStructureMap.this.fieldFont);
            if (AbstractDataStructureMap.this.primaryKey) {
                for (i = 0; i < this.fieldListPrimaryKey.size() && i < this.nbDisplayField; ++i) {
                    fieldRep = this.fieldListPrimaryKey.get(i);
                    graphics2D.translate(0, border + ((FieldRepKey)fieldRep).getSize().height);
                    ((FieldRepKey)fieldRep).paint(graphics2D);
                }
                graphics2D.translate(0, border);
                if (this.queryDataStructureTable.getParentTable() != null) {
                    graphics2D.setPaint(AbstractDataStructureMap.this.titleBackColor);
                } else {
                    graphics2D.setPaint(AbstractDataStructureMap.this.factTitleBackColor);
                }
                graphics2D.drawLine(0, 0, this.getSize().width, 0);
                graphics2D.setColor(Color.black);
            }
            if (AbstractDataStructureMap.this.foreignKey) {
                for (i = 0; i < this.fieldListForeignKey.size() && i < this.nbDisplayField; ++i) {
                    fieldRep = this.fieldListForeignKey.get(i);
                    graphics2D.translate(0, border + ((FieldRepKey)fieldRep).getSize().height);
                    ((FieldRepKey)fieldRep).paint(graphics2D);
                }
                graphics2D.translate(0, border);
                if (this.queryDataStructureTable.getParentTable() != null) {
                    graphics2D.setPaint(AbstractDataStructureMap.this.titleBackColor);
                } else {
                    graphics2D.setPaint(AbstractDataStructureMap.this.factTitleBackColor);
                }
                graphics2D.drawLine(0, 0, this.getSize().width, 0);
                graphics2D.setColor(Color.black);
            }
            if (AbstractDataStructureMap.this.fields) {
                for (i = 0; i < this.fieldRepList.size() && i < this.nbDisplayField; ++i) {
                    fieldRep = this.fieldRepList.get(i);
                    graphics2D.translate(0, border + ((FieldRep)fieldRep).getSize().height);
                    ((FieldRep)fieldRep).paint(graphics2D);
                }
            }
            if (this.fieldRepList.size() > this.nbDisplayField) {
                graphics2D.translate(0, border + this.restRep.getSize().height);
                this.restRep.paint(graphics2D);
            }
            graphics2D.setTransform(at);
            for (i = 0; i < this.childTableRepList.size(); ++i) {
                TableRep lTableRep = this.childTableRepList.get(i);
                lTableRep.paint(graphics2D);
            }
        }

        public Dimension getSize() {
            return this.size;
        }

        public final void setSize(Dimension size) {
            this.size = size;
        }
    }
}

