/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.dao.BatchDataDao;
import com.prelytis.dashboard.dao.BatchFileDao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.TimeUnitDao;
import com.prelytis.dashboard.dao.value.DbBatchDocumentMetaData;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.model.helper.DashBoardHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.value.data.BeanDashBoard;
import com.prelytis.dashboard.value.data.BeanReport;
import com.prelytis.dashboard.value.data.BeanTaskDocExport;
import com.prelytis.dashboard.value.data.BeanTimeUnit;
import com.prelytis.dashboard.value.structure.BatchDocument;
import com.prelytis.dashboard.value.structure.DashboardBlock;
import com.prelytis.dashboard.value.structure.DashboardDocument;
import com.prelytis.dashboard.value.structure.DashboardTemplate;
import com.prelytis.dashboard.value.structure.Document;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class BatchHelper {
    private final DaoFactory daoFactory;
    private final boolean zip = true;

    public BatchHelper(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public <T extends BatchDocument> T getDocument(int taskOid, Date dateHisto, String filterName, ExpressionEvaluationData data, Class<T> clazz) throws DashboardException {
        BatchDataDao batchDataDao = this.daoFactory.getBatchDataDao();
        DbBatchDocumentMetaData metaData = dateHisto == null && filterName == null ? batchDataDao.getLatestDocument(taskOid, data.getUserOid().intValue(), data.getExecutionContextOid().intValue()) : batchDataDao.getDocument(taskOid, data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), dateHisto, filterName);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(metaData.getDateHisto());
        BatchFileDao batchFileDao = this.daoFactory.getBatchFileDao();
        try {
            BatchDocument document = batchFileDao.getDocument(metaData);
            this.updateI18n((Document)document, data.getLocale());
            return (T)((BatchDocument)clazz.cast(document));
        }
        catch (DashboardRuntimeException e) {
            if (e.getCode() == ErrorCode.NOT_FOUND_ERROR) {
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("batchFileNotFound", null, null);
            }
            throw e;
        }
    }

    private void updateI18n(Document document, Locale locale) throws DashboardException {
        if (document instanceof ReportDocument) {
            ReportHelper reportHelper = ReportHelper.getInstance(this.daoFactory);
            BeanReport report = reportHelper.getCore(document.getName());
            ReportDocument reportDocument = (ReportDocument)document;
            reportDocument.getDescriptionMap().putAll(report.getDescriptionMap());
            reportDocument.setDescription((String)report.getDescriptionMap().get(locale));
            reportDocument.setComment((String)report.getCommentMap().get(locale));
        } else if (document instanceof DashboardDocument) {
            DashBoardHelper dashBoardHelper = DashBoardHelper.getInstance(this.daoFactory);
            BeanDashBoard dashBoard = dashBoardHelper.getCore(document.getName());
            DashboardDocument dashboardDocument = (DashboardDocument)document;
            dashboardDocument.getDescriptionMap().putAll(dashBoard.getDescriptionMap());
            dashboardDocument.setDescription((String)dashBoard.getDescriptionMap().get(locale));
            for (DashboardTemplate template : dashboardDocument.getTemplateList()) {
                for (DashboardBlock block : template.getBlockList()) {
                    this.updateI18n(block.getUserObject(), locale);
                }
            }
        }
    }

    public void writeFile(int taskOid, BatchDocument document) {
        List userList = document.getUserList();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(document.getDateHisto());
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        StringBuilder fileName = new StringBuilder().append(hour).append("-").append(minute).append("-").append(second).append("-").append(document.getBatchNumber()).append("-").append(this.getExtension(document));
        this.getClass();
        fileName.append(".zip");
        DbBatchDocumentMetaData metaData = this.getMetaData(taskOid, fileName.toString(), document.getDateHisto(), document.getFilterName(), document.getBatchNumber());
        BatchDataDao batchDataDao = this.daoFactory.getBatchDataDao();
        batchDataDao.writeDocument(metaData, userList);
        BatchFileDao batchFileDao = this.daoFactory.getBatchFileDao();
        batchFileDao.writeDocument(metaData, document);
    }

    private String getExtension(BatchDocument document) {
        if (document instanceof DashboardDocument) {
            return "dash";
        }
        if (document instanceof ReportDocument) {
            return "rep";
        }
        return "???";
    }

    private DbBatchDocumentMetaData getMetaData(int taskOid, String fileName, Date dateHisto, String filterName, int batchNumber) {
        DbBatchDocumentMetaData md = new DbBatchDocumentMetaData();
        md.setTaskOid(taskOid);
        md.setFileName(fileName);
        md.setDateHisto(dateHisto);
        md.setFilterName(filterName);
        md.setBatchNum(batchNumber);
        return md;
    }

    public static BatchHelper getInstance(DaoFactory daoFactory) {
        return new BatchHelper(daoFactory);
    }

    public void cleanHistory(BeanTaskDocExport taskDocExport, int objectID) {
        TimeUnitDao timeUnitDao = this.daoFactory.getTimeUnitDao();
        BeanTimeUnit beanTimeUnit = (BeanTimeUnit)timeUnitDao.getCore(taskDocExport.getTimeHistory());
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        Date today = new Date();
        calendar.setTime(today);
        int nbHisto = taskDocExport.getNbHistory();
        calendar.add(beanTimeUnit.getConvField().getId(), -beanTimeUnit.getConvFactor() * nbHisto);
        BatchDataDao dataDao = this.daoFactory.getBatchDataDao();
        BatchFileDao fileDao = this.daoFactory.getBatchFileDao();
        List list = dataDao.getMetaDataList(objectID, calendar.getTime());
        for (DbBatchDocumentMetaData metaData : list) {
            fileDao.deleteDocument(metaData);
            dataDao.deleteDocument(metaData);
        }
    }
}

