/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.value.util.ClassElement;
import com.prelytis.dashboard.value.util.Font;
import com.prelytis.dashboard.value.util.StyleElement;
import java.util.HashMap;
import java.util.Map;

public final class ClassElementHelper {
    private Map<ClassElement, ClassElement> map = new HashMap<ClassElement, ClassElement>();

    public ClassElement getClassElement(String className, StyleElement styleElement) {
        ClassElement classElement = new ClassElement();
        classElement.setName(className);
        classElement.setStyle(styleElement);
        ClassElement ce = this.map.get(classElement);
        if (ce != null) {
            classElement = ce;
        }
        return classElement;
    }

    public ClassElement getClassElement(String className) {
        return this.getClassElement(className, null);
    }

    public void clear() {
        this.map.clear();
    }

    public ClassElement create(ClassElement classElement, String backColor) {
        ClassElement newCE = new ClassElement();
        newCE.setName(classElement.getName());
        newCE.setStyle(this.createStyleElement(classElement.getStyle(), backColor));
        ClassElement ce = this.map.get(newCE);
        if (ce != null) {
            newCE = ce;
        }
        return newCE;
    }

    private StyleElement createStyleElement(StyleElement styleElement, String backColor) {
        StyleElement newStyleElement = new StyleElement((Font)styleElement);
        newStyleElement.setBackColor(backColor);
        return newStyleElement;
    }
}

