/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.dao.ConnectionInformationDao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.LoginException;
import com.prelytis.dashboard.model.helper.PrelytisInfoHelper;
import com.prelytis.dashboard.util.sql.ConnectionInformation;
import java.util.List;
import java.util.Locale;

public class ConnectionInformationHelper {
    private final DaoFactory daoFactory;
    private final ConnectionInformationDao dao;

    private ConnectionInformationHelper(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
        this.dao = daoFactory.getConnectionInformationDao();
    }

    public static final ConnectionInformationHelper getInstance(DaoFactory daoFactory) {
        return new ConnectionInformationHelper(daoFactory);
    }

    public boolean exists(String userSessionGuid) {
        return this.dao.exists(userSessionGuid);
    }

    public void connectUser(ConnectionInformation connectionInformation, boolean force) throws DashboardException {
        if (connectionInformation.getProfile() != 0) {
            String sessionId = this.dao.getFirstSessionGUID(connectionInformation.getUserName());
            if (!force && sessionId != null) {
                throw this.createLoginException(this.daoFactory, ErrorCode.INSIGHT_USER_ALREADY_CONNECTED, "alreadyConnected");
            }
            this.disconnect(sessionId);
        }
        this.dao.saveConnectedUser(connectionInformation);
    }

    public ConnectionInformation getConnectedUser(String userSessionGuid) {
        return this.dao.getConnectedUser(userSessionGuid);
    }

    public void disconnect(String userSessionGuid) {
        this.dao.deleteUser(userSessionGuid);
    }

    public List<ConnectionInformation> getConnectedUsers() {
        return this.dao.getConnectedUsers();
    }

    private LoginException createLoginException(DaoFactory daoFactory, ErrorCode errorCode, String key) {
        PrelytisInfoHelper prelytisInfoHelper = PrelytisInfoHelper.getInstance(daoFactory);
        Locale locale = prelytisInfoHelper.getDefaultLocale();
        return ExceptionHelper.getInstance(locale).createLoginException(errorCode, key);
    }
}

