/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.TaskDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbTaskFilter;
import com.prelytis.dashboard.document.factory.PDFiTextFactory;
import com.prelytis.dashboard.document.factory.PDFiTextFactoryTable;
import com.prelytis.dashboard.document.factory.PageLayout;
import com.prelytis.dashboard.helper.BatchHelper;
import com.prelytis.dashboard.helper.ControlPanelHelper;
import com.prelytis.dashboard.helper.DashboardRenderer;
import com.prelytis.dashboard.helper.DocumentHelper;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.FullFilterListHelper;
import com.prelytis.dashboard.helper.FullReportFilter;
import com.prelytis.dashboard.helper.FullReportFilterDS;
import com.prelytis.dashboard.helper.MetricPanelHelper;
import com.prelytis.dashboard.helper.ReportDocumentHelper;
import com.prelytis.dashboard.helper.TextDocumentHelper;
import com.prelytis.dashboard.helper.ValueListHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.DashBoardHelper;
import com.prelytis.dashboard.model.helper.ExtSessionHelper;
import com.prelytis.dashboard.model.helper.FormHelper;
import com.prelytis.dashboard.model.helper.LengthUnitHelper;
import com.prelytis.dashboard.model.helper.PageLayoutHelper;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.model.helper.TaskHelper;
import com.prelytis.dashboard.model.helper.TextHelper;
import com.prelytis.dashboard.model.helper.ThemeHelper;
import com.prelytis.dashboard.persistence.helper.ListHelper;
import com.prelytis.dashboard.util.sql.ExceptionHandler;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.BeanDashBoardBlock;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockControl;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockControlPanel;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockExternSession;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockForm;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockMetric;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockMetricPanel;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockReport;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockTextSession;
import com.prelytis.dashboard.value.data.BeanDashBoardDefinition;
import com.prelytis.dashboard.value.data.BeanDashBoardFilter;
import com.prelytis.dashboard.value.data.BeanDashBoardTemplate;
import com.prelytis.dashboard.value.data.BeanDashboardFilterLinkedField;
import com.prelytis.dashboard.value.data.BeanExtSession;
import com.prelytis.dashboard.value.data.BeanForm;
import com.prelytis.dashboard.value.data.BeanLengthUnit;
import com.prelytis.dashboard.value.data.BeanPageLayout;
import com.prelytis.dashboard.value.data.BeanReport;
import com.prelytis.dashboard.value.data.BeanTask;
import com.prelytis.dashboard.value.data.BeanText;
import com.prelytis.dashboard.value.data.BeanThemeDefinition;
import com.prelytis.dashboard.value.data.BlockDisplayType;
import com.prelytis.dashboard.value.data.DashBoardFilter;
import com.prelytis.dashboard.value.data.HierarchicalElement;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.data.TaskType;
import com.prelytis.dashboard.value.query.InteractiveOperand;
import com.prelytis.dashboard.value.query.PromptHierarchicalElt;
import com.prelytis.dashboard.value.structure.AbstractDocument;
import com.prelytis.dashboard.value.structure.ControlPanelDocument;
import com.prelytis.dashboard.value.structure.DashboardBlock;
import com.prelytis.dashboard.value.structure.DashboardComment;
import com.prelytis.dashboard.value.structure.DashboardDocument;
import com.prelytis.dashboard.value.structure.DashboardTemplate;
import com.prelytis.dashboard.value.structure.Document;
import com.prelytis.dashboard.value.structure.ExternalDocument;
import com.prelytis.dashboard.value.structure.ImageDocument;
import com.prelytis.dashboard.value.structure.MetricPanelDocument;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DashboardDocumentHelper {
    private static final Logger log = LogManager.getLogger(DashboardDocumentHelper.class);
    private final DaoFactory daoFactory;
    private BeanDashBoardDefinition dashboard;
    private List<? extends ReportFilter> filterList;
    private DashboardDocument document;
    private Date dateHisto;
    private String filterName;
    private ExpressionEvaluationData data;
    private final ExceptionHandler exceptionHandler;

    private DashboardDocumentHelper(DaoFactory daoFactory, ExceptionHandler exceptionHandler) {
        this.daoFactory = daoFactory;
        this.exceptionHandler = exceptionHandler;
    }

    public static final DashboardDocumentHelper getInstance(DaoFactory daoFactory, ExceptionHandler exceptionHandler) {
        return new DashboardDocumentHelper(daoFactory, exceptionHandler);
    }

    public void init() throws DashboardException {
        block7: {
            try {
                if (this.document != null) {
                    return;
                }
                if (this.dashboard.getExecutionMode() == 0) {
                    this.initDashboard();
                    break block7;
                }
                TaskDao taskDao = this.daoFactory.getTaskDao();
                DbTaskFilter taskFilter = new DbTaskFilter();
                taskFilter.setTaskTypeSet(EnumSet.of(TaskType.TASK_TYPE_DOCUMENT_EXPORT));
                taskFilter.setDashboardOid(Integer.valueOf(this.dashboard.getObjectID()));
                List list = taskDao.listAll((DbDefaultFilter)taskFilter, 2);
                if (list.size() == 1) {
                    int taskOid = ((Element)list.get(0)).getObjectID();
                    BatchHelper batchHelper = BatchHelper.getInstance(this.daoFactory);
                    this.document = batchHelper.getDocument(taskOid, this.dateHisto, this.filterName, this.data, DashboardDocument.class);
                    for (DashboardTemplate t : this.document.getTemplateList()) {
                        for (DashboardBlock b : t.getBlockList()) {
                            if (!(b.getUserObject() instanceof ReportDocument)) continue;
                            ReportDocument rd = (ReportDocument)b.getUserObject();
                            ReportDocumentHelper.updateDisplayType(this.daoFactory, rd.getDisplayProperties());
                        }
                    }
                    this.document.setExecutionMode(1);
                    this.document.setFilterFirst(this.dashboard.isShowFilterFirst());
                    PrelytisInfoDao infoDao = this.daoFactory.getPrelytisInfoDao();
                    this.document.setPdfExportEnabled(this.dashboard.isPdfExportEnabled());
                    this.document.setAutoValidateFilter(infoDao.isAutoValidateFilter() && this.dashboard.isAutoValidateFilter());
                    break block7;
                }
                throw ExceptionHelper.getInstance(this.data.getLocale()).createDashboardException("noBatchDashFound", null, null);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void initDashboard() throws DashboardException {
        try {
            this.document = new DashboardDocument();
            boolean editAccess = false;
            WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
            if (this.data.getExecutionContextOid() != null) {
                editAccess = workspaceDao.getAccessLevelForEC(this.data.getExecutionContextOid().intValue(), SessionParameterType.DASHBOARD).getAccessLevel() == 2;
            }
            this.document.setEditAccess(editAccess);
            this.document.setObjectID(this.dashboard.getObjectID());
            this.document.setName(this.dashboard.getName());
            this.document.setDescription((String)this.dashboard.getDescriptionMap().get(this.data.getLocale()));
            this.document.getDescriptionMap().putAll(this.dashboard.getDescriptionMap());
            this.document.setExecutionMode(this.dashboard.getExecutionMode());
            this.document.setAutoRefreshDelay(this.dashboard.getAutoRefreshDelay());
            this.document.setPageLayoutName(this.dashboard.getPageLayoutName());
            DashBoardHelper dashboardHelper = DashBoardHelper.getInstance(this.daoFactory);
            this.document.setFilterList(ReportDocumentHelper.cleanValueList(dashboardHelper.getFilterList(this.dashboard.getFilterList(), this.data), this.filterList, this.data));
            this.document.setFilterFirst(this.dashboard.isShowFilterFirst());
            this.document.setPdfExportEnabled(this.dashboard.isPdfExportEnabled());
            this.document.setAutoValidateFilter(this.dashboard.isAutoValidateFilter());
            HashMap<String, BeanDashBoardFilter> nameFilterMap = new HashMap<String, BeanDashBoardFilter>();
            for (BeanDashBoardFilter filter : this.dashboard.getFilterList()) {
                nameFilterMap.put(filter.getName(), filter);
            }
            QueryHelper queryHelper = QueryHelper.getInstance(this.daoFactory);
            ReportHelper reportHelper = ReportHelper.getInstance(this.daoFactory);
            TaskHelper taskHelper = TaskHelper.getInstance(this.daoFactory);
            TextHelper textHelper = TextHelper.getInstance(this.daoFactory);
            ExtSessionHelper externSessionHelper = ExtSessionHelper.getInstance(this.daoFactory);
            FormHelper formHelper = FormHelper.getInstance(this.daoFactory);
            ListHelper listHelper = ListHelper.getInstance();
            for (ReportFilter filter : this.document.getFilterList()) {
                try {
                    String fltName;
                    FullReportFilter fullFilter;
                    Integer blockOid;
                    Integer templateOid;
                    String reportName;
                    BeanDashBoardFilter dflt = (BeanDashBoardFilter)nameFilterMap.get(filter.getName());
                    if (dflt == null || (reportName = this.getReportName(templateOid = dflt.getTemplateOid(), blockOid = dflt.getBlockOid())) == null) continue;
                    AbstractBeanReport report = reportHelper.getDefinition(reportName);
                    IQueryDefinition query = queryHelper.getFinal(report.getQueryName());
                    ValueListHelper vlh = ValueListHelper.getInstance(this.daoFactory, this.data, query, report);
                    List<FullReportFilter> fullFilterList = FullFilterListHelper.getFullFilterList(vlh.getReport(), vlh.getQuery());
                    Map fullFilterMap = listHelper.getMapByName(fullFilterList);
                    Set list = dflt.getFilterList();
                    if (list == null || fullFilterMap == null || (fullFilter = (FullReportFilter)fullFilterMap.get(fltName = dflt.getSrcFilterName())) == null) continue;
                    filter.setPromptType(fullFilter.getPromptType());
                    switch (filter.getPromptType()) {
                        case 2: 
                        case 3: {
                            filter.setValueList(vlh.getValueList(fullFilter));
                            if (!(fullFilter instanceof FullReportFilterDS)) break;
                            FullReportFilterDS fullFilterDS = (FullReportFilterDS)fullFilter;
                            ArrayList<HierarchicalElement> hel = new ArrayList<HierarchicalElement>();
                            InteractiveOperand io = fullFilterDS.getOperand();
                            if (io == null) break;
                            if (io.getHierarchicalEltList() != null) {
                                for (int i = io.getHierarchicalEltList().size() - 1; i >= 0; --i) {
                                    PromptHierarchicalElt phe = (PromptHierarchicalElt)io.getHierarchicalEltList().get(i);
                                    HierarchicalElement he = new HierarchicalElement();
                                    he.setDescription((String)phe.getDescriptionMap().get(this.data.getLocale()));
                                    he.setName(phe.getHierarchicalField());
                                    he.setPromptType(phe.getTypeList());
                                    he.setFormat(phe.getFormat());
                                    he.setSortOrder(phe.getSortOrder());
                                    he.setCompleteList(io.isCompleteList());
                                    hel.add(he);
                                }
                                filter.setHierarchicalFilter(true);
                                filter.setHierarchicalEltList(hel);
                            } else {
                                filter.setHierarchicalFilter(false);
                                filter.setHierarchicalEltList(null);
                            }
                            filter.setFormat(io.getFormat());
                            filter.setSortOrder(io.getSortOrder());
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            List newTemplateList = this.document.getTemplateList();
            for (BeanDashBoardTemplate template : this.dashboard.getTemplateList()) {
                DashboardTemplate newTemplate = new DashboardTemplate();
                newTemplate.setWidth(template.getWidth());
                newTemplate.setHeight(template.getHeight());
                newTemplate.setBackgroundImage(template.getBackgroundImage());
                newTemplate.setDescription((String)template.getDescriptionMap().get(this.data.getLocale()));
                newTemplate.setBackgroundImage(template.getBackgroundImage());
                newTemplateList.add(newTemplate);
                List newBlockList = newTemplate.getBlockList();
                for (BeanDashBoardBlock block : template.getBlockList()) {
                    try {
                        DashboardBlock newBlock = new DashboardBlock();
                        newBlock.setId(block.getId());
                        newBlock.setAutoRefresh(block.isAutoRefresh());
                        newBlock.setHideHeader(block.getHideHeader() == null ? BlockDisplayType.VISIBLE : block.getHideHeader());
                        newBlock.setTop(block.getTop());
                        newBlock.setLeft(block.getLeft());
                        newBlock.setWidth(block.getWidth());
                        newBlock.setHeight(block.getHeight());
                        newBlock.setBlockType(block.getType());
                        newBlock.setOverflow(true);
                        newBlock.setTargetBlock(block.getTargetBlockId() == null ? Integer.valueOf(block.getId()) : block.getTargetBlockId());
                        if (block instanceof BeanDashBoardBlockReport) {
                            BeanDashBoardBlockReport reportBlock = (BeanDashBoardBlockReport)block;
                            newBlock.setObjectName(reportBlock.getReportName());
                            BeanReport report = reportHelper.getCore(reportBlock.getReportName());
                            newBlock.setDescription((String)report.getDescriptionMap().get(this.data.getLocale()));
                            if (report.isShowFilterFirst() && !this.document.isFilterFirst()) {
                                log.info((Object)("Forcing show filter first on dashboard '" + this.dashboard.getName() + "', as it is activated on report '" + report.getName() + "'"));
                                this.document.setFilterFirst(true);
                            }
                        } else if (block instanceof BeanDashBoardBlockMetric) {
                            String metricName = ((BeanDashBoardBlockMetric)block).getMetricName();
                            BeanTask metric = taskHelper.getCore(metricName);
                            newBlock.setObjectName(metricName);
                            newBlock.setDescription((String)metric.getDescriptionMap().get(this.data.getLocale()));
                        } else if (block instanceof BeanDashBoardBlockControl) {
                            String controlName = ((BeanDashBoardBlockControl)block).getControlName();
                            BeanTask control = taskHelper.getCore(controlName);
                            newBlock.setObjectName(controlName);
                            newBlock.setDescription((String)control.getDescriptionMap().get(this.data.getLocale()));
                        } else if (block instanceof BeanDashBoardBlockExternSession) {
                            String extSessionName = ((BeanDashBoardBlockExternSession)block).getExternSessionName();
                            BeanExtSession extSession = externSessionHelper.getCore(extSessionName, this.data);
                            newBlock.setObjectName(extSessionName);
                            newBlock.setDescription((String)extSession.getDescriptionMap().get(this.data.getLocale()));
                        } else if (block instanceof BeanDashBoardBlockForm) {
                            String formName = ((BeanDashBoardBlockForm)block).getFormName();
                            BeanForm form = formHelper.getCore(formName, this.data);
                            newBlock.setObjectName(formName);
                            newBlock.setDescription((String)form.getDescriptionMap().get(this.data.getLocale()));
                        } else if (block instanceof BeanDashBoardBlockTextSession) {
                            String textSessionName = ((BeanDashBoardBlockTextSession)block).getTextSessionName();
                            BeanText text = textHelper.getCore(textSessionName, this.data);
                            newBlock.setObjectName(textSessionName);
                            newBlock.setDescription((String)text.getDescriptionMap().get(this.data.getLocale()));
                        } else if (block instanceof BeanDashBoardBlockControlPanel || block instanceof BeanDashBoardBlockMetricPanel) {
                            // empty if block
                        }
                        newBlockList.add(newBlock);
                    }
                    catch (Exception ex) {
                        this.exceptionHandler.logException(ex);
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private String getReportName(Integer templateOid, Integer blockOid) {
        for (BeanDashBoardTemplate template : this.dashboard.getTemplateList()) {
            if (template.getId() != templateOid.intValue()) continue;
            for (BeanDashBoardBlock block : template.getBlockList()) {
                if (block.getId() != blockOid.intValue() || !(block instanceof BeanDashBoardBlockReport)) continue;
                BeanDashBoardBlockReport rpt = (BeanDashBoardBlockReport)block;
                return rpt.getReportName();
            }
        }
        return null;
    }

    public void initDashboardHierarchicalFilter() throws DashboardException {
        HashMap<String, BeanDashBoardFilter> nameFilterMap = new HashMap<String, BeanDashBoardFilter>();
        List dfl = this.dashboard.getFilterList();
        for (BeanDashBoardFilter filter : dfl) {
            nameFilterMap.put(filter.getName(), filter);
        }
        for (ReportFilter reportFilter : this.document.getFilterList()) {
            DashBoardFilter filter = null;
            if (reportFilter instanceof DashBoardFilter) {
                filter = (DashBoardFilter)reportFilter;
            }
            if (filter == null) continue;
            BeanDashBoardFilter dflt = (BeanDashBoardFilter)nameFilterMap.get(filter.getName());
            Integer blockId = dflt.getBlockOid();
            Integer templateId = dflt.getTemplateOid();
            filter.setBlockId(blockId);
            filter.setTemplateId(templateId);
            filter.setSrcFilterName(dflt.getSrcFilterName());
        }
    }

    public void initHolder() {
        ReportHelper reportHelper = ReportHelper.getInstance(this.daoFactory);
        DocumentHelper documentHelper = DocumentHelper.getInstance(this.daoFactory);
        TextDocumentHelper tdh = TextDocumentHelper.getInstance(this.daoFactory.getTextDao());
        int templateId = 0;
        for (DashboardTemplate template : this.document.getTemplateList()) {
            for (DashboardBlock block : template.getBlockList()) {
                if (block.getUserObject() != null) continue;
                Integer accessLevel = null;
                try {
                    switch (block.getBlockType()) {
                        case CONTROL: {
                            break;
                        }
                        case CONTROL_PANEL: {
                            accessLevel = this.getAccessLevel(documentHelper, SessionType.CONTROL_PANEL, null);
                            if (accessLevel != null && 1 > accessLevel) break;
                            ControlPanelHelper controlPanelHelper = ControlPanelHelper.getInstance(this.daoFactory);
                            ControlPanelDocument controlPanelDocument = controlPanelHelper.getDocument(this.data);
                            block.setUserObject((Document)controlPanelDocument);
                            block.setDescription(controlPanelDocument.getDescription());
                            break;
                        }
                        case EXTERN: {
                            accessLevel = this.getAccessLevel(documentHelper, SessionType.EXTERN, block.getObjectName());
                            if (accessLevel != null && 1 > accessLevel) break;
                            ExternalDocument externalDocument = documentHelper.getExternalDocument(block.getObjectName(), this.getReportFilter(templateId, block.getId()), this.data);
                            block.setUserObject((Document)externalDocument);
                            block.setDescription(externalDocument.getDescription());
                            break;
                        }
                        case METRIC: {
                            accessLevel = this.getAccessLevel(documentHelper, SessionType.METRIC, block.getObjectName());
                            if (accessLevel != null && 1 > accessLevel) break;
                            ReportDocument metricDocument = documentHelper.getMetricDataDocument(block.getObjectName(), this.data);
                            block.setUserObject((Document)metricDocument);
                            block.setDescription(metricDocument.getDescription());
                            break;
                        }
                        case METRIC_HISTORY: {
                            break;
                        }
                        case METRIC_PANEL: 
                        case STRATEGY_MAP: {
                            accessLevel = this.getAccessLevel(documentHelper, SessionType.METRIC_PANEL, null);
                            if (accessLevel != null && 1 > accessLevel) break;
                            MetricPanelHelper metricPanelHelper = MetricPanelHelper.getInstance(this.daoFactory);
                            MetricPanelDocument metricPanelDocument = metricPanelHelper.getDocument(this.data, block.getBlockType() == SessionType.METRIC_PANEL);
                            block.setUserObject((Document)metricPanelDocument);
                            block.setDescription(metricPanelDocument.getDescription());
                            break;
                        }
                        case DOCUMENT: {
                            accessLevel = this.getAccessLevel(documentHelper, SessionType.DOCUMENT, block.getObjectName());
                            if (accessLevel != null && 1 > accessLevel) break;
                            AbstractBeanReport report = reportHelper.getDefinition(block.getObjectName());
                            ReportDocumentHelper.Builder rdhb = new ReportDocumentHelper.Builder(this.daoFactory, this.exceptionHandler, report, this.data, false).filterList(this.getReportFilter(templateId, block.getId()));
                            ReportDocumentHelper rdh = rdhb.build();
                            ReportDocument rd = rdh.getReportDocument();
                            block.setUserObject((Document)rd);
                            block.setDescription(rd.getDescription());
                            break;
                        }
                        case TEXT_SESSION: {
                            accessLevel = this.getAccessLevel(documentHelper, SessionType.TEXT_SESSION, block.getObjectName());
                            if (accessLevel != null && 1 > accessLevel) break;
                            block.setUserObject((Document)tdh.getDocument(block.getObjectName(), this.data));
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            ++templateId;
        }
    }

    private Integer getAccessLevel(DocumentHelper helper, SessionType type, String name) throws DashboardException {
        if (this.data.getExecutionContextOid() == null) {
            return null;
        }
        return helper.getDocumentAccessLevelForEC(this.data.getExecutionContextOid(), type, name, false);
    }

    private List<? extends ReportFilter> getReportFilter(int templateId, int blockId) {
        ArrayList<ReportFilter> filterList = new ArrayList<ReportFilter>();
        for (ReportFilter filter : this.document.getFilterList()) {
            if (!(filter instanceof DashBoardFilter)) continue;
            DashBoardFilter f = (DashBoardFilter)filter;
            for (BeanDashboardFilterLinkedField linkedField : f.getReportFilterMap()) {
                if (linkedField.getBlockId() != blockId || linkedField.getTemplateId() != templateId) continue;
                ReportFilter reportFilter = new ReportFilter();
                reportFilter.setMandatory(f.getMandatory());
                reportFilter.setUseFilter(f.getUseFilter());
                reportFilter.setValues(f.getValues());
                reportFilter.setPromptType(f.getPromptType());
                reportFilter.setName(linkedField.getFieldName());
                reportFilter.setDatatype(f.getDatatype());
                reportFilter.setFormat(f.getFormat());
                filterList.add(reportFilter);
            }
        }
        return filterList;
    }

    public ImageDocument getPdfDashboard(String baseDir, Map<Integer, List<DashboardComment>> commentMap) throws DashboardException {
        ThemeHelper themeHelper = ThemeHelper.getInstance(this.daoFactory);
        BeanThemeDefinition theme = themeHelper.getDefinition(this.data.getThemeName());
        PageLayoutHelper pageLayoutHelper = PageLayoutHelper.getInstance(this.daoFactory);
        BeanPageLayout pl = pageLayoutHelper.getDefinition(this.document.getPageLayoutName());
        LengthUnitHelper lengthUnitHelper = LengthUnitHelper.getInstance(this.daoFactory);
        BeanLengthUnit lengthUnit = lengthUnitHelper.getDefinition(pl.getLengthUnitName());
        PageLayout pageLayout = new PageLayout(pl, lengthUnit, theme);
        if (this.dashboard.isPdfBooklet()) {
            PDFiTextFactoryTable pdfFactory = new PDFiTextFactoryTable(this.daoFactory, (AbstractDocument)this.document, this.data.getLocale(), pageLayout, this.data.getPersFieldList());
            pdfFactory.setReportFilterList(this.filterList);
            return pdfFactory.getImageDocument();
        }
        DashboardRenderer renderer = new DashboardRenderer(this.daoFactory, this.document, pageLayout, this.data.getLocale(), commentMap);
        PDFiTextFactory factory = new PDFiTextFactory();
        factory.setLocale(this.data.getLocale());
        factory.setTitle(this.document.getName());
        factory.setSubject(this.document.getName());
        factory.setPageLayout(pageLayout);
        return factory.getImageDocument((I18nElement)this.document, renderer, null, 1.0, null, false);
    }

    protected void handleException(Exception e) throws DashboardException {
        if (e instanceof DashboardException) {
            throw (DashboardException)((Object)e);
        }
        if (e instanceof DashboardRuntimeException) {
            throw (DashboardRuntimeException)((Object)e);
        }
        log.error((Object)e, (Throwable)e);
        throw new DashboardException((Throwable)e);
    }

    public BeanDashBoardDefinition getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(BeanDashBoardDefinition dashboard) {
        this.dashboard = dashboard;
    }

    public DashboardDocument getDashboardData() {
        return this.document;
    }

    public void setDocument(DashboardDocument document) {
        this.document = document;
    }

    public List<? extends ReportFilter> getFilterList() {
        return this.filterList;
    }

    public void setFilterList(List<? extends ReportFilter> filterList) {
        this.filterList = filterList;
    }

    public void setData(ExpressionEvaluationData data) {
        this.data = data;
    }

    public Date getDateHisto() {
        return this.dateHisto;
    }

    public void setDateHisto(Date dateHisto) {
        this.dateHisto = dateHisto;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }
}

