/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.chart.IChart;
import com.prelytis.dashboard.chart.IPaintable;
import com.prelytis.dashboard.chart.StrategyMapChart;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.document.factory.ChartFactory;
import com.prelytis.dashboard.document.factory.PageLayout;
import com.prelytis.dashboard.helper.ControlPanel;
import com.prelytis.dashboard.helper.MetricPanel;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.StyleHelper;
import com.prelytis.dashboard.util.Command;
import com.prelytis.dashboard.util.FontHelper;
import com.prelytis.dashboard.util.PanelCommand;
import com.prelytis.dashboard.util.StyleElementHelper;
import com.prelytis.dashboard.util.TableHelper;
import com.prelytis.dashboard.value.area.IArea;
import com.prelytis.dashboard.value.chart.DisplayProperties;
import com.prelytis.dashboard.value.chart.PaintableProperties;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.chart.properties.AbstractChartProperties;
import com.prelytis.dashboard.value.data.BeanDisplayType;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.data.BlockDisplayType;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.structure.Commentable;
import com.prelytis.dashboard.value.structure.ControlPanelDocument;
import com.prelytis.dashboard.value.structure.DashboardBlock;
import com.prelytis.dashboard.value.structure.DashboardComment;
import com.prelytis.dashboard.value.structure.DashboardDocument;
import com.prelytis.dashboard.value.structure.DashboardTemplate;
import com.prelytis.dashboard.value.structure.Document;
import com.prelytis.dashboard.value.structure.MetricHistoryDocument;
import com.prelytis.dashboard.value.structure.MetricPanelDocument;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.structure.SectionDocument;
import com.prelytis.dashboard.value.structure.TableDocument;
import com.prelytis.dashboard.value.structure.TextDocument;
import com.prelytis.dashboard.value.util.Font;
import com.prelytis.dashboard.value.util.StyleElement;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.RepaintManager;
import javax.swing.border.Border;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DashboardRenderer
implements Commentable,
IPaintable {
    private static final Logger log = LogManager.getLogger(DashboardRenderer.class);
    private static final String NO_DATA_KEY = "report.noData";
    private static final int DEFAULT_PADDING = 2;
    private final DaoFactory daoFactory;
    private List<List<BlockRenderer>> list;
    private Dimension size;
    private Dimension bodySize;
    private PaintableProperties paintableProperties;
    private int currentTemplate;
    private String noDataLabel;
    private Locale locale;
    private String dashboardTitle = "";
    private final Map<Integer, List<DashboardComment>> commentMap;
    private final List<? extends ReportFilter> filterList;
    private static final int TYPE_REPORT = 3;
    private static final int TYPE_EXTERN_SESSION = 4;
    private static final int TYPE_CONTROL_PANEL = 6;
    private static final int TYPE_METRIC_PANEL = 11;
    private static final int TYPE_STRATEGY_MAP = 12;
    private static final int TYPE_CONTROL = 13;
    private static final int TYPE_METRIC = 14;
    private static final int TYPE_METRIC_HISTORY = 16;
    private static final int TYPE_TEXT_SESSION = 22;
    private static final int TYPE_FILTER = 100;

    public DashboardRenderer(DaoFactory daoFactory, DashboardDocument document, PageLayout pageLayout, Locale locale, Map<Integer, List<DashboardComment>> commentMap) throws DashboardException {
        String tmp;
        this.daoFactory = daoFactory;
        this.locale = locale;
        this.commentMap = commentMap;
        this.filterList = document.getFilterList();
        if (this.noDataLabel == null) {
            this.noDataLabel = "No Data";
        }
        this.paintableProperties = new PaintableProperties();
        ArrayList templateList = new ArrayList(document.getTemplateList());
        boolean showFilter = false;
        if (document.getFilterList() != null && !document.getFilterList().isEmpty()) {
            for (ReportFilter filter : document.getFilterList()) {
                if (!filter.isVisible()) continue;
                showFilter = true;
                break;
            }
        }
        this.list = new ArrayList<List<BlockRenderer>>(templateList.size());
        float pageWidth = pageLayout.getPageWidth() - pageLayout.getLeftMargin() - pageLayout.getRightMargin();
        float pageHeight = pageLayout.getPageHeight() - pageLayout.getTopMargin() - pageLayout.getBottomMargin() - pageLayout.getHeaderHeight() - pageLayout.getFooterHeight();
        if (document.getDescription() != null && (tmp = document.getDescription()) != null) {
            this.dashboardTitle = tmp;
        }
        this.size = new Dimension((int)pageLayout.unitToPt(pageLayout.getPageWidth()), (int)pageLayout.unitToPt(pageLayout.getPageHeight()));
        this.bodySize = new Dimension((int)pageLayout.unitToPt(pageWidth), (int)pageLayout.unitToPt(pageHeight) - 22);
        StyleHelper styleHelper = StyleHelper.getInstance(daoFactory);
        for (int i = 0; i < templateList.size(); ++i) {
            DashboardTemplate template = (DashboardTemplate)templateList.get(i);
            Converter xConv = new Converter(this.bodySize.getWidth(), template.getWidth());
            Converter yConv = new Converter(this.bodySize.getHeight(), template.getHeight());
            List blockList = template.getBlockList();
            ArrayList<BlockRenderer> currentList = new ArrayList<BlockRenderer>();
            this.list.add(currentList);
            for (DashboardBlock block : blockList) {
                BlockRenderer br = new BlockRenderer();
                br.position = new Point(xConv.getIntValue(block.getLeft()), yConv.getIntValue(block.getTop()));
                br.size = new Dimension(xConv.getIntValue(block.getWidth()), yConv.getIntValue(block.getHeight()));
                br.type = block.getBlockType().getId();
                br.pagelayout = pageLayout;
                br.hideHeader = block.getHideHeader() == null ? BlockDisplayType.VISIBLE : block.getHideHeader();
                String title = block.getDescription();
                br.title = title != null ? title : "";
                switch (br.type) {
                    case 6: {
                        if (!(block.getUserObject() instanceof ControlPanelDocument)) break;
                        ControlPanelDocument controlPanelDocument = (ControlPanelDocument)block.getUserObject();
                        br.document = (Document)controlPanelDocument;
                        currentList.add(br);
                        break;
                    }
                    case 11: {
                        if (!(block.getUserObject() instanceof MetricPanelDocument)) break;
                        MetricPanelDocument metricPanelDocument = (MetricPanelDocument)block.getUserObject();
                        br.document = (Document)metricPanelDocument;
                        currentList.add(br);
                        break;
                    }
                    case 3: 
                    case 13: 
                    case 14: {
                        if (!(block.getUserObject() instanceof ReportDocument)) break;
                        ReportDocument rd = (ReportDocument)block.getUserObject();
                        br.document = (Document)rd;
                        if (rd.getStyle() != null) {
                            br.style = styleHelper.getDefinition(rd.getStyle());
                        }
                        currentList.add(br);
                        break;
                    }
                    case 12: {
                        if (!(block.getUserObject() instanceof MetricPanelDocument)) break;
                        MetricPanelDocument metricPanelDocument = (MetricPanelDocument)block.getUserObject();
                        br.document = (Document)metricPanelDocument;
                        currentList.add(br);
                        break;
                    }
                    case 16: {
                        if (!(block.getUserObject() instanceof MetricHistoryDocument)) break;
                        MetricHistoryDocument mhd = (MetricHistoryDocument)block.getUserObject();
                        br.document = (Document)mhd;
                        currentList.add(br);
                        break;
                    }
                    case 22: {
                        if (!(block.getUserObject() instanceof TextDocument)) break;
                        TextDocument td = (TextDocument)block.getUserObject();
                        br.document = (Document)td;
                        currentList.add(br);
                    }
                }
            }
        }
        if (showFilter) {
            ArrayList<BlockRenderer> currentList = new ArrayList<BlockRenderer>();
            Converter xConv = new Converter(this.bodySize.getWidth(), 100.0);
            Converter yConv = new Converter(this.bodySize.getHeight(), 100.0);
            BlockRenderer br = new BlockRenderer();
            br.position = new Point(xConv.getIntValue(0.0), yConv.getIntValue(0.0));
            br.size = new Dimension(xConv.getIntValue(100.0), yConv.getIntValue(100.0));
            br.type = 100;
            br.pagelayout = pageLayout;
            br.hideHeader = BlockDisplayType.HIDDEN;
            br.title = "";
            currentList.add(br);
            this.list.add(currentList);
        }
    }

    public void init() {
    }

    public void paint(Graphics2D g2d) {
        Stroke savedStroke = g2d.getStroke();
        Color savedColor = g2d.getColor();
        java.awt.Font savedFont = g2d.getFont();
        java.awt.Font titleFont = savedFont.deriveFont(1).deriveFont(16.0f);
        g2d.setColor(Color.BLACK);
        g2d.setFont(titleFont);
        g2d.setStroke(new BasicStroke());
        Rectangle2D rect2d = g2d.getFontMetrics().getStringBounds(this.dashboardTitle, g2d);
        int titleHeight = (int)Math.ceil(rect2d.getHeight());
        int titleWidth = (int)Math.ceil(rect2d.getWidth());
        int titleBlockHeight = 22;
        g2d.drawString(this.dashboardTitle, (this.bodySize.width - titleWidth) / 2, titleHeight - g2d.getFontMetrics().getDescent());
        g2d.translate(0, 22);
        g2d.setFont(savedFont);
        g2d.setColor(savedColor);
        g2d.setStroke(savedStroke);
        List<BlockRenderer> currentList = this.list.get(this.currentTemplate);
        for (int i = 0; i < currentList.size(); ++i) {
            BlockRenderer block = currentList.get(i);
            block.paint(g2d);
        }
    }

    public List<DashboardComment> getComments() {
        List<DashboardComment> dcList;
        ArrayList<DashboardComment> commentList = new ArrayList<DashboardComment>();
        if (this.commentMap != null && (dcList = this.commentMap.get(this.currentTemplate)) != null) {
            for (int i = 0; i < dcList.size(); ++i) {
                DashboardComment dc = dcList.get(i);
                if (dc.getUserDescription() == null || dc.getComment() == null || dc.getLastModDate() == null) continue;
                commentList.add(dc);
            }
        }
        return commentList;
    }

    private String getValue(SectionDocument sd, Locale locale) {
        String res = "";
        if (sd.getData() == null) {
            return "";
        }
        String pattern = sd.getPattern();
        if (pattern == null) {
            pattern = "{0}";
        }
        try {
            MessageFormat mf = new MessageFormat(pattern, locale);
            Object[] value = new Object[]{sd.getData()};
            res = mf.format(value);
        }
        catch (Exception e) {
            log.error((Object)e);
            res = sd.getData().toString();
        }
        return res.replaceAll("\\[euro\\]", "\u20ac");
    }

    public List<IArea> getAreas() {
        return null;
    }

    public PaintableProperties getPaintableProperties() {
        return this.paintableProperties;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public int getPages() {
        return this.list.size();
    }

    public void setCurrentPage(int currentPage) {
        this.currentTemplate = currentPage;
    }

    public int getCurrentPage() {
        return this.currentTemplate;
    }

    private int getId(SessionType sessionType) {
        switch (sessionType) {
            case DOCUMENT: {
                return 3;
            }
            case EXTERN: {
                return 4;
            }
            case CONTROL_PANEL: {
                return 6;
            }
            case METRIC_PANEL: {
                return 11;
            }
            case STRATEGY_MAP: {
                return 12;
            }
            case CONTROL: {
                return 13;
            }
            case METRIC: {
                return 14;
            }
            case METRIC_HISTORY: {
                return 16;
            }
            case TEXT_SESSION: {
                return 22;
            }
        }
        return 0;
    }

    private class BlockRenderer {
        private Point2D position;
        private Dimension size;
        private String title;
        private Document document;
        private BeanStyleDefinition style;
        private int type;
        private PageLayout pagelayout;
        private BlockDisplayType hideHeader;

        private BlockRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics2D g2d) {
            Dimension paintSize = new Dimension(this.size.width - 2, this.size.height - 2);
            AffineTransform at = g2d.getTransform();
            java.awt.Font font = g2d.getFont();
            try {
                Dimension dim;
                g2d.translate(this.position.getX(), this.position.getY());
                g2d.setClip(new Rectangle(new Point(), paintSize));
                if (this.hideHeader == BlockDisplayType.VISIBLE || this.hideHeader == BlockDisplayType.MOUSE_OVER) {
                    g2d.setColor(Color.BLACK);
                    g2d.setFont(font.deriveFont(1));
                    int height = (int)Math.round(g2d.getFontMetrics().getStringBounds(this.title, g2d).getHeight());
                    g2d.drawString(this.title, 2, height + 2 - g2d.getFontMetrics().getDescent());
                    g2d.translate(0, height + 4);
                    dim = new Dimension(paintSize.width, paintSize.height - height - 8);
                } else {
                    dim = new Dimension(paintSize.width, paintSize.height);
                }
                g2d.setFont(font);
                switch (this.type) {
                    case 3: 
                    case 13: 
                    case 14: {
                        if (this.document == null) break;
                        this.paint((ReportDocument)this.document, dim, g2d);
                        break;
                    }
                    case 11: {
                        if (this.document == null) break;
                        this.paintMetricPanel((MetricPanelDocument)this.document, dim, g2d);
                        break;
                    }
                    case 6: {
                        if (this.document == null) break;
                        this.paintControlPanel((ControlPanelDocument)this.document, dim, g2d);
                        break;
                    }
                    case 16: {
                        if (this.document == null) break;
                        MetricHistoryDocument mhd = (MetricHistoryDocument)this.document;
                        this.paint(mhd.getTable(), mhd.getDisplayProperties(), dim, g2d, StyleElementHelper.getInstance((BeanStyleDefinition)this.style));
                        break;
                    }
                    case 12: {
                        if (this.document == null) break;
                        this.paintStrategyMap((MetricPanelDocument)this.document, dim, g2d);
                        break;
                    }
                    case 22: {
                        if (this.document == null) break;
                        this.paintTextSession((TextDocument)this.document, dim, g2d);
                        break;
                    }
                    case 100: {
                        this.paintFilter(DashboardRenderer.this.filterList, dim, g2d);
                    }
                }
                Color savedColor = g2d.getColor();
                Stroke savedStroke = g2d.getStroke();
                g2d.setStroke(new BasicStroke());
                g2d.setColor(Color.BLACK);
                g2d.drawLine(0, 0, paintSize.width, 0);
                g2d.setColor(savedColor);
                g2d.setStroke(savedStroke);
            }
            finally {
                g2d.setFont(font);
                g2d.setClip(null);
                g2d.setTransform(at);
            }
        }

        private void paintFilter(List<? extends ReportFilter> filterList, Dimension dim, Graphics2D g2d) {
            try {
                StringBuilder sb = new StringBuilder();
                DateFormat[] df = this.createDateFormats(DashboardRenderer.this.locale);
                sb.append("<html><head><title></title></head><body><table>");
                for (ReportFilter reportFilter : filterList) {
                    if (!reportFilter.isVisible() || !reportFilter.getUseFilter()) continue;
                    sb.append("<tr><td>").append(reportFilter.getDescription()).append("</td><td>").append(this.format(df, reportFilter.getValues())).append("</td></tr>");
                }
                sb.append("</table></body></html>");
                this.paintTextSession(sb.toString(), dim, g2d);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }

        private DateFormat[] createDateFormats(Locale locale) {
            return new DateFormat[]{DateFormat.getDateInstance(3, locale), DateFormat.getTimeInstance(3, locale), DateFormat.getDateTimeInstance(3, 3, locale)};
        }

        private String format(DateFormat[] df, Object value) {
            if (value == null) {
                return "";
            }
            if (value instanceof Time) {
                return df[1].format(value);
            }
            if (value instanceof Timestamp) {
                return df[2].format(value);
            }
            if (value instanceof Date) {
                return df[0].format(value);
            }
            if (value instanceof java.util.Date) {
                return df[2].format(value);
            }
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                StringBuffer str = new StringBuffer();
                for (int i = 0; i < values.length; ++i) {
                    if (i != 0) {
                        str.append("/");
                    }
                    str.append(this.format(df, values[i]));
                }
                return str.toString();
            }
            return value.toString();
        }

        private void paintTextSession(TextDocument document, Dimension dim, Graphics2D g2d) {
            try {
                String text = document.getText();
                if (text == null) {
                    text = "";
                }
                text = text.replaceAll("<br/>", "<br>");
                this.paintTextSession(text, dim, g2d);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintTextSession(String text, Dimension dim, Graphics2D g2d) {
            AffineTransform at = g2d.getTransform();
            try {
                JTextPane jep = new JTextPane();
                jep.setSize((int)dim.getWidth(), (int)dim.getHeight());
                jep.setContentType("text/html; charset=UTF-8");
                jep.setText(text);
                MutableAttributeSet attrs = jep.getInputAttributes();
                int fontSize = this.pagelayout.getFontSize()[2];
                java.awt.Font font = g2d.getFont();
                StyleConstants.setFontSize(attrs, fontSize);
                StyleConstants.setFontFamily(attrs, font.getFamily());
                StyledDocument doc = jep.getStyledDocument();
                doc.setCharacterAttributes(0, doc.getLength() + 1, attrs, false);
                jep.paint(g2d);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            finally {
                g2d.setTransform(at);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintStrategyMap(MetricPanelDocument document, Dimension dim, Graphics2D g2d) {
            AffineTransform at = g2d.getTransform();
            try {
                StrategyMapChart smHelper = new StrategyMapChart(document.getPerspectives());
                smHelper.init();
                smHelper.paint(g2d);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            finally {
                g2d.setTransform(at);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintControlPanel(ControlPanelDocument document, Dimension dim, Graphics2D g2d) {
            AffineTransform at = g2d.getTransform();
            try {
                ControlPanel cpHelper = new ControlPanel(document.getGroups(), DashboardRenderer.this.locale, this.pagelayout);
                cpHelper.setSize(dim);
                cpHelper.init();
                cpHelper.paint(g2d);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            finally {
                g2d.setTransform(at);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintMetricPanel(MetricPanelDocument document, Dimension dim, Graphics2D g2d) {
            AffineTransform at = g2d.getTransform();
            try {
                MetricPanel mpHelper = new MetricPanel(document.getPerspectives(), DashboardRenderer.this.locale, this.pagelayout);
                mpHelper.setSize(dim);
                mpHelper.init();
                mpHelper.paint(g2d);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            finally {
                g2d.setTransform(at);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paint(ReportDocument document, Dimension dim, Graphics2D g2d) {
            AffineTransform at = g2d.getTransform();
            try {
                if (document.size() == 0) {
                    this.paintNoData(dim, g2d);
                } else {
                    Border emptyBorder = BorderFactory.createEmptyBorder();
                    TableHelper tableHelper = new TableHelper();
                    PanelCommand pc = new PanelCommand(this.style);
                    JPanel panel = new JPanel();
                    panel.setBorder(emptyBorder);
                    panel.setOpaque(false);
                    panel.setAlignmentY(0.0f);
                    GridBagLayout gbl = new GridBagLayout();
                    panel.setLayout(gbl);
                    GridBagConstraints gbc = new GridBagConstraints();
                    gbc.fill = 2;
                    gbc.weightx = 1.0;
                    gbc.gridx = 0;
                    gbc.anchor = 18;
                    DisplayProperties dp = document.getDisplayProperties();
                    StyleElementHelper seh = StyleElementHelper.getInstance((BeanStyleDefinition)this.style);
                    if (dp.getDisplayType() == BeanDisplayType.TABLE || dp.getDisplayType() == BeanDisplayType.SEARCH) {
                        for (int i = 0; i < document.size(); ++i) {
                            Document ad = document.get(i);
                            if (ad instanceof TableDocument) {
                                TableDocument td = (TableDocument)ad;
                                tableHelper.encodeTable(td, (Command)pc, DashboardRenderer.this.locale);
                                panel.add((Component)pc.getComponent(), gbc);
                                continue;
                            }
                            if (!(ad instanceof SectionDocument)) continue;
                            SectionDocument section = (SectionDocument)ad;
                            GridBagConstraints gbcs = new GridBagConstraints();
                            gbcs.fill = 2;
                            gbcs.weightx = 1.0;
                            gbcs.gridx = 0;
                            gbcs.anchor = 18;
                            JLabel text = new JLabel(tableHelper.getFormat(section.getPattern(), new Object[]{section.getData()}, DashboardRenderer.this.locale));
                            this.setStyle(text, seh.getStyleElement(section.getClassElement()), gbcs);
                            panel.add((Component)text, gbcs);
                        }
                        GridBagConstraints gbcl = new GridBagConstraints();
                        gbcl.fill = 1;
                        gbcl.gridx = 0;
                        gbcl.weighty = 1.0;
                        gbcl.weightx = 1.0;
                        JPanel fakePanel = new JPanel();
                        fakePanel.setBorder(emptyBorder);
                        fakePanel.setOpaque(false);
                        panel.add((Component)fakePanel, gbcl);
                        JScrollPane pane = new JScrollPane(panel, 21, 31);
                        pane.setBorder(emptyBorder);
                        pane.setOpaque(false);
                        pane.getViewport().setOpaque(false);
                        pane.setPreferredSize(dim);
                        pane.setMinimumSize(dim);
                        pane.setSize(dim);
                        pane.addNotify();
                        RepaintManager.currentManager(pane).setDoubleBufferingEnabled(false);
                        pane.validate();
                        pane.paint(g2d);
                    } else {
                        for (int i = 0; i < document.size(); ++i) {
                            Document ad = document.get(i);
                            if (ad instanceof TableDocument) {
                                this.paint((TableDocument)ad, dp, dim, g2d, seh);
                                continue;
                            }
                            if (!(ad instanceof SectionDocument)) continue;
                            dim = this.paint((SectionDocument)ad, dim, g2d, seh);
                        }
                    }
                }
            }
            finally {
                g2d.setTransform(at);
            }
        }

        private void setStyle(JComponent comp, StyleElement styleElement, GridBagConstraints gbc) {
            if (styleElement != null) {
                if (styleElement.getBackColor() != null) {
                    comp.setBackground(this.getColor(styleElement.getBackColor()));
                    comp.setOpaque(true);
                } else {
                    comp.setOpaque(false);
                }
                if (styleElement.getForeColor() != null) {
                    comp.setForeground(this.getColor(styleElement.getForeColor()));
                }
                comp.setFont(FontHelper.getAwtFont((Font)styleElement, null));
                switch (styleElement.getTextAlign()) {
                    case 1: {
                        comp.setAlignmentX(0.0f);
                        if (gbc != null) {
                            gbc.anchor = 17;
                        }
                        if (!(comp instanceof JLabel)) break;
                        ((JLabel)comp).setHorizontalAlignment(2);
                        break;
                    }
                    case 3: {
                        comp.setAlignmentX(1.0f);
                        if (gbc != null) {
                            gbc.anchor = 13;
                        }
                        if (!(comp instanceof JLabel)) break;
                        ((JLabel)comp).setHorizontalAlignment(4);
                        break;
                    }
                    case 2: {
                        comp.setAlignmentX(0.5f);
                        if (gbc != null) {
                            gbc.anchor = 10;
                        }
                        if (!(comp instanceof JLabel)) break;
                        ((JLabel)comp).setHorizontalAlignment(0);
                    }
                }
                comp.setAlignmentY(0.5f);
            } else {
                comp.setOpaque(false);
            }
        }

        private Color getColor(String color) {
            return new Color(Integer.parseInt(color, 16));
        }

        private void paint(TableDocument td, DisplayProperties dp, Dimension dim, Graphics2D g2d, StyleElementHelper seh) {
            Table table = td.getTable();
            BeanDisplayType displayType = dp == null ? null : dp.getDisplayType();
            try {
                IChart chart = ChartFactory.getInstance(DashboardRenderer.this.daoFactory).getChart(displayType, (PaintableProperties)((AbstractChartProperties)dp), table, this.style);
                chart.setScreen(td.getScreen() + 1);
                chart.setSize(dim);
                chart.init();
                chart.paint(g2d);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension paint(SectionDocument sd, Dimension dim, Graphics2D g2d, StyleElementHelper seh) {
            java.awt.Font defaultFont = g2d.getFont();
            Paint paint = g2d.getPaint();
            try {
                StyleElement styleElement = seh.getStyleElement(sd.getClassElement());
                g2d.setColor(new Color(Integer.parseInt(styleElement.getForeColor(), 16)));
                java.awt.Font font = FontHelper.getAwtFont((Font)styleElement, (java.awt.Font)defaultFont);
                g2d.setFont(font);
                FontMetrics fm = g2d.getFontMetrics();
                String label = DashboardRenderer.this.getValue(sd, DashboardRenderer.this.locale);
                Rectangle2D rect = fm.getStringBounds(label, g2d);
                int baseline = fm.getAscent() + fm.getLeading() + 2;
                double posX = 0.0;
                switch (styleElement.getTextAlign()) {
                    case 1: {
                        posX = 0.0;
                        break;
                    }
                    case 2: {
                        posX = 0.5;
                        break;
                    }
                    case 3: {
                        posX = 1.0;
                    }
                }
                g2d.drawString(label, (float)(posX *= dim.getWidth() - (double)fm.stringWidth(label)), (float)baseline);
                g2d.translate(2.0, rect.getHeight() + 4.0);
                Dimension dimension = new Dimension((int)dim.getWidth(), (int)(dim.getHeight() - rect.getHeight()));
                return dimension;
            }
            finally {
                g2d.setPaint(paint);
                g2d.setFont(defaultFont);
            }
        }

        private Dimension paintNoData(Dimension dim, Graphics2D g2d) {
            g2d.setColor(Color.BLACK);
            FontMetrics fm = g2d.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(DashboardRenderer.this.noDataLabel, g2d);
            int baseline = fm.getAscent() + fm.getLeading() + 2;
            g2d.drawString(DashboardRenderer.this.noDataLabel, 0, baseline);
            g2d.translate(2.0, rect.getHeight() + 4.0);
            return new Dimension((int)dim.getWidth(), (int)(dim.getHeight() - rect.getHeight()));
        }
    }

    private static class Converter {
        private final double size;
        private final double max;

        private Converter(double size, double max) {
            this.size = size;
            this.max = max;
        }

        private double getValue(double value) {
            return value / this.max * this.size;
        }

        private int getIntValue(double value) {
            return (int)this.getValue(value);
        }
    }
}

