/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.helper.AbstractDataStructureMap;
import com.prelytis.dashboard.value.data.BeanQueryStar;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.Locale;

public class DataStructureMap
extends AbstractDataStructureMap {
    protected Point leftTop = new Point();
    protected Point rightBottom = new Point();
    private int rayon;
    private int coef;

    public DataStructureMap(BeanQueryStar queryStar, int nbDisplayField, int coef, boolean primaryKey, boolean foreignKey, boolean aFields, Locale locale) {
        super(queryStar, nbDisplayField, primaryKey, foreignKey, aFields, locale);
        this.coef = coef;
    }

    public DataStructureMap(BeanQueryStar queryStar, Locale locale) {
        this(queryStar, 10, 100, false, false, true, locale);
    }

    public void init() {
        this.tableRep.refresh();
        this.rayon = (int)(Math.sqrt(this.maxHeight * this.maxHeight + this.maxWidth * this.maxWidth) * (double)this.coef / 100.0);
        this.calcPosition(this.tableRep, 0, 0.0, Math.PI * 2);
        this.size = new Dimension(this.rightBottom.x - this.leftTop.x + 2, this.rightBottom.y - this.leftTop.y + 2);
    }

    private void calcPosition(AbstractDataStructureMap.TableRep tableRep, int level, double angleAvg, double angleExt) {
        int nbChild = tableRep.getChildTableRepList().size();
        if (level == 0) {
            tableRep.setPosition(new Point(0, 0));
            if (this.leftTop.x > -tableRep.getSize().width / 2) {
                this.leftTop.x = -tableRep.getSize().width / 2;
            }
            if (this.leftTop.y > -tableRep.getSize().height / 2) {
                this.leftTop.y = -tableRep.getSize().height / 2;
            }
            if (this.rightBottom.x < tableRep.getSize().width / 2) {
                this.rightBottom.x = tableRep.getSize().width / 2;
            }
            if (this.rightBottom.y < tableRep.getSize().height / 2) {
                this.rightBottom.y = tableRep.getSize().height / 2;
            }
        } else {
            Point lPoint = new Point(0, -this.rayon * level);
            AffineTransform lAT = AffineTransform.getRotateInstance(angleAvg);
            lAT.transform(lPoint, lPoint);
            tableRep.setPosition(lPoint);
            if (this.leftTop.x > lPoint.x - tableRep.getSize().width / 2) {
                this.leftTop.x = lPoint.x - tableRep.getSize().width / 2;
            }
            if (this.leftTop.y > lPoint.y - tableRep.getSize().height / 2) {
                this.leftTop.y = lPoint.y - tableRep.getSize().height / 2;
            }
            if (this.rightBottom.x < lPoint.x + tableRep.getSize().width / 2) {
                this.rightBottom.x = lPoint.x + tableRep.getSize().width / 2;
            }
            if (this.rightBottom.y < lPoint.y + tableRep.getSize().height / 2) {
                this.rightBottom.y = lPoint.y + tableRep.getSize().height / 2;
            }
        }
        for (int i = 0; i < nbChild; ++i) {
            AbstractDataStructureMap.TableRep lTableRep = tableRep.getChildTableRepList().get(i);
            this.calcPosition(lTableRep, level + 1, angleAvg - angleExt / 2.0 + ((double)i + 0.5) * angleExt / (double)nbChild, angleExt / (double)nbChild);
        }
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.backColor != null) {
            graphics2D.setColor(this.backColor);
            graphics2D.fillRect(0, 0, this.size.width, this.size.height);
        }
        graphics2D.translate(-this.leftTop.x, -this.leftTop.y);
        graphics2D.setColor(Color.black);
        this.tableRep.paint(graphics2D);
    }

    public int getCurrentPage() {
        return 0;
    }

    public int getPages() {
        return 1;
    }

    public void setCurrentPage(int currentPage) {
    }
}

