/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.canvas.Canvas;
import com.prelytis.dashboard.chart.ComponentPaintableWrapper;
import com.prelytis.dashboard.chart.IChart;
import com.prelytis.dashboard.chart.IPaintable;
import com.prelytis.dashboard.chart.TAChart;
import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.MetricResultDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.TaskDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.document.factory.AbstractImageFactory;
import com.prelytis.dashboard.document.factory.CanvasFactory;
import com.prelytis.dashboard.document.factory.ChartFactory;
import com.prelytis.dashboard.helper.ReportDocumentHelper;
import com.prelytis.dashboard.helper.UrlHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.OutputFormat;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.ExtSessionHelper;
import com.prelytis.dashboard.model.helper.Helper;
import com.prelytis.dashboard.util.Command;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.util.PanelCommand;
import com.prelytis.dashboard.util.TableFactory;
import com.prelytis.dashboard.util.TableHelper;
import com.prelytis.dashboard.util.ThresholdHelper;
import com.prelytis.dashboard.value.chart.Cell;
import com.prelytis.dashboard.value.chart.CellHeader;
import com.prelytis.dashboard.value.chart.CellHeaderElt;
import com.prelytis.dashboard.value.chart.CellValue;
import com.prelytis.dashboard.value.chart.CellValueElt;
import com.prelytis.dashboard.value.chart.ColRow;
import com.prelytis.dashboard.value.chart.DisplayProperties;
import com.prelytis.dashboard.value.chart.PaintableProperties;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.chart.properties.AbstractChartProperties;
import com.prelytis.dashboard.value.chart.properties.GaugeChartProperties;
import com.prelytis.dashboard.value.data.BeanDisplayType;
import com.prelytis.dashboard.value.data.BeanExtSessionDefinition;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.data.BeanTaskDefinition;
import com.prelytis.dashboard.value.data.BeanTaskMetric;
import com.prelytis.dashboard.value.data.BeanTaskMetricResult;
import com.prelytis.dashboard.value.data.Position;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.structure.AbstractDocument;
import com.prelytis.dashboard.value.structure.CanvasDocument;
import com.prelytis.dashboard.value.structure.Document;
import com.prelytis.dashboard.value.structure.ExternalDocument;
import com.prelytis.dashboard.value.structure.ImageDocument;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.structure.TableDocument;
import com.prelytis.dashboard.value.util.ClassElement;
import com.prelytis.dashboard.value.util.ColorList;
import com.prelytis.dashboard.value.util.Expression;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.Severity;
import com.prelytis.dashboard.value.util.Threshold;
import com.prelytis.dashboard.value.util.Thresholds;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public final class DocumentHelper {
    private final ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();
    private final DaoFactory daoFactory;
    private static final int CONTROL_PANEL_SESSION_OID = 10;
    private static final int METRIC_PANEL_SESSION_OID = 36;
    private static final int STRATEGY_MAP_SESSION_OID = 37;

    public static final DocumentHelper getInstance(DaoFactory daoFactory) {
        return new DocumentHelper(daoFactory);
    }

    private DocumentHelper(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public ImageDocument getImageDocument(OutputFormat format, TableDocument tableDocument, DisplayProperties dp, Dimension dim, Double scale, Integer dpi, BeanStyleDefinition style) throws DashboardException {
        try {
            Table table = tableDocument.getTable();
            if (TableFactory.hasData((Table)table)) {
                Rectangle2D r;
                TAChart taChart;
                ComponentPaintableWrapper paintable;
                BeanDisplayType displayType;
                BeanDisplayType beanDisplayType = displayType = dp == null ? null : dp.getDisplayType();
                if (displayType == BeanDisplayType.TABLE || displayType == BeanDisplayType.SEARCH) {
                    PanelCommand panelCommand = new PanelCommand(style);
                    TableHelper helper = new TableHelper();
                    helper.encodeTable(tableDocument, (Command)panelCommand, table.getLocale());
                    paintable = new ComponentPaintableWrapper(panelCommand.getComponent());
                } else {
                    AbstractChartProperties chartProperties = (AbstractChartProperties)dp;
                    IChart chart = ChartFactory.getInstance(this.daoFactory).getChart(chartProperties.getDisplayType(), (PaintableProperties)chartProperties, table, style);
                    if (tableDocument.getCurrentPage() != null) {
                        chart.setScreen(tableDocument.getCurrentPage().intValue());
                    }
                    if (chart instanceof TAChart) {
                        taChart = (TAChart)chart;
                        taChart.setEnd(tableDocument.getTimeAxisEnd());
                        taChart.setStart(tableDocument.getTimeAxisStart());
                    }
                    tableDocument.setScreenColumns(chart.getScreenColumns());
                    tableDocument.setScreen(chart.getScreen() - 1);
                    paintable = chart;
                }
                AbstractImageFactory factory = AbstractImageFactory.getInstance(format);
                ImageDocument imageDocument = factory.getImageDocument((I18nElement)tableDocument, (IPaintable)paintable, dim, scale, dpi, false);
                if (paintable.getSize() != null) {
                    imageDocument.setImageWidth(paintable.getSize().width);
                    imageDocument.setImageHeight(paintable.getSize().height);
                }
                if (paintable instanceof TAChart && (r = (taChart = (TAChart)paintable).getAxisRect()) != null) {
                    imageDocument.setLeftAxis((int)r.getMinX());
                    imageDocument.setRightAxis((int)r.getMaxX());
                    imageDocument.setBottomAxis((int)r.getMaxY());
                    imageDocument.setTopAxis((int)r.getMinY());
                }
                imageDocument.setTimeAxisEnd(tableDocument.getTimeAxisEnd());
                imageDocument.setTimeAxisStart(tableDocument.getTimeAxisStart());
                return imageDocument;
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        return null;
    }

    protected DashboardException getException(Exception e) {
        Logger log = Logger.getLogger(this.getClass());
        if (e instanceof DashboardException) {
            ((DashboardException)((Object)e)).log(log);
            return (DashboardException)((Object)e);
        }
        log.error((Object)e, (Throwable)e);
        return new DashboardException((Throwable)e);
    }

    public ExternalDocument getExternalDocument(String name, List<? extends ReportFilter> filterList, ExpressionEvaluationData data) throws DashboardException {
        try {
            ExternalDocument document = new ExternalDocument();
            Helper helper = Helper.getInstance(this.daoFactory);
            BeanExtSessionDefinition extSession = helper.get((Dao)this.daoFactory.getExternSessionDao(), name, 2, BeanExtSessionDefinition.class);
            document.setObjectID(extSession.getObjectID());
            document.setName(extSession.getName());
            document.setDescription((String)extSession.getDescriptionMap().get(data.getLocale()));
            document.getDescriptionMap().putAll(extSession.getDescriptionMap());
            ExtSessionHelper externSessionHelper = ExtSessionHelper.getInstance(this.daoFactory);
            List<ReportFilter> finalFilterList = externSessionHelper.getLinkableFilterList(extSession.getParameterList(), filterList, data);
            if (extSession.isPluginMode()) {
                document.setUrl(extSession.getUrl());
            } else {
                UrlHelper urlHelper = new UrlHelper();
                urlHelper.setData(data);
                urlHelper.setExtSession(extSession);
                urlHelper.setFilterList(finalFilterList);
                urlHelper.setValueList(data.getPersFieldList());
                document.setUrl(urlHelper.getUrl());
            }
            document.setFilterList(finalFilterList);
            document.setPluginMode(extSession.isPluginMode());
            document.setBootClass(extSession.getBootClass());
            PrelytisInfoDao infoDao = this.daoFactory.getPrelytisInfoDao();
            document.setAutoValidateFilter(infoDao.isAutoValidateFilter() && extSession.isAutoValidateFilter());
            return document;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    public ReportDocument getMetricDataDocument(String metricName, ExpressionEvaluationData data) throws DashboardException {
        try {
            int entityOid = data.getEntityOid();
            TaskDao taskDao = this.daoFactory.getTaskDao();
            BeanTaskDefinition taskDef = (BeanTaskDefinition)taskDao.getDefinition(metricName);
            if (!(taskDef instanceof BeanTaskMetric)) {
                throw new DashboardException();
            }
            BeanTaskMetric task = (BeanTaskMetric)taskDef;
            MetricResultDao metricResultDao = this.daoFactory.getMetricResultDao();
            BeanTaskMetricResult taskResult = metricResultDao.open(task, entityOid);
            String desc = (String)taskDef.getDescriptionMap().get(data.getLocale());
            Table table = this.getMetricTable(taskResult, desc, data);
            GaugeChartProperties chartProperties = new GaugeChartProperties();
            chartProperties.setLegend(Integer.valueOf(0));
            chartProperties.setInteractive(Boolean.TRUE);
            chartProperties.setDisplayType(BeanDisplayType.GAUGE_CHART2);
            ReportDocumentHelper.updateDisplayType(this.daoFactory, (DisplayProperties)chartProperties);
            ReportDocument srcDocument = new ReportDocument();
            srcDocument.setObjectID(task.getObjectID());
            srcDocument.setSessionType(SessionType.METRIC);
            srcDocument.setName(task.getName());
            srcDocument.setDescription(desc);
            srcDocument.getDescriptionMap().putAll(task.getDescriptionMap());
            srcDocument.setDisplayProperties((DisplayProperties)chartProperties);
            srcDocument.setShowFilterFirst(false);
            srcDocument.setCommentPosition(Position.HIDDEN);
            srcDocument.setCustomized(false);
            TableDocument td = new TableDocument();
            td.setTable(table);
            srcDocument.add((Document)td);
            return srcDocument;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    public ReportDocument getMetricDocument(ReportDocument metricDocument, ExpressionEvaluationData data, OutputFormat outputFormat, Dimension size, Double scale, Integer dpi) throws DashboardException {
        try {
            if (size.width == 0 || size.height == 0) {
                size = new Dimension(800, 600);
            }
            if (scale == null) {
                scale = new Double(1.0);
            }
            ReportDocument document = null;
            if (outputFormat == null) {
                outputFormat = OutputFormat.DATA;
            }
            switch (outputFormat) {
                case DATA: {
                    document = metricDocument;
                    break;
                }
                case GIF: 
                case JPEG: 
                case PDF: 
                case PNG: 
                case JSON: {
                    document = new ReportDocument();
                    document.setObjectID(metricDocument.getObjectID());
                    document.setName(metricDocument.getName());
                    document.setSessionType(SessionType.METRIC);
                    document.setDescription(metricDocument.getDescription());
                    document.getDescriptionMap().putAll(metricDocument.getDescriptionMap());
                    document.setComment(metricDocument.getComment());
                    document.setStyle(metricDocument.getStyle());
                    document.setPageLayoutOid(metricDocument.getPageLayoutOid());
                    document.setPageLayoutName(metricDocument.getPageLayoutName());
                    document.setDisplayProperties(metricDocument.getDisplayProperties());
                    document.setCustomized(metricDocument.isCustomized());
                    document.setFilterPosition(metricDocument.getFilterPosition());
                    document.setCommentPosition(metricDocument.getCommentPosition());
                    document.setShowFilterFirst(metricDocument.isShowFilterFirst());
                    document.setFilterList(metricDocument.getFilterList());
                    document.setRowsPerPage(metricDocument.getRowsPerPage());
                    document.setStandard(metricDocument.isStandard());
                    BeanStyleDefinition style = null;
                    Canvas canvas = null;
                    if (outputFormat == OutputFormat.JSON) {
                        CanvasFactory cf = CanvasFactory.getInstance(this.daoFactory);
                        DisplayProperties dp = metricDocument.getDisplayProperties();
                        canvas = cf.createCanvas(dp, style);
                    }
                    for (int i = 0; i < metricDocument.size(); ++i) {
                        AbstractDocument doc = metricDocument.getDocument(i);
                        if (doc instanceof TableDocument) {
                            TableDocument td = (TableDocument)doc;
                            CanvasDocument cd = null;
                            if (canvas != null) {
                                cd = canvas.getDocument(td);
                            }
                            if (cd != null) {
                                document.add((Document)cd);
                                continue;
                            }
                            ImageDocument id = this.getImageDocument(outputFormat, td, document.getDisplayProperties(), size, scale, dpi, style);
                            document.add((Document)id);
                            continue;
                        }
                        document.add((Document)doc);
                    }
                    break;
                }
            }
            return document;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private Table getMetricTable(BeanTaskMetricResult taskResult, String description, ExpressionEvaluationData data) throws DashboardException {
        Table table = null;
        try {
            table = TableFactory.getStdTable((TimeZone)data.getTimeZone(), (Locale)data.getLocale(), (int)3);
            ColorList colorList = new ColorList();
            colorList.addColor((Object)"7D9DEC");
            colorList.addColor((Object)"FF0000");
            table.setColorList(colorList);
            ClassElement headerFS = new ClassElement();
            ColRow row = TableFactory.addRow((Table)table);
            this.setValue((Cell)row.get(0), headerFS, null, "Metric");
            this.setValue((Cell)row.get(1), headerFS, null, "Target");
            this.setValue((Cell)row.get(2), headerFS, null, "Value");
            row = TableFactory.addRow((Table)table);
            String format = taskResult.getMetricFormat();
            this.setValue((Cell)row.get(0), headerFS, null, description);
            ClassElement valueFS = new ClassElement();
            valueFS.setName("report.num");
            this.setValue((Cell)row.get(1), valueFS, format, taskResult.getTargetValue());
            valueFS = new ClassElement();
            this.setValue((Cell)row.get(2), valueFS, format, taskResult.getMetric());
            Thresholds thresholds = ThresholdHelper.copy((Thresholds)taskResult.getThresholds());
            this.cleanThresholds(thresholds, data);
            if (taskResult.getTargetValue() != null) {
                Object targetValue = taskResult.getTargetValue();
                if (targetValue instanceof Expression) {
                    targetValue = this.helper.evaluateExpression((Expression)targetValue, data);
                }
                Threshold threshold = ThresholdHelper.insertNewThreshold((Thresholds)thresholds, (Object)targetValue);
                threshold.setDescriptionKey("target");
                threshold.setSeverity(new Severity(-1, "Target value", "7D9DEC"));
            }
            table.setThresholds(thresholds);
            TableFactory.transpose((Table)table);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        return table;
    }

    private void setValue(Cell cell, ClassElement classElement, String format, Object value) {
        if (cell instanceof CellHeader) {
            CellHeader cellHeader = (CellHeader)cell;
            CellHeaderElt elt = new CellHeaderElt();
            elt.setCell((Cell)cellHeader);
            elt.setCellEltNum((byte)0);
            elt.setClassElement(classElement);
            elt.setFormat(format);
            elt.setValue(value);
            cellHeader.setCellHeaderElt(elt);
        } else {
            CellValue cellValue = (CellValue)cell;
            CellValueElt elt = new CellValueElt();
            elt.setCell((Cell)cellValue);
            elt.setCellEltNum((byte)0);
            elt.setClassElement(classElement);
            elt.setFormat(format);
            elt.setValue(value);
            cellValue.setCellValueElt(new CellValueElt[]{elt});
        }
    }

    private void cleanThresholds(Thresholds thresholds, ExpressionEvaluationData data) throws DashboardException {
        if (thresholds != null) {
            for (int i = 0; i < thresholds.size(); ++i) {
                Threshold th = thresholds.getThreshold(i);
                Object thValue = th.getValue();
                if (thValue instanceof Expression) {
                    thValue = this.helper.evaluateExpression((Expression)thValue, data);
                }
                th.setValue((Object)new Double(Double.parseDouble(thValue.toString())));
            }
        }
    }

    public Integer getDocumentAccessLevelForEC(int execCtxOid, SessionType docType, String name, boolean preview) throws DashboardException {
        Integer accessLevel = null;
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        switch (docType) {
            case DOCUMENT: {
                if (preview) {
                    accessLevel = workspaceDao.getAccessLevelForEC(execCtxOid, SessionParameterType.REPORT).getAccessLevel();
                    break;
                }
                accessLevel = workspaceDao.getAccessLevelForEC(execCtxOid, SessionType.DOCUMENT, name).getAccessLevel();
                break;
            }
            case CONTROL: {
                accessLevel = workspaceDao.getControlAccessLevelForEC(execCtxOid, name);
                break;
            }
            case CONTROL_PANEL: {
                accessLevel = workspaceDao.getAccessLevelForEC(execCtxOid, 10).getAccessLevel();
                break;
            }
            case DASHBOARD: {
                accessLevel = workspaceDao.getAccessLevelForEC(execCtxOid, SessionType.DASHBOARD, name).getAccessLevel();
                break;
            }
            case EXTERN: {
                accessLevel = workspaceDao.getAccessLevelForEC(execCtxOid, SessionType.EXTERN, name).getAccessLevel();
                break;
            }
            case METRIC: 
            case METRIC_HISTORY: {
                accessLevel = workspaceDao.getMetricAccessLevelForEC(execCtxOid, name);
                break;
            }
            case METRIC_PANEL: {
                accessLevel = workspaceDao.getAccessLevelForEC(execCtxOid, 36).getAccessLevel();
                break;
            }
            case STRATEGY_MAP: {
                accessLevel = workspaceDao.getAccessLevelForEC(execCtxOid, 37).getAccessLevel();
                break;
            }
        }
        return accessLevel;
    }
}

