/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.InvalidSessionException;
import com.prelytis.dashboard.interfaces.LoginException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public final class ExceptionHelper {
    private final Locale locale;

    public static ExceptionHelper getInstance(Locale locale) {
        return new ExceptionHelper(locale);
    }

    private ExceptionHelper(Locale locale) {
        this.locale = locale;
    }

    public DashboardException createUnicityNameException(SessionParameterType type, String name) {
        return this.createDashboardException("unicityName", new String[]{name}, null);
    }

    public DashboardException createMissingNameException(SessionParameterType type) {
        return this.createDashboardException("missingName", null, null);
    }

    public DashboardException createNotFoundException(SessionParameterType type, String name) {
        return this.createDashboardException("notFound", new String[]{name}, null);
    }

    public DashboardException createInvalidSessionGUIDException() {
        return new InvalidSessionException(this.getMessage("invalidSessionGUID", null));
    }

    public DashboardException createMissingParameter(String paramName) {
        return this.createDashboardException("missingParameter", new String[]{paramName}, null);
    }

    public DashboardException createDashboardException(String key, Object[] param, Throwable t) {
        return this.createDashboardException(null, key, param, t);
    }

    public DashboardException createDashboardException(ErrorCode code, String key, Object[] param, Throwable t) {
        String msg = this.getMessage(key, param);
        DashboardException de = new DashboardException(code, t, msg);
        de.setLocalizedMessage(msg);
        return de;
    }

    public LoginException createLoginException(ErrorCode code, String key) {
        String msg = this.getMessage(key, null);
        LoginException de = new LoginException(code, null, msg);
        de.setLocalizedMessage(msg);
        return de;
    }

    public String getMessage(String key, Object[] param) {
        String msg = null;
        if (key != null) {
            ResourceBundle bundle = ResourceBundle.getBundle("com.prelytis.dashboard.resources.Messages", this.locale);
            msg = bundle.getString(key);
            if (param != null) {
                MessageFormat mf = new MessageFormat(msg);
                msg = mf.format(param);
            }
        }
        return msg;
    }

    public DashboardException createDashboardException(DashboardRuntimeException dre) {
        String msg = this.getMessage(this.getMessageKey(dre.getCode()), null);
        DashboardException de = new DashboardException(dre.getCode(), (Throwable)dre, msg);
        de.setLocalizedMessage(msg);
        return de;
    }

    private String getMessageKey(ErrorCode code) {
        if (code == null) {
            return null;
        }
        String c = code.toString();
        if (c.endsWith("_NAME_NOT_FOUND")) {
            return "notFound";
        }
        if (c.startsWith("INSIGHT_MISSING_EXECUTION") && c.endsWith("_NAME")) {
            return "missingName";
        }
        switch (code) {
            case INSIGHT_ACCESS_DENIED: {
                return "security";
            }
            case LICENSE_VIOLATION: {
                return "licenseViolation";
            }
        }
        return "genericError";
    }
}

