/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.value.util.ExecutionMessage;
import com.prelytis.dashboard.value.util.ExecutionMessageI18n;
import com.prelytis.dashboard.value.util.ExecutionMessageStd;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class ExecutionMessageHelper {
    private final Locale locale;
    private final ResourceBundle bundle;

    public ExecutionMessageHelper(Locale locale) {
        this.locale = locale;
        this.bundle = ResourceBundle.getBundle("com.prelytis.dashboard.resources.Messages", locale);
    }

    public List<ExecutionMessageStd> getLocalizedMessages(List<ExecutionMessage> messages) {
        ArrayList<ExecutionMessageStd> localizedMessages = new ArrayList<ExecutionMessageStd>();
        for (ExecutionMessage message : messages) {
            localizedMessages.add(this.getLocalizedMessage(message));
        }
        return localizedMessages;
    }

    public ExecutionMessageStd getLocalizedMessage(ExecutionMessage message) {
        if (message instanceof ExecutionMessageI18n) {
            ExecutionMessageI18n i18nMessage = (ExecutionMessageI18n)message;
            String msg = null;
            try {
                msg = this.bundle.getString(i18nMessage.getMessageKey());
                if (i18nMessage.getParameters() != null) {
                    msg = new MessageFormat(msg, this.locale).format(i18nMessage.getParameters());
                }
            }
            catch (Exception e) {
                msg = "Unknown message";
            }
            return new ExecutionMessageStd(message.getDate(), message.getSeverity(), msg);
        }
        if (message instanceof ExecutionMessageStd) {
            return (ExecutionMessageStd)message;
        }
        return new ExecutionMessageStd(message.getDate(), message.getSeverity(), message.toString());
    }
}

