/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.value.data.BeanFile;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.io.File;
import java.io.IOException;

public final class FileHelper {
    private final ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();
    private final BeanFile file;
    private final String fileName;

    private FileHelper(BeanFile file, String fileName) {
        this.file = file;
        this.fileName = fileName;
    }

    public static final FileHelper getInstance(BeanFile folder, String fileName) {
        return new FileHelper(folder, fileName);
    }

    public static final FileHelper getInstance(BeanFile file) {
        return new FileHelper(file, null);
    }

    public final File getFile(ExpressionEvaluationData data) throws DashboardException {
        File finalFile = null;
        String rawDirectory = this.file.getRawDirectory();
        StringBuffer directory = new StringBuffer();
        Configuration configuration = Configuration.getInstance();
        boolean folderSecurity = true;
        try {
            int pos = rawDirectory.indexOf("{WEBDASHBOARD-DIR}");
            if (pos == 0 || folderSecurity) {
                directory.append(configuration.getBaseDir());
                if (!directory.toString().endsWith(File.separator)) {
                    directory.append(File.separator);
                }
                if (pos == 0 && pos + 18 < rawDirectory.length()) {
                    directory.append(rawDirectory.substring(pos + 18));
                } else {
                    directory.append(rawDirectory);
                }
            } else {
                if (pos > 0) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("incorrectDirectory", new String[]{rawDirectory}, null);
                }
                directory = new StringBuffer(rawDirectory);
            }
        }
        catch (Exception e) {
            directory = new StringBuffer(rawDirectory);
        }
        finalFile = this.fileName == null ? new File(this.replaceAll(data, directory.toString())) : new File(this.replaceAll(data, directory.toString()), this.replaceAll(data, this.fileName));
        if (folderSecurity) {
            String fileCanonicalPath = null;
            String baseDirCanonicalPath = null;
            String etcCanonicalPath = null;
            try {
                fileCanonicalPath = finalFile.getCanonicalPath();
                baseDirCanonicalPath = new File(configuration.getBaseDir()).getCanonicalPath();
                etcCanonicalPath = new File(configuration.getBaseDir(), "etc").getCanonicalPath();
            }
            catch (IOException ioe) {
                throw new DashboardException((Throwable)ioe);
            }
            if (!fileCanonicalPath.startsWith(baseDirCanonicalPath) || fileCanonicalPath.startsWith(etcCanonicalPath)) {
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("notASafeDirectory", null, null);
            }
        }
        return finalFile;
    }

    public static final File getFile(BeanFile file, ExpressionEvaluationData data) throws DashboardRuntimeException, DashboardException {
        return FileHelper.getInstance(file).getFile(data);
    }

    private String replaceAll(ExpressionEvaluationData data, String name) throws DashboardException {
        return this.helper.evaluate(name, data);
    }
}

