/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.chart.IPaintable;
import com.prelytis.dashboard.chart.StrategyMapChart;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.PerspectiveDao;
import com.prelytis.dashboard.dao.ReportDao;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.dao.TimeUnitDao;
import com.prelytis.dashboard.dao.value.DbPerspectiveAccess;
import com.prelytis.dashboard.dao.value.DbPerspectiveAccessList;
import com.prelytis.dashboard.dao.value.DbStrategicObjectiveAccess;
import com.prelytis.dashboard.dao.value.DbTaskMetricResultAccess;
import com.prelytis.dashboard.document.factory.AbstractImageFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.OutputFormat;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.SessionHelper;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanSession;
import com.prelytis.dashboard.value.structure.ImageDocument;
import com.prelytis.dashboard.value.structure.MetricPanelDocument;
import com.prelytis.dashboard.value.structure.MetricResult;
import com.prelytis.dashboard.value.structure.Perspective;
import com.prelytis.dashboard.value.structure.StrategicObjective;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MetricPanelHelper {
    private final DaoFactory daoFactory;

    private MetricPanelHelper(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public static final MetricPanelHelper getInstance(DaoFactory daoFactory) {
        return new MetricPanelHelper(daoFactory);
    }

    public MetricPanelDocument getDocument(ExpressionEvaluationData data, boolean metricPanel) {
        BeanSession bean;
        ReportDao reportDao = this.daoFactory.getReportDao();
        TimeUnitDao unitDao = this.daoFactory.getTimeUnitDao();
        PerspectiveDao perspectiveDao = this.daoFactory.getPerspectiveDao();
        DbPerspectiveAccessList perspectiveAccessList = perspectiveDao.listForUser(data.getEntityOid().intValue(), data.getWorkspaceOid().intValue());
        ArrayList<Perspective> perspectives = new ArrayList<Perspective>();
        HashMap<Integer, String> oidNameMap = new HashMap<Integer, String>();
        for (DbPerspectiveAccess refPerspective : perspectiveAccessList.getBeanPerspectiveAccessMap().values()) {
            for (DbStrategicObjectiveAccess refStratObj : refPerspective.getStrategicObjectiveAccessList().values()) {
                oidNameMap.put(refStratObj.getObjectID(), refStratObj.getName());
            }
        }
        for (DbPerspectiveAccess refPerspective : perspectiveAccessList.getBeanPerspectiveAccessMap().values()) {
            Perspective perspective = new Perspective();
            perspective.setObjectID(refPerspective.getObjectID());
            perspective.setName(refPerspective.getName());
            perspective.setDescription((String)refPerspective.getDescriptionMap().get(data.getLocale()));
            perspective.setFont(refPerspective.getFont());
            List stratObjList = perspective.getObjectiveList();
            for (DbStrategicObjectiveAccess refStratObj : refPerspective.getStrategicObjectiveAccessList().values()) {
                StrategicObjective stratObj = new StrategicObjective();
                stratObj.setObjectID(refStratObj.getObjectID());
                stratObj.setName(refStratObj.getName());
                stratObj.setDescription((String)refStratObj.getDescriptionMap().get(data.getLocale()));
                stratObj.setBulFont(refStratObj.getBulFont());
                stratObj.setIncFont(refStratObj.getIncFont());
                if (refStratObj.getStrategicObjectiveOID() != 0) {
                    stratObj.setParentName((String)oidNameMap.get(refStratObj.getStrategicObjectiveOID()));
                }
                List metricList = stratObj.getResultList();
                for (DbTaskMetricResultAccess refMetric : refStratObj.getTaskMetricResultAccessList().values()) {
                    MetricResult metric = new MetricResult();
                    if (refMetric.getAnalysisReportOID() != null) {
                        Bean analysisReport = reportDao.getCore(refMetric.getAnalysisReportOID().intValue());
                        metric.setAnalysisReportName(analysisReport.getName());
                    }
                    metric.setCalcDate(refMetric.getCalcDate());
                    metric.setCalcTargetValue(refMetric.getCalcTargetValue());
                    metric.setCalcThresholdName(refMetric.getCalcThresholdTypeName());
                    metric.setCalcThresholds(refMetric.getCalcThresholds());
                    metric.setCalcValue(refMetric.getCalcValue());
                    metric.setCustomized(refMetric.isCustomized());
                    metric.setDescription((String)refMetric.getDescriptionMap().get(data.getLocale()));
                    metric.setFreq(Integer.valueOf(refMetric.getFreq()));
                    metric.setMetric(refMetric.getMetric());
                    metric.setMetricFormat(refMetric.getMetricFormat());
                    metric.setName(refMetric.getName());
                    metric.setObjectID(refMetric.getObjectID());
                    metric.setPreviousCalcValue(refMetric.getPreviousCalcValue());
                    metric.setReportAccessLevel(refMetric.getReportAccessLevel());
                    Bean report = reportDao.getCore(refMetric.getCalculationReportOID());
                    metric.setReportDescription((String)report.getDescriptionMap().get(data.getLocale()));
                    metric.setReportName(report.getName());
                    metric.setTargetValue(refMetric.getTargetValue());
                    metric.setTaskAccessLevel(refMetric.getTaskAccessLevel());
                    Bean timeUnit = unitDao.getCore(refMetric.getFreqUnitOID());
                    metric.setTimeUnitDescription((String)timeUnit.getDescriptionMap().get(data.getLocale()));
                    metric.setTrend(refMetric.getTrend());
                    metric.setTrendNbPer(refMetric.getTrendNbPer());
                    Bean trendUnit = unitDao.getCore(refMetric.getTrendTimeUnitOID());
                    metric.setTrendTimeUnitDescription((String)trendUnit.getDescriptionMap().get(data.getLocale()));
                    metricList.add(metric);
                }
                stratObjList.add(stratObj);
            }
            perspectives.add(perspective);
        }
        MetricPanelDocument mpd = new MetricPanelDocument();
        mpd.setPerspectives(perspectives);
        SessionDao sessionDao = this.daoFactory.getSessionDao();
        if (metricPanel) {
            bean = sessionDao.getSession(SessionType.METRIC_PANEL, null);
            mpd.setDescription((String)bean.getDescriptionMap().get(data.getLocale()));
        } else {
            bean = sessionDao.getSession(SessionType.STRATEGY_MAP, null);
            mpd.setDescription((String)bean.getDescriptionMap().get(data.getLocale()));
        }
        return mpd;
    }

    public ImageDocument getStrategyMap(MetricPanelDocument metricPanelDocument, ExpressionEvaluationData data, OutputFormat format, Dimension size, double scale, Integer dpi) throws DashboardException {
        try {
            if (format == null) {
                format = OutputFormat.PNG;
            }
            SessionHelper sessionHelper = SessionHelper.getInstance(this.daoFactory);
            BeanSession session = sessionHelper.getDefinition(SessionType.STRATEGY_MAP, null, data);
            switch (format) {
                default: 
            }
            StrategyMapChart strategyMap = new StrategyMapChart(metricPanelDocument.getPerspectives());
            AbstractImageFactory factory = AbstractImageFactory.getInstance(format);
            ImageDocument img = factory.getImageDocument((I18nElement)metricPanelDocument, (IPaintable)strategyMap, size, scale, dpi, false);
            img.setName(session.getName());
            img.setDescription((String)session.getDescriptionMap().get(data.getLocale()));
            img.getDescriptionMap().putAll(session.getDescriptionMap());
            return img;
        }
        catch (DashboardException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DashboardException((Throwable)e);
        }
    }
}

