/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.value.util.DataType;
import java.io.Serializable;

public class QuerySQLPattern
implements Serializable {
    private static final long serialVersionUID = 6626660997920406118L;
    private final String pattern;
    private final Object value;
    private final DataType dataType;
    private final boolean canBeUsedAsAParameter;

    public QuerySQLPattern(String pattern, DataType dataType, Object value) {
        this.pattern = pattern;
        this.dataType = dataType;
        this.value = value;
        this.canBeUsedAsAParameter = true;
    }

    public QuerySQLPattern(String pattern, DataType dataType, Object value, boolean canBeUsedAsAParameter) {
        this.pattern = pattern;
        this.dataType = dataType;
        this.value = value;
        this.canBeUsedAsAParameter = canBeUsedAsAParameter;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Object getValue() {
        return this.value;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean getCanBeUsedAsAParameter() {
        return this.canBeUsedAsAParameter;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.pattern).append("=");
        if (this.value == null) {
            str.append("null");
        } else {
            str.append(this.value.toString());
        }
        return str.toString();
    }

    public static final QuerySQLPattern getFixedPattern(String pattern, String value) {
        return new QuerySQLPattern(pattern, DataType.VARCHAR, value, false);
    }
}

