/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.canvas.Canvas;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.LengthUnitDao;
import com.prelytis.dashboard.dao.MapDefinitionDao;
import com.prelytis.dashboard.dao.PageLayoutDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.TaskDao;
import com.prelytis.dashboard.dao.ThemeDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbTaskFilter;
import com.prelytis.dashboard.document.factory.CanvasFactory;
import com.prelytis.dashboard.document.factory.PDFiTextFactoryTable;
import com.prelytis.dashboard.document.factory.PageLayout;
import com.prelytis.dashboard.document.factory.XLSFactoryTable;
import com.prelytis.dashboard.helper.BatchHelper;
import com.prelytis.dashboard.helper.DocumentHelper;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.FullFilterListHelper;
import com.prelytis.dashboard.helper.FullReportFilter;
import com.prelytis.dashboard.helper.FullReportFilterDS;
import com.prelytis.dashboard.helper.TableHelper;
import com.prelytis.dashboard.helper.ValueListHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.interfaces.OutputFormat;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.model.helper.StyleHelper;
import com.prelytis.dashboard.persistence.helper.ListHelper;
import com.prelytis.dashboard.util.DisplayTypeFactory;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.util.TableFactory;
import com.prelytis.dashboard.util.sql.ExceptionHandler;
import com.prelytis.dashboard.value.chart.ColRow;
import com.prelytis.dashboard.value.chart.DisplayProperties;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.chart.map.MapInfo;
import com.prelytis.dashboard.value.chart.properties.AbstractChartProperties;
import com.prelytis.dashboard.value.chart.properties.MapChartProperties;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.BeanDisplayType;
import com.prelytis.dashboard.value.data.BeanLengthUnit;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.BeanPageLayout;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.data.BeanTask;
import com.prelytis.dashboard.value.data.BeanThemeDefinition;
import com.prelytis.dashboard.value.data.HierarchicalElement;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.data.TaskType;
import com.prelytis.dashboard.value.structure.AbstractDocument;
import com.prelytis.dashboard.value.structure.CanvasDocument;
import com.prelytis.dashboard.value.structure.Document;
import com.prelytis.dashboard.value.structure.ImageDocument;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.structure.TableDocument;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.ThresholdUsage;
import java.awt.Dimension;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ReportDocumentHelper {
    private static final Logger log = LogManager.getLogger(ReportDocumentHelper.class);
    private final DaoFactory daoFactory;
    private final ReportDocument srcDocument;
    private final Dimension preferredSize;
    private final Double preferredScale;
    private final Integer preferredDpi;
    private final ExpressionEvaluationData data;
    private final List<? extends ReportFilter> filterList;
    private final ExceptionHandler exceptionHandler;

    private ReportDocumentHelper(Builder builder, ReportDocument srcDocument, List<? extends ReportFilter> filterList) {
        this.daoFactory = builder.daoFactory;
        this.exceptionHandler = builder.exceptionHandler;
        this.preferredSize = builder.preferredSize;
        this.preferredScale = builder.preferredScale;
        this.preferredDpi = builder.preferredDpi;
        this.data = builder.data;
        this.srcDocument = srcDocument;
        this.filterList = filterList;
    }

    public ReportDocument getReportDocument() {
        return this.srcDocument;
    }

    private ReportDocument createDocument() {
        ReportDocument document = new ReportDocument();
        document.setObjectID(this.srcDocument.getObjectID());
        document.setName(this.srcDocument.getName());
        document.setDescription(this.srcDocument.getDescription());
        document.getDescriptionMap().putAll(this.srcDocument.getDescriptionMap());
        document.setSessionType(SessionType.DOCUMENT);
        document.setComment(this.srcDocument.getComment());
        document.setStyle(this.srcDocument.getStyle());
        document.setPageLayoutOid(this.srcDocument.getPageLayoutOid());
        document.setPageLayoutName(this.srcDocument.getPageLayoutName());
        document.setDisplayProperties(this.srcDocument.getDisplayProperties());
        document.setCustomized(this.srcDocument.isCustomized());
        document.setFilterContent(this.srcDocument.getFilterContent());
        document.setFilterPosition(this.srcDocument.getFilterPosition());
        document.setCommentPosition(this.srcDocument.getCommentPosition());
        document.setShowFilterFirst(this.srcDocument.isShowFilterFirst());
        document.setShowHeader(this.srcDocument.isShowHeader());
        document.setFilterList(this.srcDocument.getFilterList());
        document.setRowsPerPage(this.srcDocument.getRowsPerPage());
        document.setStandard(this.srcDocument.isStandard());
        document.setPdfExportEnabled(this.srcDocument.isPdfExportEnabled());
        document.setAutoValidateFilter(this.srcDocument.isAutoValidateFilter());
        return document;
    }

    public ReportDocument getCanvasDocument() throws DashboardException {
        DisplayProperties dp;
        CanvasFactory cf = CanvasFactory.getInstance(this.daoFactory);
        Canvas canvas = cf.createCanvas(dp = this.srcDocument.getDisplayProperties(), this.getStyle());
        if (canvas == null) {
            return null;
        }
        ReportDocument document = this.createDocument();
        try {
            for (int i = 0; i < this.srcDocument.size(); ++i) {
                AbstractDocument doc = this.srcDocument.getDocument(i);
                if (doc instanceof TableDocument) {
                    TableDocument td = (TableDocument)doc;
                    CanvasDocument cd = canvas.getDocument(td);
                    document.add((Document)cd);
                    continue;
                }
                document.add((Document)doc);
            }
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
        return document;
    }

    public ReportDocument getImageDocument(OutputFormat outputFormat) throws DashboardException {
        Dimension size = this.preferredSize;
        Double scale = this.preferredScale;
        if (size == null) {
            size = new Dimension(800, 600);
        }
        if (scale == null) {
            scale = new Double(1.0);
        }
        ReportDocument document = this.createDocument();
        try {
            DocumentHelper helper = DocumentHelper.getInstance(this.daoFactory);
            for (int i = 0; i < this.srcDocument.size(); ++i) {
                AbstractDocument doc = this.srcDocument.getDocument(i);
                if (doc instanceof TableDocument) {
                    TableDocument td = (TableDocument)doc;
                    ImageDocument id = helper.getImageDocument(outputFormat, td, this.srcDocument.getDisplayProperties(), size, scale, this.preferredDpi, this.getStyle());
                    document.add((Document)id);
                    continue;
                }
                document.add((Document)doc);
            }
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
        return document;
    }

    public ImageDocument getPdfDocument() throws DashboardException {
        ThemeDao themeDao = this.daoFactory.getThemeDao();
        BeanThemeDefinition theme = (BeanThemeDefinition)themeDao.getDefinition(this.data.getThemeOid().intValue());
        PageLayoutDao pageLayoutDao = this.daoFactory.getPageLayoutDao();
        BeanPageLayout pl = (BeanPageLayout)pageLayoutDao.getCore(this.srcDocument.getPageLayoutOid());
        LengthUnitDao lengthUnitDao = this.daoFactory.getLengthUnitDao();
        BeanLengthUnit lu = (BeanLengthUnit)lengthUnitDao.getCore(pl.getLengthUnitOID());
        PageLayout pageLayout = new PageLayout(pl, lu, theme);
        PDFiTextFactoryTable pdfFactory = new PDFiTextFactoryTable(this.daoFactory, (AbstractDocument)this.srcDocument, this.data.getLocale(), pageLayout, this.data.getPersFieldList());
        pdfFactory.setReportFilterList(this.filterList);
        pdfFactory.setDisplayReportTop(this.daoFactory.getPrelytisInfoDao().isDisplayReportFilterTop());
        return pdfFactory.getImageDocument();
    }

    public ImageDocument getXlsDocument() throws DashboardException {
        ThemeDao themeDao = this.daoFactory.getThemeDao();
        BeanThemeDefinition theme = (BeanThemeDefinition)themeDao.getDefinition(this.data.getThemeOid().intValue());
        XLSFactoryTable xlsFactory = new XLSFactoryTable((AbstractDocument)this.srcDocument, this.data.getLocale(), this.getStyle(), theme, this.data.getPersFieldList());
        xlsFactory.setFilterList(this.filterList);
        return xlsFactory.getImageDocument();
    }

    private BeanStyleDefinition getStyle() throws DashboardException {
        StyleHelper styleHelper = StyleHelper.getInstance(this.daoFactory);
        return styleHelper.getDefinition(this.srcDocument.getStyle());
    }

    public static List<? extends ReportFilter> cleanValueList(List<? extends ReportFilter> filterList, List<? extends ReportFilter> valueFilterList, ExpressionEvaluationData data) throws DashboardException {
        ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();
        HashMap<String, ReportFilter> filterMap = new HashMap<String, ReportFilter>();
        if (valueFilterList != null) {
            for (ReportFilter reportFilter : valueFilterList) {
                filterMap.put(reportFilter.getName(), reportFilter);
            }
        }
        return ReportDocumentHelper.cleanValueList(helper, filterList, filterMap, data);
    }

    private static List<ReportFilter> cleanValueList(ExpressionEvaluationHelper helper, List<? extends ReportFilter> filterList, Map<String, ReportFilter> valueFilterMap, ExpressionEvaluationData data) throws DashboardException {
        if (filterList == null) {
            return null;
        }
        ArrayList<ReportFilter> dstFilterList = new ArrayList<ReportFilter>();
        for (int i = 0; i < filterList.size(); ++i) {
            ReportFilter filterValue;
            ReportFilter filter = filterList.get(i);
            Object[] values = filter.getValues();
            if (values != null) {
                filter.setValues(helper.evaluateExpression(values, data));
            }
            if ((filterValue = valueFilterMap.get(filter.getName())) != null) {
                filter.setUseFilter(filterValue.getUseFilter());
                if (filterValue.getUseFilter()) {
                    filter.setValues(helper.evaluateExpression(filterValue.getValues(), data));
                }
            }
            dstFilterList.add(filter);
        }
        return dstFilterList;
    }

    public static void updateDisplayType(DaoFactory daoFactory, DisplayProperties displayType) {
        if (displayType instanceof AbstractChartProperties) {
            AbstractChartProperties cp = (AbstractChartProperties)displayType;
            switch (displayType.getDisplayType()) {
                case BAR_CHART_3D: 
                case COLUMN_CHART_3D: 
                case LINE_CHART_3D: 
                case LINE_CHART_3D_TA: 
                case PIE_CHART_3D: 
                case BAR_CHART_IN_ROWS: 
                case STACKED_COLUMN_CHART_3D: {
                    cp.setCanvasEnabled(Boolean.FALSE);
                    break;
                }
                case MAP_CHART: {
                    MapChartProperties mcp;
                    if (!(displayType instanceof MapChartProperties) || (mcp = (MapChartProperties)displayType).getMapType() == null) break;
                    MapDefinitionDao mapDefinitionDao = daoFactory.getMapDefinitionDao();
                    MapInfo mi = mapDefinitionDao.getMapInfo(mcp.getMapType().intValue());
                    mcp.setCanvasEnabled(Boolean.valueOf(mi == null ? true : mi.isCanvasSupported()));
                    break;
                }
                default: {
                    cp.setCanvasEnabled(Boolean.TRUE);
                }
            }
        }
    }

    public static class Builder {
        private final DaoFactory daoFactory;
        private final ExpressionEvaluationData data;
        private final AbstractBeanReport report;
        private Dimension preferredSize;
        private Integer preferredDpi;
        private Double preferredScale;
        private boolean withoutAvailableFilterValues;
        private boolean reportFilterFirst;
        private boolean preview;
        private final boolean customized;
        private ThresholdUsage thresholdUsage;
        private List<? extends ReportFilter> filterList;
        private Date dateHisto;
        private String filterName;
        private ExceptionHandler exceptionHandler;

        public Builder(DaoFactory daoFactory, ExceptionHandler exceptionHandler, AbstractBeanReport report, ExpressionEvaluationData data, boolean customized) {
            this.daoFactory = daoFactory;
            this.exceptionHandler = exceptionHandler;
            this.report = report;
            this.data = data;
            this.customized = customized;
        }

        public Builder preview(boolean preview) {
            this.preview = preview;
            return this;
        }

        public Builder withoutAvailableFilterValues(boolean withoutAvailableFilterValues) {
            this.withoutAvailableFilterValues = withoutAvailableFilterValues;
            return this;
        }

        public Builder doNotExecuteReport(boolean doNotExecuteReport) {
            this.reportFilterFirst = doNotExecuteReport;
            return this;
        }

        public Builder imagePreferences(Dimension preferredSize, Double preferredScale, Integer preferredDpi) {
            this.preferredSize = preferredSize;
            this.preferredScale = preferredScale;
            this.preferredDpi = preferredDpi;
            return this;
        }

        public Builder thresholdUsage(ThresholdUsage thresholdUsage) {
            this.thresholdUsage = thresholdUsage;
            return this;
        }

        public Builder batchFilter(Date dateHisto, String filterName) {
            this.dateHisto = dateHisto;
            this.filterName = filterName;
            return this;
        }

        public Builder filterList(List<? extends ReportFilter> filterList) {
            this.filterList = filterList;
            return this;
        }

        public ReportDocumentHelper build(ReportDocument document) throws DashboardException {
            if (document == null) {
                return this.build();
            }
            List reportFilterList = null;
            if (this.preview || this.report.getExecutionMode() == 0) {
                ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();
                reportFilterList = ReportDocumentHelper.cleanValueList(helper, document.getFilterList(), new HashMap(), this.data);
            }
            return new ReportDocumentHelper(this, document, reportFilterList);
        }

        public ReportDocumentHelper build(TableHelper tableHelper, int executionMode) throws DashboardException {
            try {
                ReportDocument document = null;
                if (this.preview || executionMode == 0) {
                    document = this.getReportDocument(tableHelper, tableHelper.getFilterList(), this.reportFilterFirst);
                    if (!this.withoutAvailableFilterValues) {
                        ValueListHelper vlh = ValueListHelper.getInstance(this.daoFactory, this.data, tableHelper.getQuery(), this.report);
                        this.fillValueList(vlh, tableHelper.getFilterList());
                    }
                } else {
                    TaskDao taskDao = this.daoFactory.getTaskDao();
                    DbTaskFilter taskFilter = new DbTaskFilter();
                    taskFilter.setTaskTypeSet(EnumSet.of(TaskType.TASK_TYPE_DOCUMENT_EXPORT));
                    taskFilter.setReportOid(Integer.valueOf(this.report.getObjectID()));
                    List list = taskDao.listAll((DbDefaultFilter)taskFilter, 2);
                    int taskOid = 0;
                    if (list != null && !list.isEmpty()) {
                        taskOid = ((BeanTask)list.get(0)).getObjectID();
                        BatchHelper batchHelper = BatchHelper.getInstance(this.daoFactory);
                        document = batchHelper.getDocument(taskOid, this.dateHisto, this.filterName, this.data, ReportDocument.class);
                        this.fillEditProperty(document);
                    } else {
                        throw ExceptionHelper.getInstance(this.data.getLocale()).createDashboardException("noBatchReportFound", null, null);
                    }
                }
                ReportDocumentHelper.updateDisplayType(this.daoFactory, document.getDisplayProperties());
                return new ReportDocumentHelper(this, document, tableHelper == null ? null : tableHelper.getFilterList());
            }
            catch (Exception e) {
                if (e instanceof DashboardException) {
                    throw (DashboardException)((Object)e);
                }
                if (e instanceof DashboardRuntimeException) {
                    throw (DashboardRuntimeException)((Object)e);
                }
                throw new DashboardException((Throwable)e);
            }
        }

        public ReportDocumentHelper build() throws DashboardException {
            try {
                List<? extends ReportFilter> reportFilterList = null;
                TableHelper tableHelper = null;
                if (this.preview || this.report.getExecutionMode() == 0) {
                    QueryHelper queryHelper = QueryHelper.getInstance(this.daoFactory);
                    IQueryDefinition query = queryHelper.getFinal(this.report.getQueryName());
                    reportFilterList = this.getReportFilterList(query);
                    tableHelper = TableHelper.getInstance(this.daoFactory);
                    tableHelper.setPreview(this.preview);
                    tableHelper.setReport(this.report);
                    tableHelper.setQuery(query);
                    tableHelper.setThresholdUsage(this.thresholdUsage);
                    tableHelper.setData(this.data);
                    tableHelper.setFilterList(reportFilterList);
                }
                return this.build(tableHelper, this.report.getExecutionMode());
            }
            catch (Exception e) {
                throw this.exceptionHandler.logException(e);
            }
        }

        private List<? extends ReportFilter> getReportFilterList(IQueryDefinition query) throws DashboardException {
            ReportHelper reportHelper = ReportHelper.getInstance(this.daoFactory);
            List<ReportFilter> list = reportHelper.getFilterList(this.report, query, this.data);
            return ReportDocumentHelper.cleanValueList(list, this.filterList, this.data);
        }

        private void fillValueList(ValueListHelper vlh, List<? extends ReportFilter> filterList) throws DashboardException {
            if (filterList == null) {
                return;
            }
            List<FullReportFilter> fullFilterList = FullFilterListHelper.getFullFilterList(vlh.getReport(), vlh.getQuery());
            ListHelper listHelper = ListHelper.getInstance();
            Map fullFilterMap = listHelper.getMapByName(fullFilterList);
            for (int i = 0; i < filterList.size(); ++i) {
                ReportFilter filter = filterList.get(i);
                FullReportFilter fullFilter = (FullReportFilter)fullFilterMap.get(filter.getName());
                if (fullFilter == null) continue;
                try {
                    if (!filter.isHierarchicalFilter()) {
                        filter.setValueList(vlh.getValueList(fullFilter));
                        continue;
                    }
                    if (!(fullFilter instanceof FullReportFilterDS)) continue;
                    HierarchicalElement hierarchicalFilter = (HierarchicalElement)filter.getHierarchicalEltList().get(0);
                    hierarchicalFilter.setValueList(vlh.getFirstHierarchicalValueList((FullReportFilterDS)fullFilter, hierarchicalFilter.getName()));
                    continue;
                }
                catch (Exception e) {
                    this.exceptionHandler.logException(e);
                }
            }
        }

        private ReportDocument getReportDocument(TableHelper tableHelper, List<? extends ReportFilter> reportFilterList, boolean doNotExecuteReport) throws DashboardException {
            StyleHelper styleHelper = StyleHelper.getInstance(this.daoFactory);
            BeanStyleDefinition style = styleHelper.getDefinition(this.report.getStyleName());
            PageLayoutDao pageLayoutDao = this.daoFactory.getPageLayoutDao();
            BeanPageLayout pl = (BeanPageLayout)pageLayoutDao.getCore(this.report.getPageLayoutOID());
            PrelytisInfoDao prelytisInfoDao = this.daoFactory.getPrelytisInfoDao();
            BeanPRPInfo info = prelytisInfoDao.getPrelytisInfo();
            ReportDocument document = new ReportDocument();
            document.setObjectID(this.report.getObjectID());
            document.setName(this.report.getName());
            document.setDescription((String)this.report.getDescriptionMap().get(this.data.getLocale()));
            document.getDescriptionMap().putAll(this.report.getDescriptionMap());
            document.setSessionType(SessionType.DOCUMENT);
            document.setComment((String)this.report.getCommentMap().get(this.data.getLocale()));
            document.setStyle(style.getName());
            document.setPageLayoutOid(this.report.getPageLayoutOID());
            document.setPageLayoutName(pl.getName());
            tableHelper.setPageBreakOnSection(pl.getPageBreakOnSection());
            DisplayTypeFactory factory = new DisplayTypeFactory();
            DisplayProperties displayType = factory.getProperties(this.report.getDisplayProperties());
            document.setDisplayProperties(displayType);
            document.setFilterContent(this.report.getFilterContent());
            document.setFilterPosition(this.report.getFilterPosition());
            document.setCommentPosition(this.report.getCommentPosition());
            document.setShowFilterFirst(this.report.isShowFilterFirst());
            if (this.report instanceof BeanReportStd) {
                document.setShowHeader(((BeanReportStd)this.report).isShowHeaders());
                document.setCommands(((BeanReportStd)this.report).getSentinelCommands().getAllCommands());
            }
            document.setRowsPerPage(this.report.getRowsPerPage());
            document.setFilterList(reportFilterList);
            document.setStandard(this.report.getReportType() == 0);
            document.setCustomized(this.customized);
            document.setHtmlAllowed(info.isHtmlAllowedInReports());
            document.setPdfExportEnabled(this.report.isPdfExportEnabled());
            document.setXlsExportEnabled(this.report.isXlsExportEnabled());
            document.setAutoValidateFilter(info.isAutoValidateFilter() && this.report.isAutoValidateFilter());
            try {
                if (!doNotExecuteReport) {
                    ReportDocument rd = tableHelper.getDocument();
                    document.addAll((Collection)rd);
                    document.setIgnoredDatas(rd.isIgnoredDatas());
                    this.addTimeAxisLabels(document);
                } else {
                    tableHelper.checkParameters();
                }
            }
            catch (Exception e) {
                this.exceptionHandler.handleException(e);
            }
            return document;
        }

        private void addTimeAxisLabels(ReportDocument document) {
            DisplayProperties displayProperties = document.getDisplayProperties();
            if (BeanDisplayType.isTimeAxis((BeanDisplayType)displayProperties.getDisplayType())) {
                Table table = null;
                for (Document d : document) {
                    if (!(d instanceof TableDocument)) continue;
                    table = ((TableDocument)d).getTable();
                    break;
                }
                if (table == null) {
                    return;
                }
                ArrayList<String> timeAxisLabels = new ArrayList<String>();
                document.setTimeAxisLabels(timeAxisLabels);
                Date tMin = null;
                Date tMax = null;
                ColRow col = TableFactory.getFinalCol((Table)table, (int)0);
                int nbRows = TableFactory.getFinalNbRows((Table)table);
                for (int i = 1; i < nbRows; ++i) {
                    Object value = null;
                    try {
                        value = TableFactory.getFinalCellElt((ColRow)col, (int)i, (int)0).getValue();
                    }
                    catch (Exception e) {
                        value = null;
                    }
                    if (value == null) continue;
                    Date date = null;
                    if (value instanceof Date) {
                        date = (Date)value;
                    }
                    if (value instanceof Number) {
                        date = new Date(((Number)value).longValue());
                    }
                    if (date == null) continue;
                    if (tMin == null) {
                        tMin = date;
                    }
                    if (tMax == null) {
                        tMax = date;
                    }
                    if (date.after(tMax)) {
                        tMax = date;
                    }
                    if (!date.before(tMin)) continue;
                    tMin = date;
                }
                if (tMin == null || tMax == null) {
                    return;
                }
                Date lDate = tMin;
                MessageFormat dateMF = null;
                Calendar lCal = Calendar.getInstance(table.getTimeZone(), table.getLocale());
                lCal.setTime(tMin);
                try {
                    String dateFormat = null;
                    dateFormat = TableFactory.getColRowInv((Table)table) ? TableFactory.getFinalCellElt((ColRow)TableFactory.getFinalRow((Table)table, (int)0), (int)1, (int)0).getFormat() : TableFactory.getFinalCellElt((ColRow)TableFactory.getFinalCol((Table)table, (int)0), (int)1, (int)0).getFormat();
                    if (!"{0}".equals(dateFormat)) {
                        dateMF = new MessageFormat(dateFormat, table.getLocale());
                    }
                }
                catch (Exception dateFormat) {
                    // empty catch block
                }
                if (dateMF == null) {
                    long ext = (tMax.getTime() - tMin.getTime()) / 6L;
                    dateMF = ext <= 3600000L ? new MessageFormat("{0,date,dd/MM/yyyy HH:mm}") : (ext <= 144000000L ? new MessageFormat("{0,date,dd/MM/yyyy HH:00}") : (ext <= 1008000000L ? new MessageFormat("{0,date,dd/MM/yyyy}") : (ext <= 4464000000L ? new MessageFormat("{0,date,ww/yyyy}") : (ext <= 36720000000L ? new MessageFormat("{0,date,MM/yyyy}") : new MessageFormat("{0,date,yyyy}")))));
                }
                Format[] lF = dateMF.getFormats();
                int datePart = 1;
                for (int i = 0; i < lF.length; ++i) {
                    if (!(lF[i] instanceof SimpleDateFormat)) continue;
                    char[] pat = ((SimpleDateFormat)lF[i]).toPattern().toCharArray();
                    block16: for (int j = 0; j < pat.length; ++j) {
                        switch (pat[j]) {
                            case 'm': {
                                if (datePart >= 12) continue block16;
                                datePart = 12;
                                continue block16;
                            }
                            case 'H': 
                            case 'K': 
                            case 'a': 
                            case 'h': 
                            case 'k': {
                                if (datePart >= 11) continue block16;
                                datePart = 11;
                                continue block16;
                            }
                            case 'D': 
                            case 'E': 
                            case 'F': 
                            case 'd': {
                                if (datePart >= 5) continue block16;
                                datePart = 5;
                                continue block16;
                            }
                            case 'M': {
                                if (datePart >= 2) continue block16;
                                datePart = 2;
                                continue block16;
                            }
                            case 'w': {
                                if (datePart >= 3) continue block16;
                                datePart = 3;
                                continue block16;
                            }
                            case 'W': {
                                if (datePart >= 4) continue block16;
                                datePart = 4;
                                continue block16;
                            }
                            case 'y': {
                                if (datePart >= 1) continue block16;
                                datePart = 1;
                            }
                        }
                    }
                }
                while (lDate.before(tMax)) {
                    Object[] lParam = new Object[]{lDate};
                    String label = dateMF.format(lParam);
                    lCal.add(datePart, 1);
                    lDate = lCal.getTime();
                    timeAxisLabels.add(label);
                }
            }
        }

        private void fillEditProperty(ReportDocument rd) {
            WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
            boolean editAccess = workspaceDao.getAccessLevelForEC(this.data.getExecutionContextOid().intValue(), SessionParameterType.REPORT).getAccessLevel() == 2;
            rd.setEditAccess(editAccess);
        }
    }
}

