/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.util.sql.SQLTable;
import com.prelytis.dashboard.util.sql.SQLTableHelper;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class SQLExportHelper {
    private DataSource dataSource;
    private String comment = null;
    private boolean generateDelete = true;
    private String[] deleteOnTables = null;
    private boolean generateInsert = true;
    private String[] insertOnTables = null;
    private String encoding = "UTF-8";
    private String identifierQuoteString;

    public SQLExportHelper(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean getGenerateDelete() {
        return this.generateDelete;
    }

    public void setGenerateDelete(boolean generateDelete) {
        this.generateDelete = generateDelete;
    }

    public void setDeleteOnTables(String[] deleteOnTables) {
        this.deleteOnTables = deleteOnTables;
    }

    public boolean getGenerateInsert() {
        return this.generateInsert;
    }

    public void setGenerateInsert(boolean generateInsert) {
        this.generateInsert = generateInsert;
    }

    public void setInsertOnTables(String[] insertOnTables) {
        this.insertOnTables = insertOnTables;
    }

    public List<ExecutionMessage> go(OutputStream os) throws DashboardException {
        try {
            int i;
            ArrayList<ExecutionMessage> list = new ArrayList<ExecutionMessage>();
            if (this.comment != null) {
                os.write(this.comment.getBytes(this.encoding));
            }
            if (this.generateDelete && this.deleteOnTables != null && this.deleteOnTables.length > 0) {
                for (i = 0; i < this.deleteOnTables.length; ++i) {
                    String delete = new StringBuffer("DELETE FROM ").append(this.deleteOnTables[i]).append(";\n").toString();
                    os.write(delete.getBytes(this.encoding));
                }
            }
            if (this.generateInsert && this.insertOnTables != null && this.insertOnTables.length > 0) {
                for (i = 0; i < this.insertOnTables.length; ++i) {
                    SQLTableHelper sqlTableHelper = SQLTableHelper.getInstance((DataSource)this.dataSource, (String)this.identifierQuoteString);
                    SQLTable table = new SQLTable((String)null, (String)null, this.insertOnTables[i]);
                    sqlTableHelper.writeContentSQL(table, os, null);
                }
            }
            return list;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private void handleException(Exception e) throws DashboardException {
        if (e instanceof DashboardException) {
            throw (DashboardException)((Object)e);
        }
        throw new DashboardException((Throwable)e);
    }

    public String toString() {
        int i;
        StringBuffer str = new StringBuffer();
        str.append("generateDeleteOnTables=");
        for (i = 0; i < this.deleteOnTables.length; ++i) {
            str.append(",").append(this.deleteOnTables[i]);
        }
        str.append("\ngenerateInsertOnTables=");
        for (i = 0; i < this.insertOnTables.length; ++i) {
            str.append(",").append(this.insertOnTables[i]);
        }
        return str.toString();
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public void setIdentifierQuoteString(String identifierQuoteString) {
        this.identifierQuoteString = identifierQuoteString;
    }
}

