/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.dao.LanguageDao;
import com.prelytis.dashboard.dao.db.DefaultDaoFactory;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.util.ResourceLocator;
import com.prelytis.dashboard.util.ResourceLocatorFactory;
import com.prelytis.dashboard.util.sql.DatabaseStructure;
import com.prelytis.dashboard.util.sql.DatabaseStructureFactory;
import com.prelytis.dashboard.util.sql.SQLFileInputStream;
import com.prelytis.dashboard.util.sql.SQLInputStream;
import com.prelytis.dashboard.value.data.BeanLanguage;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import com.prelytis.dashboard.value.util.ExecutionMessageStd;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SQLImportHelper {
    protected static final Logger log = LogManager.getLogger(SQLImportHelper.class);
    private final DataSource dataSource;
    private final List<ExecutionMessage> msgList;
    private boolean simulate;
    private boolean importOK = true;
    private final ResourceLocator resourceLocator;
    private static final String PATH = "/com/prelytis/dashboard/resources/sql/";

    public static final SQLImportHelper getInstance(DataSource ds) {
        ResourceLocatorFactory factory = ResourceLocatorFactory.getInstance();
        return new SQLImportHelper(ds, factory.getJarResourceLocator(PATH));
    }

    public static SQLImportHelper getInstance(DataSource ds, byte[] data) throws IOException {
        ResourceLocatorFactory factory = ResourceLocatorFactory.getInstance();
        return new SQLImportHelper(ds, factory.getZipResourceLocator(data));
    }

    private SQLImportHelper(DataSource dataSource, ResourceLocator resourceLocator) {
        this.dataSource = dataSource;
        this.msgList = new ArrayList<ExecutionMessage>();
        this.simulate = false;
        this.resourceLocator = resourceLocator;
    }

    public void execute() throws DashboardException {
        this.execute("main.sql");
    }

    public void execute(String file) throws DashboardException {
        this.execute(Arrays.asList(file));
    }

    public void execute(List<String> files) throws DashboardException {
        try (Connection con = this.dataSource.getConnection();){
            this.execute(con, files);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void execute(Connection con, List<String> files) throws DashboardException {
        try {
            DatabaseStructure ds = DatabaseStructureFactory.getInstance().getDatabaseStructure(this.resourceLocator, con, "");
            for (String file : files) {
                this.execute(con, ds, file);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Connection con, DatabaseStructure ds, String filename) throws DashboardException {
        SQLInputStream is = null;
        String line = null;
        try {
            this.msgList.add((ExecutionMessage)new ExecutionMessageStd("Opening file '" + filename + "'."));
            is = this.getSQLInputStream(filename);
            if (is == null) {
                this.importOK = false;
                throw ExceptionHelper.getInstance(Locale.getDefault()).createDashboardException("fileNotFound", new String[]{filename}, null);
            }
            boolean ignore = false;
            boolean onErrorStop = false;
            boolean showSQL = false;
            while ((line = is.readLine()) != null) {
                if (line.startsWith("#include")) {
                    try {
                        this.execute(con, ds, line.substring(9));
                    }
                    catch (Exception e) {
                        if (onErrorStop) {
                            throw e;
                        }
                        this.msgList.add((ExecutionMessage)new ExecutionMessageStd(e.getMessage()));
                        this.importOK = false;
                    }
                    continue;
                }
                if (line.startsWith("#import")) {
                    this.importData(con, line.substring(8), Boolean.FALSE);
                    continue;
                }
                if (line.startsWith("#echo")) {
                    this.Trace(line, this.msgList);
                    continue;
                }
                if (line.startsWith("#trace on")) {
                    this.msgList.add((ExecutionMessage)new ExecutionMessageStd("trace on"));
                    showSQL = true;
                    continue;
                }
                if (line.startsWith("#trace off")) {
                    this.msgList.add((ExecutionMessage)new ExecutionMessageStd("trace off"));
                    showSQL = false;
                    continue;
                }
                if (line.startsWith("#on error stop")) {
                    onErrorStop = true;
                    continue;
                }
                if (line.startsWith("#on error continue")) {
                    onErrorStop = false;
                    continue;
                }
                if (line.startsWith("#echo")) {
                    this.msgList.add((ExecutionMessage)new ExecutionMessageStd("#"));
                    continue;
                }
                if (ignore) continue;
                if (showSQL && line != null) {
                    this.msgList.add((ExecutionMessage)new ExecutionMessageStd(line));
                }
                try {
                    if (this.simulate) {
                        this.msgList.add((ExecutionMessage)new ExecutionMessageStd(line));
                        continue;
                    }
                    ds.execute(con, line);
                }
                catch (Exception ex) {
                    if (onErrorStop) {
                        throw ex;
                    }
                    this.msgList.add((ExecutionMessage)new ExecutionMessageStd(2, ex.getMessage()));
                    this.importOK = false;
                    if (!showSQL && line != null) {
                        this.msgList.add((ExecutionMessage)new ExecutionMessageStd(line));
                    }
                    this.msgList.add((ExecutionMessage)new ExecutionMessageStd("Continuing process..."));
                }
            }
        }
        catch (Exception e) {
            try {
                StringBuffer msg = new StringBuffer();
                msg.append(e.toString()).append(" (");
                if (filename != null) {
                    msg.append(filename);
                }
                if (is != null) {
                    msg.append(":").append(is.getCurrentLine());
                }
                msg.append(")");
                this.msgList.add((ExecutionMessage)new ExecutionMessageStd(3, msg.toString()));
                this.msgList.add((ExecutionMessage)new ExecutionMessageStd("Process stopped..."));
                this.importOK = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.handleException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void Trace(String line, List<ExecutionMessage> msgList) {
        if (line == null) {
            return;
        }
        msgList.add((ExecutionMessage)new ExecutionMessageStd(line.substring(6)));
    }

    protected void handleException(Exception e) throws DashboardException {
        if (e instanceof DashboardException) {
            throw (DashboardException)((Object)e);
        }
        if (e instanceof DashboardRuntimeException) {
            throw (DashboardRuntimeException)((Object)e);
        }
        log.error((Object)e, (Throwable)e);
        throw new DashboardRuntimeException((Throwable)e);
    }

    public SQLInputStream getSQLInputStream(String filename) {
        try {
            return new SQLFileInputStream(this.getInputStream(filename), "UTF-8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected InputStream getInputStream(String filename) {
        return this.resourceLocator.getInputStream(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(List<String> filenames, Boolean overwrite) throws DashboardException {
        try (Connection con = this.dataSource.getConnection();){
            this.importData(con, filenames, overwrite);
        }
        catch (Exception e) {
            throw new DashboardException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importData(Connection con, List<String> filenames, Boolean overwrite) {
        LanguageDao languageDao = DefaultDaoFactory.getInstance().getLanguageDao();
        for (String filename : filenames) {
            try (InputStream is = this.getInputStream(filename);){
                Properties prop = new Properties();
                prop.load(is);
                int languageOid = Integer.parseInt((String)prop.remove("languageOid"));
                BeanLanguage language = (BeanLanguage)languageDao.getCore(languageOid);
                if (!language.isActive()) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    map.put((String)entry.getKey(), (String)entry.getValue());
                }
                languageDao.save(con, languageOid, overwrite, map);
            }
            catch (Exception e) {
                log.info((Object)e);
            }
        }
        try {
            languageDao.check(con);
        }
        catch (Exception e) {
            log.info((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(String filename, Boolean overwrite, Integer fromLanguageOid) throws SQLException {
        try (Connection con = this.dataSource.getConnection();){
            this.importData(con, filename, overwrite, fromLanguageOid);
        }
    }

    private void importData(Connection con, String filename, Boolean overwrite) {
        this.importData(con, filename, overwrite, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importData(Connection con, String filename, Boolean overwrite, Integer fromLanguageOid) {
        LanguageDao languageDao = DefaultDaoFactory.getInstance().getLanguageDao();
        try (InputStream is = this.getInputStream(filename);){
            Properties prop = new Properties();
            prop.load(is);
            int languageOid = Integer.parseInt((String)prop.remove("languageOid"));
            BeanLanguage language = (BeanLanguage)languageDao.getCore(languageOid);
            if (language.isActive()) {
                Map map = fromLanguageOid != null && fromLanguageOid != languageOid ? languageDao.getData(fromLanguageOid.intValue()) : new HashMap();
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    map.put((String)entry.getKey(), (String)entry.getValue());
                }
                languageDao.save(con, languageOid, overwrite, map);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public List<ExecutionMessage> getMsgList() {
        return this.msgList;
    }

    public boolean isImportOK() {
        return this.importOK;
    }
}

