/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.util.Compare;
import com.prelytis.dashboard.value.util.Severity;
import com.prelytis.dashboard.value.util.Threshold;
import com.prelytis.dashboard.value.util.Thresholds;

public class SeverityHelper {
    public static final Severity getSeverity(Thresholds thresholds, Value value) {
        return SeverityHelper.getSeverity(thresholds, Value.getObject((Value)value));
    }

    public static final Severity getSeverity(Thresholds thresholds, Object value) {
        Threshold threshold = null;
        for (int i = 0; i < thresholds.size(); ++i) {
            threshold = thresholds.getThreshold(i);
            int diff = Compare.compare((Object)value, (Object)threshold.getValue());
            if (diff == 0) {
                return threshold.getSeverity();
            }
            if (diff >= 0) continue;
            return threshold.getBefore().getSeverity();
        }
        if (threshold == null) {
            return null;
        }
        return threshold.getAfter().getSeverity();
    }

    public static void updateSeverities(int[] severities, Thresholds[] thresholds, Value value) {
        SeverityHelper.updateSeverities(severities, thresholds, Value.getObject((Value)value));
    }

    public static void updateSeverities(int[] severities, Thresholds[] thresholds, Object value) {
        for (int i = 0; i < thresholds.length; ++i) {
            Severity newSeverity = SeverityHelper.getSeverity(thresholds[i], value);
            if (newSeverity.getSeverity() <= severities[i]) continue;
            severities[i] = newSeverity.getSeverity();
        }
    }
}

