/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.helper;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.data.Break;
import com.prelytis.dashboard.data.CrossTableCalculation;
import com.prelytis.dashboard.data.CrossTableCalculationLine;
import com.prelytis.dashboard.data.CrossTableHeaderDefinition;
import com.prelytis.dashboard.data.CrossTableValue;
import com.prelytis.dashboard.data.CrossTableValueDefinition;
import com.prelytis.dashboard.data.calculation.CalculationDistinctWrapper;
import com.prelytis.dashboard.data.calculation.CalculationFractionWrapper;
import com.prelytis.dashboard.data.calculation.CalculationSimple;
import com.prelytis.dashboard.data.comparator.ReverseOrderComparator;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.helper.EngineHelper;
import com.prelytis.dashboard.data.helper.ExecutionPlanHelper;
import com.prelytis.dashboard.data.link.LinkHelperCrossTable;
import com.prelytis.dashboard.data.link.LinkHelperStd;
import com.prelytis.dashboard.data.link.RefField;
import com.prelytis.dashboard.data.link.RefType;
import com.prelytis.dashboard.data.transformation.CalculationDataFilter;
import com.prelytis.dashboard.data.transformation.CalculationDefinition;
import com.prelytis.dashboard.data.transformation.CalculationHelper;
import com.prelytis.dashboard.data.transformation.ConditionalFormatDataFilter;
import com.prelytis.dashboard.data.transformation.ConditionalFormatDefinition;
import com.prelytis.dashboard.data.transformation.ConditionalFormatHelper;
import com.prelytis.dashboard.data.transformation.ControlCrossTableDataFilter;
import com.prelytis.dashboard.data.transformation.ControlStdDataFilter;
import com.prelytis.dashboard.data.transformation.CrossTableCache;
import com.prelytis.dashboard.data.transformation.DataTransformer;
import com.prelytis.dashboard.data.transformation.DefaultDataFilter;
import com.prelytis.dashboard.data.transformation.EvolutionCalculationHelper;
import com.prelytis.dashboard.data.transformation.GlobalCacheDataFilter;
import com.prelytis.dashboard.data.transformation.InlineCalculationDataFilter;
import com.prelytis.dashboard.data.transformation.InlineCalculationDefinition;
import com.prelytis.dashboard.data.transformation.InlineCalculationHelper;
import com.prelytis.dashboard.data.transformation.LabelDefinition;
import com.prelytis.dashboard.data.transformation.PercEvolutionCalculationHelper;
import com.prelytis.dashboard.data.transformation.PrevColumnCalculationHelper;
import com.prelytis.dashboard.data.transformation.RankDataFilter;
import com.prelytis.dashboard.data.transformation.RatioCalculationHelper;
import com.prelytis.dashboard.data.transformation.ResultsetDataReader;
import com.prelytis.dashboard.data.transformation.RuptureDataFilter;
import com.prelytis.dashboard.data.transformation.SectionCacheDataFilter;
import com.prelytis.dashboard.data.transformation.SectionDataFilter;
import com.prelytis.dashboard.data.transformation.SortDataFilter;
import com.prelytis.dashboard.data.transformation.TableContainerCrossTableDataHandler;
import com.prelytis.dashboard.data.transformation.TableContainerQueryHandler;
import com.prelytis.dashboard.data.transformation.TableContainerStdDataHandler;
import com.prelytis.dashboard.data.transformation.TrendCalculationHelper;
import com.prelytis.dashboard.data.transformation.interfaces.DataHandler;
import com.prelytis.dashboard.data.transformation.interfaces.DataReader;
import com.prelytis.dashboard.db.ValueComparator;
import com.prelytis.dashboard.db.operation.OperationFinal;
import com.prelytis.dashboard.db.operation.SortColumn;
import com.prelytis.dashboard.db.sql.Result;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueString;
import com.prelytis.dashboard.helper.ClassElementHelper;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.model.helper.ColorListHelper;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.model.helper.StyleHelper;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.util.DataExpressionParser;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.util.TreeNodeHelper;
import com.prelytis.dashboard.value.chart.CellHeaderElt;
import com.prelytis.dashboard.value.chart.DisplayProperties;
import com.prelytis.dashboard.value.chart.properties.Bubble;
import com.prelytis.dashboard.value.chart.properties.DefaultColorList;
import com.prelytis.dashboard.value.chart.properties.Marker;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.AbstractBeanReportCalculation;
import com.prelytis.dashboard.value.data.BeanColorListDefinition;
import com.prelytis.dashboard.value.data.BeanColorListElement;
import com.prelytis.dashboard.value.data.BeanDisplayType;
import com.prelytis.dashboard.value.data.BeanQuerySQL;
import com.prelytis.dashboard.value.data.BeanReportCalculation;
import com.prelytis.dashboard.value.data.BeanReportCalculationLabel;
import com.prelytis.dashboard.value.data.BeanReportCalculationLine;
import com.prelytis.dashboard.value.data.BeanReportConditionalFormat;
import com.prelytis.dashboard.value.data.BeanReportCrossTable;
import com.prelytis.dashboard.value.data.BeanReportCrossTableUsedField;
import com.prelytis.dashboard.value.data.BeanReportDataUsedField;
import com.prelytis.dashboard.value.data.BeanReportSection;
import com.prelytis.dashboard.value.data.BeanReportSortField;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanReportStdBreak;
import com.prelytis.dashboard.value.data.BeanReportStdRanking;
import com.prelytis.dashboard.value.data.BeanReportStdSection;
import com.prelytis.dashboard.value.data.BeanReportStdSortField;
import com.prelytis.dashboard.value.data.BeanReportStdUsedField;
import com.prelytis.dashboard.value.data.BeanReportUsedField;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.data.CrossTableLabel;
import com.prelytis.dashboard.value.data.FieldAgregation;
import com.prelytis.dashboard.value.data.FieldCalculation;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.data.SortOrder;
import com.prelytis.dashboard.value.data.SummaryCalculation;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.tree.DefaultMutableTreeNode;
import com.prelytis.dashboard.value.tree.TreeNode;
import com.prelytis.dashboard.value.tree.TreePath;
import com.prelytis.dashboard.value.util.ClassElement;
import com.prelytis.dashboard.value.util.ColorList;
import com.prelytis.dashboard.value.util.ConstantExpression;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.Expression;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.Font;
import com.prelytis.dashboard.value.util.StyleElement;
import com.prelytis.dashboard.value.util.ThresholdUsage;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TableHelper {
    private static final Logger log = LogManager.getLogger(TableHelper.class);
    private final DaoFactory daoFactory;
    private final ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();
    private final DataExpressionParser ep = DataExpressionParser.getInstance();
    private AbstractBeanReport report;
    private IQueryDefinition query;
    private List<? extends ReportFilter> reportFilterList;
    private BeanStyleDefinition style;
    private ThresholdUsage thresholdUsage;
    private boolean preview;
    private ExpressionEvaluationData data;
    private ExecutionContext context;
    private final ClassElementHelper classElementHelper = new ClassElementHelper();
    private boolean directLink;
    private boolean pageBreakOnSection;

    private TableHelper(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public static final TableHelper getInstance(DaoFactory daoFactory) {
        return new TableHelper(daoFactory);
    }

    public IQueryDefinition getQuery() {
        return this.query;
    }

    public void setQuery(IQueryDefinition query) {
        this.query = query;
    }

    public ReportDocument getDocument() throws DashboardException {
        this.checkParameters();
        if (this.report == null) {
            return this.getQueryDocument();
        }
        if (this.report instanceof BeanReportStd) {
            return this.getStdDocument();
        }
        if (this.report instanceof BeanReportCrossTable) {
            return this.getCrossTableDocument();
        }
        throw new DashboardException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReportDocument getQueryDocument() throws DashboardException {
        EngineHelper engineHelper = EngineHelper.getInstance(this.daoFactory);
        try (Result result = engineHelper.getResult((BeanQuerySQL)this.query, this.data, null, false, 10);){
            ResultsetDataReader dataReader = new ResultsetDataReader(result, null, true);
            TableContainerQueryHandler containerHandler = new TableContainerQueryHandler();
            containerHandler.setLocale(this.data.getLocale());
            DataTransformer transformer = new DataTransformer();
            transformer.transform(dataReader, containerHandler);
            ReportDocument reportDocument = containerHandler.getDocument();
            return reportDocument;
        }
    }

    public OperationFinal getOperation() throws DashboardException {
        EngineHelper engineHelper = EngineHelper.getInstance(this.daoFactory);
        return engineHelper.getOperation(this.report, this.getContext());
    }

    private ExecutionContext getContext() throws DashboardException {
        if (this.context == null) {
            this.checkParameters();
            EngineHelper engineHelper = EngineHelper.getInstance(this.daoFactory);
            HashMap<String, ReportFilter> filterMap = new HashMap<String, ReportFilter>();
            if (this.reportFilterList != null) {
                for (ReportFilter reportFilter : this.reportFilterList) {
                    filterMap.put(reportFilter.getName(), reportFilter);
                }
            }
            this.context = engineHelper.getExecutionContext(this.report, this.data, filterMap, true);
        }
        return this.context;
    }

    public AbstractBeanReport getReport() {
        return this.report;
    }

    public void setReport(AbstractBeanReport report) {
        this.report = report;
    }

    public List<? extends ReportFilter> getFilterList() {
        return this.reportFilterList;
    }

    public void setFilterList(List<? extends ReportFilter> reportFilterList) {
        this.reportFilterList = reportFilterList;
    }

    public void checkParameters() throws DashboardException {
        if (this.query == null || this.report != null && this.query.getObjectID() != this.report.getQueryOID()) {
            QueryHelper queryHelper = QueryHelper.getInstance(this.daoFactory);
            this.query = queryHelper.getFinal(this.report.getQueryOID());
        }
        if (this.query == null) {
            throw ExceptionHelper.getInstance(this.data.getLocale()).createDashboardException("missingQuery", null, null);
        }
        if (this.style == null) {
            StyleHelper styleHelper = StyleHelper.getInstance(this.daoFactory);
            this.style = styleHelper.getDefinition(this.report.getStyleName());
        }
        PrelytisInfoDao infoDao = this.daoFactory.getPrelytisInfoDao();
        this.directLink = infoDao.isDirectLink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReportDocument getStdDocument() throws DashboardException {
        EngineHelper engineHelper = EngineHelper.getInstance(this.daoFactory);
        OperationFinal op = engineHelper.getOperation(this.report, this.getContext(), !this.preview);
        try (Result result = engineHelper.getResult(op);){
            BeanReportStdRanking ranking;
            DataHandler cdf;
            List sortFieldList;
            CalculationHelper helper;
            ArrayList<LabelDefinition> labelList;
            ArrayList<CalculationDefinition> calculationList;
            int[] markerRows;
            int[] markerCols;
            BeanReportStd stdReport = (BeanReportStd)this.report;
            Collator collator = Collator.getInstance(this.data.getLocale());
            ConditionalFormatHelper conditionalFormatHelper = ConditionalFormatHelper.getInstance(this.classElementHelper, new ValueComparator(collator));
            List sectionList = stdReport.getSectionList();
            int nbUsedFields = stdReport.getFieldList().size();
            int nbCols = sectionList.size() + nbUsedFields;
            boolean isTable = stdReport.getDisplayProperties().getDisplayType() == BeanDisplayType.TABLE;
            isTable = isTable || stdReport.getDisplayProperties().getDisplayType() == BeanDisplayType.SEARCH;
            String[] formats = new String[nbCols];
            ClassElement[] classElements = new ClassElement[nbCols];
            ArrayList<List<ConditionalFormatDefinition>> conditionalFormats = new ArrayList<List<ConditionalFormatDefinition>>(nbCols);
            InlineCalculationHelper iglobal = null;
            HashMap<Integer, InlineCalculationHelper> isections = new HashMap<Integer, InlineCalculationHelper>();
            HashMap<Integer, InlineCalculationHelper> iruptures = new HashMap<Integer, InlineCalculationHelper>();
            RatioCalculationHelper ratio = null;
            PercEvolutionCalculationHelper percEvol = null;
            EvolutionCalculationHelper evol = null;
            TrendCalculationHelper trend = null;
            List fieldList = stdReport.getFieldList();
            Integer controlCol = null;
            String controlFieldName = null;
            FieldAgregation controlAgregation = null;
            if (this.thresholdUsage != null) {
                controlFieldName = this.thresholdUsage.getFieldName();
                controlAgregation = this.thresholdUsage.getAgregation();
            }
            int cpt = 0;
            for (BeanReportSection section : stdReport.getSectionList()) {
                formats[cpt] = section.getFormat();
                classElements[cpt] = this.classElementHelper.getClassElement("-section", section.getStyle());
                if (controlFieldName != null && controlFieldName.equals(section.getField().getName()) && controlAgregation == FieldAgregation.AGREGATION_NONE) {
                    controlCol = cpt;
                }
                conditionalFormats.add(null);
                ++cpt;
            }
            ArrayList<BeanReportCalculationLine> markerCalcLines = new ArrayList<BeanReportCalculationLine>();
            if (this.report.getDisplayProperties() instanceof Bubble) {
                Bubble b = (Bubble)this.report.getDisplayProperties();
                List markers = b.getMarkers();
                if (markers != null && !markers.isEmpty()) {
                    markerCols = new int[markers.size()];
                    markerRows = new int[markers.size()];
                    int[] cpts = new int[fieldList.size()];
                    int p = 0;
                    block17: for (Marker m : markers) {
                        if (m.getColumn() == null) continue;
                        int c = 0;
                        for (BeanReportStdUsedField usedField : fieldList) {
                            if (m.getColumn().equals(usedField.getName())) {
                                this.setCalculationLine(markerCalcLines, c, cpts[c], m.getAgregation());
                                markerCols[p] = c;
                                markerRows[p] = cpts[c];
                                int n = c;
                                cpts[n] = cpts[n] + 1;
                                ++p;
                                continue block17;
                            }
                            ++c;
                        }
                    }
                } else {
                    markerCols = null;
                    markerRows = null;
                }
            } else {
                markerCols = null;
                markerRows = null;
            }
            boolean needsGlobalCache = false;
            boolean needsSectionCache = false;
            ConversionHelper conv = ConversionHelper.getDBConverter();
            int fieldNum = 0;
            HashSet<Integer> cdtFmtSet = new HashSet<Integer>();
            for (BeanReportStdUsedField usedField : fieldList) {
                for (BeanReportConditionalFormat cdtFmt : usedField.getConditionalFormatList()) {
                    cdtFmtSet.add(cdtFmt.getColId());
                }
            }
            for (BeanReportStdUsedField usedField : fieldList) {
                formats[cpt] = usedField.getBodyFormat();
                StyleElement bdSE = usedField.getBodyStyle();
                if (DataType.isNumeric((DataType)usedField.getDataType()) && this.style.isRightAlignNumeric() && bdSE.getTextAlign() == 0) {
                    bdSE = new StyleElement((Font)bdSE);
                    bdSE.setTextAlign(3);
                }
                classElements[cpt] = this.classElementHelper.getClassElement("tbl-body", bdSE);
                ArrayList<ConditionalFormatDefinition> defList = new ArrayList<ConditionalFormatDefinition>();
                for (BeanReportConditionalFormat format : usedField.getConditionalFormatList()) {
                    try {
                        BeanReportStdUsedField refField = (BeanReportStdUsedField)fieldList.get(format.getColId());
                        ConditionalFormatDefinition def = new ConditionalFormatDefinition();
                        StyleElement styleElement = new StyleElement((Font)usedField.getBodyStyle());
                        styleElement.override((Font)format.getStyle());
                        def.setClassElement(this.classElementHelper.getClassElement("tbl-body", styleElement));
                        String fmt = format.getFormat();
                        if (fmt == null || "".equals(fmt)) {
                            fmt = usedField.getBodyFormat();
                        }
                        def.setFormat(this.getFormat(fmt, ReportHelper.getDatatype(usedField), this.isPercent(usedField)));
                        def.setOperator(format.getOperator());
                        def.setValue(this.getValue(conv.parse(ReportHelper.getDatatype(refField), format.getValue())));
                        def.setField(new RefField(RefType.COL, sectionList.size() + format.getColId()));
                        defList.add(def);
                    }
                    catch (Exception e) {
                        log.warn((Object)e);
                    }
                }
                if (usedField.getCalculation() != null) {
                    CalculationSimple cs = CalculationSimple.getCalculation(usedField.getCalculation());
                    if (cs != null) {
                        InlineCalculationDefinition icd = new InlineCalculationDefinition();
                        icd.setCalculation(cs);
                        icd.setCol(usedField.getId());
                        switch (usedField.getCalculation()) {
                            case CALCULATION_PERCENT_EVOL: 
                            case CALCULATION_PERCENT_TOTAL: {
                                icd.setPercent(true);
                            }
                        }
                        switch (usedField.getCalculationScope()) {
                            case BREAK: {
                                Integer bsi = usedField.getCalculationScopeIndex();
                                InlineCalculationHelper bich = (InlineCalculationHelper)iruptures.get(bsi);
                                if (bich == null) {
                                    bich = new InlineCalculationHelper();
                                    bich.setCalculationList(new ArrayList<InlineCalculationDefinition>());
                                    iruptures.put(bsi, bich);
                                }
                                bich.getCalculationList().add(icd);
                                if (!cdtFmtSet.contains(usedField.getId())) break;
                                needsSectionCache = true;
                                break;
                            }
                            case GLOBAL: {
                                if (iglobal == null) {
                                    iglobal = new InlineCalculationHelper();
                                    iglobal.setCalculationList(new ArrayList<InlineCalculationDefinition>());
                                }
                                iglobal.getCalculationList().add(icd);
                                if (!cdtFmtSet.contains(usedField.getId())) break;
                                needsGlobalCache = true;
                                break;
                            }
                            case SECTION: {
                                Integer ssi = usedField.getCalculationScopeIndex();
                                InlineCalculationHelper sich = (InlineCalculationHelper)isections.get(ssi);
                                if (sich == null) {
                                    sich = new InlineCalculationHelper();
                                    sich.setCalculationList(new ArrayList<InlineCalculationDefinition>());
                                    isections.put(ssi, sich);
                                }
                                sich.getCalculationList().add(icd);
                                if (!cdtFmtSet.contains(usedField.getId())) break;
                                needsSectionCache = true;
                            }
                        }
                    } else if (usedField.getCalculation() == FieldCalculation.CALCULATION_RATIO) {
                        if (ratio == null) {
                            ratio = new RatioCalculationHelper();
                            ratio.setCalculationList(new ArrayList<Integer>());
                        }
                        ratio.getCalculationList().add(usedField.getId());
                    } else if (usedField.getCalculation() == FieldCalculation.CALCULATION_PERCENT_EVOL_PREV_COL) {
                        if (percEvol == null) {
                            percEvol = new PercEvolutionCalculationHelper();
                            percEvol.setCalculationList(new ArrayList<Integer>());
                        }
                        percEvol.getCalculationList().add(usedField.getId());
                    } else if (usedField.getCalculation() == FieldCalculation.CALCULATION_TREND_PREV_COL) {
                        if (trend == null) {
                            trend = new TrendCalculationHelper();
                            trend.setCalculationList(new ArrayList<Integer>());
                        }
                        trend.getCalculationList().add(usedField.getId());
                    } else if (usedField.getCalculation() == FieldCalculation.CALCULATION_EVOL_PREV_COL) {
                        if (evol == null) {
                            evol = new EvolutionCalculationHelper();
                            evol.setCalculationList(new ArrayList<Integer>());
                        }
                        evol.getCalculationList().add(usedField.getId());
                    }
                }
                if (controlFieldName != null && controlFieldName.equals(usedField.getField().getName()) && usedField.getAgregation() == controlAgregation) {
                    controlCol = fieldNum + sectionList.size();
                }
                conditionalFormats.add(defList);
                ++cpt;
                ++fieldNum;
            }
            Object dataReader = new ResultsetDataReader(result, classElements, false);
            if (this.thresholdUsage != null && controlCol != null) {
                ControlStdDataFilter control = new ControlStdDataFilter();
                control.setCol(controlCol);
                control.setThresholds(this.thresholdUsage.getThresholds());
                control.setRemoveInfo(this.thresholdUsage.isRemoveInfo());
                control.setParent((DataReader)dataReader);
                dataReader = control;
            }
            CalculationHelper global = null;
            HashMap<Integer, CalculationHelper> sections = new HashMap<Integer, CalculationHelper>();
            HashMap<Integer, CalculationHelper> ruptures = new HashMap<Integer, CalculationHelper>();
            cpt = 0;
            for (BeanReportStdSection section : sectionList) {
                List calculationLineList;
                ClassElement classElement = this.classElementHelper.getClassElement("-section", section.getStyle());
                SectionDataFilter sdf = new SectionDataFilter(0, classElement, this.getFormat(section.getFormat(), section.getField().getDataType()));
                if (isTable && !(calculationLineList = section.getCalculationLineList()).isEmpty()) {
                    calculationList = new ArrayList<CalculationDefinition>();
                    labelList = new ArrayList<LabelDefinition>();
                    this.fillCalculation(fieldList, calculationLineList, calculationList, labelList, "calcul-section");
                    ClassElement sectionClassElement = new ClassElement();
                    sectionClassElement.setName("calcul-section");
                    sectionClassElement.setStyle(new StyleElement());
                    helper = new CalculationHelper();
                    helper.setConditionalFormatHelper(conditionalFormatHelper);
                    helper.setConditionalFormatList(conditionalFormats);
                    helper.setDefaultClassElement(sectionClassElement);
                    helper.setCalculationList(calculationList);
                    helper.setLabelList(labelList);
                    helper.setNbCols(nbUsedFields);
                    helper.setNbRows(calculationLineList.size());
                    helper.setPrevColCalcList(this.getPrevColCalcList(calculationList, ratio, percEvol, evol, trend));
                    sections.put(cpt, helper);
                }
                sdf.setParent((DataReader)dataReader);
                dataReader = sdf;
                ++cpt;
            }
            if (isTable) {
                List stdBreakList = stdReport.getBreakList();
                for (cpt = stdBreakList.size() - 1; cpt >= 0; --cpt) {
                    BeanReportStdBreak stdBreak = (BeanReportStdBreak)stdBreakList.get(cpt);
                    List calculationLineList = stdBreak.getCalculationLineList();
                    if (calculationLineList.isEmpty()) continue;
                    RuptureDataFilter rupture = new RuptureDataFilter();
                    Break b = new Break(new int[]{stdBreak.getColId()});
                    rupture.setBreak(b);
                    rupture.setParent((DataReader)dataReader);
                    rupture.setRuptureLevel(cpt);
                    dataReader = rupture;
                    calculationList = new ArrayList();
                    labelList = new ArrayList();
                    this.fillCalculation(fieldList, calculationLineList, calculationList, labelList, "calcul-break");
                    ClassElement breakClassElement = new ClassElement();
                    breakClassElement.setName("calcul-break");
                    breakClassElement.setStyle(new StyleElement());
                    helper = new CalculationHelper();
                    helper.setConditionalFormatHelper(conditionalFormatHelper);
                    helper.setConditionalFormatList(conditionalFormats);
                    helper.setDefaultClassElement(breakClassElement);
                    helper.setCalculationList(calculationList);
                    helper.setLabelList(labelList);
                    helper.setNbCols(nbUsedFields);
                    helper.setNbRows(calculationLineList.size());
                    helper.setPrevColCalcList(this.getPrevColCalcList(calculationList, ratio, percEvol, evol, trend));
                    ruptures.put(cpt, helper);
                }
            }
            if (isTable || !markerCalcLines.isEmpty()) {
                List<Object> globalCalculationLineList;
                List<Object> list = globalCalculationLineList = markerCalcLines.isEmpty() ? stdReport.getGlobalCalcLineList() : markerCalcLines;
                if (!globalCalculationLineList.isEmpty()) {
                    ArrayList<CalculationDefinition> calculationList2 = new ArrayList<CalculationDefinition>();
                    ArrayList labelList2 = new ArrayList();
                    this.fillCalculation(fieldList, globalCalculationLineList, calculationList2, labelList2, "calcul-global");
                    ClassElement globalClassElement = new ClassElement();
                    globalClassElement.setName("calcul-global");
                    globalClassElement.setStyle(new StyleElement());
                    global = new CalculationHelper();
                    global.setConditionalFormatHelper(conditionalFormatHelper);
                    global.setConditionalFormatList(conditionalFormats);
                    global.setDefaultClassElement(globalClassElement);
                    global.setCalculationList(calculationList2);
                    global.setLabelList(labelList2);
                    global.setNbCols(nbUsedFields);
                    global.setNbRows(globalCalculationLineList.size());
                    global.setPrevColCalcList(this.getPrevColCalcList(calculationList2, ratio, percEvol, evol, trend));
                }
            }
            if ((sortFieldList = stdReport.getSortFieldList()) != null && !sortFieldList.isEmpty()) {
                ArrayList<SortColumn> sortColums = new ArrayList<SortColumn>();
                for (BeanReportStdSortField sortField : sortFieldList) {
                    SortColumn sort = new SortColumn();
                    sort.setCol(sortField.getColId());
                    sort.setSortOrder(sortField.getSortOrder());
                    sortColums.add(sort);
                }
                SortDataFilter sortDataFilter = new SortDataFilter();
                sortDataFilter.setParent((DataReader)dataReader);
                sortDataFilter.setSortDefinition(sortColums);
                sortDataFilter.setCollator(collator);
                dataReader = sortDataFilter;
            }
            if (iglobal != null || !isections.isEmpty() || !iruptures.isEmpty() || ratio != null || percEvol != null || evol != null || trend != null) {
                InlineCalculationDataFilter icdf = new InlineCalculationDataFilter();
                icdf.setGlobal(iglobal);
                icdf.setRuptures(iruptures);
                icdf.setSections(isections);
                icdf.setParent((DataReader)dataReader);
                icdf.setPrevColCalcList(this.getPrevColCalcList(ratio, percEvol, evol, trend));
                dataReader = icdf;
                if (needsGlobalCache) {
                    cdf = new GlobalCacheDataFilter();
                    ((GlobalCacheDataFilter)cdf).setParent((DataReader)dataReader);
                    dataReader = cdf;
                } else if (needsSectionCache) {
                    cdf = new SectionCacheDataFilter();
                    ((SectionCacheDataFilter)cdf).setParent((DataReader)dataReader);
                    dataReader = cdf;
                }
            }
            ConditionalFormatDataFilter cfdf = new ConditionalFormatDataFilter();
            cfdf.setConditionalFormatHelper(conditionalFormatHelper);
            cfdf.setConditionalFormatList(conditionalFormats);
            cfdf.setFormats(formats);
            cfdf.setParent((DataReader)dataReader);
            dataReader = cfdf;
            if (global != null || !sections.isEmpty() || !ruptures.isEmpty()) {
                cdf = new CalculationDataFilter();
                ((CalculationDataFilter)cdf).setNbSections(sectionList.size());
                ((CalculationDataFilter)cdf).setGlobal(global);
                ((CalculationDataFilter)cdf).setRuptures(ruptures);
                ((CalculationDataFilter)cdf).setSections(sections);
                ((DefaultDataFilter)cdf).setParent((DataReader)dataReader);
                dataReader = cdf;
            }
            if ((ranking = stdReport.getRanking()).isActive()) {
                int nbSection = sectionList == null ? 0 : sectionList.size();
                CalculationHelper calculationHelper = null;
                if (ranking.getShowOthers()) {
                    calculationList = new ArrayList();
                    Integer firstVisibleCol = null;
                    cpt = 0;
                    for (BeanReportStdUsedField usedField : stdReport.getFieldList()) {
                        CalculationSimple cs = null;
                        switch (usedField.getAgregation()) {
                            default: {
                                break;
                            }
                            case AGREGATION_AVERAGE: 
                            case AGREGATION_COUNT: 
                            case AGREGATION_SUM: 
                            case AGREGATION_MAX: 
                            case AGREGATION_MIN: 
                            case AGREGATION_MEDIAN: {
                                cs = CalculationSimple.getCalculation(usedField.getAgregation());
                                if (usedField.getCalculation() != FieldCalculation.CALCULATION_PERCENT_TOTAL) break;
                                cs = new CalculationFractionWrapper(cs);
                                cs.reset();
                            }
                        }
                        if (cs != null) {
                            CalculationDefinition cd = new CalculationDefinition();
                            cd.setCalculation(cs);
                            cd.setCol(cpt);
                            cd.setClassElement(classElements[nbSection + cpt]);
                            DataType datatype = ReportHelper.getDatatype(usedField);
                            cd.setFormat(this.getFormat(usedField.getBodyFormat(), datatype));
                            calculationList.add(cd);
                        } else if (firstVisibleCol == null && usedField.isVisible()) {
                            firstVisibleCol = cpt;
                        }
                        ++cpt;
                    }
                    ArrayList<LabelDefinition> labelList3 = new ArrayList<LabelDefinition>();
                    if (firstVisibleCol != null) {
                        LabelDefinition label = new LabelDefinition();
                        label.setCol(firstVisibleCol);
                        label.setRow(0);
                        label.setValue((Value)new ValueString((String)ranking.getOthersLabelMap().get(this.data.getLocale())));
                        label.setClassElement(classElements[nbSection + firstVisibleCol]);
                        label.setFormat("{0}");
                        labelList3.add(label);
                    }
                    calculationHelper = new CalculationHelper();
                    calculationHelper.setCalculationList(calculationList);
                    calculationHelper.setLabelList(labelList3);
                    calculationHelper.setNbCols(nbUsedFields);
                    calculationHelper.setNbRows(1);
                }
                RankDataFilter rank = new RankDataFilter();
                rank.setTopRows(ranking.getNbTopLines());
                rank.setBottomRows(ranking.getNbBottomLines());
                rank.setParent((DataReader)dataReader);
                rank.setCalculationHelper(calculationHelper);
                dataReader = rank;
            }
            TableContainerStdDataHandler containerHandler = isTable ? new TableContainerStdDataHandler.DefaultHandler() : (markerCols != null && markerRows != null ? new TableContainerStdDataHandler.MarkerHandler(markerCols, markerRows) : new TableContainerStdDataHandler.ChartHandler());
            containerHandler.setColorList(this.getColorList());
            containerHandler.setDirectLink(this.directLink);
            containerHandler.setReport(stdReport);
            containerHandler.setData(this.getContext().getData());
            containerHandler.setFilterMap(this.getContext().getFilterMap());
            if (this.thresholdUsage != null) {
                containerHandler.setThresholds(this.thresholdUsage.getThresholds());
            }
            if (!this.preview) {
                LinkHelperStd linkHelper = new LinkHelperStd(this.daoFactory, stdReport, this.reportFilterList, this.data);
                containerHandler.setLinkHelper(linkHelper);
            }
            containerHandler.setStyle(this.style);
            containerHandler.setLocale(this.data.getLocale());
            containerHandler.setTimeZone(this.data.getTimeZone());
            containerHandler.setEraseOnCols(this.getEraseOnCols());
            containerHandler.setPageBreakOnSection(this.pageBreakOnSection);
            DataTransformer transformer = new DataTransformer();
            transformer.transform((DataReader)dataReader, containerHandler);
            ReportDocument reportDocument = containerHandler.getDocument();
            return reportDocument;
        }
    }

    private void setCalculationLine(List<BeanReportCalculationLine> list, int col, int row, FieldAgregation agregation) {
        while (list.size() <= row) {
            list.add(new BeanReportCalculationLine());
        }
        BeanReportCalculationLine line = list.get(row);
        BeanReportCalculation calc = new BeanReportCalculation();
        calc.setColId(col);
        switch (agregation) {
            case AGREGATION_AVERAGE: {
                calc.setCalculation(SummaryCalculation.AVERAGE);
                break;
            }
            case AGREGATION_COUNT: {
                calc.setCalculation(SummaryCalculation.COUNT);
                break;
            }
            case AGREGATION_SUM: {
                calc.setCalculation(SummaryCalculation.TOTAL);
                break;
            }
            case AGREGATION_MIN: {
                calc.setCalculation(SummaryCalculation.MIN);
                break;
            }
            case AGREGATION_MAX: {
                calc.setCalculation(SummaryCalculation.MAX);
                break;
            }
            case AGREGATION_MEDIAN: {
                calc.setCalculation(SummaryCalculation.MEDIAN);
                break;
            }
            default: {
                return;
            }
        }
        line.getCalculationList().add(calc);
    }

    private List<BeanColorListElement> getColorList() {
        DisplayProperties dp = this.report.getDisplayProperties();
        if (dp instanceof DefaultColorList) {
            DefaultColorList dcl = (DefaultColorList)dp;
            String colorListName = this.style.getColorListName();
            if (dcl.getColorListName() != null) {
                colorListName = dcl.getColorListName();
            }
            if (colorListName != null) {
                try {
                    ColorListHelper colorListHelper = ColorListHelper.getInstance(this.daoFactory);
                    BeanColorListDefinition color = colorListHelper.getDefinition(colorListName);
                    return color.getElementList();
                }
                catch (Exception e) {
                    log.error((Object)new StringBuffer("Color list not found on report '").append(this.report.getName()).append("'").toString());
                }
            }
        }
        return null;
    }

    private boolean[] getEraseOnCols() {
        List fieldList = ((BeanReportStd)this.report).getFieldList();
        boolean[] resu = new boolean[fieldList.size()];
        for (int i = 0; i < fieldList.size(); ++i) {
            BeanReportStdUsedField usedField = (BeanReportStdUsedField)fieldList.get(i);
            resu[i] = usedField.isEraseDoub();
        }
        return resu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReportDocument getCrossTableDocument() throws DashboardException {
        TreeNode<CrossTableHeaderDefinition> absDef;
        int mda;
        TreeNodeHelper tnh = TreeNodeHelper.getInstance();
        Collator collator = Collator.getInstance(this.data.getLocale());
        ConditionalFormatHelper conditionalFormatHelper = ConditionalFormatHelper.getInstance(this.classElementHelper, new ValueComparator(collator));
        BeanReportCrossTable report = (BeanReportCrossTable)this.report;
        TreeNode<BeanReportCrossTableUsedField> colTree = TableHelper.getVisible((TreeNode<BeanReportCrossTableUsedField>)report.getColFieldList());
        List colTreePath = tnh.getPathList(colTree);
        TreeNode<BeanReportCrossTableUsedField> rowTree = TableHelper.getVisible((TreeNode<BeanReportCrossTableUsedField>)report.getRowFieldList());
        List rowTreePath = tnh.getPathList(rowTree);
        List dataFieldList = report.getDataFieldList();
        LinkHelperCrossTable linkHelper = !this.preview ? new LinkHelperCrossTable(this.daoFactory, report, this.reportFilterList, this.data) : null;
        boolean isTable = report.getDisplayProperties().getDisplayType() == BeanDisplayType.TABLE;
        isTable = isTable || report.getDisplayProperties().getDisplayType() == BeanDisplayType.SEARCH;
        int nbData = dataFieldList.size();
        TreeNode<CrossTableHeaderDefinition> ordDef = this.getDefinition(collator, rowTree, 2 + nbData + 2 * (mda = this.getDepth(absDef = this.getDefinition(collator, colTree, 2 + nbData, nbData, !isTable, linkHelper, RefType.COL))), nbData, !isTable, linkHelper, RefType.ROW);
        int mdo = this.getDepth(ordDef);
        if (mdo < 1 || mda < 1) {
            throw new DashboardRuntimeException(ErrorCode.INSIGHT_UNKNOWN, "pas assez de colonnes");
        }
        EngineHelper engineHelper = EngineHelper.getInstance(this.daoFactory);
        OperationFinal op = engineHelper.getOperation(report, this.getContext(), colTree, colTreePath, rowTree, rowTreePath, dataFieldList);
        try (Result result = engineHelper.getResult(op);){
            CrossTableLabel firstCell;
            CellHeaderElt firstCellElt;
            List fl;
            DataReader dataReader = new ResultsetDataReader(result);
            List sectionList = report.getSectionList();
            for (BeanReportSection section : sectionList) {
                ClassElement classElement = this.classElementHelper.getClassElement("-section", section.getStyle());
                SectionDataFilter sdf = new SectionDataFilter(2, classElement, this.getFormat(section.getFormat(), section.getField().getDataType()));
                sdf.setParent(dataReader);
                dataReader = sdf;
            }
            int cpt = 2;
            int[] valueCols = new int[dataFieldList.size()];
            ClassElement[] classElements = new ClassElement[dataFieldList.size()];
            String[] formats = new String[dataFieldList.size()];
            boolean[] dataVisible = new boolean[dataFieldList.size()];
            int dcpt = 0;
            int thresholdCellEltId = -1;
            int nbVisible = 0;
            for (Object usedField : dataFieldList) {
                dataVisible[dcpt] = usedField.isVisible();
                if (usedField.isVisible()) {
                    ++nbVisible;
                }
                valueCols[dcpt] = cpt + dcpt;
                StyleElement dSE = usedField.getStyle();
                if (dSE.getTextAlign() == 0 && this.style.isRightAlignNumeric()) {
                    dSE = new StyleElement((Font)dSE);
                    dSE.setTextAlign(3);
                }
                classElements[dcpt] = this.classElementHelper.getClassElement("tbl-body", dSE);
                formats[dcpt] = usedField.getFormat();
                if (this.thresholdUsage != null && this.thresholdUsage.getAgregation() == usedField.getAgregation() && this.thresholdUsage.getFieldName() == usedField.getField().getName()) {
                    thresholdCellEltId = dcpt;
                }
                ++dcpt;
            }
            String[] descriptions = new String[nbVisible];
            dcpt = 0;
            for (BeanReportDataUsedField usedField : dataFieldList) {
                if (!usedField.isVisible()) continue;
                descriptions[dcpt] = this.getDescription((String)usedField.getDescriptionMap().get(this.data.getLocale()));
                ++dcpt;
            }
            HashMap<Integer, Map<Integer, CrossTableValue[]>> map = new HashMap<Integer, Map<Integer, CrossTableValue[]>>();
            ConversionHelper conv = ConversionHelper.getDBConverter();
            List abs = tnh.asChildList(absDef);
            List ord = tnh.asChildList(ordDef);
            int rowId = 0;
            for (TreePath rowPath : rowTreePath) {
                Integer cdtFmtRowId = ((CrossTableHeaderDefinition)((TreeNode)ord.get(rowId)).getUserObject()).getPathId();
                HashMap<Integer, CrossTableValue[]> m = (HashMap<Integer, CrossTableValue[]>)map.get(cdtFmtRowId);
                if (m == null) {
                    m = new HashMap<Integer, CrossTableValue[]>();
                    map.put(cdtFmtRowId, m);
                }
                int colId = 0;
                for (TreePath colPath : colTreePath) {
                    Integer cdtFmtColId = ((CrossTableHeaderDefinition)((TreeNode)abs.get(colId)).getUserObject()).getPathId();
                    CrossTableValue[] vd = linkHelper != null ? linkHelper.getLinkDefinition((TreePath<BeanReportCrossTableUsedField>)colPath, (TreePath<BeanReportCrossTableUsedField>)rowPath, dataFieldList) : new CrossTableValue[dataFieldList.size()];
                    m.put(cdtFmtColId, vd);
                    dcpt = 0;
                    for (BeanReportDataUsedField usedField : dataFieldList) {
                        List cdtFmtList;
                        CrossTableValue ctv = vd[dcpt];
                        if (ctv == null) {
                            vd[dcpt] = ctv = new CrossTableValue();
                        }
                        if ((cdtFmtList = usedField.getConditionalFormatList()) != null && !cdtFmtList.isEmpty()) {
                            ArrayList<ConditionalFormatDefinition> defList = new ArrayList<ConditionalFormatDefinition>();
                            for (BeanReportConditionalFormat format : cdtFmtList) {
                                try {
                                    RefField refField = null;
                                    BeanReportDataUsedField field = null;
                                    block3 : switch (format.getUsage()) {
                                        case 1: {
                                            int refCellPos;
                                            TreeNode an = tnh.getNode(colTree, format.getColId());
                                            if (an == null || (refCellPos = this.getIndex(colPath.getPath(), an)) == -1) break;
                                            field = (BeanReportUsedField)an.getUserObject();
                                            refField = new RefField(RefType.COL, refCellPos);
                                            break;
                                        }
                                        case 2: {
                                            int refCellPos;
                                            TreeNode on = tnh.getNode(rowTree, format.getColId());
                                            if (on == null || (refCellPos = this.getIndex(rowPath.getPath(), on)) == -1) break;
                                            field = (BeanReportUsedField)on.getUserObject();
                                            refField = new RefField(RefType.ROW, refCellPos);
                                            break;
                                        }
                                        case 3: {
                                            int refCellPos = 0;
                                            for (BeanReportDataUsedField f : report.getDataFieldList()) {
                                                if (f.getId() == format.getColId()) {
                                                    field = f;
                                                    refField = new RefField(RefType.DATA, refCellPos);
                                                    break block3;
                                                }
                                                ++refCellPos;
                                            }
                                            break;
                                        }
                                    }
                                    if (field == null || refField == null) continue;
                                    ConditionalFormatDefinition def = new ConditionalFormatDefinition();
                                    StyleElement styleElement = new StyleElement((Font)usedField.getStyle());
                                    styleElement.override((Font)format.getStyle());
                                    def.setClassElement(this.classElementHelper.getClassElement("tbl-body", styleElement));
                                    String fmt = format.getFormat();
                                    if (fmt == null || "".equals(fmt)) {
                                        fmt = usedField.getFormat();
                                    }
                                    def.setFormat(this.getFormat(fmt, usedField.getDataType()));
                                    def.setOperator(format.getOperator());
                                    def.setValue(this.getValue(conv.parse(field.getDataType(), format.getValue())));
                                    def.setField(refField);
                                    defList.add(def);
                                }
                                catch (Exception e) {
                                    log.warn((Object)e);
                                }
                            }
                            ctv.setConditionalFormats(defList);
                        }
                        ++dcpt;
                    }
                    ++colId;
                }
                ++rowId;
            }
            CrossTableValueDefinition value = new CrossTableValueDefinition();
            value.setCols(valueCols);
            value.setClassElements(classElements);
            value.setFormats(formats);
            value.setVisibleDescriptions(descriptions);
            value.setMap(map);
            value.setVisible(dataVisible);
            if (this.thresholdUsage != null && thresholdCellEltId != -1) {
                dataReader = this.getCrossThresholdFilter(dataReader, thresholdCellEltId);
            }
            ColorList chartColorList = new ColorList();
            List colorList = null;
            DisplayProperties dp = this.report.getDisplayProperties();
            if (dp instanceof DefaultColorList) {
                DefaultColorList dcl = (DefaultColorList)dp;
                String colorListName = this.style.getColorListName();
                if (dcl.getColorListName() != null) {
                    colorListName = dcl.getColorListName();
                }
                if (colorListName != null) {
                    BeanColorListDefinition color = null;
                    try {
                        ColorListHelper colorListHelper = ColorListHelper.getInstance(this.daoFactory);
                        color = colorListHelper.getDefinition(colorListName);
                        colorList = color.getElementList();
                    }
                    catch (Exception e) {
                        log.error((Object)new StringBuffer("Color list not found on report '").append(this.report.getName()).append("'").toString());
                    }
                }
                if (colorList != null) {
                    chartColorList.clear();
                    for (int j = 0; j < colorList.size(); ++j) {
                        chartColorList.addColor((Object)((BeanColorListElement)colorList.get(j)).getColor());
                    }
                }
            }
            if (report.getFirstCell() != null) {
                switch (report.getFirstCell()) {
                    case ABSCISSE: {
                        fl = !report.getColRowInversion() ? colTreePath : rowTreePath;
                        break;
                    }
                    case ORDINATE: {
                        fl = report.getColRowInversion() ? colTreePath : rowTreePath;
                        break;
                    }
                    default: {
                        fl = null;
                        break;
                    }
                }
            } else {
                fl = null;
            }
            if (fl != null && fl.size() == 1) {
                TreePath path = (TreePath)fl.get(0);
                CellHeaderElt p = null;
                int cen = 0;
                for (TreeNode node : path.getPath()) {
                    CellHeaderElt e = new CellHeaderElt();
                    e.setParent(p);
                    e.setCellEltNum((byte)cen);
                    e.setValue((Object)this.getDescription((String)((BeanReportCrossTableUsedField)node.getUserObject()).getDescriptionMap().get(this.data.getLocale())));
                    p = e;
                    ++cen;
                }
                firstCellElt = p;
                firstCell = report.getFirstCell();
            } else {
                firstCellElt = null;
                firstCell = CrossTableLabel.NONE;
            }
            CrossTableCache cache = new CrossTableCache(0, absDef, mda, 1, ordDef, mdo, value, conditionalFormatHelper, firstCell, firstCellElt);
            TableContainerCrossTableDataHandler containerHandler = new TableContainerCrossTableDataHandler(cache);
            containerHandler.setReport(report);
            containerHandler.setChartColorList(chartColorList);
            if (this.thresholdUsage != null) {
                containerHandler.setThresholds(this.thresholdUsage.getThresholds());
            }
            containerHandler.setLocale(this.data.getLocale());
            containerHandler.setTimeZone(this.data.getTimeZone());
            containerHandler.setPageBreakOnSection(this.pageBreakOnSection);
            DataTransformer transformer = new DataTransformer();
            transformer.transform(dataReader, containerHandler);
            ReportDocument reportDocument = containerHandler.getDocument();
            return reportDocument;
        }
    }

    private <T> int getIndex(T[] list, T t) {
        if (list == null) {
            return -1;
        }
        int cpt = list.length;
        for (T i : list) {
            --cpt;
            if (i != t) continue;
            return cpt;
        }
        return -1;
    }

    private boolean isPercent(BeanReportStdUsedField usedField) {
        if (usedField == null || usedField.getCalculation() == null) {
            return false;
        }
        switch (usedField.getCalculation()) {
            case CALCULATION_PERCENT_EVOL: 
            case CALCULATION_PERCENT_TOTAL: 
            case CALCULATION_PERCENT_EVOL_PREV_COL: {
                return true;
            }
        }
        return false;
    }

    private List<PrevColumnCalculationHelper> getPrevColCalcList(List<CalculationDefinition> calculationList, RatioCalculationHelper ratio, PercEvolutionCalculationHelper percEvol, EvolutionCalculationHelper evol, TrendCalculationHelper trend) throws DashboardException {
        RatioCalculationHelper r = this.getPrevColumnCalculationHelper(calculationList, ratio, RatioCalculationHelper.class);
        EvolutionCalculationHelper e = this.getPrevColumnCalculationHelper(calculationList, evol, EvolutionCalculationHelper.class);
        PercEvolutionCalculationHelper pe = this.getPrevColumnCalculationHelper(calculationList, percEvol, PercEvolutionCalculationHelper.class);
        TrendCalculationHelper t = this.getPrevColumnCalculationHelper(calculationList, trend, TrendCalculationHelper.class);
        return this.getPrevColCalcList(r, pe, e, t);
    }

    private List<PrevColumnCalculationHelper> getPrevColCalcList(RatioCalculationHelper ratio, PercEvolutionCalculationHelper percEvol, EvolutionCalculationHelper evol, TrendCalculationHelper trend) {
        if (ratio == null && percEvol == null && evol == null && trend == null) {
            return null;
        }
        ArrayList<PrevColumnCalculationHelper> list = new ArrayList<PrevColumnCalculationHelper>();
        if (ratio != null) {
            list.add(ratio);
        }
        if (percEvol != null) {
            list.add(percEvol);
        }
        if (evol != null) {
            list.add(evol);
        }
        if (trend != null) {
            list.add(trend);
        }
        return list;
    }

    private <T extends PrevColumnCalculationHelper> T getPrevColumnCalculationHelper(List<CalculationDefinition> calculationList, T ref, Class<T> cl) throws DashboardException {
        if (ref == null) {
            return null;
        }
        ArrayList<Integer> chList = new ArrayList<Integer>();
        block2: for (Integer col : ref.getCalculationList()) {
            for (CalculationDefinition cd : calculationList) {
                if (cd.getCol() != col.intValue()) continue;
                if (!cd.isCalculationOnRawData()) continue block2;
                chList.add(col);
                continue block2;
            }
        }
        if (!chList.isEmpty()) {
            try {
                PrevColumnCalculationHelper helper = (PrevColumnCalculationHelper)cl.newInstance();
                helper.setCalculationList(chList);
                return (T)helper;
            }
            catch (Exception e) {
                throw new DashboardException((Throwable)e);
            }
        }
        return null;
    }

    private String getFormat(String format, DataType dataType) {
        return this.getFormat(format, dataType, false);
    }

    private String getFormat(String format, DataType dataType, boolean percent) {
        if (format == null || "".equals(format.trim())) {
            if (DataType.isNumeric((DataType)dataType)) {
                if (percent) {
                    return this.style.getFormatPercent();
                }
                return this.style.getFormatNumeric();
            }
            if (DataType.isDate((DataType)dataType)) {
                return this.style.getFormatDate();
            }
            return this.style.getFormatString();
        }
        return format;
    }

    private int getDepth(TreeNode<CrossTableHeaderDefinition> node) {
        return this.getDepth(node, 0, 0)[0];
    }

    private int[] getDepth(TreeNode<CrossTableHeaderDefinition> node, int depth, int lastId) {
        if (node.getChildren() != null) {
            int maxDepth = depth;
            int lid = lastId;
            for (TreeNode child : node.getChildren()) {
                int[] resu = this.getDepth((TreeNode<CrossTableHeaderDefinition>)child, depth + 1, lid);
                maxDepth = Math.max(maxDepth, resu[0]);
                lid = resu[1];
            }
            return new int[]{maxDepth, lid};
        }
        if (node.getUserObject() != null) {
            ((CrossTableHeaderDefinition)node.getUserObject()).setPathId(lastId);
            return new int[]{depth, lastId + 1};
        }
        return new int[]{depth, lastId};
    }

    public static <T extends BeanReportUsedField> List<T> getVisibleList(List<T> list) {
        ArrayList<BeanReportUsedField> l = new ArrayList<BeanReportUsedField>();
        for (BeanReportUsedField t : list) {
            if (!t.isVisible()) continue;
            l.add(t);
        }
        return l;
    }

    public static TreeNode<BeanReportCrossTableUsedField> getVisible(TreeNode<BeanReportCrossTableUsedField> node) {
        if (node == null) {
            return null;
        }
        if (node.getUserObject() == null || ((BeanReportCrossTableUsedField)node.getUserObject()).isVisible()) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
            newNode.setUserObject(node.getUserObject());
            if (node.getChildren() != null) {
                ArrayList<TreeNode<BeanReportCrossTableUsedField>> list = new ArrayList<TreeNode<BeanReportCrossTableUsedField>>();
                for (TreeNode cn : node.getChildren()) {
                    TreeNode<BeanReportCrossTableUsedField> ncn = TableHelper.getVisible((TreeNode<BeanReportCrossTableUsedField>)cn);
                    if (ncn == null) continue;
                    list.add(ncn);
                    ncn.setParent((TreeNode)newNode);
                }
                if (!list.isEmpty()) {
                    newNode.setChildren(list);
                }
            }
            return newNode;
        }
        return null;
    }

    private TreeNode<CrossTableHeaderDefinition> getDefinition(Collator collator, TreeNode<BeanReportCrossTableUsedField> node, int pos, int nbData, boolean ignoreCalculationLines, LinkHelperCrossTable linkHelper, RefType type) {
        DefaultMutableTreeNode defNode = new DefaultMutableTreeNode();
        int currentPos = pos;
        BeanReportCrossTableUsedField usedField = (BeanReportCrossTableUsedField)node.getUserObject();
        if (usedField != null) {
            CrossTableHeaderDefinition def = new CrossTableHeaderDefinition();
            def.setClassElement(this.classElementHelper.getClassElement("tbl-header", usedField.getStyle()));
            def.setFormat(this.getFormat(usedField.getFormat(), usedField.getDataType()));
            defNode.setUserObject((Object)def);
            BeanReportSortField sortField = usedField.getSortField();
            def.setValueComparator((Comparator<Value>)new ValueComparator(collator));
            if (sortField != null && sortField.getSortOrder() == SortOrder.SORT_DESCENDING) {
                def.setValueComparator(new ReverseOrderComparator<Value>(def.getValueComparator()));
            }
            def.setValueCol(currentPos++);
            def.setSortValueCol(currentPos++);
            if (linkHelper != null) {
                linkHelper.update(def, node, type);
            }
            if (!ignoreCalculationLines && usedField.getCalculationLineList() != null) {
                ArrayList<CrossTableCalculationLine> calculationLines = new ArrayList<CrossTableCalculationLine>();
                for (BeanReportCalculationLine calculationLine : usedField.getCalculationLineList()) {
                    List calculationList = calculationLine.getCalculationList();
                    try {
                        if (calculationList == null || calculationList.isEmpty()) continue;
                        if (calculationList.size() == nbData + 1) {
                            BeanReportCalculationLabel label = (BeanReportCalculationLabel)calculationList.get(0);
                            CrossTableCalculationLine cl = new CrossTableCalculationLine();
                            String description = (String)label.getDescriptionMap().get(this.data.getLocale());
                            if (description == null) {
                                description = "?";
                            }
                            cl.setDescription(description);
                            cl.setClassElement(this.classElementHelper.getClassElement("tbl-header", label.getStyle()));
                            CrossTableCalculation[] cs = new CrossTableCalculation[nbData];
                            cl.setCalculations(cs);
                            for (int i = 1; i <= nbData; ++i) {
                                BeanReportCalculation calculation = (BeanReportCalculation)calculationList.get(i);
                                CrossTableCalculation c = new CrossTableCalculation();
                                c.setCalculation(calculation.getCalculation());
                                if (calculation.getCalculation() == SummaryCalculation.PERC_TOTAL) {
                                    switch (type) {
                                        case COL: {
                                            c.setOrdonneeRefColId(calculation.getRefColId());
                                            break;
                                        }
                                        case ROW: {
                                            c.setAbcisseRefColId(calculation.getRefColId());
                                        }
                                    }
                                }
                                c.setClassElement(this.classElementHelper.getClassElement("calcul-cross-table", calculation.getStyle()));
                                boolean perc = calculation.getCalculation() == SummaryCalculation.PERC_TOTAL || calculation.getCalculation() == SummaryCalculation.PERC_EVOLUTION;
                                c.setFormat(this.getFormat(calculation.getFormat(), DataType.NUMERIC, perc));
                                cs[i - 1] = c;
                            }
                            calculationLines.add(cl);
                            continue;
                        }
                        log.info((Object)"Calculation line ignored");
                    }
                    catch (Exception e) {
                        log.warn((Object)e);
                    }
                }
                if (!calculationLines.isEmpty()) {
                    def.setCalculationLines(calculationLines);
                }
            }
        }
        if (node.getChildren() != null) {
            ArrayList<TreeNode<CrossTableHeaderDefinition>> childList = new ArrayList<TreeNode<CrossTableHeaderDefinition>>();
            int cpt = 0;
            for (TreeNode childNode : node.getChildren()) {
                TreeNode<CrossTableHeaderDefinition> childDefNode = this.getDefinition(collator, (TreeNode<BeanReportCrossTableUsedField>)childNode, currentPos, nbData, ignoreCalculationLines, linkHelper, type);
                childDefNode.setParent((TreeNode)defNode);
                ((CrossTableHeaderDefinition)childDefNode.getUserObject()).setId(cpt++);
                childList.add(childDefNode);
            }
            defNode.setChildren(childList);
        }
        return defNode;
    }

    private void fillCalculation(List<BeanReportStdUsedField> fieldList, List<BeanReportCalculationLine> calculationLineList, List<CalculationDefinition> calculationList, List<LabelDefinition> labelList, String className) throws DashboardException {
        int cpt = 0;
        for (BeanReportCalculationLine calculationLine : calculationLineList) {
            for (AbstractBeanReportCalculation calculation : calculationLine.getCalculationList()) {
                Object def;
                if (calculation instanceof BeanReportCalculation) {
                    boolean perc;
                    def = new CalculationDefinition();
                    BeanReportCalculation c = (BeanReportCalculation)calculation;
                    ((CalculationDefinition)def).setApplyConditionalFormat(((BeanReportCalculation)calculation).isApplyConditionalFormat());
                    ((CalculationDefinition)def).setCalculationOnRawData(c.isCalculationOnRawData());
                    ((CalculationDefinition)def).setCol(calculation.getColId());
                    ((CalculationDefinition)def).setRow(cpt);
                    BeanReportStdUsedField fld = fieldList.get(calculation.getColId());
                    CalculationSimple cs = CalculationSimple.getCalculation(c.getCalculation());
                    if (fld.getCalculation() == FieldCalculation.CALCULATION_PERCENT_TOTAL) {
                        cs = new CalculationFractionWrapper(cs);
                    }
                    if (c.isCalculationOnDistinctValues()) {
                        cs = new CalculationDistinctWrapper(cs);
                    }
                    ((CalculationDefinition)def).setCalculation(cs);
                    ((CalculationDefinition)def).setClassElement(this.classElementHelper.getClassElement(className, c.getStyle()));
                    switch (c.getCalculation()) {
                        case AVERAGE: 
                        case EVOLUTION: 
                        case MAX: 
                        case MEDIAN: 
                        case MIN: 
                        case TOTAL: {
                            perc = this.isPercent(fld);
                            break;
                        }
                        case PERC_TOTAL: 
                        case PERC_EVOLUTION: {
                            perc = true;
                            break;
                        }
                        default: {
                            perc = false;
                        }
                    }
                    ((CalculationDefinition)def).setFormat(this.getFormat(c.getFormat(), DataType.NUMERIC, perc));
                    calculationList.add((CalculationDefinition)def);
                    continue;
                }
                if (calculation instanceof BeanReportCalculationLabel) {
                    def = new LabelDefinition();
                    BeanReportCalculationLabel label = (BeanReportCalculationLabel)calculation;
                    ((LabelDefinition)def).setCol(calculation.getColId());
                    ((LabelDefinition)def).setRow(cpt);
                    ((LabelDefinition)def).setClassElement(this.classElementHelper.getClassElement(className, label.getStyle()));
                    ((LabelDefinition)def).setFormat("{0}");
                    ((LabelDefinition)def).setValue((Value)new ValueString(this.getDescription((String)label.getDescriptionMap().get(this.data.getLocale()))));
                    labelList.add((LabelDefinition)def);
                    continue;
                }
                throw new DashboardException();
            }
            ++cpt;
        }
    }

    private DataReader getCrossThresholdFilter(DataReader newDataReader, int cellEltNum) {
        ControlCrossTableDataFilter filter = new ControlCrossTableDataFilter();
        filter.setCellEltNum(cellEltNum);
        filter.setClassElementHelper(this.classElementHelper);
        filter.setThresholds(this.thresholdUsage.getThresholds());
        filter.setParent(newDataReader);
        return filter;
    }

    public BeanStyleDefinition getStyle() {
        return this.style;
    }

    public void setStyle(BeanStyleDefinition style) {
        this.style = style;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public void setThresholdUsage(ThresholdUsage thresholdUsage) {
        this.thresholdUsage = thresholdUsage;
    }

    public ExpressionEvaluationData getData() {
        return this.data;
    }

    public void setData(ExpressionEvaluationData data) {
        this.data = data;
    }

    public String getSql() throws DashboardException {
        EngineHelper engineHelper = EngineHelper.getInstance(this.daoFactory);
        ExecutionPlanHelper helper = new ExecutionPlanHelper();
        OperationFinal op = engineHelper.getOperation(this.report, this.getContext());
        helper.setOperation(op.getOperation());
        return helper.getPlan();
    }

    private Value getValue(Object value) throws DashboardException {
        Object v = value;
        if (value instanceof Expression) {
            v = this.helper.evaluateExpression((Expression)value, this.context.getData(), this.context.getFilterMap());
        }
        return Value.valueOf((Object)v);
    }

    public boolean isPageBreakOnSection() {
        return this.pageBreakOnSection;
    }

    public void setPageBreakOnSection(boolean pageBreakOnSection) {
        this.pageBreakOnSection = pageBreakOnSection;
    }

    private String getDescription(String description) throws DashboardException {
        if (description == null) {
            return "";
        }
        Expression expression = this.ep.parseExpression(DataType.VARCHAR, description);
        if (expression != null) {
            if (expression instanceof ConstantExpression) {
                return ((ConstantExpression)expression).getValue();
            }
            Object v = this.helper.evaluateExpression(expression, this.data, this.context.getFilterMap());
            if (v instanceof String) {
                return (String)v;
            }
            if (v instanceof Object[]) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Object o : (Object[])v) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append("/");
                    }
                    sb.append(o);
                }
                return sb.toString();
            }
            if (v != null) {
                return v.toString();
            }
        }
        return description;
    }
}

