/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.message;

import com.prelytis.dashboard.message.ISendMessage;
import com.prelytis.dashboard.message.Message;
import com.prelytis.dashboard.message.MessageHistoryHelper;
import com.prelytis.dashboard.value.data.BeanMessageProvDefinition;
import com.prelytis.dashboard.value.data.BeanMessageTypeDefinition;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractSendMessage
implements ISendMessage {
    protected static final Logger log = LogManager.getLogger(AbstractSendMessage.class);
    protected BeanMessageTypeDefinition messageType;
    protected BeanMessageProvDefinition messageProv;
    protected String identifier;
    protected String entityName;
    protected String userName;
    protected String taskName;
    protected Message message;
    public static final String MESSAGE_TYPE = "MessageType";
    public static final String MESSAGE_PROVIDER = "MessageProvider";
    public static final String IDENTIFIER = "Identifier";
    public static final String DOCUMENT_FRAGMENT_LIST = "DocumentFragmentList";
    public static final String ENTITY = "Entity";
    public static final String USER = "User";
    public static final String TASK = "Task";

    protected AbstractSendMessage(Map<?, ?> map) {
        this.messageType = (BeanMessageTypeDefinition)map.get(MESSAGE_TYPE);
        this.messageProv = (BeanMessageProvDefinition)map.get(MESSAGE_PROVIDER);
        this.identifier = (String)map.get(IDENTIFIER);
        this.entityName = (String)map.get(ENTITY);
        this.userName = (String)map.get(USER);
        this.taskName = (String)map.get(TASK);
        this.message = (Message)map.get(DOCUMENT_FRAGMENT_LIST);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public abstract boolean sendMessage() throws Exception;

    public Message getMessage() {
        return this.message;
    }

    public void setDocumentFragmentList(Message message) {
        this.message = message;
    }

    public boolean sendMessage(Message message) throws Exception {
        this.message = message;
        if (!this.sendMessage()) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ENTITY, this.entityName);
        map.put(USER, this.userName);
        map.put(TASK, this.taskName);
        map.put("Message Type", this.messageType);
        map.put("Message Prov", this.messageProv);
        map.put("Date", new Date());
        MessageHistoryHelper.insert(map);
        return true;
    }

    public abstract String getBaseURL();

    public abstract boolean getIsMobility();
}

