/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.message;

import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.persistence.DataSourceConfiguration;
import com.prelytis.dashboard.util.sql.PreparedStatementHelper;
import com.prelytis.dashboard.value.data.BeanMessageProv;
import com.prelytis.dashboard.value.data.BeanMessageType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;

public class MessageHistoryHelper {
    public static final String ENTITY = "Entity";
    public static final String USER = "User";
    public static final String TASK = "Task";
    public static final String MESSAGE_TYPE = "Message Type";
    public static final String MESSAGE_PROV = "Message Prov";
    public static final String DATE = "Date";

    public static void insert(Map<String, Object> map) throws DashboardRuntimeException {
        String entity = (String)map.get(ENTITY);
        String user = (String)map.get(USER);
        String task = (String)map.get(TASK);
        BeanMessageType messageType = (BeanMessageType)map.get(MESSAGE_TYPE);
        BeanMessageProv messageProv = (BeanMessageProv)map.get(MESSAGE_PROV);
        Date date = (Date)map.get(DATE);
        String request = "";
        Connection con = null;
        Statement stmt = null;
        try {
            Configuration configuration = Configuration.getInstance();
            DataSourceConfiguration dsConf = configuration.getDataSourceConfiguration();
            PreparedStatementHelper helper = PreparedStatementHelper.getInstance((int)dsConf.getQueryTimeOut(), (int)dsConf.getDefaultTransactionIsolation());
            DataSource ds = dsConf.getDataSource();
            con = ds.getConnection();
            request = "INSERT INTO BA_MsgHist (EntityName, UserName, TaskName, MsgTypeName, MsgProvName, SendDate) VALUES (?, ?, ?, ?, ?, ?)";
            stmt = helper.prepareStatement(con, request);
            helper.setParameter((PreparedStatement)stmt, 1, entity);
            helper.setParameter((PreparedStatement)stmt, 2, user);
            helper.setParameter((PreparedStatement)stmt, 3, task);
            helper.setParameter((PreparedStatement)stmt, 4, messageType.getName());
            helper.setParameter((PreparedStatement)stmt, 5, messageProv.getName());
            helper.setParameter((PreparedStatement)stmt, 6, date);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new DashboardRuntimeException(ErrorCode.SQL_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

