/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.message;

import com.axway.sentinel.dashboard.exception.DashboardServiceException;
import com.prelytis.dashboard.helper.LogMessagesHelper;
import com.prelytis.dashboard.message.AbstractSendMessage;
import com.prelytis.dashboard.security.DashboardManager;
import com.prelytis.dashboard.security.util.SettingsHelper;
import com.prelytis.dashboard.value.data.BeanUserMessageType;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.ServiceUnavailableException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SendMessageListHelper {
    private static final Logger LOG = LogManager.getLogger(SendMessageListHelper.class);
    private static final String REGEX_EMAIL = "(?i)(.*)email(.*)";
    private static final String REGEX_SMS = "(?i)(.*)sms(.*)";

    public static final List<AbstractSendMessage> getInstance(ExpressionEvaluationData data, List<BeanUserMessageType> messageTypeList, String taskName) throws Exception {
        ArrayList<AbstractSendMessage> messageList = new ArrayList<AbstractSendMessage>();
        Map userContact = null;
        try {
            userContact = DashboardManager.getInstance().getUserContact(data.getUserName());
        }
        catch (ServiceUnavailableException e) {
            LogMessagesHelper.warn(LOG, "Could not retrieve user contact details from server.", e);
            throw e;
        }
        catch (DashboardServiceException e) {
            LogMessagesHelper.warn(LOG, "Could not retrieve user contact details from server.", e);
            throw e;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isPassportFGAC = SettingsHelper.getInstance().usesPassportAuthorization();
        for (BeanUserMessageType userMessageType : messageTypeList) {
            if (!isPassportFGAC && !userMessageType.getActive()) continue;
            map.clear();
            map.put("MessageType", userMessageType.getBeanMessageType());
            map.put("MessageProvider", userMessageType.getBeanMessageProv());
            map.put("Identifier", SendMessageListHelper.getIdentifier(data.getUserName(), userContact, userMessageType));
            map.put("Entity", data.getEntityName());
            map.put("User", data.getUserName());
            map.put("Task", taskName);
            try {
                Thread thread = Thread.currentThread();
                ClassLoader classLoader = thread.getContextClassLoader();
                Class<?> provClass = classLoader.loadClass(userMessageType.getBeanMessageProv().getClassName());
                Class[] paramType = new Class[]{Map.class};
                Object[] param = new Object[]{map};
                messageList.add((AbstractSendMessage)provClass.getConstructor(paramType).newInstance(param));
            }
            catch (Exception e) {
                LogMessagesHelper.warn(LOG, e.getMessage(), e);
            }
        }
        return messageList;
    }

    private static String getIdentifier(String userName, Map<String, List<String>> userContact, BeanUserMessageType userMessageType) {
        String identifier = userMessageType.getIdentifier();
        if (userContact != null) {
            if (SendMessageListHelper.isEmailMessageProvider(userMessageType)) {
                if (userContact.containsKey("userEmails") && userContact.get("userEmails") != null && !userContact.get("userEmails").isEmpty()) {
                    identifier = userContact.get("userEmails").get(0);
                    LOG.debug((Object)("Received from server the email address for user '" + userName + "'."));
                } else {
                    LOG.warn((Object)("No email address for user '" + userName + "' found on the server. It will try to use the email defined in WebDashboard."));
                    if (identifier == null || identifier.isEmpty()) {
                        LOG.warn((Object)("No email address found for user '" + userName + "' on WebDashboard."));
                    }
                }
            } else if (SendMessageListHelper.isSmsMessageProvider(userMessageType)) {
                if (userContact.containsKey("userPhones") && userContact.get("userPhones") != null && !userContact.get("userPhones").isEmpty()) {
                    identifier = userContact.get("userPhones").get(0);
                    LOG.debug((Object)("Received from server the phone number for user '" + userName + "'."));
                } else {
                    LOG.warn((Object)("No phone number user '" + userName + "' found on the server. It will try to use the phone defined in WebDashboard."));
                    if (identifier == null || identifier.isEmpty()) {
                        LOG.warn((Object)("No phone number found for user '" + userName + "' on WebDashboard."));
                    }
                }
            } else {
                LOG.warn((Object)("Unknown type of message provider: " + userMessageType.getBeanMessageProv().getClassName()));
            }
        }
        return identifier;
    }

    private static boolean isSmsMessageProvider(BeanUserMessageType userMessageType) {
        return userMessageType != null && userMessageType.getBeanMessageProv() != null && userMessageType.getBeanMessageProv().getClassName() != null && userMessageType.getBeanMessageProv().getClassName().matches(REGEX_SMS);
    }

    private static boolean isEmailMessageProvider(BeanUserMessageType userMessageType) {
        return userMessageType != null && userMessageType.getBeanMessageProv() != null && userMessageType.getBeanMessageProv().getClassName() != null && userMessageType.getBeanMessageProv().getClassName().matches(REGEX_EMAIL);
    }
}

