/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.message;

import com.prelytis.dashboard.message.AbstractSendMessage;
import com.prelytis.dashboard.message.MessageAttachment;
import com.prelytis.dashboard.message.MessageBody;
import com.prelytis.dashboard.message.MessageSubject;
import com.prelytis.dashboard.util.CryptUtils;
import com.prelytis.dashboard.value.data.BeanMessageProvParam;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class eMail
extends AbstractSendMessage {
    private static final String SMTP_HOST = "SmtpHost";
    private static final String FROM_ADDRESS = "FromAddress";
    private static final String MOBILITY = "Mobility";
    private static final String URL = "URL";
    private static final String SMTP_AUTH_USER = "SMTPAuthUser";
    private static final String SMTP_AUTH_PASSWORD = "SMTPAuthPassword";
    private static final String JNDI_NAME = "JDNIName";
    private static final String SMTP_SSL = "SMTPSsl";
    private static final String SMTP_PORT = "SMTPPort";
    private String from;
    private String cc;
    private String url;
    private boolean isMobility;
    private String smtpHost;
    private String smtpAuthUser;
    private String smtpAuthPassword;
    private String jndiName;
    private boolean isSsl;
    private String smtpPort;

    public eMail(Map<String, Object> map) {
        super(map);
        List list = this.messageType.getBeanMessageProvParamList();
        for (int i = 0; i < list.size(); ++i) {
            BeanMessageProvParam param = (BeanMessageProvParam)list.get(i);
            String paramName = param.getName();
            String paramValue = param.getValue();
            if (SMTP_HOST.equals(paramName)) {
                this.smtpHost = paramValue;
                continue;
            }
            if (FROM_ADDRESS.equals(paramName)) {
                this.from = paramValue;
                continue;
            }
            if (MOBILITY.equals(paramName)) {
                this.isMobility = "1".equals(paramValue);
                continue;
            }
            if (URL.equals(paramName)) {
                this.url = paramValue;
                continue;
            }
            if (SMTP_AUTH_USER.equals(paramName)) {
                this.smtpAuthUser = paramValue;
                continue;
            }
            if (SMTP_AUTH_PASSWORD.equals(paramName)) {
                String decryptedPwd = "";
                if (paramValue != null && !paramValue.isEmpty()) {
                    decryptedPwd = CryptUtils.decrypt((String)paramValue);
                }
                this.smtpAuthPassword = decryptedPwd;
                continue;
            }
            if (JNDI_NAME.equals(paramName)) {
                this.jndiName = paramValue;
                continue;
            }
            if (SMTP_SSL.equals(paramName)) {
                this.isSsl = "1".equals(paramValue);
                continue;
            }
            if (!SMTP_PORT.equals(paramName)) continue;
            this.smtpPort = paramValue;
        }
    }

    private boolean getSMTPAuth() {
        return this.smtpAuthUser != null;
    }

    @Override
    public boolean sendMessage() throws Exception {
        MessageBody body;
        if (this.message == null) {
            log.debug((Object)"No mail sent : message is null");
            throw new Exception("No message to send");
        }
        if (this.identifier == null) {
            log.debug((Object)"No mail sent : identifier is null");
            return false;
        }
        Session session = this.getSession();
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(this.from));
        InternetAddress[] address = InternetAddress.parse((String)this.identifier, (boolean)false);
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        if (this.cc != null) {
            address = InternetAddress.parse((String)this.cc, (boolean)false);
            msg.setRecipients(Message.RecipientType.CC, (Address[])address);
        }
        msg.setSentDate(new Date());
        MimeMultipart part = new MimeMultipart();
        MessageSubject subject = this.message.getSubject();
        if (subject != null) {
            msg.setSubject(subject.getText(), subject.getEncoding());
        }
        if ((body = this.message.getBody()) != null) {
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setText(body.getText(), body.getEncoding());
            part.addBodyPart((BodyPart)mbp);
        }
        for (int i = 0; i < this.message.size(); ++i) {
            MessageAttachment messagePart = this.message.get(i);
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setDataHandler(new DataHandler((DataSource)messagePart));
            if (messagePart.getName() != null) {
                mbp.setFileName(messagePart.getName());
            }
            part.addBodyPart((BodyPart)mbp);
        }
        msg.setContent((Multipart)part);
        Transport transport = session.getTransport();
        try {
            transport.connect();
            msg.saveChanges();
            transport.sendMessage((Message)msg, msg.getAllRecipients());
            boolean messagePart = true;
            return messagePart;
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw e;
        }
        finally {
            try {
                if (transport != null) {
                    transport.close();
                }
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
    }

    @Override
    public String getBaseURL() {
        return this.url;
    }

    @Override
    public boolean getIsMobility() {
        return this.isMobility;
    }

    private Session getSession() throws NamingException {
        Session session = null;
        if (this.jndiName != null) {
            InitialContext initCtx = new InitialContext();
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            session = (Session)envCtx.lookup(this.jndiName);
        } else {
            boolean debug = false;
            try {
                debug = Boolean.parseBoolean(System.getProperty("mail.debug"));
            }
            catch (SecurityException envCtx) {
                // empty catch block
            }
            Properties properties = new Properties();
            List list = this.messageType.getBeanMessageProvParamList();
            for (BeanMessageProvParam param : list) {
                if (!param.getName().startsWith("mail.smtp")) continue;
                properties.put(param.getName(), param.getValue());
            }
            String hostProp = this.isSsl ? "mail.smtps.host" : "mail.smtp.host";
            String authProp = this.isSsl ? "mail.smtps.auth" : "mail.smtp.auth";
            String portProp = this.isSsl ? "mail.smtps.port" : "mail.smtp.port";
            properties.put(hostProp, this.smtpHost);
            properties.put("mail.transport.protocol", this.isSsl ? "smtps" : "smtp");
            properties.put("mail.debug", (Object)debug);
            if (this.smtpPort != null && !"".equals(this.smtpPort.trim())) {
                properties.put(portProp, this.smtpPort);
            }
            if (this.getSMTPAuth()) {
                properties.put(authProp, "true");
                session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(eMail.this.smtpAuthUser, eMail.this.smtpAuthPassword);
                    }
                });
            } else {
                session = Session.getInstance((Properties)properties);
            }
        }
        return session;
    }
}

