/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.BatchDataDao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.TaskDao;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.value.BatchFileRequest;
import com.prelytis.dashboard.value.BatchFileResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.BeanTask;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.Date;

class BatchFileResponseFactory
extends ResponseFactory {
    BatchFileResponseFactory() {
    }

    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        BatchFileResponse response = new BatchFileResponse();
        BatchFileRequest batchRequest = (BatchFileRequest)request;
        BatchDataDao batchDataDao = daoFactory.getBatchDataDao();
        BatchFileRequest.Action action = batchRequest.getAction();
        TaskDao taskDao = daoFactory.getTaskDao();
        BeanTask task = (BeanTask)taskDao.getCore(batchRequest.getTaskName());
        if (action != null) {
            switch (action) {
                case DATE_HISTO_LIST: {
                    response.setDateHistoList(batchDataDao.getDateHistoList(task.getObjectID(), data.getUserOid().intValue(), data.getExecutionContextOid().intValue()));
                    break;
                }
                case FILTER_LIST: {
                    Date dateHisto = batchRequest.getDateHisto();
                    response.setFilterNameList(batchDataDao.getFilterNameList(task.getObjectID(), data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), dateHisto));
                    break;
                }
            }
        }
        return response;
    }
}

