/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.canvas.Canvas;
import com.prelytis.dashboard.chart.IChart;
import com.prelytis.dashboard.chart.IPaintable;
import com.prelytis.dashboard.dao.ControlResultDao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.MetricResultDao;
import com.prelytis.dashboard.dao.QueryDao;
import com.prelytis.dashboard.dao.TaskDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.document.factory.AbstractImageFactory;
import com.prelytis.dashboard.document.factory.CanvasFactory;
import com.prelytis.dashboard.document.factory.ChartFactory;
import com.prelytis.dashboard.helper.ControlPanelHelper;
import com.prelytis.dashboard.helper.DashboardDocumentHelper;
import com.prelytis.dashboard.helper.DocumentHelper;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.FormDocumentHelper;
import com.prelytis.dashboard.helper.LocalizedExceptionHandler;
import com.prelytis.dashboard.helper.MetricPanelHelper;
import com.prelytis.dashboard.helper.ReportDocumentHelper;
import com.prelytis.dashboard.helper.TextDocumentHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.OutputFormat;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.ControlHelper;
import com.prelytis.dashboard.model.helper.CustomizationReportHelper;
import com.prelytis.dashboard.model.helper.DashBoardHelper;
import com.prelytis.dashboard.model.helper.FormHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.util.BeanReportHelper;
import com.prelytis.dashboard.util.DisplayTypeFactory;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.util.ThresholdHelper;
import com.prelytis.dashboard.util.sql.ExceptionHandler;
import com.prelytis.dashboard.value.DocumentRequest;
import com.prelytis.dashboard.value.DocumentResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.chart.DisplayProperties;
import com.prelytis.dashboard.value.chart.PaintableProperties;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.chart.properties.AreaChartProperties;
import com.prelytis.dashboard.value.chart.properties.ChartExtent;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanDashBoardDefinition;
import com.prelytis.dashboard.value.data.BeanDisplayType;
import com.prelytis.dashboard.value.data.BeanFormDefinition;
import com.prelytis.dashboard.value.data.BeanQueryDataStructure;
import com.prelytis.dashboard.value.data.BeanTaskControl;
import com.prelytis.dashboard.value.data.BeanTaskControlResult;
import com.prelytis.dashboard.value.data.BeanTaskDefinition;
import com.prelytis.dashboard.value.data.BeanTaskMetric;
import com.prelytis.dashboard.value.data.BeanTaskMetricResult;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.data.SecurityAdapter;
import com.prelytis.dashboard.value.data.report.AbstractCustomization;
import com.prelytis.dashboard.value.structure.AbstractDocument;
import com.prelytis.dashboard.value.structure.CanvasDocument;
import com.prelytis.dashboard.value.structure.ControlPanelDocument;
import com.prelytis.dashboard.value.structure.DashboardDocument;
import com.prelytis.dashboard.value.structure.Document;
import com.prelytis.dashboard.value.structure.FormDocument;
import com.prelytis.dashboard.value.structure.ImageDocument;
import com.prelytis.dashboard.value.structure.MetricHistoryDocument;
import com.prelytis.dashboard.value.structure.MetricPanelDocument;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.structure.TableDocument;
import com.prelytis.dashboard.value.structure.TextDocument;
import com.prelytis.dashboard.value.util.Expression;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.Severity;
import com.prelytis.dashboard.value.util.Threshold;
import com.prelytis.dashboard.value.util.ThresholdUsage;
import com.prelytis.dashboard.value.util.Thresholds;
import java.awt.Dimension;
import java.util.List;

class DocumentResponseFactory
extends ResponseFactory {
    private final ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();

    DocumentResponseFactory() {
    }

    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        DocumentRequest value = (DocumentRequest)request;
        DocumentResponse response = new DocumentResponse();
        SessionType documentType = value.getDocumentType();
        DocumentHelper documentHelper = DocumentHelper.getInstance(daoFactory);
        LocalizedExceptionHandler exceptionHandler = LocalizedExceptionHandler.getInstance(data.getLocale(), response.getNotifications(), false);
        if (value.getOutputFormat() == null) {
            value.setOutputFormat(OutputFormat.DATA);
        }
        try {
            switch (documentType) {
                case CONTROL_PANEL: {
                    ControlPanelHelper controlPanelHelper = ControlPanelHelper.getInstance(daoFactory);
                    ControlPanelDocument controlPanelDocument = controlPanelHelper.getDocument(data);
                    response.setDocument(new SecurityAdapter((I18nElement)controlPanelDocument));
                    break;
                }
                case METRIC_PANEL: {
                    MetricPanelHelper metricPanelHelper = MetricPanelHelper.getInstance(daoFactory);
                    MetricPanelDocument metricPanelDocument = metricPanelHelper.getDocument(data, true);
                    response.setDocument(new SecurityAdapter((I18nElement)metricPanelDocument));
                    break;
                }
                case CONTROL: {
                    this.fillControlDocument(daoFactory, exceptionHandler, data, value, response);
                    break;
                }
                case METRIC: {
                    Dimension size = new Dimension(value.getPreferredWidth(), value.getPreferredHeight());
                    ReportDocument metricData = (ReportDocument)value.getDocument();
                    if (metricData == null) {
                        metricData = documentHelper.getMetricDataDocument(value.getName(), data);
                    }
                    ReportDocument metricDocument = documentHelper.getMetricDocument(metricData, data, value.getOutputFormat(), size, new Double(value.getPreferredScale()), value.getPreferredDpi());
                    response.setDocument(new SecurityAdapter((I18nElement)metricDocument));
                    break;
                }
                case DASHBOARD: {
                    response.setDocument(new SecurityAdapter((I18nElement)this.getDashboard(daoFactory, exceptionHandler, data, value)));
                    break;
                }
                case STRATEGY_MAP: {
                    response.setDocument(new SecurityAdapter((I18nElement)this.getStrategyMap(daoFactory, data, value)));
                    break;
                }
                case EXTERN: {
                    response.setDocument(new SecurityAdapter((I18nElement)documentHelper.getExternalDocument(value.getName(), value.getFilterList(), data)));
                    break;
                }
                case METRIC_HISTORY: {
                    return this.getMetricHistoryDocument(daoFactory, data, value);
                }
                case TEXT_SESSION: {
                    response.setDocument(this.getTextDocument(daoFactory, value, data));
                    break;
                }
                case DOCUMENT: {
                    this.fillReportDocument(daoFactory, exceptionHandler, value, response, data, false);
                    break;
                }
                case FORM: {
                    this.fillFormDocument(daoFactory, exceptionHandler, value, response, data);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Document type not supported");
                }
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        return response;
    }

    private void fillFormDocument(DaoFactory daoFactory, ExceptionHandler exceptionHandler, DocumentRequest value, DocumentResponse response, ExpressionEvaluationData data) throws DashboardException {
        FormHelper formHelper = FormHelper.getInstance(daoFactory);
        BeanFormDefinition form = formHelper.getDefinition(value.getName());
        QueryDao queryDao = daoFactory.getQueryDao();
        Bean query = queryDao.getDefinition(form.getQueryOID());
        if (query instanceof BeanQueryDataStructure) {
            try {
                BeanQueryDataStructure ds = (BeanQueryDataStructure)query;
                FormDocumentHelper fdh = FormDocumentHelper.getInstance(daoFactory, form, ds, data, value.getFilterList());
                if (value.getDocument() instanceof FormDocument) {
                    FormDocument doc = (FormDocument)value.getDocument();
                    fdh.processFormDocument(doc);
                }
                FormDocument fd = fdh.getFormDocument();
                SecurityAdapter sa = new SecurityAdapter((I18nElement)fd);
                sa.setUpdate(fd.isUpdatable());
                sa.setDelete(fd.isDeletable());
                response.setDocument(sa);
            }
            catch (Exception e) {
                exceptionHandler.handleException(e);
            }
        } else {
            exceptionHandler.info("Not a data structure");
        }
    }

    private SecurityAdapter getTextDocument(DaoFactory daoFactory, DocumentRequest value, ExpressionEvaluationData data) throws DashboardException {
        TextDocumentHelper tdh = TextDocumentHelper.getInstance(daoFactory.getTextDao());
        TextDocument tsd = value.getText() != null ? tdh.getDocument(value.getText(), data) : tdh.getDocument(value.getName(), data);
        return new SecurityAdapter((I18nElement)tsd);
    }

    private void fillReportDocument(DaoFactory daoFactory, ExceptionHandler exceptionHandler, DocumentRequest value, DocumentResponse response, ExpressionEvaluationData data, boolean ignoreCusto) throws DashboardException {
        try {
            AbstractBeanReport report;
            int accessLevel = 0;
            boolean editAccess = false;
            boolean customizable = false;
            OutputFormat outputFormat = OutputFormat.DATA;
            if (value.getOutputFormat() != null) {
                outputFormat = value.getOutputFormat();
            }
            List filterList = value.getFilterList();
            ReportDocumentHelper rdh = null;
            boolean customized = false;
            if (value.isPreview()) {
                report = value.getReport();
            } else {
                Document doc;
                WorkspaceDao workspaceDao = daoFactory.getWorkspaceDao();
                ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
                report = reportHelper.getDefinition(value.getName());
                if (value.getDocument() != null && !(doc = value.getDocument()).getName().equals(value.getName())) {
                    throw new DashboardException();
                }
                accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionType.DOCUMENT, report.getName()).getAccessLevel();
                boolean bl = editAccess = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.REPORT).getAccessLevel() == 2;
                if (accessLevel == 2 && !ignoreCusto && data.getProfile() != 0) {
                    customizable = true;
                    try {
                        CustomizationReportHelper customizationReportHelper = CustomizationReportHelper.getInstance(daoFactory);
                        AbstractCustomization custo = customizationReportHelper.getCustomizedReport(report, data);
                        if (custo != null) {
                            customized = true;
                            AbstractBeanReport cr = this.getReport(report, custo, data);
                            rdh = this.getReportDocumentHelper(daoFactory, exceptionHandler, value, cr, true, filterList, outputFormat == OutputFormat.DATA && filterList == null && cr.isShowFilterFirst(), data);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)("Ignoring customization for " + report.getName() + "/" + data.getUserName()));
                    }
                }
            }
            if (rdh == null) {
                rdh = this.getReportDocumentHelper(daoFactory, exceptionHandler, value, report, false, filterList, outputFormat == OutputFormat.DATA && filterList == null && report.isShowFilterFirst(), data);
            }
            ReportDocument document = null;
            switch (outputFormat) {
                case DATA: {
                    document = rdh.getReportDocument();
                    break;
                }
                case GIF: 
                case JPEG: 
                case PNG: 
                case SVG: {
                    document = rdh.getImageDocument(outputFormat);
                    break;
                }
                case JSON: {
                    document = rdh.getCanvasDocument();
                    if (document != null) break;
                    document = rdh.getImageDocument(OutputFormat.PNG);
                    break;
                }
                case PDF: {
                    response.setDocument(new SecurityAdapter((I18nElement)rdh.getPdfDocument()));
                    return;
                }
                case XLS: {
                    response.setDocument(new SecurityAdapter((I18nElement)rdh.getXlsDocument()));
                    return;
                }
                default: {
                    throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("notImplemented", null, null);
                }
            }
            document.setEditAccess(editAccess);
            document.setCustomizable(customizable);
            document.setCustomized(customized);
            SecurityAdapter sa = new SecurityAdapter((I18nElement)document);
            sa.setUpdate(accessLevel == 2);
            response.setDocument(sa);
        }
        catch (Exception e) {
            exceptionHandler.handleException(e);
        }
    }

    private ReportDocumentHelper getReportDocumentHelper(DaoFactory daoFactory, ExceptionHandler exceptionHandler, DocumentRequest value, AbstractBeanReport report, boolean customized, List<? extends ReportFilter> filterList, boolean doNotExecuteReport, ExpressionEvaluationData data) throws DashboardException {
        try {
            ReportDocumentHelper.Builder rdhb = new ReportDocumentHelper.Builder(daoFactory, exceptionHandler, report, data, customized);
            Dimension dim = new Dimension(value.getPreferredWidth(), value.getPreferredHeight());
            rdhb.imagePreferences(dim, value.getPreferredScale(), value.getPreferredDpi());
            rdhb.preview(value.isPreview());
            rdhb.thresholdUsage(value.getThresholdUsage());
            rdhb.batchFilter(value.getBatchHisto(), value.getBatchFilter());
            rdhb.filterList(filterList);
            rdhb.withoutAvailableFilterValues(value.isWithoutFilterAvailableValues());
            rdhb.doNotExecuteReport(doNotExecuteReport);
            ReportDocumentHelper rdh = value.getDocument() instanceof ReportDocument ? rdhb.build((ReportDocument)value.getDocument()) : rdhb.build();
            return rdh;
        }
        catch (Exception e) {
            throw exceptionHandler.logException(e);
        }
    }

    private AbstractBeanReport getReport(AbstractBeanReport report, AbstractCustomization customization, ExpressionEvaluationData data) {
        if (customization != null) {
            BeanReportHelper helper = BeanReportHelper.getInstance();
            return helper.getCustomizedReport(report, customization);
        }
        return report;
    }

    private void fillControlDocument(DaoFactory daoFactory, ExceptionHandler exceptionHandler, ExpressionEvaluationData data, DocumentRequest value, DocumentResponse response) throws DashboardException {
        String controlName = value.getName();
        ControlHelper controlHelper = ControlHelper.getInstance(daoFactory);
        BeanTaskControl taskDef = controlHelper.getDefinition(controlName);
        if (!(taskDef instanceof BeanTaskControl)) {
            throw new DashboardException();
        }
        BeanTaskControl taskCtrl = taskDef;
        Thresholds thresholds = null;
        ControlResultDao controlResultDao = daoFactory.getControlResultDao();
        try {
            BeanTaskControlResult task = controlResultDao.open(taskCtrl, data.getUserOid().intValue(), data.getExecutionContextOid().intValue());
            thresholds = ThresholdHelper.copy((Thresholds)task.getCalcThresholds());
        }
        catch (Exception task) {
            // empty catch block
        }
        if (thresholds == null) {
            thresholds = ThresholdHelper.copy((Thresholds)taskCtrl.getThresholds());
        }
        this.cleanThresholds(thresholds, data);
        DocumentRequest request = new DocumentRequest();
        request.setName(taskCtrl.getCalculationReportName());
        ThresholdUsage thresholdUsage = new ThresholdUsage();
        thresholdUsage.setRemoveInfo(taskCtrl.getRemoveInfoLines());
        thresholdUsage.setFieldName(taskCtrl.getQueryFieldName());
        thresholdUsage.setAgregation(taskCtrl.getAgregation());
        thresholdUsage.setThresholds(thresholds);
        request.setThresholdUsage(thresholdUsage);
        request.setDocumentType(SessionType.DOCUMENT);
        request.setOutputFormat(value.getOutputFormat());
        request.setPreferredWidth(value.getPreferredWidth());
        request.setPreferredHeight(value.getPreferredHeight());
        request.setExecutionContext(value.getExecutionContext());
        this.fillReportDocument(daoFactory, exceptionHandler, request, response, data, true);
        SecurityAdapter sa = response.getDocument();
        AbstractDocument d = (AbstractDocument)sa.getElement();
        d.setObjectID(taskCtrl.getObjectID());
        d.setName(taskCtrl.getName());
        d.getDescriptionMap().putAll(taskCtrl.getDescriptionMap());
        d.setDescription((String)d.getDescriptionMap().get(data.getLocale()));
        if (d instanceof ReportDocument) {
            ReportDocument rd = (ReportDocument)d;
            rd.setCustomizable(false);
            rd.setSessionType(SessionType.CONTROL);
        }
    }

    private TableDocument getMetricHistoryTable(DaoFactory daoFactory, DocumentRequest value, ExpressionEvaluationData data, BeanTaskDefinition taskDef, OutputFormat outputFormat) throws DashboardException {
        if (outputFormat != OutputFormat.DATA && value.getDocument() instanceof TableDocument) {
            return (TableDocument)value.getDocument();
        }
        BeanTaskMetric taskMetric = (BeanTaskMetric)taskDef;
        Thresholds thresholds = null;
        Object targetValue = null;
        MetricResultDao metricResultDao = daoFactory.getMetricResultDao();
        try {
            BeanTaskMetricResult task = metricResultDao.open(taskMetric, data.getEntityOid().intValue());
            thresholds = ThresholdHelper.copy((Thresholds)task.getCalcThresholds());
            targetValue = task.getCalcTargetValue();
        }
        catch (Exception e) {
            thresholds = ThresholdHelper.copy((Thresholds)taskMetric.getThresholds());
            targetValue = taskMetric.getTargetValue();
        }
        Table table = metricResultDao.getTable(data, taskMetric, 29999);
        if (targetValue != null) {
            if (targetValue instanceof Expression) {
                targetValue = this.helper.evaluateExpression((Expression)targetValue, data);
            }
            Threshold threshold = ThresholdHelper.insertNewThreshold((Thresholds)thresholds, (Object)targetValue);
            threshold.setDescriptionKey("target");
            threshold.setSeverity(new Severity(-1, "target", "7D9DEC"));
        }
        this.cleanThresholds(thresholds, data);
        table.setThresholds(thresholds);
        TableDocument td = new TableDocument();
        td.setObjectID(taskDef.getObjectID());
        td.setName(taskDef.getName());
        td.setDescription((String)taskDef.getDescriptionMap().get(data.getLocale()));
        td.getDescriptionMap().putAll(taskDef.getDescriptionMap());
        td.setTable(table);
        return td;
    }

    private DocumentResponse getMetricHistoryDocument(DaoFactory daoFactory, ExpressionEvaluationData data, DocumentRequest value) throws DashboardException {
        try {
            OutputFormat outputFormat = OutputFormat.DATA;
            if (value.getOutputFormat() != null) {
                outputFormat = value.getOutputFormat();
            }
            String metricName = value.getName();
            TaskDao taskDao = daoFactory.getTaskDao();
            Bean taskDef = taskDao.getDefinition(metricName);
            if (!(taskDef instanceof BeanTaskMetric)) {
                throw new DashboardException();
            }
            TableDocument td = this.getMetricHistoryTable(daoFactory, value, data, (BeanTaskDefinition)((BeanTaskMetric)taskDef), outputFormat);
            DisplayTypeFactory factory = new DisplayTypeFactory();
            AreaChartProperties chartProperties = (AreaChartProperties)factory.getProperties(BeanDisplayType.AREA_CHART_TA);
            chartProperties.setExtentCalculation(ChartExtent.ENLARGED);
            chartProperties.setLegend(Integer.valueOf(0));
            chartProperties.setInteractive(Boolean.FALSE);
            ReportDocumentHelper.updateDisplayType(daoFactory, (DisplayProperties)chartProperties);
            MetricHistoryDocument mhd = new MetricHistoryDocument();
            mhd.setName(taskDef.getName());
            mhd.setDescription((String)taskDef.getDescriptionMap().get(data.getLocale()));
            mhd.getDescriptionMap().putAll(taskDef.getDescriptionMap());
            mhd.setTable(td);
            mhd.setDisplayProperties((DisplayProperties)chartProperties);
            SecurityAdapter sa = null;
            switch (outputFormat) {
                case DATA: {
                    sa = new SecurityAdapter((I18nElement)mhd);
                    break;
                }
                case JSON: {
                    CanvasFactory cf = CanvasFactory.getInstance(daoFactory);
                    Canvas canvas = cf.createCanvas((DisplayProperties)chartProperties, null);
                    CanvasDocument cd = canvas.getDocument(td);
                    cd.setObjectID(taskDef.getObjectID());
                    cd.setName(taskDef.getName());
                    cd.setDescription((String)taskDef.getDescriptionMap().get(data.getLocale()));
                    cd.getDescriptionMap().putAll(taskDef.getDescriptionMap());
                    sa = new SecurityAdapter((I18nElement)cd);
                    break;
                }
                case GIF: 
                case JPEG: 
                case PNG: 
                case SVG: 
                case PDF: {
                    Dimension size = new Dimension(value.getPreferredWidth(), value.getPreferredHeight());
                    if (size.width == 0 || size.height == 0) {
                        size = new Dimension(800, 600);
                    }
                    IChart chart = ChartFactory.getInstance(daoFactory).getChart(BeanDisplayType.AREA_CHART_TA, (PaintableProperties)chartProperties, td.getTable(), null);
                    AbstractImageFactory f = AbstractImageFactory.getInstance(value.getOutputFormat());
                    ImageDocument document = f.getImageDocument((I18nElement)taskDef, (IPaintable)chart, size, value.getPreferredScale(), value.getPreferredDpi(), false);
                    sa = new SecurityAdapter((I18nElement)document);
                }
            }
            if (sa != null) {
                DocumentResponse response = new DocumentResponse();
                response.setDocument(sa);
                return response;
            }
            return null;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private AbstractDocument getStrategyMap(DaoFactory daoFactory, ExpressionEvaluationData data, DocumentRequest value) throws DashboardException {
        try {
            OutputFormat format = value.getOutputFormat();
            if (format == null) {
                format = OutputFormat.PNG;
            }
            MetricPanelHelper metricPanelHelper = MetricPanelHelper.getInstance(daoFactory);
            MetricPanelDocument metricPanelDocument = metricPanelHelper.getDocument(data, false);
            switch (format) {
                case DATA: {
                    return metricPanelDocument;
                }
            }
            Dimension size = null;
            if (value.getPreferredWidth() > 0 && value.getPreferredHeight() > 0) {
                size = new Dimension(value.getPreferredWidth(), value.getPreferredHeight());
            }
            return metricPanelHelper.getStrategyMap(metricPanelDocument, data, format, size, value.getPreferredScale(), value.getPreferredDpi());
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private AbstractDocument getDashboard(DaoFactory daoFactory, ExceptionHandler exceptionHandler, ExpressionEvaluationData data, DocumentRequest value) throws DashboardException {
        if (value.getOutputFormat() == null || value.getOutputFormat() == OutputFormat.DATA) {
            return this.getDataDashboard(daoFactory, exceptionHandler, data, value);
        }
        return this.getImageDashboard(daoFactory, exceptionHandler, data, value);
    }

    private AbstractDocument getImageDashboard(DaoFactory daoFactory, ExceptionHandler exceptionHandler, ExpressionEvaluationData data, DocumentRequest value) throws DashboardException {
        DashboardDocumentHelper helper = this.getDashboardDocumentHelper(daoFactory, exceptionHandler, data, value);
        helper.initHolder();
        return helper.getPdfDashboard(data.getBaseDir(), value.getCommentMap());
    }

    private AbstractDocument getDataDashboard(DaoFactory daoFactory, ExceptionHandler exceptionHandler, ExpressionEvaluationData data, DocumentRequest value) throws DashboardException {
        return this.getDashboardDocumentHelper(daoFactory, exceptionHandler, data, value).getDashboardData();
    }

    private DashboardDocumentHelper getDashboardDocumentHelper(DaoFactory daoFactory, ExceptionHandler exceptionHandler, ExpressionEvaluationData data, DocumentRequest value) throws DashboardException {
        try {
            String dashboardName = value.getName();
            if (dashboardName == null) {
                return null;
            }
            DashBoardHelper helper = DashBoardHelper.getInstance(daoFactory);
            BeanDashBoardDefinition def = helper.getDefinition(dashboardName);
            DashboardDocumentHelper ddh = DashboardDocumentHelper.getInstance(daoFactory, exceptionHandler);
            ddh.setDashboard(def);
            if (value.getDocument() instanceof DashboardDocument) {
                ddh.setDocument((DashboardDocument)value.getDocument());
            }
            ddh.setFilterList(value.getFilterList());
            ddh.setDateHisto(value.getBatchHisto());
            ddh.setFilterName(value.getBatchFilter());
            ddh.setData(data);
            ddh.init();
            return ddh;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private void cleanThresholds(Thresholds thresholds, ExpressionEvaluationData data) throws DashboardException {
        if (thresholds != null) {
            for (int i = 0; i < thresholds.size(); ++i) {
                Threshold th = thresholds.getThreshold(i);
                Object thValue = th.getValue();
                if (thValue instanceof Expression) {
                    thValue = this.helper.evaluateExpression((Expression)thValue, data);
                }
                th.setValue((Object)new Double(Double.parseDouble(thValue.toString())));
            }
        }
    }
}

