/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.axway.sentinel.dashboard.audit.AuditActionType;
import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.FolderDao;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbDefaultVersionFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.LicenseViolationException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.Versionable;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.value.ImportParamRequest;
import com.prelytis.dashboard.value.ImportParamResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanFile;
import com.prelytis.dashboard.value.data.ImportBean;
import com.prelytis.dashboard.value.data.ImportKey;
import com.prelytis.dashboard.value.data.ImportXmlResult;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.xml.stax.XmlHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

class ImportParamResponseFactory
extends ResponseFactory {
    private static final String ORDER = "export.xml";
    private static final String DATA = "data.xml";

    ImportParamResponseFactory() {
    }

    @Override
    public Response create(Request value, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        ImportParamRequest request = (ImportParamRequest)value;
        ImportParamRequest.Action action = request.getAction();
        switch (action) {
            case ANALYZE: {
                return this.getImportOpenZip(daoFactory, request, data);
            }
            case EXECUTION: {
                return this.getPlayImport(daoFactory, request, data);
            }
            case SIMULATION: {
                return this.getSimulateImport(daoFactory, request, data);
            }
        }
        return null;
    }

    private InputStream getInputStream(DaoFactory daoFactory, ImportParamRequest request, ExpressionEvaluationData data, String unzipFileName) throws DashboardException, IOException {
        if (request.getData() != null) {
            return this.getData(request.getData(), unzipFileName);
        }
        if (request.getFileName() != null) {
            String fullFileName = request.getFileName();
            int pos = fullFileName.indexOf("/");
            if (pos == -1) {
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("fileNotFound", null, null);
            }
            String folderName = fullFileName.substring(0, pos);
            String fileName = fullFileName.substring(pos);
            String fileDirectory = this.getFolderDirectory(daoFactory, folderName, data);
            return this.getData(fileName, fileDirectory, unzipFileName);
        }
        throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("fileNotFound", null, null);
    }

    private Response getImportOpenZip(DaoFactory daoFactory, ImportParamRequest request, ExpressionEvaluationData data) {
        ImportParamResponse response = new ImportParamResponse();
        try {
            response.setImportList(this.getImportList(daoFactory, request, data));
            response.setMessage(null);
        }
        catch (DashboardException e) {
            response.setMessage(e.getMessage());
        }
        catch (Exception e) {
            response.setMessage(e.getMessage());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportBean> getImportList(DaoFactory daoFactory, ImportParamRequest request, ExpressionEvaluationData data) throws DashboardException {
        List list;
        InputStream is = this.getInputStream(daoFactory, request, data, ORDER);
        try {
            HashMap descriptions = new HashMap();
            SessionDao sessionDao = daoFactory.getSessionDao();
            List list2 = XmlHelper.getInstance().readCommand(is);
            for (ImportBean bean : list2) {
                Bean s;
                Dao dao = daoFactory.getDao(bean.getSessionParameterType());
                if (dao == null) continue;
                String description = (String)descriptions.get(bean.getSessionParameterType());
                if (description == null && (description = (String)(s = sessionDao.getCore(bean.getSessionParameterType().getId())).getDescriptionMap().get(data.getLocale())) == null) {
                    description = s.getName();
                }
                bean.setSessionDescription(description);
                DbDefaultVersionFilter filter = new DbDefaultVersionFilter();
                filter.setName(bean.getName());
                List l = dao.listAll((DbDefaultFilter)filter, 1);
                if (l.size() == 1) {
                    if (bean.getDefaultAction() == ImportBean.Action.DELETE) {
                        bean.setAction(bean.getDefaultAction());
                        continue;
                    }
                    Element e = (Element)l.get(0);
                    if (e instanceof Bean) {
                        Bean b = (Bean)e;
                        bean.setDescription((String)b.getDescriptionMap().get(data.getLocale()));
                    }
                    if (e instanceof Versionable) {
                        Versionable v = (Versionable)e;
                        bean.setVersionBd(v.getVersion());
                        if (this.changeVersion(bean.getVersionXml(), bean.getVersionBd())) {
                            bean.setAction(bean.getDefaultAction());
                            continue;
                        }
                        bean.setAction(ImportBean.Action.NONE);
                        continue;
                    }
                    bean.setAction(ImportBean.Action.NONE);
                    continue;
                }
                if (bean.getDefaultAction() == ImportBean.Action.DELETE) {
                    bean.setAction(ImportBean.Action.NONE);
                    continue;
                }
                bean.setAction(bean.getDefaultAction());
            }
            list = list2;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Exception e) {
                throw this.getException(e);
            }
        }
        is.close();
        return list;
    }

    private InputStream getData(String tarFileName, String path, String unzipFileName) throws IOException {
        ZipInputStream source = new ZipInputStream(new FileInputStream(new File(path, tarFileName)));
        ZipEntry entry = source.getNextEntry();
        while (entry != null && !entry.getName().equals(unzipFileName)) {
            entry = source.getNextEntry();
        }
        if (entry != null) {
            return source;
        }
        source.close();
        return null;
    }

    private InputStream getData(byte[] data, String unzipFileName) throws IOException {
        ZipInputStream source = new ZipInputStream(new ByteArrayInputStream(data));
        ZipEntry entry = source.getNextEntry();
        while (entry != null && !entry.getName().equals(unzipFileName)) {
            entry = source.getNextEntry();
        }
        if (entry != null) {
            return source;
        }
        source.close();
        return null;
    }

    private boolean changeVersion(String versionXml, String versionBd) {
        boolean changeVersion = true;
        int separator1 = 2;
        int separator2 = 5;
        if (versionXml == null || versionXml.isEmpty()) {
            return versionBd != null && !versionBd.isEmpty();
        }
        if (versionBd != null && !versionBd.isEmpty()) {
            int bdPart1;
            int xmlPart1 = Integer.parseInt(versionXml.substring(0, separator1));
            if (xmlPart1 == (bdPart1 = Integer.parseInt(versionBd.substring(0, separator1)))) {
                int bdPart2;
                int xmlPart2 = Integer.parseInt(versionXml.substring(separator1 + 1, separator2));
                if (xmlPart2 == (bdPart2 = Integer.parseInt(versionBd.substring(separator1 + 1, separator2)))) {
                    int bdPart3;
                    int xmlPart3 = Integer.parseInt(versionXml.substring(separator2 + 1));
                    if (xmlPart3 <= (bdPart3 = Integer.parseInt(versionBd.substring(separator2 + 1)))) {
                        changeVersion = false;
                    }
                } else if (xmlPart2 < bdPart2) {
                    changeVersion = false;
                }
            } else if (xmlPart1 < bdPart1) {
                changeVersion = false;
            }
        }
        return changeVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getSimulateImport(DaoFactory daoFactory, ImportParamRequest request, ExpressionEvaluationData data) throws DashboardException {
        try {
            try (InputStream is = this.getInputStream(daoFactory, request, data, DATA);){
                XmlHelper helper = XmlHelper.getInstance();
                helper.read(is);
            }
            ImportParamResponse response = new ImportParamResponse();
            List beanList = request.getBeanList();
            ArrayList<ImportXmlResult> resultList = new ArrayList<ImportXmlResult>();
            for (ImportBean importBean : beanList) {
                Bean bdBean;
                ImportXmlResult result = new ImportXmlResult();
                result.setBeanName(importBean.getName());
                result.setSessionParameterType(importBean.getSessionParameterType());
                if (importBean.getAction() == ImportBean.Action.ADD) {
                    result.setAction(1);
                    try {
                        bdBean = this.getBeanBySessionOidAndName(daoFactory, importBean.getSessionParameterType(), importBean.getName());
                        if (bdBean == null) {
                            result.setAction(2);
                        }
                        result.setImportOk(true);
                        result.setImportError(false);
                    }
                    catch (Exception e) {
                        result.setImportOk(false);
                        result.setImportError(true);
                        result.setMessage(this.getLocalizedException(data.getLocale(), e));
                    }
                    resultList.add(result);
                    continue;
                }
                if (importBean.getAction() != ImportBean.Action.DELETE) continue;
                result.setAction(3);
                try {
                    bdBean = this.getBeanBySessionOidAndName(daoFactory, importBean.getSessionParameterType(), importBean.getName());
                    if (bdBean != null) {
                        result.setImportOk(true);
                        result.setImportError(false);
                    } else {
                        result.setImportOk(false);
                        result.setImportError(true);
                        result.setMessage("doesn't exist in database.");
                    }
                }
                catch (Exception e) {
                    result.setImportOk(false);
                    result.setImportError(true);
                    result.setMessage(e.toString());
                }
                resultList.add(result);
            }
            response.setResultList(resultList);
            return response;
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getPlayImport(DaoFactory daoFactory, ImportParamRequest request, ExpressionEvaluationData data) throws DashboardException {
        ImportParamResponse response = new ImportParamResponse();
        try {
            Map map;
            response.setShouldReload(false);
            try (InputStream is = this.getInputStream(daoFactory, request, data, DATA);){
                XmlHelper helper = XmlHelper.getInstance();
                map = helper.read(is);
            }
            ArrayList<ImportXmlResult> resultList = new ArrayList<ImportXmlResult>();
            List<ImportBean> beanList = request.getBeanList();
            if (beanList == null) {
                beanList = this.getImportList(daoFactory, request, data);
            }
            boolean importOk = true;
            for (ImportBean importBean : beanList) {
                ImportXmlResult result = new ImportXmlResult();
                result.setBeanName(importBean.getName());
                result.setSessionParameterType(importBean.getSessionParameterType());
                boolean explicitlySkipImport = false;
                if (importBean.getAction() == ImportBean.Action.ADD && importBean.getSessionParameterType() != SessionParameterType.SESSION) {
                    try {
                        boolean isNew;
                        ImportKey key;
                        Bean xmlBean;
                        if (!(response.isShouldReload() || importBean.getSessionParameterType() != SessionParameterType.STYLE && importBean.getSessionParameterType() != SessionParameterType.THEME)) {
                            response.setShouldReload(true);
                        }
                        if ((xmlBean = (Bean)map.get(key = new ImportKey(importBean.getSessionParameterType(), importBean.getName()))) == null) {
                            throw new DashboardException();
                        }
                        Bean bdBean = this.getBeanBySessionOidAndName(daoFactory, importBean.getSessionParameterType(), importBean.getName());
                        if (bdBean != null) {
                            xmlBean.setObjectID(bdBean.getObjectID());
                            result.setAction(1);
                            isNew = false;
                        } else {
                            xmlBean.setObjectID(0);
                            result.setAction(2);
                            isNew = true;
                        }
                        ParameterHelper.save(daoFactory, xmlBean, data, isNew, true);
                        result.setImportOk(true);
                        result.setImportError(false);
                    }
                    catch (DashboardException e) {
                        if (e.getCode() == ErrorCode.SAVE_ACTION_SKIPPED) {
                            explicitlySkipImport = true;
                        } else {
                            result.setMessage(this.getLocalizedException(data.getLocale(), (Exception)((Object)e)));
                            importOk = false;
                        }
                        result.setImportOk(false);
                        result.setImportError(true);
                    }
                    catch (Exception e) {
                        result.setImportOk(false);
                        result.setImportError(true);
                        result.setMessage(this.getLocalizedException(data.getLocale(), e));
                        importOk = false;
                    }
                    if (!explicitlySkipImport) {
                        resultList.add(result);
                    }
                } else if (importBean.getAction() == ImportBean.Action.DELETE) {
                    try {
                        Bean bdBean = this.getBeanBySessionOidAndName(daoFactory, importBean.getSessionParameterType(), importBean.getName());
                        result.setBeanName(importBean.getName());
                        if (bdBean != null) {
                            result.setAction(3);
                            Dao dao = daoFactory.getDao(importBean.getSessionParameterType());
                            dao.delete((Element)bdBean);
                            result.setImportOk(true);
                            result.setImportError(false);
                        } else {
                            result.setAction(3);
                            result.setImportOk(false);
                            result.setImportError(true);
                            importOk = false;
                            result.setMessage("Doesn't exist in database.");
                        }
                    }
                    catch (DashboardException e) {
                        result.setBeanName(importBean.getName());
                        result.setAction(3);
                        result.setImportOk(false);
                        result.setImportError(true);
                        result.setMessage(this.getLocalizedException(data.getLocale(), (Exception)((Object)e)));
                        importOk = false;
                    }
                    catch (Exception e) {
                        result.setBeanName(importBean.getName());
                        result.setAction(3);
                        result.setImportOk(false);
                        result.setImportError(true);
                        result.setMessage(this.getLocalizedException(data.getLocale(), e));
                        importOk = false;
                    }
                    resultList.add(result);
                }
                this.audit(result, request.getUserLoginName(), request.getAuditSessionId());
            }
            response.setResultList(resultList);
            response.setImportOk(importOk);
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
        return response;
    }

    private void audit(ImportXmlResult result, String userName, String auditSessionId) {
        int actionType = result.getAction();
        int objectType = result.getSessionParameterType().getId();
        String objectName = result.getBeanName();
        boolean success = result.isImportOk();
        String moreInfo = "(Import)";
        if (actionType == 2) {
            actionType = AuditActionType.ADD.getId();
        }
        this.audit(userName, auditSessionId, actionType, objectType, objectName, success, "(Import)");
    }

    private Bean getBeanBySessionOidAndName(DaoFactory daoFactory, SessionParameterType sessionParameterType, String name) throws DashboardException {
        Dao dao = daoFactory.getDao(sessionParameterType);
        try {
            return dao.getCore(name);
        }
        catch (DashboardRuntimeException dbe) {
            if (dbe.getCode() == ErrorCode.NOT_FOUND_ERROR) {
                return null;
            }
            throw dbe;
        }
    }

    private String getFolderDirectory(DaoFactory daoFactory, String fileDirectory, ExpressionEvaluationData data) throws DashboardException {
        if (data == null) {
            return null;
        }
        FolderDao folderDao = daoFactory.getFolderDao();
        BeanFile beanFile = (BeanFile)folderDao.getCore(fileDirectory);
        FileHelper fileHelper = FileHelper.getInstance(beanFile);
        File file = fileHelper.getFile(data);
        return file.getPath();
    }

    private String getLocalizedException(Locale locale, Exception e) {
        try {
            if (locale == null) {
                Configuration configuration = Configuration.getInstance();
                locale = configuration.getDefaultLocale();
            }
            if (e instanceof SecurityException) {
                return this.getLocalizedException(locale, new DashboardException((Throwable)e), "com.prelytis.dashboard.resources.Messages", "security", null);
            }
            if (e instanceof LicenseViolationException) {
                return this.getLocalizedException(locale, (DashboardException)((Object)e), "com.prelytis.dashboard.resources.Messages", "licenseViolation", null);
            }
            if (e instanceof DashboardException && e.getMessage() != null) {
                return e.getMessage();
            }
            return e.toString();
        }
        catch (Exception exception) {
            return "?";
        }
    }

    private String getLocalizedException(Locale locale, DashboardException e, String bundleName, String msgKey, Object[] parameters) {
        ResourceBundle bundle = null;
        bundle = locale == null ? ResourceBundle.getBundle(bundleName) : ResourceBundle.getBundle(bundleName, locale);
        String message = bundle.getString(msgKey);
        if (parameters != null) {
            MessageFormat mf = new MessageFormat(message);
            return mf.format(parameters);
        }
        return message;
    }

    private DashboardException getDashboardException(Exception e) {
        SAXException se;
        TransformerException te;
        Throwable t;
        if (e instanceof TransformerException && (t = (te = (TransformerException)e).getException()) != null && t != te && t instanceof Exception) {
            return this.getDashboardException((Exception)t);
        }
        if (e instanceof SAXException && (t = (se = (SAXException)e).getException()) != null && t != se) {
            return this.getDashboardException((Exception)t);
        }
        if (e instanceof DashboardException) {
            return (DashboardException)((Object)e);
        }
        return new DashboardException((Throwable)e);
    }
}

