/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.FolderDao;
import com.prelytis.dashboard.dao.JdbcDriverDao;
import com.prelytis.dashboard.dao.WorldDao;
import com.prelytis.dashboard.data.transformation.ExcelDataReader;
import com.prelytis.dashboard.db.operator.WorldHelper;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.helper.MessageListListener;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.persistence.DataSourceConfiguration;
import com.prelytis.dashboard.task.PrelytisErrorListener;
import com.prelytis.dashboard.task.QueryReader;
import com.prelytis.dashboard.task.RenameFilter;
import com.prelytis.dashboard.task.TableHandler;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.util.sql.SQLTableHelper;
import com.prelytis.dashboard.util.xml.PrelytisErrorHandler;
import com.prelytis.dashboard.util.xml.PrelytisResolver;
import com.prelytis.dashboard.value.ImportRequest;
import com.prelytis.dashboard.value.ImportResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.BeanFile;
import com.prelytis.dashboard.value.data.BeanImportColumn;
import com.prelytis.dashboard.value.data.BeanImportDefinition;
import com.prelytis.dashboard.value.data.BeanImportWorksheet;
import com.prelytis.dashboard.value.data.BeanJDBCDriverDefinition;
import com.prelytis.dashboard.value.data.BeanQueryDataStructure;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQueryDefinition;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.DriverCharacteristics;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.FieldMetaData;
import com.prelytis.dashboard.value.util.IPoolDBInfo;
import com.prelytis.jdbc.msexcel.ExcelSheet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class ImportResponseFactory
extends ResponseFactory {
    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        ImportRequest value = (ImportRequest)request;
        switch (value.getAction()) {
            case ANALYZE_SERVER_FILE: {
                return this.getAnalyzedServerFile(daoFactory, value, data);
            }
            case ANALYZE_UPLOADED_FILE: {
                return this.getAnalyzedFile(daoFactory, value.getFileName(), value.getData(), value.getDefinition(), data);
            }
            case EXECUTE: {
                return this.getExecute(daoFactory, data, value);
            }
        }
        return null;
    }

    private ImportResponse getAnalyzedFile(DaoFactory daoFactory, String fileName, byte[] b, BeanImportDefinition definition, ExpressionEvaluationData data) throws DashboardException {
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(b);
            Workbook workbook = this.getWorkbook(bais, data.getLocale());
            List<BeanImportWorksheet> sheetList = this.getSheetList(workbook, this.getSheetMap(definition));
            if (definition.getTable() == null) {
                definition.setBatchType(Integer.valueOf(1));
                definition.setCommitType(Integer.valueOf(1));
                definition.setInsertType(Integer.valueOf(5));
                definition.setImportType(BeanImportDefinition.ImportType.CARBON_COPY);
                definition.setCreateTable(true);
                definition.setTable(this.getGUID());
                definition.setCreateDataDictionary(true);
            }
            definition.setOwnerEntOID(data.getEntityOid().intValue());
            definition.setOwnerEntityName(data.getEntityName());
            if (fileName != null && fileName.length() > 30) {
                fileName = fileName.substring(0, 30);
            }
            definition.setFileName(fileName);
            definition.setWorksheetList(sheetList);
            definition.setData(b);
            this.updateData(workbook, definition.getWorksheetList());
            ImportResponse response = new ImportResponse();
            response.setDefinition(definition);
            ImportResponse importResponse = response;
            return importResponse;
        }
        catch (DashboardException de) {
            throw de;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private String getGUID() {
        StringBuilder strTemp = new StringBuilder("t");
        strTemp.append(Long.toHexString(System.currentTimeMillis()));
        return strTemp.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImportResponse getAnalyzedServerFile(DaoFactory daoFactory, ImportRequest value, ExpressionEvaluationData data) throws DashboardException {
        try {
            int pos;
            String fullFileName = value.getFileName();
            int n = pos = fullFileName == null ? -1 : fullFileName.indexOf("/");
            if (fullFileName == null || pos == -1) {
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("fileNotFound", null, null);
            }
            String folderName = fullFileName.substring(0, pos);
            String fileName = fullFileName.substring(pos);
            FolderDao folderDao = daoFactory.getFolderDao();
            BeanFile folder = (BeanFile)folderDao.getDefinition(folderName);
            FileHelper fileHelper = FileHelper.getInstance(folder, fileName);
            File file = fileHelper.getFile(data);
            byte[] b = null;
            try (FileInputStream fis = new FileInputStream(file);){
                b = new byte[(int)file.length()];
                fis.read(b);
            }
            return this.getAnalyzedFile(daoFactory, value.getFileName(), b, value.getDefinition(), data);
        }
        catch (DashboardException de) {
            throw de;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private Map<String, BeanImportWorksheet> getSheetMap(BeanImportDefinition definition) {
        List sheetList;
        HashMap<String, BeanImportWorksheet> sheetMap = new HashMap<String, BeanImportWorksheet>();
        if (definition != null && (sheetList = definition.getWorksheetList()) != null) {
            for (BeanImportWorksheet sheet : sheetList) {
                sheetMap.put(sheet.getName(), sheet);
            }
        }
        return sheetMap;
    }

    private Workbook getWorkbook(InputStream is, Locale locale) throws DashboardException {
        try {
            return WorkbookFactory.create((InputStream)is);
        }
        catch (IllegalArgumentException e) {
            throw ExceptionHelper.getInstance(locale).createDashboardException("invalidExcelFile", null, e);
        }
        catch (InvalidFormatException ife) {
            throw ExceptionHelper.getInstance(locale).createDashboardException("invalidExcelFile", null, ife);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private List<BeanImportWorksheet> getSheetList(Workbook workbook, Map<String, BeanImportWorksheet> sheetMap) throws DashboardException {
        ArrayList<BeanImportWorksheet> sheetList = new ArrayList<BeanImportWorksheet>();
        try {
            FormulaEvaluator formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                ExcelSheet excelSheet;
                BeanImportWorksheet s;
                Sheet sheet = workbook.getSheetAt(i);
                String sn = workbook.getSheetName(i);
                BeanImportWorksheet beanImportWorksheet = s = sn == null || sheetMap == null ? null : sheetMap.get(sn);
                if (s == null && sheet != null && (excelSheet = new ExcelSheet.Builder(formulaEvaluator, sheet, -1).build()) != null) {
                    s = new BeanImportWorksheet();
                    s.setName(sn);
                    s.setFirstRowTitle(excelSheet.isFirstRowTitle());
                    s.setStartRow(excelSheet.getFirstRow());
                    s.setStartCol((int)excelSheet.getFirstCol());
                    s.setEndRow(excelSheet.getLastRow());
                    s.setEndCol((int)excelSheet.getLastCol());
                    s.setOffsetX((int)excelSheet.getFirstCol());
                    s.setOffsetY(excelSheet.getFirstRow());
                    ArrayList<BeanImportColumn> columnList = new ArrayList<BeanImportColumn>();
                    int nbCols = excelSheet.getNbCols();
                    String[] cols = excelSheet.getCols();
                    for (int c = 0; c < nbCols; ++c) {
                        BeanImportColumn column = new BeanImportColumn();
                        column.setColumnIndex(excelSheet.getFirstCol() + c);
                        column.setDatatype(DataType.valueOf((int)excelSheet.getDataType(c)));
                        column.setName(cols[c]);
                        column.setFieldPrecision(excelSheet.getPrecision(c));
                        column.setFieldScale(excelSheet.getScale(c));
                        column.setFieldSize(excelSheet.getSize(c));
                        columnList.add(column);
                    }
                    s.setColumnList(columnList);
                }
                if (s == null) continue;
                sheetList.add(s);
            }
            if (!sheetList.isEmpty()) {
                ((BeanImportWorksheet)sheetList.get(0)).setImportWorksheet(true);
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        return sheetList;
    }

    private void updateData(Workbook workbook, List<BeanImportWorksheet> sheetList) {
        FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        for (BeanImportWorksheet s : sheetList) {
            int i;
            HSSFSheet tmp;
            ArrayList data = new ArrayList();
            Sheet sheet = workbook.getSheet(s.getName());
            if (sheet == null) break;
            int[] cols = new int[s.getColumnList().size()];
            for (int c = 0; c < s.getColumnList().size(); ++c) {
                BeanImportColumn column = (BeanImportColumn)s.getColumnList().get(c);
                cols[c] = column.getColumnIndex();
            }
            int startRow = s.getStartRow();
            ArrayList<CellRangeAddress> ranges = new ArrayList<CellRangeAddress>();
            if (sheet instanceof HSSFSheet) {
                tmp = (HSSFSheet)sheet;
                for (i = 0; i < tmp.getNumMergedRegions(); ++i) {
                    ranges.add(tmp.getMergedRegion(i));
                }
            } else if (sheet instanceof XSSFSheet) {
                tmp = (XSSFSheet)sheet;
                for (i = 0; i < tmp.getNumMergedRegions(); ++i) {
                    ranges.add(tmp.getMergedRegion(i));
                }
            }
            DataFormatter df = new DataFormatter();
            for (int r = startRow; r <= s.getEndRow(); ++r) {
                ArrayList<String> dr = new ArrayList<String>();
                Row row = sheet.getRow(r);
                for (int col : cols) {
                    Cell cell = null;
                    for (CellRangeAddress range : ranges) {
                        Row rr;
                        if (col < range.getFirstColumn() || col > range.getLastColumn() || r < range.getFirstRow() || r > range.getLastRow() || (rr = r == range.getFirstRow() ? row : sheet.getRow(range.getFirstRow())) == null) continue;
                        cell = rr.getCell(range.getFirstColumn());
                        break;
                    }
                    if (cell == null && row != null && (cell = row.getCell(col)) != null) {
                        try {
                            evaluator.evaluateInCell(cell);
                        }
                        catch (Exception e) {
                            cell = null;
                        }
                    }
                    String value = null;
                    if (cell != null) {
                        switch (cell.getCellType()) {
                            case 3: {
                                break;
                            }
                            case 5: {
                                break;
                            }
                            case 4: {
                                value = Boolean.valueOf(cell.getBooleanCellValue()).toString();
                                break;
                            }
                            case 0: {
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    value = cell.getDateCellValue().toString();
                                    break;
                                }
                                if ("@".equals(cell.getCellStyle().getDataFormatString())) {
                                    value = df.formatCellValue(cell);
                                    break;
                                }
                                value = BigDecimal.valueOf(cell.getNumericCellValue()).toPlainString();
                                break;
                            }
                            case 1: {
                                value = cell.getRichStringCellValue().getString();
                            }
                        }
                    }
                    if (value == null) {
                        value = "";
                    }
                    dr.add(value);
                }
                data.add(dr);
            }
            s.setDataList(data);
        }
    }

    private ImportResponse getExecute(DaoFactory daoFactory, ExpressionEvaluationData data, ImportRequest value) throws DashboardException {
        try {
            BeanImportDefinition definition = value.getDefinition();
            ArrayList<ExecutionMessage> messageList = new ArrayList<ExecutionMessage>();
            for (BeanImportWorksheet s : definition.getWorksheetList()) {
                if (!s.isImportWorksheet() || s.getColumnList() == null || s.getDataList() == null) continue;
                if (s.isFirstRowTitle()) {
                    List row = (List)s.getDataList().get(s.getStartRow());
                    for (BeanImportColumn c : s.getColumnList()) {
                        c.setName((String)row.get(c.getColumnIndex()));
                    }
                    continue;
                }
                for (BeanImportColumn c : s.getColumnList()) {
                    c.setName(new StringBuffer("Col").append(c.getColumnIndex()).toString());
                }
            }
            WorldDao worldDao = daoFactory.getWorldDao();
            BeanWorldDefinition world = (BeanWorldDefinition)worldDao.getDefinition(definition.getWorldName());
            JdbcDriverDao jdbcDriverDao = daoFactory.getJdbcDriverDao();
            BeanJDBCDriverDefinition driver = (BeanJDBCDriverDefinition)jdbcDriverDao.getDefinition(world.getDriverOID());
            WorldHelper worldHelper = WorldHelper.getInstance((BeanWorldDefinition)world, (DriverCharacteristics)driver, (ExpressionEvaluationData)data);
            IPoolDBInfo dbInfo = worldHelper.getPoolDbInfo();
            int insertType = definition.getInsertType() == null ? 5 : definition.getInsertType();
            int deleteType = definition.getDeleteType() == null ? 1 : definition.getDeleteType();
            int batchType = definition.getBatchType() == null ? 1 : definition.getBatchType();
            String identifierQuoteString = worldHelper.getIdentifierQuoteString();
            int batchNbLines = definition.getBatchNbLines() == null ? 0 : definition.getBatchNbLines();
            int commitType = definition.getCommitType() == null ? 1 : definition.getCommitType();
            int commitNbLine = definition.getCommitNbLines() == null ? 0 : definition.getCommitNbLines();
            String table = worldHelper.getTable(definition.getTable());
            String catalog = worldHelper.getCatalog(definition.getCatalog());
            String schema = worldHelper.getSchema(definition.getSchema());
            Configuration configuration = Configuration.getInstance();
            DataSourceConfiguration dsc = configuration.getDataSourceConfiguration();
            SQLTableHelper sqlTableHelper = SQLTableHelper.getInstance((DataSource)dsc.getDataSource(dbInfo), (String)identifierQuoteString);
            TableHandler tableHandler = new TableHandler.Builder(sqlTableHelper, new MessageListListener(messageList)).defaultTable(catalog, schema, table).type(insertType, deleteType, batchType, batchNbLines, commitType, commitNbLine).create(definition.isCreateTable(), definition.isCreatePK()).empty(definition.getImportType() == BeanImportDefinition.ImportType.CARBON_COPY).build();
            SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            factory.setErrorListener(new PrelytisErrorListener());
            ExcelDataReader xlReader = new ExcelDataReader(definition);
            QueryReader reader = new QueryReader(xlReader);
            reader.setEntityResolver((EntityResolver)new PrelytisResolver());
            reader.setErrorHandler((ErrorHandler)new PrelytisErrorHandler());
            RenameFilter filter = new RenameFilter();
            filter.setParent(reader);
            InputSource is = new InputSource();
            SAXSource source = new SAXSource(filter, is);
            Transformer transformer = factory.newTransformer();
            transformer.setErrorListener(new PrelytisErrorListener());
            transformer.transform(source, new SAXResult(tableHandler));
            ImportResponse response = new ImportResponse();
            if (definition.isCreateDataDictionary() && definition.getQueryOid() == null) {
                Map<String, String> fldMap = filter.getFieldMap();
                GuidFactory guidFactory = GuidFactory.getInstance();
                Locale locale = data.getLocale();
                BeanQueryDataStructure ds = new BeanQueryDataStructure();
                ds.setName(guidFactory.generateGUID((Object)ds));
                ds.setDescriptionKey(guidFactory.generateGUID((Object)ds));
                ds.getDescriptionMap().putAll(definition.getDescriptionMap());
                ds.setCommentKey(guidFactory.generateGUID((Object)ds));
                ds.setWorldName(definition.getWorldName());
                ds.setMaxLines(-1);
                String dsDesc = xlReader.getDocumentTitle();
                if (dsDesc == null) {
                    dsDesc = definition.getFileName();
                }
                if (dsDesc == null) {
                    dsDesc = definition.getName();
                }
                ds.getDescriptionMap().put(locale, dsDesc);
                BeanQueryDataStructureTable dsTable = new BeanQueryDataStructureTable();
                dsTable.setName(definition.getTable());
                dsTable.setDescriptionKey(guidFactory.generateGUID((Object)dsTable));
                dsTable.getDescriptionMap().putAll(definition.getDescriptionMap());
                dsTable.setCatalog(definition.getCatalog());
                dsTable.setSchema(definition.getSchema());
                dsTable.setId(1);
                dsTable.setUpdatable(true);
                dsTable.setInsertable(true);
                dsTable.setDeletable(true);
                String desc = xlReader.getTableDescription();
                if (desc == null) {
                    desc = dsTable.getName();
                }
                dsTable.getDescriptionMap().put(locale, desc);
                List fieldList = dsTable.getTableFieldList();
                for (FieldMetaData fmd : tableHandler.getFieldList()) {
                    BeanQueryDataStructureTableField field = new BeanQueryDataStructureTableField();
                    field.setActive(true);
                    field.setName(fmd.getName());
                    field.setDescriptionKey(guidFactory.generateGUID((Object)field));
                    field.setDataType(fmd.getDataType());
                    if (DataType.isChar((DataType)fmd.getDataType())) {
                        field.setSize(fmd.getFieldSize());
                    } else if (DataType.isNumeric((DataType)fmd.getDataType())) {
                        field.setSize(fmd.getFieldPrecision());
                        field.setDigits(fmd.getFieldScale());
                    }
                    field.setNullable(fmd.isNullable());
                    field.setAutoincrement(fmd.isAutoIncrement());
                    field.setId(fmd.getObjectID());
                    field.setSqlField(fmd.getName());
                    if (DataType.isNumeric((DataType)field.getDataType())) {
                        field.setFieldGroupName("Metric");
                    } else if (DataType.isDate((DataType)field.getDataType())) {
                        field.setFieldGroupName("TimeAxis");
                    } else {
                        field.setFieldGroupName("Attribut");
                    }
                    String description = fldMap.get(field.getName().toLowerCase());
                    if (description == null) {
                        description = field.getName();
                    }
                    field.getDescriptionMap().put(locale, description);
                    field.setInsertable(true);
                    field.setUpdatable(true);
                    fieldList.add(field);
                }
                ds.setTableFact(dsTable);
                ds.setOwnerEntityName(data.getEntityName());
                ds.setCreationDate(new Date());
                ds.setOwner(data.getUserName());
                QueryHelper.getInstance(daoFactory).save((BeanQueryDefinition)ds, data, true);
                definition.setQueryName(ds.getName());
            }
            response.setDefinition(definition);
            response.setExecutionMessages(messageList);
            return response;
        }
        catch (DashboardException de) {
            throw de;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }
}

